<?php
/**
 * WP Forms Integration
 */

add_filter( 'wpforms_field_properties', 'hellix_wpforms_field_atts', 10, 3 );

add_filter( 'wpforms_frontend_form_atts', 'hellix_wpforms_frontend_form_atts', 10, 2 );

add_action( 'wpforms_form_settings_general', 'hellix_wpforms_settings_general', 10, 1 );

add_filter( 'wpforms_field_properties_textarea', 'hellix_wpforms_inputs_properties', 10, 3 );

if ( ! function_exists( 'hellix_wpforms_field_atts' ) ) {
	/**
	 * Adding Wpforms field attributes
	 *
	 * @param array $properties Field properties.
	 * @param array $field Form Fields.
	 * @param array $form_data Form data.
	 * @return array $properties Form properties.
	 */
	function hellix_wpforms_field_atts( $properties, $field, $form_data ) {

		if ( isset( $properties['inputs'] ) && isset( $properties['inputs']['primary'] ) && isset( $properties['inputs']['primary']['class'] ) ) {
			$properties['inputs']['primary']['class'][] = 'form-control';
		}

		if ( isset( $properties['label'] ) && isset( $properties['label']['class'] ) ) {
			$properties['label']['class'][] = 'form-label';
		}

		return $properties;
	}
}

if ( ! function_exists( 'hellix_wpforms_frontend_form_atts' ) ) {
	/**
	 * Begin to build the output
	 *
	 * @param array $form_atts Form atts.
	 * @param array $form_data Form data.
	 */
	function hellix_wpforms_frontend_form_atts( $form_atts, $form_data ) {

		if ( isset( $form_data['settings']['form_tag_class'] ) && ! empty( $form_data['settings']['form_tag_class'] ) ) {

			$form_classes       = explode( ' ', $form_data['settings']['form_tag_class'] );
			$form_atts['class'] = array_merge( $form_atts['class'], $form_classes );
		}

		return $form_atts;
	}
}

if ( ! function_exists( 'hellix_wpforms_settings_general' ) ) {
	/**
	 * Adding Wpform field
	 *
	 * @param object $settings Adding Form settings.
	 */
	function hellix_wpforms_settings_general( $settings ) {

		wpforms_panel_field(
			'text',
			'settings',
			'form_tag_class',
			$settings->form_data,
			esc_html__( 'Form Tag Class', 'hellix' ),
			[
				'tooltip' => esc_html__( 'Enter CSS class names for the form tag. Multiple class names should be separated with spaces.', 'hellix' ),
			]
		);
	}
}

if ( ! function_exists( 'hellix_wpforms_inputs_properties' ) ) {
	/**
	 * Adding Wpforms field attributes
	 *
	 * @param array $properties Field properties.
	 * @param array $field Form Fields.
	 * @param array $form_data Form data.
	 * @return array $properties Form properties.
	 */
	function hellix_wpforms_inputs_properties( $properties, $field, $form_data ) {
		$properties['inputs']['primary']['class'][] = 'form-control';
		if ( 'textarea' === $field['type'] ) {
			$properties['inputs']['primary']['attr']['rows'] = '8';
		}

		return $properties;
	}
}












