<?php
/**
 * The loop template file.
 *
 * Included on pages like index.php, archive.php and search.php to display a loop of posts
 * Learn more: https://codex.wordpress.org/The_Loop
 *
 * @package hellix
 */

do_action( 'hellix_loop_before' );

?>
<div class="blogSection pr-30 lg:pr-0">
	<?php

	while ( have_posts() ) :
		the_post();

		/**
		 * Include the Post-Format-specific template for the content.
		 * If you want to override this in a child theme, then include a file
		 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
		 */
		get_template_part( 'templates/contents/content', get_post_format() );

	endwhile;

	?>
</div>
<?php

/**
 * Functions hooked in to hellix_paging_nav action
 *
 * @hooked hellix_paging_nav - 10
 */
do_action( 'hellix_loop_after' );
