<?php
/**
 * Template part for displaying a post tile in grid layout
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Around
 */

$_categories = hellix_post_get_categories();
?>

<!-- <div class="masonry__item -no-ratio "> -->
	<div data-anim-wrap class="blog -hover">
		<a data-barba href="<?php the_permalink(); ?>">
			<div class="blog__image">
				<?php if ( has_post_thumbnail() ) : ?>
					<div data-anim-child="img-right cover-black">
						<div>
							<div class="ratio ratio-41:35">
								<img class="ratio-img h-100" src="<?php echo esc_attr( get_the_post_thumbnail_url( null, 'full' ) ); ?>" alt="blog image">
							</div>
						</div>
					</div>
				<?php endif; ?>
				<div class="blog__category">
				<?php
				if ( ! empty( $_categories ) ) :
						echo implode(
							', ',
							array_map(
								function ( $category ) {
									return (
									esc_html( $category->name )
									);
								},
								$_categories
							)
						); // phpcs:ignoreFile.
					?>
					<?php
					endif;
				unset( $_categories );
				?>
					
				</div>
			</div>
		</a>

		<div class="blog__content mt-20">
			<div data-anim-child="slide-up delay-6" class="blog__info">
				<?php hellix_loop_grid_post_meta(); ?>
			</div>
			<div data-anim-child="slide-up delay-7">
				<h3 class="blog__title text-black pr-80 lg:pr-0"><a data-barba href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
			</div>

			<div data-anim-child="slide-up delay-8">
				<a data-barba href="<?php the_permalink(); ?>" class="blog__button button -simple text-black"><?php esc_html__( 'Read more', 'hellix' ); ?></a>
			</div>
		</div>
	</div>
<!-- </div> -->
