<?php
/**
 * Template for displaying archive Portfolio content v1.
 */

$layout        = get_theme_mod( 'portfolio_layout', '-col-3' );
$gap           = get_theme_mod( 'portfolio_gap', '-gap-32' );
$container     = get_theme_mod( 'portfolio_container', 'yes' );
$wrap_css      = get_theme_mod( 'portfolio_wrap_css', '-r-120' );
$padding_class = 'portfolioCard__content ';

if ( '-col-4' === $layout ) {
	$padding_class .= 'px-20 py-20';
	$margin_class   = 'mt-4';
} else {
	$padding_class .= 'px-30 py-30';
	$margin_class   = 'mt-8';

}
$args = [
	'margin'  => $margin_class,
	'padding' => $padding_class,
];

?><section class="layout-pt-md layout-pb-md">
	<?php
	if ( 'yes' === $container ) {
		?>
	<div class="container">
		<?php
	}
	?>
		<div class="section-filter px-16">
			<?php hellix_portfolio_filters(); ?>
			<div class="masonry layout-pt-sm js-masonry js-masonry-no-filter <?php echo esc_attr( $layout . ' ' . $gap ); ?>">
				<div class="masonry__sizer"></div>
				<?php

				global $hellix_loop_portfolio_index;

				$hellix_loop_portfolio_index = 0;
				while ( have_posts() ) :
					the_post();

					$portfolio_types = get_the_terms( get_the_ID(), 'jetpack-portfolio-type' );
					$groups          = '';
					$groups_arr      = [];

					if ( is_array( $portfolio_types ) ) {
						foreach ( $portfolio_types as $portfolio_type ) {
							$groups_arr[] = $portfolio_type->slug;
						}
					}
					$groups = implode( ' ', $groups_arr );
					?>
					<div class='masonry__item <?php echo esc_attr( $wrap_css ); ?> <?php echo esc_attr( $groups ); ?>'>
						<?php get_template_part( 'templates/portfolio/content-portfolio/loop/loop-portfolio', 'v1', $args ); ?>
					</div>
					<?php
					$hellix_loop_portfolio_index++;
				endwhile;


				unset( $GLOBALS['hellix_loop_portfolio_index'] );
				?>
			</div>
		</div>
		<?php hellix_portfolio_pagination(); ?>
	<?php
	if ( $container ) {
		?>
		</div>
		<?php
	}
	?>
</section>
<?php
