<?php
/**
 * Template for displaying archive Portfolio content v6.
 */

$layout = get_theme_mod( 'portfolio_layout', '-col-3' );
$gap    = get_theme_mod( 'portfolio_gap', '-gap-32' );
?><section class="layout-pt-md layout-pb-md">
	<div class="container">
		<div class="section-filter px-16">

			<?php hellix_portfolio_filters(); ?>

			<div class="masonry layout-pt-sm js-masonry js-masonry-no-filter <?php echo esc_attr( $layout . ' ' . $gap ); ?>">
				<div class="masonry__sizer"></div>
				<?php

				global $hellix_loop_portfolio_index;

				$hellix_loop_portfolio_index = 0;

				while ( have_posts() ) :
					the_post();

					$portfolio_types = get_the_terms( get_the_ID(), 'jetpack-portfolio-type' );
					$groups          = '';
					$groups_arr      = [];

					if ( is_array( $portfolio_types ) ) {
						foreach ( $portfolio_types as $portfolio_type ) {
							$groups_arr[] = $portfolio_type->slug;
						}
					}
					$groups = implode( ' ', $groups_arr );
					?>
					<div class='masonry__item -no-ratio <?php echo esc_attr( $groups ); ?>'>
						<?php get_template_part( 'templates/portfolio/content-portfolio/loop/loop-portfolio', 'v5' ); ?>
					</div>
					<?php
					$hellix_loop_portfolio_index++;
				endwhile;

				unset( $GLOBALS['hellix_loop_portfolio_index'] );
				?>
			</div>
		</div>
	</div>
</section>
<?php
