<?php
/**
 * Checkout coupon form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/form-coupon.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.0.1
 */

defined( 'ABSPATH' ) || exit;

if ( ! wc_coupons_enabled() ) { // @codingStandardsIgnoreLine.
	return;
}

?>
<div class="woocommerce-form-coupon-toggle mb-32">
	<?php wc_print_notice( apply_filters( 'woocommerce_checkout_coupon_message', esc_html__( 'Have a coupon?', 'hellix' ) . ' <a href="#" class="showcoupon font-weight-medium">' . esc_html__( 'Click here to enter your code', 'hellix' ) . '</a>' ), 'notice' ); ?>
</div>

<form class="checkout_coupon woocommerce-form-coupon row mb-32 px-3" method="post" style="display:none">

	<p class="col-md-12 mb-3"><?php esc_html_e( 'If you have a coupon code, please apply it below.', 'hellix' ); ?></p>

	<p class="form-row form-row-first col-md-6">
		<input type="text" name="coupon_code" class="input-text form-control" placeholder="<?php esc_attr_e( 'Coupon code', 'hellix' ); ?>" id="coupon_code" value="" />
	</p>

	<p class="form-row form-row-last col-md-6">
		<button type="submit" class="button btn button -md -accent col-6 text-whiten<?php echo esc_attr( wc_wp_theme_get_element_class_name( 'button' ) ? ' ' . wc_wp_theme_get_element_class_name( 'button' ) : '' ); ?>" name="apply_coupon" value="<?php esc_attr_e( 'Apply coupon', 'hellix' ); ?>"><?php esc_html_e( 'Apply coupon', 'hellix' ); ?></button>
	</p>

	<div class="clear"></div>
</form>


