<?php
/**
 * Login form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/global/form-login.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     7.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( is_user_logged_in() ) {
	return;
}

?>

<form class="woocommerce-form woocommerce-form-login login" method="post" <?php echo isset( $hidden ) && $hidden ? 'style="display:none;"' : ''; ?>>

	<?php do_action( 'woocommerce_login_form_start' ); ?>

	<?php echo ! empty( $message ) ? wpautop( wptexturize( $message ) ) : ''; // @codingStandardsIgnoreLine ?>

	<p class="form-row form-row-first mb-24 mt-24">
		<label for="username" class="mb-0"><?php esc_html_e( 'Username or email', 'hellix' ); ?>&nbsp;<span class="required">*</span></label>
		<input type="text" class="input-text py-8" name="username" id="username" autocomplete="username" />
	</p>
	<p class="form-row form-row-last mb-24">
		<label for="password" class="mb-0"><?php esc_html_e( 'Password', 'hellix' ); ?>&nbsp;<span class="required">*</span></label>
		<input class="input-text py-8" type="password" name="password" id="password" autocomplete="current-password" />
	</p>
	<div class="clear"></div>

	<?php do_action( 'woocommerce_login_form' ); ?>

	<div class="d-flex align-items-center mb-5 font-size-sm">

		<div class="form-check">
			<input class="form-check-input text-gray-800 woocommerce-form__input woocommerce-form__input-checkbox" name="rememberme" type="checkbox" id="rememberme" value="forever" />
			<label class="woocommerce-form__label woocommerce-form__label-for-checkbox woocommerce-form-login__rememberme form-check-label text-gray-800" for="rememberme">
				<?php echo esc_html__( 'Remember me', 'hellix' ); ?>
			</label>
		</div>



		<div class="ml-auto">
			<p class="lost_password mb-0">
				<a class="text-gray-800" href="<?php echo esc_url( wp_lostpassword_url() ); ?>"><?php esc_html_e( 'ForgotPassword', 'hellix' ); ?></a>
			</p>
		</div>
	</div>

	<?php wp_nonce_field( 'woocommerce-login', 'woocommerce-login-nonce' ); ?>
	<input type="hidden" name="redirect" value="<?php echo esc_url( $redirect ); ?>" />
	<button type="submit" class="woocommerce-button button woocommerce-form-login__submit button alt button -md -accent col-12 text-white mb-24<?php echo esc_attr( wc_wp_theme_get_element_class_name( 'button' ) ? ' ' . wc_wp_theme_get_element_class_name( 'button' ) : '' ); ?>" name="login" value="<?php esc_attr_e( 'Login', 'hellix' ); ?>"><?php esc_html_e( 'Login', 'hellix' ); ?></button>
	

	<div class="clear"></div>

	<?php if ( get_option( 'woocommerce_enable_myaccount_registration' ) === 'yes' ) : ?>
		<p class="mt-5 register-text mb-0 font-size-sm text-center"><?php esc_html_e( 'Don&#039;t have an account?', 'hellix' ); ?>
			 <a class="text-underline" data-toggle="collapse" href="#collapseSignup" role="button" aria-expanded="false" aria-controls="collapseSignup"><?php echo esc_html__( 'Sign up', 'hellix' ); ?></a>
		 </p>
	<?php endif; ?>



	<?php do_action( 'woocommerce_login_form_end' ); ?>

</form>
