<?php
/**
 * Pagination - Show numbered pagination for catalog pages
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/loop/pagination.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.3.1
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$max_pages = isset( $GLOBALS['wp_query']->max_num_pages ) ? $GLOBALS['wp_query']->max_num_pages : 1;
if ( $max_pages < 2 ) {
	return;
}

$shop_paged = get_query_var( 'paged' ) ? (int) get_query_var( 'paged' ) : 1;
$links      = paginate_links(
	apply_filters(
		'hellix_posts_pagination_args',
		[
			'type'      => 'array',
			'mid_size'  => 2,
			'prev_next' => false,
		]
	)
);?>


<div class="row justify-content-center mt-48">
	<div class="col-auto">
		<div class="pagination -section">

			<div class="pagination__nav">
				<?php if ( $shop_paged && 1 < $shop_paged ) : ?>
					<a data-barba href="<?php echo esc_url( get_previous_posts_page_link() ); ?>" class="nav-icon -left">
						<div class="nav-icon__circle">
							<i class="icon icon-left-arrow"></i>
						 </div>
					 </a>
				<?php endif; ?>
			</div>
			<div class="pagination__content">
				<?php foreach ( $links as $shop_link ) : ?>
					<?php
					if ( false !== strpos( $shop_link, 'current' ) ) :
						?>
						<span class="is-active">
							<?php echo wp_kses_post( $shop_paged ); ?>
						</span>
					<?php else : ?>
						<?php
						if ( ! ( $max_pages === $shop_paged ) ) {
							?>
							<?php echo wp_kses_post( $shop_link ); ?>
						<?php } else { ?>
							<span>...</span>
								<a data-barba href="<?php echo wp_kses_post( $shop_link ); ?>"><?php echo wp_kses_post( $max_pages ); ?></a>
						<?php } ?>
					<?php endif; ?>
				<?php endforeach; ?>
			</div>

			<div class="pagination__nav">
				<?php if ( $shop_paged && $shop_paged < $max_pages ) : ?>
					<a data-barba href="<?php echo esc_url( get_next_posts_page_link() ); ?>" class="nav-icon -right">
						<div class="nav-icon__circle">
							<i class="icon icon-right-arrow"></i>
						</div>
					</a>
				<?php endif; ?>
			</div>
		</div>
	</div>
</div>
   




 
				 
					  
