<?php
/**
 * The header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="content">
 *
 * @package hellix
 */

?><!doctype html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">

<?php wp_head(); ?>
</head>
<body <?php body_class(); ?> data-barba="wrapper">

<?php wp_body_open(); ?>
<?php do_action( 'hellix_before_site' ); ?>

<?php
$sticky = true === hellix_navbar_is_sticky() ? 'js-header-sticky' : '';
$args   = array( 'sticky' => $sticky );
?>
<div id="page" class="hfeed site barba-container" data-barba="container">
	<main <?php hellix_main_class(); ?>>

		<?php do_action( 'hellix_before_header' ); ?>

		<?php get_template_part( 'templates/headers/header', hellix_get_header_version(), $args ); ?>

		<?php do_action( 'hellix_before_content' ); ?>

		<div id="content" <?php hellix_content_class(); ?> tabindex="-1">
			<?php
			do_action( 'hellix_content_top' );
