<?php
/**
 * Hellix ACF Class
 *
 * @package  finder
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Hellix_ACF' ) ) {
	/**
	 * The Hellix ACF Integration class
	 */
	class Hellix_ACF {

		/**
		 * Setup class.
		 */
		public function __construct() {
			$this->includes();
		}

		/**
		 * Include settings.
		 */
		public function includes() {
			if ( function_exists( 'acf_add_local_field_group' ) ) {

				$settings = array( 'portfolio', 'page-header', 'product-category', 'user-profile' );

				foreach ( $settings as $setting ) {

					require get_template_directory() . '/inc/acf/settings/' . $setting . '.php';
				}
			}
		}
	}
}

return new Hellix_ACF();
