<?php
/**
 * ACF Functions related to Portfolio single post.
 *
 * @package hellix.
 */

if ( ! function_exists( 'hellix_acf_portfolio_common_tag' ) ) {
	/**
	 * Portfolio Common tag
	 */
	function hellix_acf_portfolio_common_tag() {
		return hellix_get_field( 'portfolio_tag' );
	}
}

if ( ! function_exists( 'hellix_acf_portfolio_type' ) ) {
	/**
	 * Portfolio Single Type
	 */
	function hellix_acf_portfolio_type() {
		return hellix_get_field( 'portfolio_type' );
	}
}


if ( ! function_exists( 'hellix_acf_portfolio_attributes' ) ) {
	/**
	 * Portfolio Single Attributes
	 */
	function hellix_acf_portfolio_attributes() {

		$attributes_portfolio = hellix_get_field( 'attributes' );

		$attributes = parse_custom_attributes( $attributes_portfolio, "\n" );

		return $attributes;
	}
}

if ( ! function_exists( 'parse_custom_attributes' ) ) {
	/**
	 * Parse Custom attributes
	 *
	 * @param string $attributes_string Attributes string.
	 * @param string $delimiter The delimiter for the tags.
	 * @return array
	 */
	function parse_custom_attributes( $attributes_string, $delimiter = ',' ) {

		$attributes = explode( $delimiter, $attributes_string );
		$result     = [];

		foreach ( $attributes as $attribute ) {
			$attr_key_value = explode( '|', $attribute );

			$attr_key = mb_strtolower( $attr_key_value[0] );

			// Remove any not allowed characters.
			preg_match( '/[-_a-z0-9]+/', $attr_key, $attr_key_matches );

			if ( empty( $attr_key_matches[0] ) ) {
				continue;
			}

			$attr_key = $attr_key_matches[0];

			// Avoid Javascript events and unescaped href.
			if ( 'href' === $attr_key || 'on' === substr( $attr_key, 0, 2 ) ) {
				continue;
			}

			if ( isset( $attr_key_value[1] ) ) {
				$attr_value = trim( $attr_key_value[1] );
			} else {
				$attr_value = '';
			}

			$result[ $attr_key ] = $attr_value;
		}

		return $result;
	}
}


if ( ! function_exists( 'hellix_get_project_version' ) ) {
	/**
	 * Returns the version of the footer for the website.
	 *
	 * @return string
	 */
	function hellix_get_project_version() {
		$single_portfolio_acf_version = hellix_acf_portfolio_type();

		$version = get_theme_mod( 'single_portfolio_layout', 'v1' );

		if ( $single_portfolio_acf_version && 'default' !== $single_portfolio_acf_version ) {
			$version = $single_portfolio_acf_version;
		}

		return apply_filters( 'hellix_single_portfolio_version', $version );

	}
}

if ( ! function_exists( 'hellix_portfolio_scroll' ) ) {
	/**
	 * Returns the version of the footer for the website.
	 *
	 * @return string
	 */
	function hellix_portfolio_scroll() {
		$value = hellix_get_field( 'enable_scroll' );

		return $value;

	}
}

if ( ! function_exists( 'hellix_acf_portfolio_social_links' ) ) {
	/**
	 * Portfolio Single Attributes
	 */
	function hellix_acf_portfolio_social_links() {

		$author_id = get_the_author_meta( 'ID' );

		$links = hellix_get_field( 'social_profile_links', 'user_' . $author_id );

		return $links;
	}
}
