<?php
/**
 * Template hooks
 *
 * @package hellix
 */

// Global.
add_action( 'hellix_before_site', 'hellix_preloader', 10 );
add_action( 'hellix_before_site', 'hellix_cursor', 20 );

add_action( 'elementor/page_templates/canvas/before_content', 'hellix_preloader', 10 );
add_action( 'elementor/page_templates/canvas/before_content', 'hellix_cursor', 20 );

// Header - v1.
add_action( 'hellix_header_v1', 'hellix_header_logo', 10 );
add_action( 'hellix_header_v1', 'hellix_primary_menu_light', 20 );
add_action( 'hellix_header_v1', 'hellix_header_icons', 30 );
add_action( 'hellix_after_header_v1', 'hellix_header_search_light', 10 );

// Header - v2.
add_action( 'hellix_before_header_v2', 'hellix_header_topbar', 5 );
add_action( 'hellix_header_v2', 'hellix_header_logo_1', 10 );
add_action( 'hellix_header_v2', 'hellix_header_icons', 20 );
add_action( 'hellix_after_header_v2', 'hellix_header_search_light', 30 );

// Header - v3.
add_action( 'hellix_before_header_v3', 'hellix_header_topbar_1', 5 );
add_action( 'hellix_header_v3', 'hellix_header_logo_2', 10 );
add_action( 'hellix_header_v3', 'hellix_header_icons_1', 20 );
add_action( 'hellix_after_header_v3', 'hellix_header_search_dark', 30 );

// Header - v4.
add_action( 'hellix_header_v4', 'hellix_header_logo_4', 10 );
add_action( 'hellix_header_v4', 'hellix_header_home_v4', 20 );
add_action( 'hellix_after_header_v4', 'hellix_header_search_light', 30 );

// Header - v5.
add_action( 'hellix_header_v5', 'hellix_header_home_dark', 10 );
add_action( 'hellix_after_header_v5', 'hellix_header_search_dark', 20 );

// Header - v6.
add_action( 'hellix_header_v6', 'hellix_header_home_light', 10 );
add_action( 'hellix_after_header_v6', 'hellix_header_search_light', 20 );

// Header - v7.
add_action( 'hellix_header_v7', 'hellix_header_home_7', 10 );
add_action( 'hellix_after_header_v7', 'hellix_header_search_light', 20 );

// Header - v8.
add_action( 'hellix_header_v8', 'hellix_header_home_dark', 10 );
add_action( 'hellix_after_header_v8', 'hellix_header_search_dark', 20 );

// Header - v9.
add_action( 'hellix_header_v9', 'hellix_header_logo_1', 10 );
add_action( 'hellix_header_v9', 'hellix_header_home_9', 20 );
add_action( 'hellix_after_header_v9', 'hellix_header_search_light', 30 );

// Header - v10.
add_action( 'hellix_header_v10', 'hellix_header_image_logo', 10 );
add_action( 'hellix_header_v10', 'hellix_secondary_menu', 20 );
add_action( 'hellix_header_v10', 'hellix_header_home_footer', 30 );
add_action( 'hellix_header_bar_v10', 'hellix_header_logo_10', 40 );
add_action( 'hellix_header_bar_v10', 'hellix_header_home_v4', 50 );
add_action( 'hellix_after_header_v10', 'hellix_header_search_light', 60 );

add_action( 'hellix_header_icons', 'hellix_header_cart', 10 );
add_action( 'hellix_header_icons', 'hellix_header_search_icon', 20 );
add_action( 'hellix_header_icons', 'hellix_header_offcanvas_menu_icon', 30 );

// Header Offcanvas.
add_action( 'hellix_content_top', 'hellix_offcanvas_sidebar', 10 );


// Posts Loop.
add_action( 'hellix_loop_post', 'hellix_loop_post_header', 10 );
add_action( 'hellix_loop_post', 'hellix_loop_post_content_wrap_start', 20 );
add_action( 'hellix_loop_post', 'hellix_loop_post_meta', 30 );
add_action( 'hellix_loop_post', 'hellix_loop_post_content', 40 );
add_action( 'hellix_loop_post', 'hellix_loop_post_content_wrap_end', 90 );

// Single Post.
add_action( 'hellix_single_post_top', 'hellix_single_post_masthead', 10 );
add_action( 'hellix_single_post_before', 'hellix_single_post_content_start', 20 );
add_action( 'hellix_single_post_before', 'hellix_single_post_wrapper_start', 30 );
add_action( 'hellix_single_post', 'hellix_single_post', 40 );
add_action( 'hellix_single_post', 'hellix_single_post_info', 50 );
add_action( 'hellix_single_post', 'hellix_single_post_nav', 60 );
add_action( 'hellix_single_post', 'hellix_single_post_author', 70 );
add_action( 'hellix_single_post_bottom', 'hellix_display_comments', 80 );
add_action( 'hellix_single_post_after', 'hellix_single_post_wrapper_end', 90 );
add_action( 'hellix_single_post_after', 'hellix_single_post_content_end', 100 );
add_filter( 'comment_reply_link', 'replace_reply_link_class' );
add_filter( 'edit_comment_link', 'replace_edit_link_class' );
add_filter( 'cancel_comment_reply_link', 'hellix_cancel_comment_reply_link' );

add_action( 'hellix_loop_after', 'hellix_loop_paging_nav_wrap_start', 10 );
add_action( 'hellix_loop_after', 'hellix_pagination', 30 );
add_action( 'hellix_loop_after', 'hellix_loop_paging_nav_wrap_end', 40 );

// Page.
add_action( 'hellix_archive_before', 'hellix_page_masthead', 30 );
add_action( 'hellix_before_portfolio', 'hellix_page_masthead', 20 );
add_action( 'hellix_page_before', 'hellix_page_masthead', 10 );
add_action( 'hellix_page', 'hellix_page_content', 10 );
add_action( 'hellix_page', 'hellix_display_comments', 20 );

// Search.
add_action( 'hellix_search_before', 'hellix_page_masthead', 10 );

/**
 * Comments
 */

add_filter( 'comment_form_default_fields', 'hellix_comment_form_default_fields', 20 );

// Footer-v1.
add_action( 'hellix_footer_v1', 'hellix_footer_static', 10 );
add_action( 'hellix_footer_v1', 'hellix_footer_credit', 20 );
add_action( 'hellix_footer_v1', 'hellix_footer_goto_top', 30 );

require get_template_directory() . '/inc/template-hooks/single-portfolio.php';
