<?php
/**
 * Hellix Footer template functions.
 *
 * @package hellix
 */

if ( ! function_exists( 'hellix_footer_skin' ) ) {
	/**
	 * Display footer Skin.
	 */
	function hellix_footer_skin() {

		$hx_page_options = array();
		if ( function_exists( 'hellix_option_enabled_post_types' ) && is_singular( hellix_option_enabled_post_types() ) ) {
			$clean_meta_data  = get_post_meta( get_the_ID(), '_hx_page_options', true );
			$_hx_page_options = maybe_unserialize( $clean_meta_data );

			if ( is_array( $_hx_page_options ) ) {
				$hx_page_options = $_hx_page_options;
			}
		}

		if ( isset( $hx_page_options['footer'] ) && isset( $hx_page_options['footer']['enable_custom_footer'] ) && 'yes' === $hx_page_options['footer']['enable_custom_footer'] ) {
			$footer_skin = isset( $hx_page_options['footer']['footer_skin'] ) ? $hx_page_options['footer']['footer_skin'] : 'dark';
		} elseif ( 'null' !== get_theme_mod( 'footer_skin', 'dark' ) ) {
			$footer_skin = get_theme_mod( 'footer_skin', 'dark' );
		} else {
			$footer_skin = 'dark';
		}
		return sanitize_key( apply_filters( 'hellix_footer_skin', $footer_skin ) );
	}
}

if ( ! function_exists( 'hellix_footer_credit' ) ) {
	/**
	 * Display credit in the footer.
	 */
	function hellix_footer_credit() {
		$copyright    = function_exists( 'hellix_footer_copyright' ) && ! empty( hellix_footer_copyright() ) ? hellix_footer_copyright() : '';
		$credit_text  = function_exists( 'hellix_footer_credit_text' ) && ! empty( hellix_footer_credit_text() ) ? hellix_footer_credit_text() : '';
		$allowed_html = array(
			'a' => array(
				'href'  => array(),
				'title' => array(),
				'class' => array(),
			),
		);
		?>
		<div class="footer__bottom">
			<div class="container">
				<div class="row align-items-center justify-content-between sm:justify-content-start">
					<div class="col-auto sm:order-2">
						<div class="footer__bottom_text">
							<?php echo wp_kses_post( $copyright ); ?> 
						</div>
					</div>

					<div class="col-auto sm:order-1">
						<div class="footer__logo">
							<?php hellix_footer_logo(); ?>
						</div>
					</div>

					<div class="col-auto sm:d-none">
						<div class="footer__bottom_text"> 
							<?php echo wp_kses_post( $credit_text ); ?>  
						</div>
					</div>
				</div>
			</div>
		</div>
		<?php
	}
}

if ( ! function_exists( 'hellix_footer_logo' ) ) {
	/**
	 * Display footer logo.
	 *
	 * @param bool $echo Should display or return the title/logo.
	 */
	function hellix_footer_logo( $echo = true ) {

		$logo_variant   = get_theme_mod( 'footer_logo_variant', 'site_logo' );
		$footer_skin    = hellix_footer_skin();
		$txt_color      = 'text-black';
		$custom_logo_id = get_theme_mod( 'footer_custom_logo_url', '' );

		$hx_page_options = array();

		if ( 'dark' === $footer_skin ) {
			$txt_color = 'text-white';
		}

		if ( function_exists( 'hellix_option_enabled_post_types' ) && is_singular( hellix_option_enabled_post_types() ) ) {
			$clean_meta_data  = get_post_meta( get_the_ID(), '_hx_page_options', true );
			$_hx_page_options = maybe_unserialize( $clean_meta_data );

			if ( is_array( $_hx_page_options ) ) {
				$hx_page_options = $_hx_page_options;
			}
		}

		$elementor_logo_id = isset( $hx_page_options['footer']['hellix_custom_elementor_logo']['id'] ) ? $hx_page_options['footer']['hellix_custom_elementor_logo']['id'] : '';

		if ( hellix_has_custom_footer( $hx_page_options ) && $elementor_logo_id > 0 ) {
			$logo_variant   = 'custom_logo';
			$custom_logo_id = $elementor_logo_id;

		}
		$custom_logo_url = wp_get_attachment_image( $custom_logo_id, '', false );

		if ( 'site_logo' === $logo_variant ) {

			if ( function_exists( 'the_custom_logo' ) && has_custom_logo() ) {
				$logo = get_custom_logo();
				$html = $logo;
			} else {
				$html = '<h1 class="site-title site-branding-text  ' . esc_attr( $txt_color ) . '"><a data-barba href="' . esc_url( home_url( '/' ) ) . '" rel="' . esc_attr__( 'Logo', 'hellix' ) . '">' . esc_html( get_bloginfo( 'name' ) ) . '</a></h1>';
			}
		} elseif ( 'site_icon' === $logo_variant ) {
			$site_icon_url = get_site_icon_url( 58 );

			if ( ! empty( $site_icon_url ) ) {
				$html = '<img src="' . esc_url( $site_icon_url ) . '" alt="' . esc_attr( get_bloginfo( 'name' ) ) . '">';
			} else {
				$html = '<h1 class="site-title site-branding-text  ' . esc_attr( $txt_color ) . '"><a data-barba href="' . esc_url( home_url( '/' ) ) . '" rel="' . esc_attr__( 'Logo', 'hellix' ) . '">' . esc_html( get_bloginfo( 'name' ) ) . '</a></h1>';
			}
		} elseif ( 'custom_logo' === $logo_variant ) {

			if ( '' !== $custom_logo_url ) {

				$html = wp_kses_post( apply_filters( 'hellix_site_custom_logo_url', $custom_logo_url ) );
			} else {
				$html = '<h1 class="site-title site-branding-text  ' . esc_attr( $txt_color ) . '"><a data-barba href="' . esc_url( home_url( '/' ) ) . '" rel="' . esc_attr__( 'Logo', 'hellix' ) . '">' . esc_html( get_bloginfo( 'name' ) ) . '</a></h1>';
			}
		}

		if ( ! $echo ) {
			return $html;
		}

		echo apply_filters( 'hellix_footer_site_title', $html ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	}
}
if ( ! function_exists( 'hellix_footer_copyright' ) ) {
	/**
	 * Display footer copyright.
	 */
	function hellix_footer_copyright() {
		$default = hellix_get_copyright_text();

		$hx_page_options = array();
		if ( function_exists( 'hellix_option_enabled_post_types' ) && is_singular( hellix_option_enabled_post_types() ) ) {
			$clean_meta_data  = get_post_meta( get_the_ID(), '_hx_page_options', true );
			$_hx_page_options = maybe_unserialize( $clean_meta_data );

			if ( is_array( $_hx_page_options ) ) {
				$hx_page_options = $_hx_page_options;
			}
		}

		if ( hellix_has_custom_footer( $hx_page_options ) ) {
			$copyright = isset( $hx_page_options['footer']['footer_copyright'] ) ? wp_kses_post( $hx_page_options['footer']['footer_copyright'] ) : '';
		} elseif ( ! empty( get_theme_mod( 'hellix_copyright' ) ) ) {
			$copyright = get_theme_mod( 'hellix_copyright', $default );
		} else {
			$copyright = $default;
		}

		return (string) apply_filters( 'hellix_footer_copyright', $copyright );
	}
}

if ( ! function_exists( 'hellix_footer_credit_text' ) ) {
	/**
	 * Display footer credit text.
	 */
	function hellix_footer_credit_text() {
		$default         = hellix_get_credit_text();
		$hx_page_options = array();
		if ( function_exists( 'hellix_option_enabled_post_types' ) && is_singular( hellix_option_enabled_post_types() ) ) {
			$clean_meta_data  = get_post_meta( get_the_ID(), '_hx_page_options', true );
			$_hx_page_options = maybe_unserialize( $clean_meta_data );

			if ( is_array( $_hx_page_options ) ) {
				$hx_page_options = $_hx_page_options;
			}
		}
		if ( hellix_has_custom_footer( $hx_page_options ) ) {
			$credit_text = isset( $hx_page_options['footer']['footer_credit_text'] ) ? wp_kses_post( $hx_page_options['footer']['footer_credit_text'] ) : '';
		} elseif ( ! empty( get_theme_mod( 'hellix_credit_text' ) ) ) {
			$credit_text = get_theme_mod( 'hellix_credit_text' );
		} else {
			$credit_text = $default;
		}
		return (string) apply_filters( 'hellix_footer_credit_text', $credit_text );
	}
}

if ( ! function_exists( 'hellix_footer_goto_top' ) ) {
	/**
	 * Display goto top in the footer
	 */
	function hellix_footer_goto_top() {
		?>
		<div data-cursor class="backButton js-backButton">
			<div class="nav -slider">
				<div class="nav__item -left"><i class="icon icon-right-arrow"></i></div>
			</div>
		</div>
		<?php
	}
}

if ( ! function_exists( 'hellix_footer_static' ) ) {
	/**
	 * Hellix footer static.
	 */
	function hellix_footer_static() {

		$hx_page_options = array();

		if ( function_exists( 'hellix_option_enabled_post_types' ) && is_singular( hellix_option_enabled_post_types() ) ) {
			$clean_meta_data  = get_post_meta( get_the_ID(), '_hx_page_options', true );
			$_hx_page_options = maybe_unserialize( $clean_meta_data );

			if ( is_array( $_hx_page_options ) ) {
				$hx_page_options = $_hx_page_options;
			}
		}

		if ( hellix_has_custom_footer( $hx_page_options ) ) {
			$footer_content = isset( $hx_page_options['footer']['footer_static_widgets'] ) ? $hx_page_options['footer']['footer_static_widgets'] : '';
			$footer_variant = isset( $hx_page_options['footer']['footer_variant'] ) ? $hx_page_options['footer']['footer_variant'] : '';
			$enable_static  = isset( $hx_page_options['footer']['enable_static_content'] ) ? $hx_page_options['footer']['enable_static_content'] : '';
		} else {

			$enable_static  = get_theme_mod( 'hellix_footer_static_content', 'no' );
			$footer_content = get_theme_mod( 'footer_static_content', '' );
			$footer_variant = get_theme_mod( 'footer_footer_variant', 'v1' );
		}

		if ( hellix_is_mas_static_content_activated() && ! empty( $footer_content ) && 'yes' === $enable_static ) {
			print( hellix_render_content( $footer_content, false ) ); //phpcs:ignore
		}
	}
}

/**
 * Checks if a page has custom footer or not
 *
 * @param array $options Page meta options.
 */
function hellix_has_custom_footer( $options ) {
	$has_custom_footer = false;

	if ( isset( $options['footer'] ) && isset( $options['footer']['enable_custom_footer'] ) && 'yes' === $options['footer']['enable_custom_footer'] ) {
		$has_custom_footer = true;
	}

	return $has_custom_footer;
}
