<?php
/**
 * Hellix Global template functions.
 *
 * @package hellix
 */

if ( ! function_exists( 'hellix_preloader' ) ) {
	/**
	 * Output Preloader HTML
	 */
	function hellix_preloader() {
		$is_enabled = apply_filters( 'hellix_preloader_is_enabled', true );
		$loader_url = apply_filters( 'hellix_preloader_loader_url', get_template_directory_uri() . '/assets/img/general/loader.svg' );
		if ( $is_enabled ) :
			?>
		<div class="preloader js-preloader">
			<div class="preloader__bg"></div>

			<div class="preloader__progress">
				<div class="preloader__progress__inner"></div>
				<img src="<?php echo esc_url( $loader_url ); ?>" alt="<?php echo esc_attr__( 'preloader image', 'hellix' ); ?>" class="preloader__img">
			</div>
		</div>
			<?php
		endif;
	}
}

/**
 * Get if page loader feature is enabled or not.
 *
 * @return bool
 */
function hellix_is_page_loader() {
	$page_loader = 'yes' === get_theme_mod( 'enable_hellix_page_loader', 'no' ) ? true : false;
	return $page_loader;
}


if ( ! function_exists( 'hellix_cursor' ) ) {
	/**
	 * Output cursor HTML
	 */
	function hellix_cursor() {
		$is_enabled = apply_filters( 'hellix_cursor_is_enabled', true );
		if ( $is_enabled ) :
			?>
		<div class="cursor js-cursor">
			<div class="cursor__wrapper">
				<div class="cursor__follower js-follower"></div>
				<div class="cursor__label js-label"></div>
				<div class="cursor__icon js-icon"></div>
			</div>
		</div>
			<?php
		endif;
	}
}

if ( ! function_exists( 'hellix_offcanvas_sidebar' ) ) {
	/**
	 * Display Offcanvas sidebar
	 */
	function hellix_offcanvas_sidebar() {
		if ( ! is_active_sidebar( 'canvas-sidebar' ) ) {
			return;
		}
		?>
		<aside class="sidebar js-sidebar">
			<div class="sidebar__cross">
				<button class="button js-sidebar-close">
					<i class="icon icon-cross"></i>
				</button>
			</div>
			<?php dynamic_sidebar( 'canvas-sidebar' ); ?>
		</aside>
		<?php
	}
}

/**
 * Displays breadcrumb.
 */

if ( ! function_exists( 'hellix_breadcrumb' ) ) {

	/**
	 * Output the WooCommerce Breadcrumb.
	 *
	 * @param array $args Arguments.
	 */
	function hellix_breadcrumb( $args = array() ) {
		$args = wp_parse_args(
			$args,
			apply_filters(
				'hellix_breadcrumb_defaults',
				array(
					'delimiter'   => ' / ',
					'wrap_before' => '<div data-anim="slide-up delay-1" class="page-masthead-bread text-white md:mt-24 text-right">',
					'wrap_after'  => '</div>',
					'home'        => _x( 'Home', 'breadcrumb', 'hellix' ),
				)
			)
		);

		if ( hellix_is_woocommerce_activated() ) {
			woocommerce_breadcrumb( $args );
		} else {
			require_once get_template_directory() . '/inc/classes/class-hellix-breadcrumb.php';

			$breadcrumbs = new Hellix_Breadcrumb();

			if ( ! empty( $args['home'] ) ) {
				$breadcrumbs->add_crumb( $args['home'], apply_filters( 'hellix_breadcrumb_home_url', home_url() ) );
			}

			$args['breadcrumb'] = $breadcrumbs->generate();

			/**
			 * WooCommerce Breadcrumb hook
			 *
			 * @hooked WC_Structured_Data::generate_breadcrumblist_data() - 10
			 */
			do_action( 'hellix_breadcrumb', $breadcrumbs, $args );

			extract( $args ); // phpcs:ignore

			if ( ! empty( $breadcrumb ) ) {

				echo wp_kses_post( $wrap_before );

				foreach ( $breadcrumb as $key => $crumb ) {

					if ( ! empty( $crumb[1] ) && count( $breadcrumb ) !== $key + 1 ) {
						echo sprintf(
							'<a data-barba href="%1s" class="page-masthead-bread__item">%2s</a>%3s',
							esc_url( $crumb[1] ),
							esc_html( $crumb[0] ),
							wp_kses_post( $delimiter )
						);
					} else {
						echo '<a data-barba class="page-masthead-bread__item active">' . esc_html( $crumb[0] ) . '</a>';
					}
				}

				echo wp_kses_post( $wrap_after );
			}
		}
	}
}

if ( ! function_exists( 'hellix_link_pages' ) ) {
	/**
	 * Output page links.
	 */
	function hellix_link_pages() {
		$link_pages = wp_link_pages(
			array(
				'before'      => '<div class="pagination -section d-block page-links"><span class="d-block text-dark mb-3">' . esc_html__( 'Pages:', 'hellix' ) . '</span><div class="pagination__content mx-0">',
				'after'       => '</div></div>',
				'link_before' => '<span class="page-link">',
				'link_after'  => '</span>',
				'echo'        => 0,
			)
		);
		$link_pages = str_replace( 'post-page-numbers', '', $link_pages );
		$link_pages = str_replace( 'current', 'is-active', $link_pages );
		echo wp_kses_post( $link_pages );
	}
}
