<?php
/**
 * Hellix Header template functions.
 *
 * @package hellix
 */

/**
 * Check if a page has custom header
 *
 * @param array $options Page meta options.
 */
function hellix_has_custom_header( $options ) {
	$has_custom_header = false;

	if ( isset( $options['header'] ) && isset( $options['header']['hellix_enable_custom_header'] ) && 'yes' === $options['header']['hellix_enable_custom_header'] ) {
		$has_custom_header = true;
	}

	return $has_custom_header;
}

if ( ! function_exists( 'hellix_header_logo' ) ) {
	/**
	 * Display logo in the header.
	 */
	function hellix_header_logo() {
		?>
		<div class="col-auto z-5 js-header-item">
			<div class="header__item -margin-sm">
				<?php hellix_header_logo_inner( 'text-white' ); ?>
			</div>
		</div>
		<?php
	}
}

if ( ! function_exists( 'hellix_header_image_logo' ) ) {
	/**
	 * Display logo in the header.
	 */
	function hellix_header_image_logo() {

		?>
		<div class="header__top">
			<div class="header__logo">
				<?php hellix_site_title_or_logo( true, 'text-black' ); ?>
			</div>
		</div>
		<?php
	}
}

if ( ! function_exists( 'hellix_header_logo_2' ) ) {
	/**
	 * Display logo in the header-v3.
	 */
	function hellix_header_logo_2() {
		?>
		<div class="col-auto js-header-item">
			<div class="header__item -margin-sm">
				<?php hellix_header_logo_inner( 'text-white' ); ?>
				<?php hellix_primary_menu( 'text-black' ); ?>
			</div>
		</div>
		<?php
	}
}

if ( ! function_exists( 'hellix_header_logo_4' ) ) {
	/**
	 * Display logo in the header-v3.
	 */
	function hellix_header_logo_4() {
		?>
		<div class="col-auto js-header-item">

			<div class="header__item -margin-sm">
				<?php hellix_header_logo_inner( 'text-white' ); ?>
			</div>
		</div>
		<?php
	}
}

if ( ! function_exists( 'hellix_header_logo_10' ) ) {
	/**
	 * Display logo in the header-v3.
	 */
	function hellix_header_logo_10() {
		?>
		<div class="col-auto js-header-item">

			<div class="header__item -margin-sm">
				<?php hellix_mobile_logo( 'true', 'text-white' ); ?>
			</div>
		</div>
		<?php
	}
}

if ( ! function_exists( 'hellix_header_topbar' ) ) {
	/**
	 * Display Hellix HeaderTopBar.
	 */
	function hellix_header_topbar() {

		$enable_topbar = hellix_header_topbar_inner_content();
		$sticky        = true === hellix_navbar_is_sticky() ? 'topbar-sticky' : '';

		if ( 'yes' == $enable_topbar ) :
			?>
			<div class="topbar bg-beige-dark md:d-none <?php echo esc_attr( $sticky ); ?>">
				<div class="container">
					<div class="row align-items-center justify-content-between">

						<?php hellix_header_topbar_content( 'text-white' ); ?>

						<?php hellix_social_icons( 'text-white' ); ?>

					</div>
				</div>
			</div>
			<?php
		endif;
	}
}

if ( ! function_exists( 'hellix_header_topbar_1' ) ) {
	/**
	 * Display Hellix HeaderTopBar.
	 */
	function hellix_header_topbar_1() {
		$enable_topbar = hellix_header_topbar_inner_content();
		$sticky        = true === hellix_navbar_is_sticky() ? 'topbar-sticky' : '';

		if ( 'yes' == $enable_topbar ) :
			?>
		<div class="topbar bg-white md:d-none <?php echo esc_attr( $sticky ); ?>">
			<div class="col-12 px-30">
				<div class="row align-items-center justify-content-between">

					<?php hellix_header_topbar_content( 'text-black' ); ?>

					<?php hellix_social_icons( 'text-black' ); ?>

				</div>
			</div>
		</div>
			<?php
		endif;
	}
}

if ( ! function_exists( 'hellix_header_topbar_inner_content' ) ) {
	/**
	 * Display Hellix HeaderTopBarInner.
	 */
	function hellix_header_topbar_inner_content() {

		$hx_page_options = array();

		if ( function_exists( 'hellix_option_enabled_post_types' ) && is_singular( hellix_option_enabled_post_types() ) ) {
			$clean_meta_data  = get_post_meta( get_the_ID(), '_hx_page_options', true );
			$_hx_page_options = maybe_unserialize( $clean_meta_data );

			if ( is_array( $_hx_page_options ) ) {
				$hx_page_options = $_hx_page_options;
			}
		}

		if ( hellix_has_custom_header( $hx_page_options ) ) {
			$enable_topbar = ( isset( $hx_page_options['header']['hellix_enable_topbar'] ) && ( '' !== $hx_page_options['header']['hellix_enable_topbar'] ) ) ? $hx_page_options['header']['hellix_enable_topbar'] : 'no';
		} else {
			$enable_topbar = get_theme_mod( 'enable_topbar', 'yes' );
		}
		return $enable_topbar;
	}
}

if ( ! function_exists( 'hellix_header_toolbar' ) ) {
	/**
	 * Display Hellix HeaderTopBar.
	 */
	function hellix_header_toolbar() {
		?>
		<div class="mainSlider__info md:d-none" data-anim-child="slide-up delay-6">
			<div class="mainSlider__info__item">
				<i class="mainSlider__info__icon text-white icon-rocket"></i>
				<a data-barba href="#" class="mainSlider__info__text text-white"><?php echo esc_html__( '+(123) 1234-567-8901', 'hellix' ); ?></a>
			</div>
			<div class="mainSlider__info__item">
				<i class="mainSlider__info__icon text-white icon-rocket"></i>
				<a data-barba href="#" class="mainSlider__info__text text-white"><?php echo esc_html__( 'hello@hellix.com', 'hellix' ); ?></a>
			</div>
			<div class="mainSlider__info__item">
				<i class="mainSlider__info__icon text-white icon-rocket"></i>
				<a data-barba href="#" class="mainSlider__info__text text-white"><?php echo esc_html__( 'Mon - Sat 8:00 - 17:30, Sunday - CLOSED', 'hellix' ); ?></a>
			</div>
			</div>
			<?php
	}
}

if ( ! function_exists( 'hellix_header_topbar_content' ) ) {
	/**
	 * Display Hellix HeaderTopBar.
	 *
	 * @param string $txt_color Should display color for the text.
	 */
	function hellix_header_topbar_content( $txt_color ) {

		$header_variant = hellix_get_header_version();

		$enable_topbar = hellix_header_topbar_inner_content();

		if ( apply_filters( 'hellix_enable_topbar', filter_var( $enable_topbar, FILTER_VALIDATE_BOOLEAN ) && ( has_nav_menu( 'topbar' ) ) ) ) :

			if ( 'v2' === $header_variant || 'v3' === $header_variant ) :
				?>
				<div class="col-auto">
					<div class="topbar__info">
				<?php

				if ( has_nav_menu( 'topbar' ) ) {
					wp_nav_menu(
						apply_filters(
							'hellix_topbar_left_args',
							[
								'theme_location' => 'topbar',
								'walker'         => new Walker_Nav_Topbar(),
								'container'      => false,
								'menu_id_prefix' => 'topbar',
								'wrap_class'     => 'topbar__item',
								'anchor_class'   => 'topbar__text ' . $txt_color,
								'item_class'     => 'topbar__icon ' . $txt_color,
								'after'          => '</div>',
								'before'         => '</i>',
								'items_wrap'     => '%3$s',
							]
						)
					);
				}
				?>
					</div>
				</div> 
				<?php
			endif;
		endif;
		if ( 'v4' === $header_variant ) {
			?>
			<div class="mainSlider__info md:d-none" data-anim-child="slide-up delay-6"> 
			<?php
			if ( has_nav_menu( 'topbar' ) ) {
				wp_nav_menu(
					apply_filters(
						'hellix_topbar_content_args',
						[
							'theme_location' => 'topbar',
							'walker'         => new Walker_Nav_Topbar(),
							'container'      => false,
							'menu_id_prefix' => 'topbar',
							'wrap_class'     => 'mainSlider__info__item',
							'anchor_class'   => 'mainSlider__info__text ' . $txt_color,
							'item_class'     => 'mainSlider__info__icon ' . $txt_color,
							'after'          => '</div>',
							'before'         => '</i>',
							'items_wrap'     => '%3$s',
						]
					)
				);
			}
			?>
			</div>
			<?php
		}
	}
}

if ( ! function_exists( 'hellix_social_icons' ) ) {
	/**
	 * Display Social Icons in the header.
	 *
	 * @param string $txt_color Should display color for the text.
	 */
	function hellix_social_icons( $txt_color ) {

		$header_variant = hellix_get_header_version();

		$enable_topbar = hellix_header_topbar_inner_content();

		if ( apply_filters( 'hellix_enable_topbar', filter_var( $enable_topbar, FILTER_VALIDATE_BOOLEAN ) && ( has_nav_menu( 'social' ) ) ) ) :

			if ( 'v2' === $header_variant || 'v3' === $header_variant ) :
				?>
			<div class="col-auto">
				<div class="topbar__socials">
					<div class="topbar__socials_content">
					<?php
						hellix_social_icon_loop( $txt_color );
					?>
					</div>
				</div>
			</div>
				<?php
			endif;
		endif;
	}
}

if ( ! function_exists( 'hellix_social_icon_loop' ) ) {
	/**
	 * Display social icon loop.
	 *
	 * @param string $txt_color Should display color for the text.
	 */
	function hellix_social_icon_loop( $txt_color ) {

		if ( has_nav_menu( 'social' ) ) {
			$topbar_left_menu_args = apply_filters(
				'hellix_topbar_left_args',
				[
					'theme_location' => 'social',
					'walker'         => new Walker_Nav_Topbar(),
					'container'      => false,
					'menu_id_prefix' => 'social',
					'anchor_class'   => $txt_color,
					'items_wrap'     => '%3$s',
					'before'         => '<i>',
				]
			);
			wp_nav_menu( $topbar_left_menu_args );
		}
	}
}

if ( ! function_exists( 'hellix_header_logo_1' ) ) {
	/**
	 * Display logo in the header-v2.
	 */
	function hellix_header_logo_1() {
		?>
		<div class="col-auto z-5 position-unset">
			<div class="header__item -margin-sm">
				<?php hellix_header_logo_inner( 'text-white' ); ?>
				<?php hellix_primary_menu( 'text-white' ); ?>
			</div>
		</div>
		<?php
	}
}

if ( ! function_exists( 'hellix_secondary_menu' ) ) {
	/**
	 * Display header primary menu.
	 */
	function hellix_secondary_menu() {
		?>
		<div class="header__nav_wrap">
			<div class="side-nav"> 
			<?php

			if ( has_nav_menu( 'secondary' ) ) {
				$secondary_menu_args = apply_filters(
					'hellix_secondary_args',
					[
						'theme_location' => 'secondary',
						'walker'         => new Walker_Nav_Topbar(),
						'container'      => false,
						'menu_id_prefix' => 'secondary',
						'items_wrap'     => '%3$s',
						'before'         => '<div class="side-nav__item">',
						'after'          => '</div>',
					]
				);
				wp_nav_menu( $secondary_menu_args );
			}
			?>
			</div>
		</div> 
		<?php
	}
}

if ( ! function_exists( 'hellix_primary_menu_light' ) ) {
	/**
	 * Display header primary menu light version.
	 */
	function hellix_primary_menu_light() {
		?>
		<div class="col"><?php hellix_primary_menu( 'text-white' ); ?></div>
		<?php
	}
}

if ( ! function_exists( 'hellix_primary_menu' ) ) {
	/**
	 * Display header primary menu.
	 *
	 * @param string $txt_color Should display color for the text.
	 */
	function hellix_primary_menu( $txt_color ) {

		$args = apply_filters(
			'hellix_primary_menu_args',
			array(
				'theme_location' => 'primary',
				'walker'         => new Walker_Nav_Primary(),
				'container'      => false,
				'menu_class'     => 'nav js-navList',
				'item_class'     => $txt_color,
			)
		);

		?>
		<div class="menu js-menu">
			<div class="mobile__background js-mobile-bg"></div>
			<div class="menu__container">
				<div class="mobile__back js-nav-list-back pointer-events-none">
					<a data-barba href="#">Homes</a>
				</div>
				<?php wp_nav_menu( $args ); ?>
			</div>
			<?php hellix_mobile_footer(); ?>
		</div>
		<?php
	}
}

if ( ! function_exists( 'hellix_mobile_footer' ) ) {
	/**
	 * Display header mobile footer.
	 */
	function hellix_mobile_footer() {
		$copyright = function_exists( 'hellix_footer_copyright' ) && ! empty( hellix_footer_copyright() ) ? hellix_footer_copyright() : '';

		?>
		<div class="mobile__footer js-mobile-footer">
			<div class="mobile__copyright mb-5">
			  <?php hellix_footer_logo(); ?>
			  <p><?php echo wp_kses_post( $copyright ); ?></p>
			</div>
		</div>
		<?php
	}
}

if ( ! function_exists( 'hellix_header_icons' ) ) {
	/**
	 * Header icons
	 */
	function hellix_header_icons() {
		?>
		<div class="col-auto z-5 sm:pos-unset js-header-item">
			<div class="header__icons">
				<?php do_action( 'hellix_header_icons' ); ?>
			</div>
		</div>
		<?php
	}
}

if ( ! function_exists( 'hellix_header_home_v4' ) ) {
	/**
	 * Header icons
	 */
	function hellix_header_home_v4() {
		?>
		<div class="col-auto pos-unset js-header-item">
			<div class="header__icons ">
				<?php hellix_primary_menu( 'text-white' ); ?>
				<?php hellix_header_cart( 'text-white' ); ?>
				<?php hellix_header_search_icon( 'text-white' ); ?>
				<?php hellix_header_offcanvas_menu_icon( 'text-white' ); ?>
			</div>
		</div>
		<?php
	}
}

if ( ! function_exists( 'hellix_header_icons_1' ) ) {
	/**
	 * Header icons
	 */
	function hellix_header_icons_1() {
		?>
		<div class="col-auto sm:pos-unset js-header-item">
			<div class="header__icons -separate">
				<?php hellix_header_cart( 'text-black' ); ?>
				<?php hellix_header_search_icon( 'text-black' ); ?>
				<?php hellix_header_offcanvas_menu_icon( 'text-black' ); ?>
			</div>
		</div>
		<?php
	}
}

if ( ! function_exists( 'hellix_header_search_icon' ) ) {
	/**
	 * Display Header Search Icon.
	 *
	 * @param string $txt_color Should display color for the text.
	 */
	function hellix_header_search_icon( $txt_color ) {

		$enable_search = hellix_navbar_is_search();

		if ( hellix_navbar_is_search() ) :
			$header_variant = hellix_get_header_version();

			?>
			<div class="header__search">
				<button class="js-headerSearch-open"><i class="icon <?php echo esc_attr( $txt_color ); ?> icon-search"></i></button>
			</div>
			<?php
		endif;
	}
}

if ( ! function_exists( 'hellix_header_offcanvas_menu_icon' ) ) {
	/**
	 * Display Header Search Icon.
	 *
	 * @param string $txt_color Should display color for the text.
	 */
	function hellix_header_offcanvas_menu_icon( $txt_color = 'text-white' ) {
		$enable_offcanvas = get_theme_mod( 'enable_offcanvas', true );
		if ( 'no' === $enable_offcanvas ) {
			return;
		}

		$header_menu = 'header__menu ';
		if ( empty( is_active_sidebar( 'canvas-sidebar' ) ) ) {
			$header_menu .= 'd-lg-none';
		}
		?>

		<div class="<?php echo esc_attr( $header_menu ); ?>">
			<button type="button" class="nav-button-open md:d-none js-sidebar-open">
			<i class="icon <?php echo esc_attr( $txt_color ); ?> icon-menu"></i>
			</button>
			<button type="button" class="nav-button-open d-none md:d-block js-nav-open">
			<i class="icon <?php echo esc_attr( $txt_color ); ?> icon-menu"></i>
			</button>
			<button type="button" class="nav-button-close d-none md:d-block pointer-events-none js-nav-close">
			<i class="icon <?php echo esc_attr( $txt_color ); ?> icon-cross"></i>
			</button>
		</div>
		<?php
	}
}

if ( ! function_exists( 'hellix_header_search_light' ) ) {
	/**
	 * Display header search form with light color.
	 */
	function hellix_header_search_light() {
		hellix_header_search( 'text-white' );
	}
}

if ( ! function_exists( 'hellix_header_search_dark' ) ) {
	/**
	 * Display header search form with dark color.
	 */
	function hellix_header_search_dark() {
		hellix_header_search( 'text-black' );
	}
}

if ( ! function_exists( 'hellix_header_search' ) ) {
	/**
	 * Display header search form.
	 *
	 * @param string $txt_color Should display color for the text.
	 */
	function hellix_header_search( $txt_color ) {
		$enable_search = hellix_navbar_is_search();
		if ( $enable_search ) :
			?>
			<div class="headerSearch js-headerSearch">
				<div class="headerSearch__line"></div>
				<?php get_search_form(); ?> 
				<button class="headerSearch__close js-headerSearch-close"><i class="icon icon-cross text-white"></i></button>
			</div>
			<?php
		endif;
	}
}

if ( ! function_exists( 'hellix_header_cart' ) ) {
	/**
	 * Display header search form.
	 *
	 * @param string $txt_color Should display color for the text.
	 */
	function hellix_header_cart( $txt_color ) {
		$enable_cart = hellix_navbar_is_cart();

		if ( hellix_is_woocommerce_activated() ) {
			if ( $enable_cart ) :
				?>
				<div class="header__cart">
					<a data-barba href="<?php echo esc_url( wc_get_cart_url() ); ?>">
						<i class="icon <?php echo esc_attr( $txt_color ); ?> icon-cart"></i>
						<span class="navbar-tool-badge"><?php hellix_cart_link_count(); ?></span>
					</a>
					<?php hellix_header_offcanvas_toggler(); ?>
				</div>
				<?php
		endif;
		}
	}
}

if ( ! function_exists( 'hellix_cart_link_count' ) ) {
	/**
	 * Cart link count
	 */
	function hellix_cart_link_count() {
		?>
		<span class="cart-contents-count">
			<?php echo absint( is_a( WC()->cart, 'WC_Cart' ) ? WC()->cart->get_cart_contents_count() : 0 ); ?>
		</span>

		<?php
	}
}

if ( ! function_exists( 'hellix_wc_offcanvas_mini_cart' ) ) {
	/**
	 * Offcanvas Mini cart
	 */
	function hellix_wc_offcanvas_mini_cart() {
		?>

	<div class="headerCart js-headerCart">
		<?php hellix_wc_offcanvas_mini_cart_content(); ?>
	</div>
		<?php

	}
}

if ( ! function_exists( 'hellix_wc_offcanvas_mini_cart_content' ) ) {
	/**
	 * Offcanvas Mini cart content
	 */
	function hellix_wc_offcanvas_mini_cart_content() {
		?>
		<div class="hellix-minicart1">
			<?php woocommerce_mini_cart(); ?>
		</div>
		<?php
	}
}

if ( ! function_exists( 'hellix_header_offcanvas_toggler' ) ) {
	/**
	 * Offcanvas Mini cart toggler
	 */
	function hellix_header_offcanvas_toggler() {
		if ( hellix_is_woocommerce_activated() ) :
			hellix_wc_offcanvas_mini_cart();
		endif;
	}
}

if ( ! function_exists( 'hellix_header_logo_inner' ) ) {
	/**
	 * Display logo in the header-v2.
	 *
	 * @param string $txt_color Should display color for the text.
	 */
	function hellix_header_logo_inner( $txt_color ) {

		$header_variant = hellix_get_header_version();

		if ( 'v3' === $header_variant ) {
			 $txt_color .= ' bg-black';

		} elseif ( 'v7' === $header_variant ) {
			$txt_color .= ' z-5';
		}
		?>
		<div class="header__logo <?php echo esc_attr( $txt_color ); ?> js-header-logo">
			<?php hellix_site_title_or_logo( true, $txt_color ); ?>
		</div>
		<?php
	}
}

if ( ! function_exists( 'hellix_site_title_or_logo' ) ) {
	/**
	 * Display the site title or logo
	 *
	 * @param bool   $echo Should display or return the title/logo.
	 *
	 * @param string $txt_color Should display color for the text.
	 */
	function hellix_site_title_or_logo( $echo = true, $txt_color ) {

		$logo_variant = get_theme_mod( 'logo_variant', 'site_logo' );

		$hx_page_options = array();

		if ( function_exists( 'hellix_option_enabled_post_types' ) && is_singular( hellix_option_enabled_post_types() ) ) {
			$clean_meta_data  = get_post_meta( get_the_ID(), '_hx_page_options', true );
			$_hx_page_options = maybe_unserialize( $clean_meta_data );

			if ( is_array( $_hx_page_options ) ) {
				$hx_page_options = $_hx_page_options;
			}
		}

		$elementor_logo_id     = isset( $hx_page_options['header']['hellix_custom_logo'] ) ? $hx_page_options['header']['hellix_custom_logo'] : '';
		$enable_elementor_logo = isset( $hx_page_options['header']['hellix_use_custom_logo'] ) && 'yes' === $hx_page_options['header']['hellix_use_custom_logo'] ? true : false;

		if ( hellix_has_custom_header( $hx_page_options ) && $enable_elementor_logo && $elementor_logo_id['id'] > 0 ) {

			$html = sprintf(
				'<a data-barba href="%1$s" class="hellix-elementor-logo" rel="' . esc_attr__( 'Logo', 'hellix' ) . '">%2$s</a>',
				esc_url( home_url( '/' ) ),
				wp_get_attachment_image( $elementor_logo_id['id'], '', false )
			);
		} elseif ( 'site_logo' === $logo_variant ) {

			if ( function_exists( 'the_custom_logo' ) && has_custom_logo() ) {
				$logo = get_custom_logo();
				$html = is_home() ? '<a data-barba href="' . esc_url( home_url( '/' ) ) . '" rel="' . esc_attr__( 'Logo', 'hellix' ) . '">' . $logo . '</a>' : $logo;
			} else {
				$html = '<h1 class="site-title site-branding-text  ' . esc_attr( $txt_color ) . '"><a data-barba href="' . esc_url( home_url( '/' ) ) . '" rel="' . esc_attr__( 'Logo', 'hellix' ) . '">' . esc_html( get_bloginfo( 'name' ) ) . '</a></h1>';
			}
		} elseif ( 'site_icon' === $logo_variant ) {
			$site_icon_url = get_site_icon_url( 58 );
			if ( ! empty( $site_icon_url ) ) {

				$html = '<img  width="58" src="' . esc_url( $site_icon_url ) . '" alt="' . esc_attr( get_bloginfo( 'name' ) ) . '">';
			} else {
				$html = '<h1 class="site-title site-branding-text  ' . esc_attr( $txt_color ) . '"><a data-barba href="' . esc_url( home_url( '/' ) ) . '" rel="' . esc_attr__( 'Logo', 'hellix' ) . '">' . esc_html( get_bloginfo( 'name' ) ) . '</a></h1>';
			}
		} elseif ( 'hellix_icon' === $logo_variant ) {
			$html = '<a data-barba href="' . esc_url( home_url( '/' ) ) . '" rel="Logo"><i class="icon icon-logo"></i></a>';
		}

		if ( ! $echo ) {
			return $html;
		}

		echo apply_filters( 'hellix_header_site_title', $html ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	}
}

if ( ! function_exists( 'hellix_mobile_logo' ) ) {
	/**
	 * Display the site title or logo
	 *
	 * @param bool   $echo Should display or return the title/logo.
	 *
	 * @param string $txt_color Should display color for the text.
	 */
	function hellix_mobile_logo( $echo = true, $txt_color ) {

		$mobile_logo = get_theme_mod( 'mobile_logo' );

		$hx_page_options = array();

		if ( function_exists( 'hellix_option_enabled_post_types' ) && is_singular( hellix_option_enabled_post_types() ) ) {
			$clean_meta_data  = get_post_meta( get_the_ID(), '_hx_page_options', true );
			$_hx_page_options = maybe_unserialize( $clean_meta_data );

			if ( is_array( $_hx_page_options ) ) {
				$hx_page_options = $_hx_page_options;
			}
		}

		$custom_mobile_logo_url = wp_get_attachment_image( $mobile_logo, '', false );

		$elementor_logo_id     = isset( $hx_page_options['header']['hellix_mobile_logo'] ) ? $hx_page_options['header']['hellix_mobile_logo'] : '';
		$enable_elementor_logo = isset( $hx_page_options['header']['hellix_use_custom_logo'] ) && 'yes' === $hx_page_options['header']['hellix_use_custom_logo'] ? true : false;

		if ( hellix_has_custom_header( $hx_page_options ) && $enable_elementor_logo && $elementor_logo_id['id'] > 0 ) {

			$html = sprintf(
				'<div class="header__logo <?php echo esc_attr( $txt_color ); ?> js-header-logo"><a data-barba href="%1$s" class="hellix-elementor-logo" rel="' . esc_attr__( 'Logo', 'hellix' ) . '">%2$s</a></div>',
				esc_url( home_url( '/' ) ),
				wp_get_attachment_image( $elementor_logo_id['id'], '', false )
			);
		} else {
			$html = $custom_mobile_logo_url;
		}

		if ( ! $echo ) {
			return $html;
		}

		echo apply_filters( 'hellix_mobile_site_title', $html ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	}
}

if ( ! function_exists( 'hellix_header_home_dark' ) ) {
	/**
	 * Display content in the header-v5 dark mode.
	 */
	function hellix_header_home_dark() {
		hellix_header_home_5( 'text-black' );
	}
}

if ( ! function_exists( 'hellix_header_home_light' ) ) {
	/**
	 * Display content in the header-v5 light.
	 */
	function hellix_header_home_light() {
		hellix_header_home_5( 'text-white' );
	}
}

if ( ! function_exists( 'hellix_header_home_5' ) ) {
	/**
	 * Display content in the header-v5.
	 *
	 * @param string $txt_color Should display color for the text.
	 */
	function hellix_header_home_5( $txt_color ) {
		?>

		<div class="col-auto z-5 position-unset">
			<div class="header__item -margin-lg">
				<?php hellix_header_logo_inner( $txt_color ); ?>
				<?php hellix_primary_menu( $txt_color ); ?>
			</div>
		</div>
		<div class="col-auto z-5 sm:pos-unset">
			<div class="header__icons ">
				<?php hellix_header_cart( $txt_color ); ?>
				<?php hellix_header_search_icon( $txt_color ); ?>
				<?php hellix_header_offcanvas_menu_icon( $txt_color ); ?>
				<?php hellix_header_offcanvas_toggler(); ?>
			</div>
		</div>
		<?php
	}
}

if ( ! function_exists( 'hellix_header_home_7' ) ) {
	/**
	 * Display content in the header-v5.
	 */
	function hellix_header_home_7() {
		?>
		<div class="col-auto">
			<div class="header__item">
				<?php hellix_header_logo_inner( 'text-white' ); ?>
				<?php hellix_primary_menu( 'text-white' ); ?>
			</div>
		</div>
		<div class="col-auto">
			<div class="header__icons z-5">
				<?php hellix_header_cart( 'text-white' ); ?>
				<?php hellix_header_search_icon( 'text-white' ); ?>
				<?php hellix_header_offcanvas_menu_icon( 'text-white' ); ?>
			</div>
		</div>
		<?php
	}
}

if ( ! function_exists( 'hellix_header_home_9' ) ) {
	/**
	 * Display content in the header-v6.
	 */
	function hellix_header_home_9() {
		?>
		<div class="col-auto z-5 sm:pos-unset">
			<div class="header__icons">
				<?php hellix_header_cart( 'text-white' ); ?>
				<?php hellix_header_search_icon( 'text-white' ); ?>
				<?php hellix_header_offcanvas_menu_icon( 'text-white' ); ?>
			</div>
		</div>
		<?php
	}
}

if ( ! function_exists( 'hellix_header_home_footer' ) ) {
	/**
	 * Display content in the header-v6.
	 */
	function hellix_header_home_footer() {
		$copyright = function_exists( 'hellix_footer_copyright' ) && ! empty( hellix_footer_copyright() ) ? hellix_footer_copyright() : '';
		?>
		<div class="header__footer">
			<span class="header__copyright text-sm"><?php echo esc_html( $copyright ); ?></span>
			<div class="header__socials">
				<?php hellix_social_icon_loop( 'text-black' ); ?>
			</div>
		</div>
		<?php
	}
}

if ( ! function_exists( 'hellix_navbar_is_search' ) ) {
	/**
	 * Enable Search
	 */
	function hellix_navbar_is_search() {

		$hx_page_options = array();

		if ( function_exists( 'hellix_option_enabled_post_types' ) && is_singular( hellix_option_enabled_post_types() ) ) {
			$clean_meta_data  = get_post_meta( get_the_ID(), '_hx_page_options', true );
			$_hx_page_options = maybe_unserialize( $clean_meta_data );

			if ( is_array( $_hx_page_options ) ) {
				$hx_page_options = $_hx_page_options;
			}
		}

		if ( hellix_has_custom_header( $hx_page_options ) ) {
			$enable_search = ( isset( $hx_page_options['header']['hellix_enable_navbar_search'] ) && ( '' !== $hx_page_options['header']['hellix_enable_navbar_search'] ) ) ? $hx_page_options['header']['hellix_enable_navbar_search'] : 'no';
		} else {
			$enable_search = get_theme_mod( 'enable_search', true );
		}

		return apply_filters( 'hellix_enable_search', filter_var( $enable_search, FILTER_VALIDATE_BOOLEAN ) );
	}
}

if ( ! function_exists( 'hellix_navbar_is_cart' ) ) {
	/**
	 * Enable Cart
	 */
	function hellix_navbar_is_cart() {

		$hx_page_options = array();

		if ( function_exists( 'hellix_option_enabled_post_types' ) && is_singular( hellix_option_enabled_post_types() ) ) {
			$clean_meta_data  = get_post_meta( get_the_ID(), '_hx_page_options', true );
			$_hx_page_options = maybe_unserialize( $clean_meta_data );

			if ( is_array( $_hx_page_options ) ) {
				$hx_page_options = $_hx_page_options;
			}
		}

		if ( hellix_has_custom_header( $hx_page_options ) ) {
			$enable_cart = ( isset( $hx_page_options['header']['enable_cart'] ) && ( '' !== $hx_page_options['header']['enable_cart'] ) ) ? $hx_page_options['header']['enable_cart'] : 'no';
		} else {
			$enable_cart = get_theme_mod( 'enable_cart', true );
		}

		return apply_filters( 'hellix_enable_cart', filter_var( $enable_cart, FILTER_VALIDATE_BOOLEAN ) );
	}
}

if ( ! function_exists( 'hellix_navbar_is_sticky' ) ) {
	/**
	 * Enable Sticky
	 */
	function hellix_navbar_is_sticky() {

		$hx_page_options = array();
		if ( function_exists( 'hellix_option_enabled_post_types' ) && is_singular( hellix_option_enabled_post_types() ) ) {
			$clean_meta_data  = get_post_meta( get_the_ID(), '_hx_page_options', true );
			$_hx_page_options = maybe_unserialize( $clean_meta_data );

			if ( is_array( $_hx_page_options ) ) {
				$hx_page_options = $_hx_page_options;
			}
		}

		if ( hellix_has_custom_header( $hx_page_options ) ) {
			$enable_sticky = isset( $hx_page_options['header']['enable_sticky'] ) ? $hx_page_options['header']['enable_sticky'] : '';
		} else {
			$enable_sticky = get_theme_mod( 'hellix_header_sticky' );
		}
		return apply_filters( 'hellix_enable_sticky', filter_var( $enable_sticky, FILTER_VALIDATE_BOOLEAN ) );
	}
}
