<?php
/**
 * Template functions used in loop post.
 *
 * @package hellix
 */

if ( ! function_exists( 'hellix_loop_post_header' ) ) {
	/**
	 * Display post header in the loop
	 */
	function hellix_loop_post_header() {
		if ( has_post_thumbnail() ) :
			$image_class  = 'bg-[#f9f6f6] ratio ratio-93:53 js-lazy bg-cover';
			$image_class .= hellix_is_extensions_activated() ? ' bg-image' : ' img';
			?>
		<div class="blogCard__image mb-20">
			<div class="<?php echo esc_attr( $image_class ); ?>" data-bg="<?php echo esc_attr( get_the_post_thumbnail_url( null, 'full' ) ); ?>"></div>
		</div>
			<?php
		endif;
	}
}

if ( ! function_exists( 'hellix_loop_post_content_wrap_start' ) ) {
	/**
	 * Output content wrap start
	 */
	function hellix_loop_post_content_wrap_start() {
		?>
		<div class="blogCard__content">
		<?php
	}
}

if ( ! function_exists( 'hellix_get_post_date_string' ) ) {
	/**
	 * Returns post date time output string.
	 *
	 * @return string
	 */
	function hellix_get_post_date_string() {
		// Posted on.
		$time_string = '<time class="entry-date uppercase published updated" datetime="%1$s">%2$s</time>';

		if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
			$time_string = '<time class="entry-date uppercase published sr-only" datetime="%1$s">%2$s</time><time class="updated" datetime="%3$s">%4$s</time>';
		}

		$time_string = sprintf(
			$time_string,
			esc_attr( get_the_date( 'c' ) ),
			esc_html( get_the_date() ),
			esc_attr( get_the_modified_date( 'c' ) ),
			esc_html( get_the_modified_date() )
		);

		return $time_string;
	}
}

if ( ! function_exists( 'hellix_loop_post_meta' ) ) {
	/**
	 * Output loop post meta.
	 */
	function hellix_loop_post_meta() {

		$time_string        = hellix_get_post_date_string();
		$output_time_string = sprintf( '<a href="%1$s" class="uppercase text-accent" rel="bookmark">%2$s</a>', esc_url( get_permalink() ), $time_string );

		// Author.
		$author = sprintf(
			'<a href="%1$s" class="uppercase text-accent" rel="author">%2$s</a>',
			esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
			esc_html( get_the_author() )
		);

		?>
		<div class="blogCard__category x-gap-20 mb-8 font-medium">
			<?php
			echo wp_kses(
				sprintf( '%1$s %2$s', $output_time_string, $author ),
				array(
					'a'    => array(
						'href'  => array(),
						'title' => array(),
						'rel'   => array(),
						'class' => array(),
					),
					'time' => array(
						'datetime' => array(),
						'class'    => array(),
					),
				)
			);
			?>
		</div>
		<?php
	}
}

if ( ! function_exists( 'hellix_loop_grid_post_meta' ) ) {
	/**
	 * Output loop post meta.
	 */
	function hellix_loop_grid_post_meta() {
		// Posted on.
		$time_string = '<time class="entry-date uppercase published updated" datetime="%1$s">%2$s</time>';

		if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
			$time_string = '<time class="entry-date uppercase published sr-only" datetime="%1$s">%2$s</time><time class="updated" datetime="%3$s">%4$s</time>';
		}

		$time_string = sprintf(
			$time_string,
			esc_attr( get_the_date( 'c' ) ),
			esc_html( get_the_date() ),
			esc_attr( get_the_modified_date( 'c' ) ),
			esc_html( get_the_modified_date() )
		);

		$output_time_string = sprintf( '<a data-barba href="%1$s">%2$s</a>', esc_url( get_permalink() ), $time_string );

		// Author.
		$author = sprintf(
			'<a data-barba href="%1$s">%2$s</a>',
			esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
			esc_html( get_the_author() )
		);

		?>
			<?php
			echo wp_kses(
				sprintf( '%1$s %2$s', $output_time_string, $author ),
				array(
					'a'    => array(
						'href'  => array(),
						'title' => array(),
						'rel'   => array(),
						'class' => array(),
					),
					'time' => array(
						'datetime' => array(),
						'class'    => array(),
					),
				)
			);
			?>
		<?php
	}
}


if ( ! function_exists( 'hellix_loop_post_title' ) ) {
	/**
	 * Display post title in the loop.
	 */
	function hellix_loop_post_title() {
		$prepend = '';

		if ( is_sticky() ) {
			$prepend = '<span class="sticky-badge badge badge badge-dark font-size-14 font-weight-normal align-middle ml-2">' . esc_html__( 'Featured', 'hellix' ) . '</span>';
		}

		the_title( sprintf( '<h4 class="blogCard__title text-2xl fw-600"><a href="%s" class="text-gray-3 group-hover:text-accent d-flex align-items-center" rel="bookmark"><span class="max-w-full">', esc_url( get_permalink() ) ), '</span>' . $prepend . '</a></h4>' );

	}
}

if ( ! function_exists( 'hellix_loop_post_content' ) ) {
	/**
	 * Output loop post title.
	 */
	function hellix_loop_post_content() {
		?>
		<?php hellix_loop_post_title(); ?>
		<div class="blogCard__text mt-20"><?php the_excerpt(); ?></div>
		<div class="blogCard__link mt-20">
			<a data-barba href="<?php the_permalink(); ?>" class="stretched-link position-static button -simple text-black"><?php esc_html_e( 'Read More', 'hellix' ); ?></a>
		</div>
		<?php
	}
}

if ( ! function_exists( 'hellix_loop_post_content_wrap_end' ) ) {
	/**
	 * Output content wrap end
	 */
	function hellix_loop_post_content_wrap_end() {
		?>
		</div><!-- /.blogCard__content -->
		<?php
	}
}

if ( ! function_exists( 'hellix_post_filters' ) ) :
	/**
	 * Output the post category filter.
	 */
	function hellix_post_filters() {

		$post_cats = array();

		while ( have_posts() ) :
			the_post();

			$post_types = get_the_terms( get_the_ID(), 'category' );
			if ( ! $post_types || is_wp_error( $post_types ) ) {
				$post_types = array();
			}

			$post_types = array_values( $post_types );

			foreach ( array_keys( $post_types ) as $key ) {
				_make_cat_compat( $post_types[ $key ] );
			}

			foreach ( $post_types as $post_type ) {
				$post_cats[ $post_type->slug ] = $post_type->name;
			}

		endwhile;
		?>
		<div class="row justify-content-center">
			<div class="col-auto">
				<div class="filter-button-group text-dark fw-500 mt-32">
					<button class="button mr-20 btn-active" data-filter="*"><?php echo esc_html__( 'All', 'hellix' ); ?></button>

					<?php
					foreach ( $post_cats as $key => $post_cat ) :
						$category_id   = get_cat_ID( $post_cat );
						$category_link = get_category_link( $category_id );
						?>
						<button class="button mr-20" data-filter=".<?php echo esc_attr( $key ); ?>" >
						<?php echo esc_html( $post_cat ); ?>
						</button>
					<?php endforeach; ?>
				</div>
			</div>
		</div>
		<?php
	}
endif;
