<?php
/**
 * Template functions assigned to Single Portfolio
 *
 * @package hellix
 */

if ( ! function_exists( 'hellix_portfolio_style' ) ) {
	/**
	 * Portfolio Layout
	 */
	function hellix_portfolio_style() {
		$layout = get_theme_mod( 'portfolio_style', 'v1' );
		return sanitize_key( apply_filters( 'portfolio_style', $layout ) );
	}
}

if ( ! function_exists( 'hellix_portfolio_type' ) ) {
	/**
	 * Portfolio Layout
	 */
	function hellix_portfolio_type() {
		$type = wp_strip_all_tags( get_the_term_list( get_the_ID(), 'jetpack-portfolio-type', '', ' / ' ) );
		return apply_filters( 'hellix_get_portfolio_type_list', $type );
	}
}

/**
 * Template functions related to portfolio
 */

if ( ! function_exists( 'hellix_portfolio_pagination' ) ) :
	/**
	 * Output the portfolio category filter.
	 */
	function hellix_portfolio_pagination() {
		?><div class="row justify-content-center mt-40">
			<div class="col-auto">
				<?php hellix_pagination(); ?>
			</div>
		</div>
		<?php
	}
endif;

if ( ! function_exists( 'hellix_portfolio_filters' ) ) :
	/**
	 * Output the portfolio category filter.
	 */
	function hellix_portfolio_filters() {

		$portfolio_cats = array();

		while ( have_posts() ) :
			the_post();

			$portfolio_types = get_the_terms( get_the_ID(), 'jetpack-portfolio-type' );
			if ( ! $portfolio_types || is_wp_error( $portfolio_types ) ) {
				$portfolio_types = array();
			}

			$portfolio_types = array_values( $portfolio_types );

			foreach ( array_keys( $portfolio_types ) as $key ) {
				_make_cat_compat( $portfolio_types[ $key ] );
			}

			foreach ( $portfolio_types as $portfolio_type ) {
				$portfolio_cats[ $portfolio_type->slug ] = $portfolio_type->name;
			}

		endwhile;
		?>
		
		<div class="row justify-content-center">
			<div class="col-auto">
				<div class="filter-button-group text-dark fw-500 mt-32">         
					<button class="button mr-20 btn-active" data-filter="*">All</button>
		   
					<?php foreach ( $portfolio_cats as $key => $portfolio_cat ) : ?>
		   
						<button class="button mr-20" data-filter=".<?php echo esc_attr( $key ); ?>" >
						<?php echo esc_html( $portfolio_cat ); ?>
						</button>
			  
					<?php endforeach; ?>
				</div>
			</div>
		</div>
		<?php
	}
endif;
