<?php
/**
 * Template functions related to single portfolio.
 *
 * @package hellix
 */

if ( ! function_exists( 'hellix_portfolio_content' ) ) {
	/**
	 * Function for Section Portfolio style 1
	 */
	function hellix_portfolio_content() {
		$view = hellix_get_project_version();

		if ( 'v1' === $view || 'v2' === $view || 'v3' === $view || 'v4' === $view ) {
			hellix_single_portfolio_content_v1();
		} elseif ( 'v5' === $view || 'v6' === $view ) {
			hellix_single_portfolio_content_v2();
		} else {
			hellix_single_portfolio_content_v3();
		}
	}
}

if ( ! function_exists( 'hellix_single_portfolio_content_v1' ) ) :
	/**
	 * Function for Section Portfolio Content Start
	 */
	function hellix_single_portfolio_content_v1() {
		$scroll        = hellix_portfolio_scroll();
		$content_class = 'project-single page-masthead__content ';

		if ( true === $scroll ) {
			$content_class .= 'js-pin-container';
		}
		hellix_output_page_masthead(); ?>
		<section class="layout-pt-md layout-pb-md">
		<div class="container">
			<div class="<?php echo esc_attr( $content_class ); ?>">
				<div class="row">
					<?php
					hellix_portfolio_gallery();
					hellix_single_portfolio_description();
					?>
				</div>
			</div>
		</div>
	</section>
		<?php
	}

endif;

if ( ! function_exists( 'hellix_single_portfolio_content_v2' ) ) :
	/**
	 * Function for Section Portfolio Content style 2
	 */
	function hellix_single_portfolio_content_v2() {
		$portfolio_single = hellix_acf_portfolio_attributes();
		hellix_output_page_masthead();
		?>
			
		<section class="layout-pt-md layout-pb-sm">
			<div class="container">
				<div class="row y-gap-60">
					<div class="col-lg-9">
						<h3 class="text-4xl leading-2xl md:mt-48"><?php the_title(); ?></h3>
						<div class="row y-gap-32 pt-32">
							<?php
							foreach ( $portfolio_single as $portfolio_single => $value ) :
								?>
								<div class="col-lg-4 col-6">
									<div class="text-xs leading-2xl uppercase text-black fw-600"><?php echo esc_html( $portfolio_single ); ?></div>
									<div class="text-sm leading-2xl mt-4"><?php echo esc_html( $value ); ?></div>
								</div>
							<?php endforeach; ?>
						</div>
					</div>
					<div class="col-lg-3">
						<?php hellix_section_single_portfolio_social_icons(); ?>
					</div>
				</div>
			</div>
		</section>
		<?php the_content(); ?>
		<?php
	}

endif;

if ( ! function_exists( 'hellix_single_portfolio_content_v3' ) ) {
	/**
	 * Function for Section Portfolio Content style 3
	 */
	function hellix_single_portfolio_content_v3() {
		$portfolio_single = hellix_acf_portfolio_attributes();
		?>
		<section class="layout-pt-2xl layout-pb-md">
			<div class="container-wide">
				<div class="row">
					<div class="col-lg-12">
						<h3 data-anim="slide-up delay-1" class="text-4xl leading-2xl md:mt-48"><?php the_title(); ?></h3>
					</div>
					<div class="col-12">
						<div data-anim="slide-up delay-2" class="row justify-content-between pt-32">
							<div class="col-lg-7">
								<div class="row y-gap-32">
									<?php foreach ( $portfolio_single as $portfolio_single => $value ) : ?>
									<div class="col-md-4 col-6">
										<div class="text-xs leading-2xl uppercase text-black fw-600"><?php echo esc_html( $portfolio_single ); ?></div>
										<div class="text-sm leading-2xl"><?php echo esc_html( $value ); ?></div>
									</div>
									<?php endforeach; ?>
								</div>
							</div>
							<div class="col-lg-2">
								<div class="text-xs leading-2xl uppercase text-black fw-600"><?php echo esc_html( 'SHARE' ); ?></div>
								<div class="socialsIcons mt-4">
									<?php
										$social_media_profiles = hellix_get_field( 'social_icons' );

										$profiles = explode( "\n", $social_media_profiles );

										$social_networks = [
											'facebook.com' => 'fa fa-facebook',
											'linkedin.com' => 'fa fa-linkedin',
											'twitter.com'  => 'fa fa-twitter',
											'instagram.com' => 'fa fa-instagram',
											'google.com'   => 'fa-google',
										];

										if ( isset( $profiles ) ) {
											foreach ( $profiles as $social_profile ) {
												$parse = parse_url( $social_profile );
												$url   = isset( $parse['host'] ) ? $parse['host'] : '';
												?>
											<a href="<?php echo esc_url( $social_profile ); ?>" class="text-dark">
												<i class="<?php echo esc_attr( $social_networks[ $url ] ); ?>"></i>
											</a>
												<?php
											}
										}
										?>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
		<?php
		if ( has_post_thumbnail() ) {
			?>
			<div>
				<div class="ratio ratio-16:9 bg-image js-lazy" data-bg="<?php echo esc_attr( get_the_post_thumbnail_url( null, 'full' ) ); ?>"></div>
			</div>
			<?php
		}
		the_content();
		?>
		<?php
	}
}


if ( ! function_exists( 'hellix_portfolio_gallery' ) ) :
	/**
	 * Function for Portfolio gallery
	 */
	function hellix_portfolio_gallery() {
		$view = hellix_get_project_version();

		$col_class = '';
		if ( 'v1' === $view ) {
			$col_class .= 'col-xl-8 col-lg-7';
		} elseif ( 'v2' === $view ) {
			$col_class .= 'col-lg-8 order-2';
		} elseif ( 'v3' === $view ) {
			$col_class .= 'col-lg-8';
		} elseif ( 'v4' === $view ) {
			$col_class .= 'col-xl-8 col-lg-7';
		}
		?>
		<div class="<?php echo esc_attr( $col_class ); ?>">
			<?php ( 'v4' === $view ? hellix_portfolio_image_gallery_carousel() : hellix_portfolio_image_gallery() ); ?>
		</div>
		<?php
	}

endif;

if ( ! function_exists( 'hellix_single_portfolio_description' ) ) :
	/**
	 * Function to display Portfolio description
	 */
	function hellix_single_portfolio_description() {
		$view         = hellix_get_project_version();
		$column_class = '';
		if ( 'v1' === $view ) {
			$column_class .= 'col-xl-4 col-lg-5 col-md-10 ';
		} elseif ( 'v2' === $view ) {
			$column_class .= 'col-lg-4 col-md-10 ';
		} elseif ( 'v3' === $view ) {
			$column_class .= 'col-lg-4 col-md-10';
		} elseif ( 'v4' === $view ) {
			$column_class .= 'col-xl-4  col-lg-5 col-md-10';
		}
		?>
		<div class="<?php echo esc_attr( $column_class ); ?>">
			<div class="js-pin-content text-left">
				<h3 class="text-4xl leading-2xl md:mt-48"><?php the_title(); ?></h3>
				<div class="text-sm leading-2xl mt-12"><?php the_content(); ?></div>
				<?php
					hellix_section_single_portfolio_details();
					hellix_section_single_portfolio_social_icons();
				?>
			</div>
		</div>
		<?php
	}

endif;


/**
* Function for Single Portfolio Attributes details
*/
if ( ! function_exists( 'hellix_section_single_portfolio_details' ) ) :
	/**
	 * Function to display Single Portfolio Attributes details
	 */
	function hellix_section_single_portfolio_details() {
		$portfolio_single = hellix_acf_portfolio_attributes();

		?>
		<div class="row y-gap-32 pt-32">
		<?php foreach ( $portfolio_single as $portfolio_single => $value ) : ?>
			<div class="col-lg-6 col-md-4 col-6">
				<div class="text-xs leading-2xl uppercase text-black fw-600"><?php echo esc_html( $portfolio_single ); ?></div>
				<div class="text-sm leading-2xl"><?php echo esc_html( $value ); ?></div>
			</div>
		<?php endforeach; ?>
		</div>
		<?php
	}
endif;

/**
* Function for Single Portfolio Social Icons
*/
if ( ! function_exists( 'hellix_section_single_portfolio_social_icons' ) ) :
	/**
	 * Function to display Single Portfolio Social Icons
	 */
	function hellix_section_single_portfolio_social_icons() {
		?>
		<div class="row y-gap-32 pt-32">
			<div class="col-md-6">
				<div class="text-xs leading-2xl uppercase text-black fw-600"><?php echo esc_html( 'SHARE' ); ?></div>
					<div class="socialsIcons mt-12">
						<?php
							$social_media_profiles = hellix_acf_portfolio_social_links();
							// print_r($social_media_profiles);

							$profiles = explode( "\n", $social_media_profiles );

							$social_networks = [
								'facebook'  	=> 'fa fa-facebook',
								'linkedin'  	=> 'fa fa-linkedin',
								'twitter'   	=> 'fa fa-twitter',
								'instagram' 	=> 'fa fa-instagram',
								'google'    	=> 'fa fa-google',
								'github'        => 'fa fa-github',
								'dribbble'      => 'fa fa-dribbble',
								'behance'       => 'fa fa-behance',
								'stackoverflow' => 'fa fa-stack-overflow',

							];

							if ( isset( $profiles ) ) {
								foreach ( $profiles as $social_profile ) {
									$parse = parse_url( $social_profile );
									$url   = isset( $parse['host'] ) ? $parse['host'] : '';
									$icon_index = explode( '.', $url );
									$icon_index = 'www' === $icon_index[0] ? $icon_index[1] : $icon_index[0];
									
									?>
								<a href="<?php echo esc_url( $social_profile ); ?>" class="text-dark">
									<i class="<?php echo esc_attr( $social_networks[ $icon_index ] ); ?>"></i>
								</a>
									<?php
								}
							}
							?>
					</div>
				</div>
			</div>
		<?php
	}

endif;

if ( ! function_exists( 'hellix_single_related_nav' ) ) {
	/**
	 * Single portfolio related navigation.
	 */
	function hellix_single_related_nav() {
		$prev_post     = get_previous_post();
		$next_post     = get_next_post();
		$archieve_link = get_post_type_archive_link( 'jetpack-portfolio' )

		?>
		<section class="related-nav py-40">
			<div class="container">
				<div class="row justify-content-between align-items-center">
					<div class="col-5">
						<?php if ( $prev_post ) : ?>
							<a data-barba href="<?php echo esc_url( get_permalink( $prev_post ) ); ?>" class="related-nav__item -prev">
								<div class="related-nav__arrow">
									<i class="icon icon-left-arrow"></i>
								</div>
								<div class="related-nav__content">
									<span><?php echo esc_html__( 'PREV', 'hellix' ); ?></span>
									<p><?php echo esc_html( get_the_title( $prev_post ) ); ?></p>
								</div>
							</a>
						
						<?php endif; ?>
					</div>

					<div class="col-auto md:d-none">
						<a class="related-nav__icon" href="<?php echo esc_url( get_post_type_archive_link( 'jetpack-portfolio' ) ); ?>">
							<span></span>
							<span></span>
							<span></span>
							<span></span>
						</a>
					</div>

					<?php if ( $next_post ) : ?>
					<div class="col-5">
						<a data-barba href="<?php echo esc_url( get_permalink( $next_post ) ); ?>" class="related-nav__item -next">
							<div class="related-nav__content">
								<span><?php echo esc_html__( 'NEXT', 'hellix' ); ?></span>
								<p><?php echo esc_html( get_the_title( $next_post ) ); ?></p>
							</div>

							<div class="related-nav__arrow">
								<i class="icon icon-right-arrow"></i>
							</div>
						</a>
					</div>
					<?php endif; ?>
				</div>
			</div>
		</section>
		<?php
	}
}

/**
 * Template functions related to Single portfolio
 */

if ( ! function_exists( 'hellix_single_portfolio_projects' ) ) :
	/**
	 * Function for Section Portfolio projects
	 */
	function hellix_single_portfolio_projects() {
		$related = get_theme_mod( 'related_projects', 'yes' );
		if ( 'yes' === $related ) {
			?>
			<section class="layout-pt-md layout-pb-md bg-beige-light">
				<div class="container">
					<?php
					hellix_single_portfolio_projects_heading();
					hellix_single_portfolio_related_works();
					?>
				</div>
			</section>
			<?php
		}
	}

endif;

if ( ! function_exists( 'hellix_single_portfolio_related_works' ) ) :
	/**
	 * Function for Section Portfolio related projects
	 */
	function hellix_single_portfolio_related_works() {
		$related_post = new WP_Query(
			array(
				'post_type'      => 'jetpack-portfolio',
				'posts_per_page' => 8,

			)
		);

		?>
		<div class="row layout-pt-sm">
			<div class="sectionSlider overflow-hidden sm:px-16 js-sectionSlider" data-gap="30" data-slider-col="base-3 lg-3 md-2 sm-1" data-pagination>
				<div class="swiper-wrapper">
				<?php
				while ( $related_post->have_posts() ) :
					$related_post->the_post();
					?>
					<div class="swiper-slide">
						<a data-barba href="<?php echo esc_url( get_permalink() ); ?>" class="portfolioCard -type-1 ratio">
							<div class="portfolioCard__image ratio ratio-3:4">
							<?php
								the_post_thumbnail(
									'full',
									[
										'class' => 'ratio-img js-lazy',
									]
								);
							?>
							</div>
							<div class="portfolioCard__content px-30 py-30">
								<span class="portfolioCard__category text-sm uppercase text-beige-dark"><?php echo esc_html( wp_strip_all_tags( get_the_term_list( get_the_ID(), 'jetpack-portfolio-type', '', ' / ' ) ) ); ?></span>
								<h3 class="portfolioCard__title text-lg mt-8 <?php echo esc_attr( $margin_class ); ?>"><?php the_title(); ?></h3>
							</div>
						</a>
					</div>
						<?php
					endwhile;
					wp_reset_postdata();
				?>
				</div>
				<?php hellix_related_pagination(); ?>
			</div>
		</div>
		<?php
	}

endif;

if ( ! function_exists( 'hellix_single_portfolio_projects_heading' ) ) :
	/**
	 * Function for Section Portfolio section heading
	 */
	function hellix_single_portfolio_projects_heading() {
		$pretitle = apply_filters( 'hellix_portfolio_related_works_pretitle', esc_html__( 'Works', 'hellix' ) );
		$title    = apply_filters( 'hellix_portfolio_related_works_title', esc_html__( 'Related Projects', 'hellix' ) );
		?>
		<div class="row justify-content-center">
			<div class="col-auto">
				<div class="sectionHeading -top-line text-center">
					<span class="sectionHeading__subtitle"><?php echo esc_html( $pretitle ); ?></span>
					<h2 class="sectionHeading__title"><?php echo esc_html( $title ); ?></h2>
				</div>
			</div>
		</div>
		<?php
	}
endif;

if ( ! function_exists( 'hellix_related_pagination' ) ) :
	/**
	 * Function for Section Portfolio related projects pagination
	 */
	function hellix_related_pagination() {
		?>
		<div class="nav -slider lg:d-none">
			<div class="nav__item -left js-prev">
				<i class="icon icon-left-arrow"></i>
			</div>

			<div class="nav__item -right js-next">
				<i class="icon icon-right-arrow"></i>
			</div>
		</div>

		<div class="pagination -slider mt-48 js-pagination"></div>
		<?php
	}

endif;

if ( ! function_exists( 'hellix_portfolio_image_gallery' ) ) {
	/**
	 * Function for Section Portfolio image gallery
	 */
	function hellix_portfolio_image_gallery() {
		global $post;
		$view           = hellix_get_project_version();
		$img_wrap_class = 'ratio ';
		$wrap_class     = 'gallery ';

		if ( 'v1' === $view ) {
			$wrap_class     .= 'y-gap-32 pr-80 lg:pr-0';
			$img_wrap_class .= 'ratio-77:60';
		} elseif ( 'v2' === $view ) {
			$wrap_class     .= 'y-gap-32 pl-80 lg:pr-0';
			$img_wrap_class .= 'ratio-1:1';
		} elseif ( 'v3' === $view ) {
			$wrap_class     .= 'row x-gap-10 y-gap-10 pr-80 lg:pr-0';
			$img_wrap_class .= 'ratio-77:60';
		}

		$portfolio_image_gallery = explode( ',', get_post_meta( $post->ID, '_portfolio_image_gallery', true ) );
		$attachments             = array_filter( $portfolio_image_gallery );

		if ( empty( $attachments ) ) {
			$post_thumbnail_id = get_post_thumbnail_id( $post->ID );
			array_unshift( $attachments, $post_thumbnail_id );
		}
		if ( ! empty( $attachments ) ) {
			?>
			<div class="<?php echo esc_attr( $wrap_class ); ?>">
			<?php
				$index = 0;
			foreach ( $attachments as $attachment_id ) {

				$attachment      = wp_get_attachment_image( $attachment_id, 'full', '', array( 'class' => 'ratio-img' ) );
				$attachment_link = wp_get_attachment_url( $attachment_id );

				if ( empty( $attachment ) ) {
					continue;
				}

				if ( 'v3' === $view ) {
					?>
						<div class="col-6">
						<?php
				}
				?>
					<a href="<?php echo esc_url( $attachment_link ); ?>" class="gallery__item js-gallery" data-gallery="gallery1">
						<div class="<?php echo esc_attr( $img_wrap_class ); ?>">
							<?php echo wp_kses_post( $attachment ); ?>
						</div>
						<div class="gallery__button">
							<i class="icon" data-feather="plus"></i>
						</div>
					</a>
					<?php
					if ( 'v3' === $view ) {
						?>
						</div>
						<?php
					}
					$index++;
			}
			?>
			</div>
			<?php
		}
	}
}

if ( ! function_exists( 'hellix_portfolio_image_gallery_carousel' ) ) {
	/**
	 * Function for Section Portfolio related projects carousel
	 */
	function hellix_portfolio_image_gallery_carousel() {
		global $post;
		$view                    = hellix_get_project_version();
		$portfolio_image_gallery = explode( ',', get_post_meta( $post->ID, '_portfolio_image_gallery', true ) );
		$attachments             = array_filter( $portfolio_image_gallery );

		if ( empty( $attachments ) ) {
			$post_thumbnail_id = get_post_thumbnail_id( $post->ID );
			array_unshift( $attachments, $post_thumbnail_id );
		}
		if ( ! empty( $attachments ) ) :
			?>
			<div class="relative pl-40 pr-80 lg:pr-0">
				<div class="sectionSlider overflow-hidden  js-sectionSlider" data-gap="0" data-slider-col="base-1 lg-1 md-1 sm-1" data-pagination>
					<div class="swiper-wrapper">
					<?php
						$index = 0;
					foreach ( $attachments as $attachment_id ) :

						$attachment      = wp_get_attachment_image( $attachment_id, 'full', '', array( 'class' => 'ratio-img' ) );
						$attachment_link = wp_get_attachment_url( $attachment_id );

						if ( empty( $attachment ) ) {
							continue;
						}
						?>
							<div class="swiper-slide">
								<a href="<?php echo esc_url( wp_get_attachment_url( $attachment_id ) ); ?>" class="gallery__item js-gallery" data-gallery="gallery1">
									<div class="ratio ratio-77:60">
										<?php echo wp_kses_post( $attachment ); ?>
									</div>
									<div class="gallery__button">
										<i class="icon" data-feather="plus"></i>
									</div>
								</a>
							</div>
							<?php
							$index++;
						endforeach;
					?>
					</div>
					<div class="pagination -slider -left js-pagination"></div>
				</div>
			</div>
			<?php
		endif;

	}
}
