<?php
/**
 * Template functions related to single post.
 *
 * @package hellix
 */

if ( ! function_exists( 'hellix_single_post_masthead' ) ) {
	/**
	 * Display Single Post Masthead
	 */
	function hellix_single_post_masthead() {
		hellix_output_page_masthead();
	}
}

if ( ! function_exists( 'hellix_single_post_content_start' ) ) {
	/**
	 * Single Post content start.
	 */
	function hellix_single_post_content_start() {
		?>
		<section class="layout-pt-md layout-pb-md">
			<div class="container">
				<div class="row">
					<?php
	}
}

if ( ! function_exists( 'hellix_single_post_wrapper_start' ) ) {
	/**
	 * Single Post content wrapper start.
	 */
	function hellix_single_post_wrapper_start() {
		$has_sidebar = hellix_blog_has_sidebar();
		$col_class   = 'col-lg-9 ';
		if ( ! $has_sidebar ) {
			$col_class .= 'mx-auto';
		}
		?>
		<div class="<?php echo esc_attr( $col_class ); ?>">
			<div class="blogSection pr-30 lg:pr-0">
			<?php
	}
}

if ( ! function_exists( 'hellix_single_post' ) ) {
	/**
	 * Single Post content.
	 */
	function hellix_single_post() {
		$title_class = ! hellix_is_extensions_activated() ? 'mb-3' : '';

		?>
		<div class="blogCard"><!---blogCard start---->
			<?php hellix_loop_post_header(); ?>
			<div class="blogCard__content">
				<?php hellix_loop_post_meta(); ?>
				<?php if ( apply_filters( 'hellix_single_post_show_content_title', false ) ) : ?>
				<h2 class="blogCard__title text-2xl fw-600 <?php echo esc_attr( $title_class ); ?>"><?php the_title(); ?></h2>
				<?php endif; ?>
				<div class="mt-30">
					<div class="flex flex-col">
						<div class="prose max-w-none"><?php the_content(); ?></div>
						<?php hellix_link_pages(); ?>
					</div>
				</div>
			</div>
		<?php
	}
}

if ( ! function_exists( 'hellix_single_post_info' ) ) {
	/**
	 * Single Post info.
	 */
	function hellix_single_post_info() {
		$posttags = get_the_tags();
		if ( $posttags ) {
			?>
		<div class="blogSingle-info mt-48">
			<div class="row justify-content-between y-gap-20">
				<div class="col-auto">
					<div class="tags__wrap">
						<?php foreach ( $posttags as $tag ) { ?>
							<div class="tags__item">
								<a data-barba href="<?php echo esc_url( get_tag_link( $tag ) ); ?>"><?php echo esc_html( $tag->name ); ?></a>
							</div>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
			<?php
		}
	}
}

if ( ! function_exists( 'hellix_single_post_nav' ) ) {
	/**
	 * Display the single post nav.
	 *
	 * @since 1.0.0
	 */
	function hellix_single_post_nav() {

		$prev_post = get_previous_post();
		$next_post = get_next_post();

		if ( ! $prev_post && ! $next_post ) {
			return;
		}

		?>
		<div class="blogSingle-nav mt-60">
			<div class="related-nav py-40 px-30">
				<div class="row justify-content-between align-items-center">
					<?php if ( $prev_post ) : ?>
					<div class="col-5">
						<a data-barba href="<?php echo esc_url( get_permalink( $prev_post ) ); ?>" class="related-nav__item -prev">
							<div class="related-nav__arrow">
								<i class="icon icon-left-arrow"></i>
							</div>
							<div class="related-nav__content">
								<span><?php echo esc_html__( 'PREV', 'hellix' ); ?></span>
								<div><?php echo wp_kses_post( get_the_title( $prev_post ) ); ?></div>
							</div>
						</a>
					</div>
					<?php endif; ?>
					<div class="col-auto md:d-none">
						<a class="related-nav__icon" href="<?php echo esc_url( get_post_type_archive_link( 'post' ) ); ?>">
							<span></span>
							<span></span>
							<span></span>
							<span></span>
						</a>
					</div>
					<div class="col-5">
					<?php if ( $next_post ) : ?>
						<a data-barba href="<?php echo esc_url( get_permalink( $next_post ) ); ?>" class="related-nav__item -next">
							<div class="related-nav__content">
								<span><?php echo esc_html__( 'NEXT', 'hellix' ); ?></span>
								<div><?php echo wp_kses_post( get_the_title( $next_post ) ); ?></div>
							</div>
							<div class="related-nav__arrow">
								<i class="icon icon-right-arrow"></i>
							</div>
						</a>
					<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
		<?php
	}
}

if ( ! function_exists( 'hellix_single_post_author' ) ) {
	/**
	 * Display the single post author.
	 *
	 * @since 1.0.0
	 */
	function hellix_single_post_author() {
		?>
		<?php if ( get_the_author_meta( 'description' ) ) { ?>
			<div class="blogSingle-author mt-60">
				<div class="blogSingle-author__image">
					<?php echo get_avatar( get_the_author_meta( 'ID' ), 176, '', 'avatar', array( 'class' => 'bg-image js-lazy' ) ); ?>
				</div>
				<div class="blogSingle-author__content ml-32 md:ml-16">
					<h4 class="blogSingle-author__title text-lg"><?php echo esc_html( get_the_author() ); ?></h4>
					<p class="blogSingle-author__text text-sm leading-3xl mt-12"><?php the_author_meta( 'description' ); ?></p>
				</div>
			</div>
			<?php } ?>
		</div>
		<?php
	}
}

if ( ! function_exists( 'hellix_display_comments' ) ) :
	/**
	 * Display comments
	 *
	 * @since  1.0.0
	 */
	function hellix_display_comments() {
		// If comments are open or we have at least one comment, load up the comment template.
		if ( comments_open() || 0 !== intval( get_comments_number() ) ) :
			comments_template();
		endif;
	}

endif;

if ( ! function_exists( 'hellix_comment' ) ) {
	/**
	 * Comment Template.
	 *
	 * @param WP_Comment $comment The comment object.
	 * @param array      $args Array of arguments.
	 * @param int        $depth Depth of the comment.
	 */
	function hellix_comment( $comment, $args, $depth ) {

		if ( 'div' === $args['style'] ) {
			$tag       = 'div';
			$add_below = 'comment-reply-target';
		} else {
			$tag       = 'li';
			$add_below = 'div-comment';
		}

		static $count = 1;

		$comment_class = [];

		if ( empty( $args['has_children'] ) ) {
			$comment_class[] = 'parent';
		}

		if ( 1 === $depth ) {
			$comment_class[] = 'card-body';
		}

		if ( 1 !== $count && 1 === $depth ) {
			$comment_class[] = 'border-top';
		}

		$comment_class  = implode( ' ', $comment_class );
		$is_post_author = in_array( 'bypostauthor', get_comment_class( $comment_class ), true );
		?>

		<<?php echo esc_attr( $tag ); ?> <?php comment_class( $comment_class ); ?> id="comment-<?php comment_ID(); ?>">
			<div class="comments__item-inner">
				<?php
					echo get_avatar( $comment, 90, '', esc_html__( 'author', 'hellix' ), [ 'class' => 'bg-image js-lazy comments__img' ] )
				?>
				<div class="comments__body">
					<div class="comments__header">
						<p class="text-accent uppercase text-[14px]"><?php echo esc_html( get_comment_date() ); ?></p>
						<h4 class="mt-4">
							<?php echo esc_html( get_comment_author() ); ?>
							<?php if ( $is_post_author ) : ?>
								<span class="sticky-badge badge badge badge-dark font-size-14 font-weight-normal align-middle ml-1"><?php echo esc_html__( 'Author', 'hellix' ); ?></span>
							<?php endif; ?>
						</h4>
					</div>
					<div class="comments__text prose prose-sm mt-20 mb-20">
						<?php comment_text(); ?>
					</div>
					<div class="comments__reply">
					<?php
						comment_reply_link(
							array_merge(
								$args,
								array(
									'add_below' => 'comment-reply-target',
									'depth'     => $depth,
									'max_depth' => $args['max_depth'],
								)
							)
						);

						edit_comment_link( esc_html__( 'Edit', 'hellix' ), '<span class="separator px-1 d-inline-block fw-medium text-muted">|</span>', '' );
					?>
					</div>
					<div id="comment-reply-target-<?php comment_ID(); ?>" class="comment-reply-target"></div>
				</div>
			</div>

		<?php
		$count++;
	}
}

if ( ! function_exists( 'hellix_single_post_wrapper_end' ) ) {
	/**
	 * Single Post content wrapper end.
	 */
	function hellix_single_post_wrapper_end() {
		$has_sidebar = hellix_blog_has_sidebar();
		?>
				</div>
			</div>
			<?php if ( $has_sidebar ) : ?>
			<div class="col-lg-3 mt-5 mt-lg-0">
				<?php get_sidebar(); ?>
			</div>
				<?php
		endif;
	}
}

if ( ! function_exists( 'hellix_single_post_content_end' ) ) {
	/**
	 * Single Post content end.
	 */
	function hellix_single_post_content_end() {
		?>
			</div><!-- /.row -->
		</div><!-- /.container -->
	</section><!-- /.layout-pt-md -->
		<?php
	}
}
