<?php
/**
 * WooCommerce Template Function Overrides
 *
 * @package woocommerce
 */

if ( ! function_exists( 'woocommerce_get_product_thumbnail' ) ) {

	/**
	 * Get the product thumbnail, or the placeholder if not set.
	 *
	 * @param string $size (default: 'woocommerce_thumbnail').
	 * @param int    $deprecated1 Deprecated since WooCommerce 2.0 (default: 0).
	 * @param int    $deprecated2 Deprecated since WooCommerce 2.0 (default: 0).
	 * @return string
	 */
	function woocommerce_get_product_thumbnail( $size = 'woocommerce_thumbnail', $deprecated1 = 0, $deprecated2 = 0 ) {
		global $product;

		$image_size = apply_filters( 'single_product_archive_thumbnail_size', $size );

		return $product ? $product->get_image( $image_size, array( 'class' => 'attachment-woocommerce_thumbnail ratio-img' ) ) : '';
	}
}

/**
 * Get the product price for the loop.
 */
function woocommerce_template_loop_price() {
	global $product;
	$price_html = $product->get_price_html();
	if ( $price_html ) : ?>
	<div class="shopCard__price text-sm text-dark mt-8"><?php echo wp_kses_post( $price_html ); ?></div>
		<?php
	endif;
}
