<?php
/**
 * Hellix WooCommerce hooks
 *
 * @package hellix
 */

remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5 );
remove_action( 'woocommerce_before_shop_loop', 'woocommerce_result_count', 20 );
remove_action( 'woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30 );
remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );
remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10 );
remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10 );
remove_action( 'woocommerce_after_shop_loop', 'woocommerce_pagination', 10 );
remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash', 10 );
remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5 );
remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 );
remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10 );
remove_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title', 10 );
remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10 );
remove_action( 'woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10 );
remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5 );



/**
 * Products Loop.
 *
 * @see woocommerce_result_count()
 * @see woocommerce_catalog_ordering()
 */
add_filter( 'woocommerce_loop_add_to_cart_link', 'hellix_wc_loop_add_to_cart_link', 10, 3 );

add_action( 'woocommerce_before_main_content', 'hellix_output_page_masthead', 20 );
add_action( 'woocommerce_before_shop_loop', 'hellix_shop_control_bar', 20 );
add_action( 'hellix_shop_control_bar_left', 'hellix_wc_result_count', 30 );
add_action( 'hellix_shop_control_bar_right', 'hellix_woocommerce_catalog_ordering', 40 );

add_action( 'woocommerce_before_shop_loop_item', 'hellix_product_loop_wrap_open', 0 );
add_action( 'woocommerce_before_shop_loop_item', 'hellix_product_image_wrap_open', 2 );
add_action( 'woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_thumbnail', 8 );
add_action( 'woocommerce_before_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 15 );
add_action( 'woocommerce_before_shop_loop_item', 'hellix_product_image_wrap_close', 20 );
add_action( 'woocommerce_before_shop_loop_item_title', 'hellix_product_loop_card_body_open', 30 );
add_action( 'woocommerce_before_shop_loop_item_title', 'hellix_template_loop_categories', 35 );
add_action( 'woocommerce_before_shop_loop_item_title', 'hellix_product_category_close', 40 );
add_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_link_open', 42 );
add_action( 'woocommerce_shop_loop_item_title', 'hellix_template_loop_product_title', 45 );
add_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_link_close', 47 );
add_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10 );
add_action( 'woocommerce_after_shop_loop_item', 'hellix_product_loop_wrap_close', 30 );
add_action( 'woocommerce_after_shop_loop_item', 'hellix_product_content_close', 30 );

/**
 * Pagination after shop loops.
 *
 * @see woocommerce_pagination()
 */
add_action( 'woocommerce_after_shop_loop', 'woocommerce_pagination', 10 );

/**
 * Template Hooks used in Single Product
 *
 * @package hellix
 */

remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0 );
remove_action( 'woocommerce_before_single_product', 'woocommerce_output_all_notices', 10 );
remove_action( 'woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash', 10 );
remove_action( 'woocommerce_before_single_product_summary', 'woocommerce_show_product_images', 20 );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_title', 5 );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10 );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 10 );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40 );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 20 );
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_product_data_tabs', 10 );
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20 );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_sharing', 50 );
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_upsell_display', 15 );



add_action( 'woocommerce_before_single_product_summary', 'hellix_wc_product_wrap_open', 5 );
add_action( 'woocommerce_before_single_product_summary', 'hellix_wc_product_container_open', 20 );
add_action( 'woocommerce_before_single_product_summary', 'woocommerce_output_all_notices', 21 );
add_action( 'woocommerce_before_single_product_summary', 'hellix_wc_product_row_open', 22 );
add_action( 'woocommerce_before_single_product_summary', 'hellix_wc_product_image_wrap_open', 25 );
add_action( 'woocommerce_before_single_product_summary', 'hellix_wc_product_images', 26 );
add_action( 'template_redirect', 'hellix_wc_product_remove_sidebar' );
add_action( 'hellix_wc_product_left_column', 'woocommerce_show_product_images', 26 );
add_action( 'woocommerce_before_single_product_summary', 'hellix_wc_product_image_wrap_close', 27 );
add_action( 'woocommerce_before_single_product_summary', 'hellix_wc_product_summary_wrap_open', 28 );
add_action( 'woocommerce_single_product_summary', 'hellix_wc_template_single_title', 29 );
add_action( 'woocommerce_single_product_summary', 'hellix_wc_single_product_price', 29 );
add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 29 );
add_action( 'woocommerce_single_product_summary', 'hellix_single_add_to_cart_wrap_open', 29 );
add_action( 'woocommerce_single_product_summary', 'hellix_single_add_to_cart_wrap_close', 31 );
add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_meta', 32 );
add_action( 'woocommerce_single_product_summary', 'hellix_wc_product_summary_wrap_close', 35 );
add_action( 'woocommerce_single_product_summary', 'hellix_wc_product_row_close', 110 );
add_action( 'woocommerce_single_product_summary', 'hellix_wc_product_container_close', 115 );
add_action( 'woocommerce_single_product_summary', 'hellix_wc_product_wrap_close', 130 );
add_action( 'woocommerce_after_single_product_summary', 'hellix_product_tabs_wrap_open', 65 );
add_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_product_data_tabs', 67 );
add_action( 'woocommerce_after_single_product_summary', 'hellix_product_tabs_wrap_close', 68 );
add_action( 'woocommerce_after_single_product_summary', 'hellix_output_related_products', 70 );
add_filter( 'woocommerce_output_related_products_args', 'hellix_output_related_products_args' );

/**
 * WC Pages
 */

remove_action( 'woocommerce_widget_shopping_cart_total', 'woocommerce_widget_shopping_cart_subtotal', 10 );
remove_action( 'woocommerce_widget_shopping_cart_buttons', 'woocommerce_widget_shopping_cart_button_view_cart', 10 );
remove_action( 'woocommerce_widget_shopping_cart_buttons', 'woocommerce_widget_shopping_cart_proceed_to_checkout', 20 );

/**
 * Cart
 */
add_filter( 'woocommerce_default_address_fields', 'hellix_wc_checkout_address_fields' );
add_filter( 'woocommerce_billing_fields', 'hellix_wc_checkout_address_fields' );
add_filter( 'woocommerce_checkout_fields', 'hellix_wc_checkout_fields' );
add_filter( 'woocommerce_add_to_cart_fragments', 'hellix_cart_link_fragment', 10 );

/**
 * Checkout
 */
remove_action( 'woocommerce_cart_collaterals', 'woocommerce_cross_sell_display' );
add_action( 'woocommerce_after_cart', 'hellix_output_cross_sell_products' );

/**
 * Reviews
 */
remove_action( 'woocommerce_review_before_comment_meta', 'woocommerce_review_display_rating', 10 );
remove_action( 'woocommerce_review_meta', 'woocommerce_review_display_meta', 10 );
remove_action( 'woocommerce_review_comment_text', 'woocommerce_review_display_comment_text', 10 );
remove_action( 'woocommerce_review_before', 'woocommerce_review_display_gravatar', 10 );

add_action( 'woocommerce_review_before_comment_text', 'hellix_wc_review_before' );

/**
 * My Account
 */
add_action( 'woocommerce_account_navigation', 'hellix_wc_account_wrapper_start', 5 );
add_action( 'woocommerce_before_account_navigation', 'hellix_wc_account_nav_wrapper_start', 5 );

add_action( 'woocommerce_after_account_navigation', 'hellix_wc_account_nav_wrapper_close', 5 );
add_action( 'woocommerce_after_account_navigation', 'hellix_wc_account_content_wrapper_start', 10 );
add_action( 'woocommerce_account_content', 'hellix_wc_account_content_wrapper_close', 15 );

