<?php
/**
 * Template functions used in Single Product
 */

if ( ! function_exists( 'hellix_wc_product_remove_sidebar' ) ) {
	/**
	 * Function to remove sidebar in single page
	 */
	function hellix_wc_product_remove_sidebar() {
		if ( is_product() ) {
			remove_action( 'woocommerce_sidebar', 'woocommerce_get_sidebar' );
		}
	}
}

if ( ! function_exists( 'hellix_wc_product_wrap_open' ) ) {
	/**
	 * Function to display open wrap
	 */
	function hellix_wc_product_wrap_open() { ?>
		<section class="layout-pt-md layout-pb-md">
		<?php
	}
}

if ( ! function_exists( 'hellix_wc_product_wrap_close' ) ) {
	/**
	 * Function to display close wrap
	 */
	function hellix_wc_product_wrap_close() {
		?>
		</section>
		<?php
	}
}

if ( ! function_exists( 'hellix_wc_product_container_open' ) ) {
	/**
	 * Function to display open wrap
	 */
	function hellix_wc_product_container_open() {
		?>
		<div class="container">
		<?php
	}
}

if ( ! function_exists( 'hellix_wc_product_row_open' ) ) {
	/**
	 * Function to display open row
	 */
	function hellix_wc_product_row_open() {
		?>
		<div class="row y-gap-60">
		<?php
	}
}

if ( ! function_exists( 'hellix_wc_product_container_close' ) ) {
	/**
	 * Function to display container close
	 */
	function hellix_wc_product_container_close() {
		?>
		</div>
		<?php
	}
}

if ( ! function_exists( 'hellix_wc_product_row_close' ) ) {
	/**
	 * Function to display row close
	 */
	function hellix_wc_product_row_close() {
		?>
	   </div>
				<?php
	}
}

if ( ! function_exists( 'hellix_wc_product_image_wrap_open' ) ) {
	/**
	 * Function to display image open wrap
	 */
	function hellix_wc_product_image_wrap_open() {
		?>
	  <div class="col-lg-7">
			<div class="shopSingle-preview js-shop-slider d-block">
			<?php
	}
}

if ( ! function_exists( 'hellix_wc_product_image_wrap_close' ) ) {
	/**
	 * Function to display image close wrap
	 */
	function hellix_wc_product_image_wrap_close() {
		?>
			</div>
		</div>
		<?php
	}
}


if ( ! function_exists( 'hellix_wc_product_images' ) ) {
	/**
	 * Function to display product image
	 */
	function hellix_wc_product_images() {
		?>
		
				<?php do_action( 'hellix_wc_product_left_column' ); ?> 
		
		<?php
	}
}

if ( ! function_exists( 'hellix_wc_product_summary_wrap_open' ) ) {
	/**
	 * Function to display summary open wrap
	 */
	function hellix_wc_product_summary_wrap_open() {
		?>
	   <div class="col-lg-5">
				<div class="shopSingle-info pl-40 lg:pl-0">
				<?php
	}
}

if ( ! function_exists( 'hellix_wc_product_summary_wrap_close' ) ) {
	/**
	 * Function to display summary wrap close
	 */
	function hellix_wc_product_summary_wrap_close() {
		?>
		</div></div>
		<?php
	}
}

if ( ! function_exists( 'hellix_wc_template_single_title' ) ) {
	/**
	 * Function to display title
	 */
	function hellix_wc_template_single_title() {
		?>
		<h2 class="shopSingle-info__title text-black mt-4"><?php single_post_title(); ?></h2>
																					  <?php
	}
}

if ( ! function_exists( 'hellix_wc_single_product_price' ) ) {
	/**
	 * Function to display price
	 */
	function hellix_wc_single_product_price() {
		global $product;
		$price_html = $product->get_price_html();

		if ( ! empty( $price_html ) ) :
			?>
		<div class="shopSingle-info__price text-lg fw-600 text-black mt-4">
			<?php echo wp_kses_post( $price_html ); ?>
		</div>
			<?php
	endif;
	}
}


if ( ! function_exists( 'hellix_single_add_to_cart_wrap_open' ) ) {
	/**
	 * Function to display add to cart wrap open
	 */
	function hellix_single_add_to_cart_wrap_open() {
		global $product;
		$price_html = $product->get_price_html();
		if ( ! empty( $price_html ) ) :
			?>
			<div class="shopSingle-info__action y-gap-24 mt-48 md:mt-48 sm:mt-32">
			<?php
		endif;
	}
}

if ( ! function_exists( 'hellix_single_add_to_cart_wrap_close' ) ) {
	/**
	 * Function to display add to cart wrap close
	 */
	function hellix_single_add_to_cart_wrap_close() {
		global $product;
		$price_html = $product->get_price_html();
		if ( ! empty( $price_html ) ) :
			?>
			</div>
			<?php
		endif;
	}
}

if ( ! function_exists( 'hellix_product_tabs_wrap_open' ) ) {
	/**
	 * Function to display tabs open wrap
	 */
	function hellix_product_tabs_wrap_open() {
		?>
		<section class="layout-pt-sm layout-pb-md">
			<div class="container">
				<div class="row">
					<div class="col-12">
					<?php
	}
}

if ( ! function_exists( 'hellix_product_tabs_wrap_close' ) ) {
	/**
	 * Function to display tabs wrap close
	 */
	function hellix_product_tabs_wrap_close() {
		?>
					</div>
				</div>
			</div>
		</section>
		<?php
	}
}

if ( ! function_exists( 'hellix_output_related_products' ) ) {
	/**
	 * Function to display related products
	 */
	function hellix_output_related_products() {
		if ( apply_filters( 'hellix_enable_related_products', get_theme_mod( 'enable_related_products', 'yes' ) ) ) {
			woocommerce_output_related_products();
		}
	}
}


if ( ! function_exists( 'hellix_output_related_products_args' ) ) {
	/**
	 * Function to pass arguments for realted products
	 *
	 * @param int $args the args to be passed.
	 */
	function hellix_output_related_products_args( $args ) {

		$args = array(
			'posts_per_page' => 4,
			'columns'        => apply_filters( 'hellix_related_products_columns', 3 ),
		);
		return $args;
	}
}

if ( ! function_exists( 'hellix_wc_review_before' ) ) {
	/**
	 * Function to display content before review.
	 *
	 * @param WP_Comment $comment Comment to display.
	 */
	function hellix_wc_review_before( $comment ) {
		$verified = wc_review_is_from_verified_owner( $comment->comment_ID );
		$rating   = intval( get_comment_meta( $comment->comment_ID, 'rating', true ) );

		?>

		<div class="comments__header">
			<p class="text-accent uppercase">
				<?php echo esc_html( get_comment_date( wc_date_format(), $comment ) ); ?>
			 </p>
			 <div class="d-flex justify-content-between">
				 <h4 class="mt-4">
					<?php comment_author( $comment ); ?>
						<?php if ( 'yes' === get_option( 'woocommerce_review_rating_verification_label' ) && $verified ) : ?>
							<i class="czi-check-circle ml-2 mt-n1 font-size-base align-middle text-success" data-toggle="tooltip" data-original-title="<?php echo esc_attr__( 'verified owner', 'hellix' ); ?>"></i>
						<?php endif; ?>
				</h4>
				<div class="star-rating">
				<?php
				if ( $rating && wc_review_ratings_enabled() ) :
					echo wc_get_rating_html( $rating ); // WPCS: XSS ok.
				endif;
				?>
				</div>
			</div>
		</div>
	   
		<?php
		echo esc_html( hellix_wc_review( $comment ) );

	}
}


/**
 * Output product reviews
 *
 * @hooked woocommerce_after_single_product_summary 240
 *
 * @since 1.0.0
 */
if ( ! function_exists( 'hellix_wc_reviews' ) ) {
	/**
	 * Function to display add to cart wrap open.
	 */
	function hellix_wc_reviews() {
		if ( ! comments_open() ) {
			return;
		}

		comments_template();
	}
}

if ( ! function_exists( 'hellix_wc_review' ) ) {
	/**
	 * Display the review
	 *
	 * @param array $comment WP_Comment.
	 * @return void
	 */
	function hellix_wc_review( $comment ) {
		?>
		<div class="comments__text">
			<?php if ( '0' === $comment->comment_approved ) : ?>
				<em class="woocommerce-review__awaiting-approval">
					<?php esc_html_e( 'Your review is awaiting approval', 'hellix' ); ?>
				</em>
			<?php else : ?>
				<?php comment_text( $comment ); ?>
			<?php endif; ?>
		</div>
		<?php
	}
}


