<?php
/**
 * Template part for displaying the "Grid" blog layout (with sidebar)
 *
 * @package Hellix
 */

$sidebar     = function_exists( 'hellix_posts_sidebar' ) ? hellix_posts_sidebar() : 'left-sidebar';
$has_sidebar = in_array( $sidebar, [ 'left-sidebar', 'right-sidebar' ], true ) ? true : false;
$columns     = $has_sidebar ? 3 : 4;

/**
 * Fires before the posts section
 */
do_action( 'hellix_posts_before' ); ?>
<div class="container">
	<div class="section-filter px-16">
		<?php hellix_post_filters(); ?>
		<?php
		/**
		 * Fires right before the blog loop starts
		 */
		?>
		<div class="masonry -gap-32 -col-3 layout-pt-sm js-masonry js-masonry-no-filter">
			<div class="masonry__sizer"></div> 
			<?php

			while ( have_posts() ) :
				the_post();
				$post_cats      = get_the_terms( get_the_ID(), 'category' );
					$groups     = '';
					$groups_arr = [];

				if ( is_array( $post_cats ) ) {
					foreach ( $post_cats as $post_cat ) {
						$groups_arr[] = $post_cat->slug;
					}
				}

					$groups = implode( ' ', $groups_arr );
				?>
				<div class="masonry__item -no-ratio <?php echo esc_attr( $groups ); ?>">
				<?php
				get_template_part( 'templates/blog/content', 'grid' );
				?>
				</div>
				<?php

			endwhile;
			?>
		</div>
		<div class="row justify-content-center mt-40">
			<div class="col-auto">
				<?php hellix_pagination(); ?>
			</div>
		</div>
	</div>
</div>

		
