<?php
/**
 * Template part for displaying the "Grid" blog layout (with sidebar)
 *
 * @package Hellix
 */

$has_sidebar = hellix_blog_has_sidebar();
$layout      = hellix_get_blog_layout();
$col_content = 'col-lg-9';

if ( ! $has_sidebar ) {
	$col_content .= ' mx-auto';
}

if ( 'left-sidebar' === $layout ) {
	$col_content .= ' order-lg-1';
}

$col_content = trim( apply_filters( 'hellix_col_content_class', $col_content ) );

do_action( 'hellix_posts_before' );

?>
<div class="container">
	<div class="row">
		<div class="<?php echo esc_attr( $col_content ); ?>">
			<?php if ( 'right-sidebar' === $layout ) { ?>
				<div class="blogSection pr-30 lg:pr-0"> 
			<?php } else { ?>
				<div class="blogSection pl-30 lg:pl-0">
				<?php
			}
				do_action( 'hellix_loop_before' );

			while ( have_posts() ) :
				the_post();
				get_template_part( 'templates/blog/content', 'list' );
				endwhile;

				do_action( 'hellix_loop_after' );
			?>
			</div>
		</div>
		<?php if ( $has_sidebar ) : ?>
			<div class="col-lg-3">
				<?php get_sidebar(); ?>
			</div>
		<?php endif; ?>
	</div><!-- /.row -->
</div>
<?php

do_action( 'hellix_posts_after' );
