<?php
/**
 * Template for displaying archive Portfolio content v2.
 */

$gap          = get_theme_mod( 'portfolio_gap', '-gap-16' );
$layout       = get_theme_mod( 'portfolio_layout', '-col-3' );
$filter_class = 'section-filter ';

if ( '-gap-16' === $gap ) {
	$filter_class .= 'px-16';
} elseif ( '-gap-32' === $gap ) {
	$filter_class .= 'px-32';
}


?><section class="layout-pt-md layout-pb-md">
	<div class="<?php echo esc_attr( $filter_class ); ?>">
		<?php hellix_portfolio_filters(); ?>
		<div class="masonry layout-pt-sm js-masonry js-masonry-no-filter <?php echo esc_attr( $layout . ' ' . $gap ); ?>">
			<div class="masonry__sizer"></div>
			<?php
				global $hellix_loop_portfolio_index;
				global $img_pos;

				$hellix_loop_portfolio_index = 0;
			while ( have_posts() ) :
				the_post();

				if ( 0 === $hellix_loop_portfolio_index % 4 ) {
					$img_pos = '-wide';
				} else {
					$img_pos = '';
				}

				$portfolio_types = get_the_terms( get_the_ID(), 'jetpack-portfolio-type' );
				$groups          = '';
				$groups_arr      = [];

				if ( is_array( $portfolio_types ) ) {
					foreach ( $portfolio_types as $portfolio_type ) {
						$groups_arr[] = $portfolio_type->slug;
					}
				}

				$groups = implode( ' ', $groups_arr );
				?>
					<div class='masonry__item <?php echo esc_attr( $img_pos ); ?> <?php echo esc_attr( $groups ); ?>'>
					<?php get_template_part( 'templates/portfolio/content-portfolio/loop/loop-portfolio', 'v2' ); ?>
					</div>
					<?php
					$hellix_loop_portfolio_index++;
				endwhile;

				unset( $GLOBALS['hellix_loop_portfolio_index'] );
			?>
		</div>
	</div>
</section>
<?php
