<?php
/**
 * Cart Page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cart.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.0.1
 */

defined( 'ABSPATH' ) || exit;

do_action( 'woocommerce_before_cart' ); ?>
<section class="cart-section">
		<div class="row x-gap-60">
			<div class="col-lg">
				<form class="woocommerce-cart-form table-responsive" action="<?php echo esc_url( wc_get_cart_url() ); ?>" method="post">
					<?php do_action( 'woocommerce_before_cart_table' ); ?>

					<table class="shop_table shop_table_responsive cart woocommerce-cart-form__contents">
						<thead>
							<tr class = "shopCart-header">
							
							   <th class="shopCart-header product-remove shopCart-header__title pl-2 pr-2">&nbsp;</th>
							   <th class="shopCart-header product-name shopCart-header__title pl-2 pr-2"><?php esc_html_e( 'Product', 'hellix' ); ?></th>
							   <th class="shopCart-header product-price shopCart-header__title pl-2 pr-2"><?php esc_html_e( 'Price', 'hellix' ); ?></th>
							   <th class="shopCart-header product-quantity shopCart-header__title pl-2 pr-2"><?php esc_html_e( 'Quantity', 'hellix' ); ?></th>
							   <th class="shopCart-header product-subtotal shopCart-header__title pl-2 pr-2"><?php esc_html_e( 'Subtotal', 'hellix' ); ?></th>
						
							</tr>
						</thead>


						<tbody>
							

								<?php do_action( 'woocommerce_before_cart_contents' ); ?>

								<?php
								foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
									$_product   = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
									$product_id = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );

									if ( $_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_cart_item_visible', true, $cart_item, $cart_item_key ) ) {
										$product_permalink = apply_filters( 'woocommerce_cart_item_permalink', $_product->is_visible() ? $_product->get_permalink( $cart_item ) : '', $cart_item, $cart_item_key );
										?>
									<tr class="woocommerce-cart-form__cart-item <?php echo esc_attr( apply_filters( 'woocommerce_cart_item_class', 'cart_item', $cart_item, $cart_item_key ) ); ?>">
										<td class="product-remove shopCart-products__item pl-2 pr-2 pr-xl-4">
										<?php
											echo apply_filters( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
												'woocommerce_cart_item_remove_link',
												sprintf(
													'<a href="%s" class="remove text-grey" aria-label="%s" data-product_id="%s" data-product_sku="%s"><i class="icon icon-cross"></i></a>',
													esc_url( wc_get_cart_remove_url( $cart_item_key ) ),
													esc_html__( 'Remove this item', 'hellix' ),
													esc_attr( $product_id ),
													esc_attr( $_product->get_sku() )
												),
												$cart_item_key
											);
										?>
										</td>

										
										<td class="shopCart-products__item product-name pl-2 pr-2" data-title="<?php esc_attr_e( 'Product', 'hellix' ); ?>">
											<div class="shopCart-products__product d-flex align-items-center">
												<?php
													$thumbnail = apply_filters( 'woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key );
												if ( ! $product_permalink ) {
																echo wp_kses_post( $thumbnail ); // PHPCS: XSS ok.
												} else {
														printf( '<a class="image" href="%s">%s</a>', esc_url( $product_permalink ), $thumbnail ); // PHPCS: XSS ok.
												}
												?>
												<div class="title">
												<?php
												if ( ! $product_permalink ) {
													echo wp_kses_post( apply_filters( 'woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key ) . '&nbsp;' );
												} else {
														echo wp_kses_post( apply_filters( 'woocommerce_cart_item_name', sprintf( '<a href="%s">%s</a>', esc_url( $product_permalink ), $_product->get_name() ), $cart_item, $cart_item_key ) );
												}
															do_action( 'woocommerce_after_cart_item_name', $cart_item, $cart_item_key );
																// Meta data.
																echo wc_get_formatted_cart_item_data( $cart_item ); // PHPCS: XSS ok.

																// Backorder notification.
												if ( $_product->backorders_require_notification() && $_product->is_on_backorder( $cart_item['quantity'] ) ) {
													echo wp_kses_post( apply_filters( 'woocommerce_cart_item_backorder_notification', '<p class="backorder_notification">' . esc_html__( 'Available on backorder', 'hellix' ) . '</p>', $product_id ) );
												}
												?>
												</div>
											</div>
										
										</td>

									<td class="shopCart-products__item product-price pl-2 pr-2" >
										
											<div class="d-flex h-100 align-items-center">
												<div class="shopCart-products__title d-none mr-8">
													<?php esc_attr_e( 'Price', 'hellix' ); ?>"
												</div>
												<div class="shopCart-products__price text-grey">
													<?php
													echo apply_filters( 'woocommerce_cart_item_price', WC()->cart->get_product_price( $_product ), $cart_item, $cart_item_key ); // PHPCS: XSS ok.
													?>
												</div>
											</div>
									
									</td>

									
									<td class="shopCart-products__item product-quantity pl-2 pr-2" data-title="<?php esc_attr_e( 'Quantity', 'hellix' ); ?>">
										<?php
										if ( $_product->is_sold_individually() ) {
											$product_quantity = sprintf( '1 <input type="hidden" name="cart[%s][qty]" value="1" />', $cart_item_key );
										} else {
											$product_quantity = woocommerce_quantity_input(
												array(
													'input_name'   => "cart[{$cart_item_key}][qty]",
													'input_value'  => $cart_item['quantity'],
													'max_value'    => $_product->get_max_purchase_quantity(),
													'min_value'    => '0',
													'product_name' => $_product->get_name(),
												),
												$_product,
												false
											);
										}

										echo apply_filters( 'woocommerce_cart_item_quantity', $product_quantity, $cart_item_key, $cart_item ); // PHPCS: XSS ok.
										?>
									</td>

									<td class="shopCart-products__item product-subtotal pl-2 pr-2">
										<div class="d-flex h-100 align-items-center">
											<div class="shopCart-products__title d-none mr-8">
													<?php esc_attr_e( 'Subtotal', 'hellix' ); ?>
											</div>
											<div class="shopCart-products__subtotal text-grey">
											<?php
												echo apply_filters( 'woocommerce_cart_item_subtotal', WC()->cart->get_product_subtotal( $_product, $cart_item['quantity'] ), $cart_item, $cart_item_key ); // PHPCS: XSS ok.
											?>
											</div>
										</div>
									</td>
							</tr>
										<?php
									}
								}
								?>

<?php do_action( 'woocommerce_cart_contents' ); ?>

<tr class="shopCart-footer">

		<?php if ( wc_coupons_enabled() ) { ?>
			<td colspan="6" class="actions pt-32">
				 <div class="row justify-content-between y-gap-32">
					<div class="col-auto">
						<div class="shopCart-footer__item">
							 <div class="d-flex coupon">
								<input type="text" name="coupon_code" class="input-text" id="coupon_code" value="" placeholder="<?php esc_attr_e( 'Coupon code', 'hellix' ); ?>" /> 
								  
								<button type="submit" class="button -md -dark text-white ml-20 apply-coupon text-nowrap button btn btn-blue<?php echo esc_attr( wc_wp_theme_get_element_class_name( 'button' ) ? ' ' . wc_wp_theme_get_element_class_name( 'button' ) : '' ); ?>" name="apply_coupon" value="<?php esc_attr_e( 'Apply coupon', 'hellix' ); ?>"><?php esc_html_e( 'Apply coupon', 'hellix' ); ?></button>
							   
								<?php do_action( 'woocommerce_cart_coupon' ); ?>
							 </div> 
						</div>
					</div>
				<?php } ?>
		
				<div class="col-auto">
					<div class="shopCart-footer__item">


						<button type="submit" class="button update-cart-button button -md -grey text-white<?php echo esc_attr( wc_wp_theme_get_element_class_name( 'button' ) ? ' ' . wc_wp_theme_get_element_class_name( 'button' ) : '' ); ?>" name="update_cart" value="<?php esc_attr_e( 'Update cart', 'hellix' ); ?>"><?php esc_html_e( 'Update cart', 'hellix' ); ?></button>
					</div>
				</div>
			</div>
			

		<?php do_action( 'woocommerce_cart_actions' ); ?>

		<?php wp_nonce_field( 'woocommerce-cart', 'woocommerce-cart-nonce' ); ?>
	</td>
</tr>


		<?php do_action( 'woocommerce_after_cart_contents' ); ?>
	</tbody>
</table>
		<?php do_action( 'woocommerce_after_cart_table' ); ?>
</form>
		<?php do_action( 'hellix_after_cart_form' ); ?>
</div>

<?php do_action( 'woocommerce_before_cart_collaterals' ); ?>
<div class="col-lg-auto">
	<div class="shopCart-sidebar">
		<div class="cart-collaterals">
		<?php
		/**
		 Cart collaterals hook.

		 @hooked woocommerce_cross_sell_display
		 @hooked woocommerce_cart_totals - 10
		 */
			do_action( 'woocommerce_cart_collaterals' );
		?>
		</div>
	</div>
</div>
</div>
<?php do_action( 'woocommerce_after_cart' ); ?>

</section>




