<?php
/**
 * Display single product reviews (comments)
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product-reviews.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 4.3.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

if ( ! comments_open() ) {
	return;
}

?>

<div class="blogPost -comments pt-12">
	
	<div id="reviews" class="woocommerce-Reviews">
			<?php do_action( 'hellix_single_product_reviews_before' ); ?>
		<div class="blogPost__content">
			<div id="comments">
				<h2 class="woocommerce-Reviews-title blogPost__title text-lg fw-600">
				<?php
					$count = $product->get_review_count();
				if ( $count && wc_review_ratings_enabled() ) {
					/* translators: 1: reviews count 2: product name */
					$reviews_title = sprintf( esc_html( _n( '%1$s comments', '%1$s comments', $count, 'hellix' ) ), esc_html( $count ) );
					echo apply_filters( 'woocommerce_reviews_title', $reviews_title, $count, $product ); // WPCS: XSS ok.
				} else {
					esc_html_e( 'Reviews', 'hellix' );
				}
				?>
				</h2>
					
					<?php
					do_action( 'hellix_single_product_reviews_before' );
					?>
				<ul class="comments__list mt-24">
				<?php

				if ( have_comments() ) :

					wp_list_comments(
						apply_filters(
							'woocommerce_product_review_list_args',
							[
								'style'        => 'div',
								'format'       => 'html5',
								'avatar_size'  => 50,
								'short_ping'   => false,
								'callback'     => 'woocommerce_comments',
								'end-callback' => function() {
									echo '</div>';
								},


							]
						)
					);

					hellix_comments_navigation();
					else :
						?>
						<p class="woocommerce-noreviews"><?php esc_html_e( 'There are no reviews yet.', 'hellix' ); ?></p>
						<?php
					endif;
					?>
				</ul>
			</div>
			</div>

			<div class="respondForm mt-64 md:mt-40">
				
						<?php
						if ( get_option( 'woocommerce_review_rating_verification_required' ) === 'no' || wc_customer_bought_product( '', get_current_user_id(), $product->get_id() ) ) :
							$account_page_url = wc_get_page_permalink( 'myaccount' );
							$commenter        = wp_get_current_commenter();
							$is_req           = (bool) get_option( 'require_name_email', 1 );
							$_cf_args         = [];

							$_cf_args['comment_field'] = '';


							if ( wc_review_ratings_enabled() ) {
								$_cf_args['comment_field'] .= sprintf(
									'<div class="comment-form-rating mt-16">
										<select name="rating" id="rating" class="custom-select" required>
											<option value="">%2$s</option>
											<option value="5">%3$s</option>
											<option value="4">%4$s</option>
											<option value="3">%5$s</option>
											<option value="2">%6$s</option>
											<option value="1">%7$s</option>
										</select>
									</div>',
									esc_html__( 'Rating', 'hellix' ),
									esc_html__( 'Choose rating', 'hellix' ),
									esc_html__( 'Perfect', 'hellix' ),
									esc_html__( 'Good', 'hellix' ),
									esc_html__( 'Average', 'hellix' ),
									esc_html__( 'Not that bad', 'hellix' ),
									esc_html__( 'Very poor', 'hellix' )
								);
							}


							$_cf_args['comment_field'] .= sprintf(
								'<div class="form-group comment-form-comment">
									<textarea name="comment" id="comment" placeholder="' . esc_attr__( 'Your Review', 'hellix' ) . '" rows="5"></textarea>' . esc_html__( ' Your review must be at least 50 characters.', 'hellix' ) . '</small>
								</div>',
								esc_html__( 'Review', 'hellix' )
							);

							// Other arguments.
							$_cf_args['logged_in_as']         = '';
							$_cf_args['label_submit']         = esc_html_x( 'Submit a Review', 'front-end', 'hellix' );
							$_cf_args['title_reply']          = esc_html_x( 'Leave a Reply', 'front-end', 'hellix' );
							$_cf_args['title_reply_to']       = esc_html__( 'Leave a Reply', 'hellix' );
							$_cf_args['title_reply_before']   = '<h3 id="reply-title" class="comments-reply-title">';
							$_cf_args['title_reply_after']    = '</h3>';
							$_cf_args['submit_button']        = '<button type="submit" name="%1$s" id="%2$s" class="%3$s">%4$s</button>';
							$_cf_args['submit_field']         = '<div class="form-group form-submit col-12 mt-24 p-0">%1$s%2$s</div>';
							$_cf_args['class_submit']         = 'button -md -accent text-white';
							$_cf_args['comment_notes_after']  = '';
							$_cf_args['comment_notes_before'] = sprintf(
								'<p class="font-size-sm text-muted">%s %s <span class="text-danger">*</span></p>',
								esc_html_x( 'Your email address will not be published.', 'front-end', 'hellix' ),
								/* translators: related to comment form; phrase follows by red mark*/
								esc_html_x( 'Required fields are marked', 'front-end', 'hellix' )
							);

							if ( $account_page_url ) {
								/* translators: %s opening and closing link tags respectively */
								$_cf_args['must_log_in'] = '<p class="must-log-in font-size-sm text-muted">' . sprintf( esc_html__( 'You must be %1$slogged in%2$s to post a review.', 'hellix' ), '<a href="' . esc_url( $account_page_url ) . '" class="text-primary">', '</a>' ) . '</p>';
							}

							comment_form( apply_filters( 'woocommerce_product_review_comment_form_args', $_cf_args ) );
							?>
						<?php else : ?>
							<div class="media">
								<div class="mr-3 font-size-xl text-danger">
									<i class="fe-announcement"></i>
								</div>
								<div class="media-body">
									<p class="woocommerce-verification-required font-size-sm mb-0"><?php esc_html_e( 'Only logged in customers who have purchased this product may leave a review.', 'hellix' ); ?></p>
								</div>
							</div>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>

		<?php do_action( 'hellix_single_product_reviews_after' ); ?>

	</div>
</div>
