<?php 

if( !defined( 'ABSPATH' ) ) exit();

if( !class_exists( 'OVA_Rooms_custom_post_type' ) ) {

	class OVA_Rooms_custom_post_type{

		public function __construct(){
			add_action( 'init', array( $this, 'OVAROOMS_register_post_type_ova_room' ) );
			add_action( 'init', array( $this, 'OVAROOMS_register_taxonomy_ova_room' ) );
		}

		
		function OVAROOMS_register_post_type_ova_room() {

			$labels = array(
				'name'                  => _x( 'Room', 'Post Type General Name', 'ova-framework' ),
				'singular_name'         => _x( 'Room', 'Post Type Singular Name', 'ova-framework' ),
				'menu_name'             => __( 'Room', 'ova-framework' ),
				'name_admin_bar'        => __( 'Room', 'ova-framework' ),
				'archives'              => __( 'Item Archives', 'ova-framework' ),
				'attributes'            => __( 'Item Attributes', 'ova-framework' ),
				'parent_item_colon'     => __( 'Parent Item:', 'ova-framework' ),
				'all_items'             => __( 'All Room', 'ova-framework' ),
				'add_new_item'          => __( 'Add New Room', 'ova-framework' ),
				'add_new'               => __( 'Add New Room', 'ova-framework' ),
				'new_item'              => __( 'New Item', 'ova-framework' ),
				'edit_item'             => __( 'Edit Room', 'ova-framework' ),
				'view_item'             => __( 'View Item', 'ova-framework' ),
				'view_items'            => __( 'View Items', 'ova-framework' ),
				'search_items'          => __( 'Search Item', 'ova-framework' ),
				'not_found'             => __( 'Not found', 'ova-framework' ),
				'not_found_in_trash'    => __( 'Not found in Trash', 'ova-framework' ),
			);
			$args = array(
				'description'         => __( 'Post Type Description', 'ova-framework' ),
				'labels'              => $labels,
				'supports'            => array( 'title','excerpt', 'editor', 'comments', 'thumbnail' ),
				'hierarchical'        => false,
				'public'              => true,
				'show_ui'             => true,
				'menu_position'       => 5,
				'query_var'           => true,
				'has_archive'         => true,
				'exclude_from_search' => true,
				'publicly_queryable'  => true,
				'rewrite'             => array( 'slug' => _x( 'ova_room', 'URL slug', 'ova-framework' ) ),
				'capability_type'     => 'post',
				'menu_icon'           => 'dashicons-layout'
			);
			register_post_type( 'ova_room', $args );
		}

		function OVAROOMS_register_taxonomy_ova_room(){

			$labels = array(
				'name'                       => _x( 'Type Room', 'Post Type General Name', 'ova-framework' ),
				'singular_name'              => _x( 'Type', 'Post Type Singular Name', 'ova-framework' ),
				'menu_name'                  => __( 'Type Room', 'ova-framework' ),
				'all_items'                  => __( 'All Type Room', 'ova-framework' ),
				'parent_item'                => __( 'Parent Item', 'ova-framework' ),
				'parent_item_colon'          => __( 'Parent Item:', 'ova-framework' ),
				'new_item_name'              => __( 'New Item Name', 'ova-framework' ),
				'add_new_item'               => __( 'Add New Type', 'ova-framework' ),
				'add_new'                    => __( 'Add New Type', 'ova-framework' ),
				'edit_item'                  => __( 'Edit Type', 'ova-framework' ),
				'view_item'                  => __( 'View Item', 'ova-framework' ),
				'separate_items_with_commas' => __( 'Separate items with commas', 'ova-framework' ),
				'add_or_remove_items'        => __( 'Add or remove items', 'ova-framework' ),
				'choose_from_most_used'      => __( 'Choose from the most used', 'ova-framework' ),
				'popular_items'              => __( 'Popular Items', 'ova-framework' ),
				'search_items'               => __( 'Search Items', 'ova-framework' ),
				'not_found'                  => __( 'Not Found', 'ova-framework' ),
				'no_terms'                   => __( 'No items', 'ova-framework' ),
				'items_list'                 => __( 'Items list', 'ova-framework' ),
				'items_list_navigation'      => __( 'Items list navigation', 'ova-framework' ),

			);
			$args = array(
				'labels'            => $labels,
				'hierarchical'      => true,
				'publicly_queryable' => true,
				'public'            => true,
				'show_ui'           => true,
				'show_admin_column' => true,
				'show_in_nav_menus' => true,
				'show_tagcloud'     => false,
				'rewrite'            => array(
					'slug'       => _x( 'cat_room','Type Slug', 'ova-framework' ),
					'with_front' => false,
					'feeds'      => true,
				),
			);
			register_taxonomy( 'cat_room', array( 'ova_room' ), $args );



			$labels_features = array(
				'name'                       => _x( 'Features Room', 'Post Type General Name', 'ova-framework' ),
				'singular_name'              => _x( 'Features', 'Post Type Singular Name', 'ova-framework' ),
				'menu_name'                  => __( 'Features Room', 'ova-framework' ),
				'all_items'                  => __( 'All Features Room', 'ova-framework' ),
				'parent_item'                => __( 'Parent Item', 'ova-framework' ),
				'parent_item_colon'          => __( 'Parent Item:', 'ova-framework' ),
				'new_item_name'              => __( 'New Item Name', 'ova-framework' ),
				'add_new_item'               => __( 'Add New Features', 'ova-framework' ),
				'add_new'                    => __( 'Add New Features', 'ova-framework' ),
				'edit_item'                  => __( 'Edit Features', 'ova-framework' ),
				'view_item'                  => __( 'View Item', 'ova-framework' ),
				'separate_items_with_commas' => __( 'Separate items with commas', 'ova-framework' ),
				'add_or_remove_items'        => __( 'Add or remove items', 'ova-framework' ),
				'choose_from_most_used'      => __( 'Choose from the most used', 'ova-framework' ),
				'popular_items'              => __( 'Popular Items', 'ova-framework' ),
				'search_items'               => __( 'Search Items', 'ova-framework' ),
				'not_found'                  => __( 'Not Found', 'ova-framework' ),
				'no_terms'                   => __( 'No items', 'ova-framework' ),
				'items_list'                 => __( 'Items list', 'ova-framework' ),
				'items_list_navigation'      => __( 'Items list navigation', 'ova-framework' ),

			);
			$args_features = array(
				'labels'            => $labels_features,
				'hierarchical'      => true,
				'publicly_queryable' => true,
				'public'            => true,
				'show_ui'           => true,
				'show_admin_column' => true,
				'show_in_nav_menus' => true,
				'show_tagcloud'     => false,
				'rewrite'            => array(
					'slug'       => _x( 'features_room','Room Slug', 'ova-framework' ),
					'with_front' => false,
					'feeds'      => true,
				),
			);
			register_taxonomy( 'features_room', array( 'ova_room' ), $args_features );
			
		}

		
	}

	new OVA_Rooms_custom_post_type();
}