/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2018-05-24 12:15:49 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` mediumblob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_eg_grids` (
  `id` mediumint(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `handle` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `postparams` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `layers` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` text COLLATE utf8mb4_unicode_ci,
  `last_modified` datetime DEFAULT NULL,
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `handle` (`handle`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_eg_item_elements` (
  `id` mediumint(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `handle` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `handle` (`handle`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_eg_item_skins` (
  `id` mediumint(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `handle` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `layers` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` text COLLATE utf8mb4_unicode_ci,
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `name` (`name`),
  UNIQUE KEY `handle` (`handle`)
) ENGINE=InnoDB AUTO_INCREMENT=102 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_eg_navigation_skins` (
  `id` mediumint(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `handle` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `css` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `handle` (`handle`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=InnoDB AUTO_INCREMENT=237 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3433 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=785 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_revslider_css` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext,
  `hover` longtext,
  `advanced` longtext,
  `params` longtext NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=112 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_revslider_layer_animations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_revslider_navigations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_revslider_sliders` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext,
  `params` longtext NOT NULL,
  `settings` text,
  `type` varchar(191) NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_revslider_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_revslider_static_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=41 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


/* INSERT TABLE DATA: wp_commentmeta */
INSERT INTO `wp_commentmeta` VALUES("1", "2", "trx_addons_comment_likes_count", "0");
INSERT INTO `wp_commentmeta` VALUES("2", "3", "trx_addons_comment_likes_count", "0");
INSERT INTO `wp_commentmeta` VALUES("3", "4", "trx_addons_comment_likes_count", "0");
INSERT INTO `wp_commentmeta` VALUES("4", "5", "trx_addons_comment_likes_count", "0");
INSERT INTO `wp_commentmeta` VALUES("5", "6", "trx_addons_comment_likes_count", "0");
INSERT INTO `wp_commentmeta` VALUES("6", "7", "trx_addons_comment_likes_count", "0");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("2", "110", "Cindy Jefferson", "cindy_jefferson@nospam.ze.tc", "", "37.229.221.230", "2018-01-14 14:13:26", "2018-01-14 14:13:26", "Thank you for helping me out with finance data and reports!", "0", "1", "Mozilla/5.0 (Windows NT 6.1; rv:57.0) Gecko/20100101 Firefox/57.0", "", "0", "0");
INSERT INTO `wp_comments` VALUES("3", "91", "Cindy Jefferson", "cindy_jefferson@nospam.ze.tc", "", "37.229.221.230", "2018-01-14 14:14:04", "2018-01-14 14:14:04", "I liked your Customer Care tea a lot! They sure do know how to treat a client", "0", "1", "Mozilla/5.0 (Windows NT 6.1; rv:57.0) Gecko/20100101 Firefox/57.0", "", "0", "0");
INSERT INTO `wp_comments` VALUES("4", "110", "Philip James", "philip_james@nospam.ze.tc", "", "37.229.221.230", "2018-01-14 14:15:16", "2018-01-14 14:15:16", "I like this website for its informative structure, amazing layouts and readability!", "0", "1", "Mozilla/5.0 (Windows NT 6.1; rv:57.0) Gecko/20100101 Firefox/57.0", "", "2", "0");
INSERT INTO `wp_comments` VALUES("5", "110", "David Matinson", "david.matinson@bigmir.net", "", "37.229.221.230", "2018-01-14 14:16:08", "2018-01-14 14:16:08", "We appreciate your feedback!", "0", "1", "Mozilla/5.0 (Windows NT 6.1; rv:57.0) Gecko/20100101 Firefox/57.0", "", "4", "1");
INSERT INTO `wp_comments` VALUES("6", "91", "David Matinson", "david.matinson@bigmir.net", "", "37.229.221.230", "2018-01-14 14:16:32", "2018-01-14 14:16:32", "Please subscribe!", "0", "1", "Mozilla/5.0 (Windows NT 6.1; rv:57.0) Gecko/20100101 Firefox/57.0", "", "3", "1");
INSERT INTO `wp_comments` VALUES("7", "91", "David Matinson", "david.matinson@bigmir.net", "", "127.0.0.1", "2018-05-12 05:52:27", "2018-05-12 05:52:27", "Aliquam bibendum lacus quis nulla dignissim faucibus. Sed mauris enim, bibendum at purus aliquet", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:59.0) Gecko/20100101 Firefox/59.0", "", "0", "1");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("1", "20180524_wealthcofinancialadvisor", "7cd94cc32e8facaf2830180524121533", "20", "2018-05-24 12:15:49", "admin", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2018-05-24 12:15:33\";s:7:\"Version\";s:6:\"1.2.38\";s:9:\"VersionWP\";s:5:\"4.8.6\";s:9:\"VersionDB\";s:6:\"5.5.48\";s:10:\"VersionPHP\";s:6:\"5.6.19\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";i:1;s:4:\"Name\";s:33:\"20180524_wealthcofinancialadvisor\";s:4:\"Hash\";s:32:\"7cd94cc32e8facaf2830180524121533\";s:8:\"NameHash\";s:66:\"20180524_wealthcofinancialadvisor_7cd94cc32e8facaf2830180524121533\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:57:\"C:/OpenServer/domains/localhost/wealthCo/wp-snapshots/tmp\";s:8:\"StoreURL\";s:39:\"http://localhost/wealthco/wp-snapshots/\";s:8:\"ScanFile\";s:76:\"20180524_wealthcofinancialadvisor_7cd94cc32e8facaf2830180524121533_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";s:5:\"admin\";s:7:\"Archive\";O:11:\"DUP_Archive\":19:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:78:\"20180524_wealthcofinancialadvisor_7cd94cc32e8facaf2830180524121533_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:40:\"C:/OpenServer/domains/localhost/wealthCo\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2018-05-24 12:15:33\";s:7:\"Version\";s:6:\"1.2.38\";s:9:\"VersionWP\";s:5:\"4.8.6\";s:9:\"VersionDB\";s:6:\"5.5.48\";s:10:\"VersionPHP\";s:6:\"5.6.19\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";N;s:4:\"Name\";s:33:\"20180524_wealthcofinancialadvisor\";s:4:\"Hash\";s:32:\"7cd94cc32e8facaf2830180524121533\";s:8:\"NameHash\";s:66:\"20180524_wealthcofinancialadvisor_7cd94cc32e8facaf2830180524121533\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:57:\"C:/OpenServer/domains/localhost/wealthCo/wp-snapshots/tmp\";s:8:\"StoreURL\";s:39:\"http://localhost/wealthco/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";r:22;s:9:\"Installer\";O:13:\"DUP_Installer\":7:{s:4:\"File\";s:80:\"20180524_wealthcofinancialadvisor_7cd94cc32e8facaf2830180524121533_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:10:\"\0*\0Package\";r:58;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:79:\"20180524_wealthcofinancialadvisor_7cd94cc32e8facaf2830180524121533_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:6:{i:0;s:49:\"C:/OpenServer/domains/localhost/wealthCo/wp-admin\";i:1;s:59:\"C:/OpenServer/domains/localhost/wealthCo/wp-content/uploads\";i:2;s:61:\"C:/OpenServer/domains/localhost/wealthCo/wp-content/languages\";i:3;s:59:\"C:/OpenServer/domains/localhost/wealthCo/wp-content/plugins\";i:4;s:58:\"C:/OpenServer/domains/localhost/wealthCo/wp-content/themes\";i:5;s:52:\"C:/OpenServer/domains/localhost/wealthCo/wp-includes\";}}s:9:\"Installer\";r:80;s:8:\"Database\";r:88;}");

/* INSERT TABLE DATA: wp_eg_grids */
INSERT INTO `wp_eg_grids` VALUES("1", "Grid", "grid", "{\"source-type\":\"post\",\"post_types\":\"post\",\"post_category\":\"post_tag_11,post_tag_13,post_tag_15\",\"category-relation\":\"OR\",\"additional-query\":\"\",\"selected_pages\":\"\",\"max_entries\":\"-1\",\"stream-source-type\":\"instagram\",\"youtube-api\":\"\",\"youtube-channel-id\":\"\",\"youtube-type-source\":\"channel\",\"youtube-playlist\":\"\",\"youtube-playlist-select\":\"\",\"youtube-thumb-size\":\"default\",\"youtube-full-size\":\"default\",\"youtube-count\":\"12\",\"youtube-transient-sec\":\"86400\",\"vimeo-type-source\":\"user\",\"vimeo-username\":\"\",\"vimeo-groupname\":\"\",\"vimeo-albumid\":\"\",\"vimeo-channelname\":\"\",\"vimeo-thumb-size\":\"thumbnail_small\",\"vimeo-count\":\"12\",\"vimeo-transient-sec\":\"86400\",\"instagram-access-key\":\"\",\"instagram-user-id\":\"\",\"instagram-thumb-size\":\"Low Resolution\",\"instagram-full-size\":\"Standard Resolution\",\"instagram-count\":\"12\",\"instagram-transient-sec\":\"86400\",\"flickr-api-key\":\"\",\"flickr-type\":\"publicphotos\",\"flickr-user-url\":\"\",\"flickr-photoset\":\"\",\"flickr-photoset-select\":\"\",\"flickr-gallery-url\":\"\",\"flickr-group-url\":\"\",\"flickr-thumb-size\":\"Small 320\",\"flickr-full-size\":\"Medium 800\",\"flickr-count\":\"12\",\"flickr-transient-sec\":\"86400\",\"facebook-app-id\":\"\",\"facebook-app-secret\":\"\",\"facebook-page-url\":\"\",\"facebook-type-source\":\"timeline\",\"facebook-album\":\"\",\"facebook-album-select\":\"\",\"facebook-count\":\"12\",\"facebook-transient-sec\":\"86400\",\"twitter-consumer-key\":\"\",\"twitter-consumer-secret\":\"\",\"twitter-access-token\":\"\",\"twitter-access-secret\":\"\",\"twitter-user-id\":\"\",\"twitter-image-only\":\"true\",\"twitter-include-retweets\":\"on\",\"twitter-exclude-replies\":\"on\",\"twitter-count\":\"12\",\"twitter-transient-sec\":\"86400\",\"behance-api\":\"\",\"behance-user-id\":\"\",\"behance-type\":\"projects\",\"behance-project\":\"\",\"behance-project-select\":\"\",\"behance-projects-thumb-size\":\"202\",\"behance-projects-full-size\":\"202\",\"behance-project-thumb-size\":\"max_1240\",\"behance-project-full-size\":\"disp\",\"behance-count\":\"12\",\"behance-transient-sec\":\"86400\",\"media-source-order\":[\"featured-image\"],\"poster-source-order\":[\"featured-image\"],\"image-source-type\":\"full\",\"image-source-type-mobile\":\"full\",\"media-filter-type\":\"none\",\"default-image\":\"0\",\"youtube-default-image\":\"0\",\"vimeo-default-image\":\"0\",\"html-default-image\":\"0\"}", "{\"layout-sizing\":\"boxed\",\"fullscreen-offset-container\":\"\",\"layout\":\"even\",\"content-push\":\"off\",\"x-ratio\":\"4\",\"y-ratio\":\"4\",\"auto-ratio\":\"true\",\"rtl\":\"off\",\"use-cobbles-pattern\":\"off\",\"columns-advanced\":\"off\",\"columns-height\":[\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"],\"columns-width\":[\"1400\",\"1170\",\"1024\",\"960\",\"778\",\"640\",\"480\"],\"mascontent-height\":[\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"],\"columns\":[\"3\",\"3\",\"3\",\"3\",\"3\",\"2\",\"1\"],\"rows-unlimited\":\"off\",\"rows\":\"3\",\"pagination-autoplay\":\"off\",\"pagination-autoplay-speed\":\"5000\",\"load-more\":\"none\",\"load-more-hide\":\"off\",\"load-more-text\":\"Load More\",\"load-more-show-number\":\"on\",\"load-more-start\":\"3\",\"load-more-amount\":\"3\",\"lazy-loading\":\"off\",\"lazy-loading-blur\":\"on\",\"lazy-load-color\":\"#FFFFFF\",\"spacings\":\"30\",\"grid-padding\":[\"0\",\"0\",\"0\",\"0\"],\"main-background-color\":\"transparent\",\"navigation-skin\":\"minimal-light\",\"entry-skin\":\"1\",\"grid-animation\":\"fade\",\"grid-animation-speed\":\"1000\",\"grid-animation-delay\":\"1\",\"grid-item-animation\":\"none\",\"grid-item-animation-zoomin\":\"125\",\"grid-item-animation-zoomout\":\"75\",\"grid-item-animation-fade\":\"75\",\"grid-item-animation-blur\":\"5\",\"grid-item-animation-rotate\":\"30\",\"grid-item-animation-shift\":\"up\",\"grid-item-animation-shift-amount\":\"10\",\"grid-item-animation-other\":\"none\",\"grid-item-other-zoomin\":\"125\",\"grid-item-other-zoomout\":\"75\",\"grid-item-other-fade\":\"75\",\"grid-item-other-blur\":\"5\",\"grid-item-other-rotate\":\"30\",\"grid-item-other-shift\":\"up\",\"grid-item-other-shift-amount\":\"10\",\"hover-animation-delay\":\"1\",\"top-1-align\":\"center\",\"top-1-margin-bottom\":\"0\",\"top-2-align\":\"center\",\"top-2-margin-bottom\":\"0\",\"bottom-1-align\":\"center\",\"bottom-1-margin-top\":\"0\",\"bottom-2-align\":\"center\",\"bottom-2-margin-top\":\"45\",\"left-margin-left\":\"0\",\"right-margin-right\":\"0\",\"module-spacings\":\"5\",\"pagination-numbers\":\"smart\",\"pagination-scroll\":\"off\",\"pagination-scroll-offset\":\"0\",\"filter-arrows\":\"single\",\"filter-logic\":\"or\",\"filter-start\":\"\",\"filter-show-on\":\"hover\",\"filter-all-text\":\"All\",\"filter-listing\":\"list\",\"filter-dropdown-text\":\"Filter Categories\",\"filter-counter\":\"off\",\"filter-selected\":[\"post_tag_11\",\"post_tag_13\",\"post_tag_15\"],\"sort-by-text\":\"Sort By \",\"sorting-order-by\":\"date\",\"sorting-order-by-start\":\"none\",\"sorting-order-by-start-meta\":\"\",\"sorting-order-type\":\"ASC\",\"search-text\":\"Search...\",\"lb-source-order\":[\"featured-image\"],\"lightbox-mode\":\"single\",\"lightbox-exclude-media\":\"off\",\"lightbox-type\":\"null\",\"lightbox-position\":\"bottom\",\"lightbox-twitter\":\"off\",\"lightbox-facebook\":\"off\",\"lbox-inpadding\":[\"0\",\"0\",\"0\",\"0\"],\"lbox-padding\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-effect-open-close\":\"fade\",\"lightbox-effect-open-close-speed\":\"normal\",\"lightbox-effect-next-prev\":\"fade\",\"lightbox-effect-next-prev-speed\":\"normal\",\"lbox-width\":\"960\",\"lbox-height\":\"540\",\"lbox-minwidth\":\"100\",\"lbox-minheight\":\"100\",\"lbox-maxwidth\":\"9999\",\"lbox-maxheight\":\"9999\",\"lightbox-autoplay\":\"off\",\"lbox-playspeed\":\"3000\",\"lbox-preload\":\"3\",\"lightbox-arrows\":\"on\",\"lightbox-thumbs\":\"off\",\"lbox-thumb-w\":\"50\",\"lbox-thumb-h\":\"50\",\"lightbox-post-spinner\":\"off\",\"lightbox-post-content-img\":\"off\",\"lightbox-post-content-img-position\":\"top\",\"lightbox-post-content-img-width\":\"50\",\"lightbox-post-content-img-margin\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-post-content-title\":\"off\",\"lightbox-post-content-title-tag\":\"h2\",\"aj-source-order\":[\"post-content\"],\"ajax-container-id\":\"ess-grid-ajax-container-\",\"ajax-container-position\":\"top\",\"ajax-scroll-onload\":\"on\",\"ajax-scrollto-offset\":\"0\",\"ajax-close-button\":\"off\",\"ajax-button-text\":\"Close\",\"ajax-nav-button\":\"off\",\"ajax-button-skin\":\"light\",\"ajax-button-type\":\"type1\",\"ajax-button-inner\":\"false\",\"ajax-button-h-pos\":\"r\",\"ajax-button-v-pos\":\"t\",\"0\":\"\",\"ajax-container-pre\":\"\",\"ajax-container-post\":\"\",\"ajax-container-css\":\"\",\"ajax-callback\":\"\",\"ajax-callback-arg\":\"false\",\"ajax-css-url\":\"\",\"ajax-js-url\":\"\",\"use-spinner\":\"0\",\"spinner-color\":\"#FFFFFF\",\"hide-markup-before-load\":\"off\",\"custom-javascript\":\"\",\"cookie-save-time\":\"30\",\"cookie-save-search\":\"off\",\"cookie-save-filter\":\"off\",\"cookie-save-pagination\":\"off\",\"css-id\":\"\",\"navigation-layout\":{\"pagination\":{\"bottom-2\":\"0\"},\"filter\":{\"top-1\":\"0\"}}}", "[]", NULL, NULL);
INSERT INTO `wp_eg_grids` VALUES("2", "Masonry", "masonry", "{\"source-type\":\"custom\",\"post_types\":\"post\",\"post_category\":\"\",\"category-relation\":\"OR\",\"additional-query\":\"\",\"selected_pages\":\"\",\"max_entries\":\"-1\",\"stream-source-type\":\"instagram\",\"youtube-api\":\"\",\"youtube-channel-id\":\"\",\"youtube-type-source\":\"channel\",\"youtube-playlist\":\"\",\"youtube-playlist-select\":\"\",\"youtube-thumb-size\":\"default\",\"youtube-full-size\":\"default\",\"youtube-count\":\"12\",\"youtube-transient-sec\":\"86400\",\"vimeo-type-source\":\"user\",\"vimeo-username\":\"\",\"vimeo-groupname\":\"\",\"vimeo-albumid\":\"\",\"vimeo-channelname\":\"\",\"vimeo-thumb-size\":\"thumbnail_small\",\"vimeo-count\":\"12\",\"vimeo-transient-sec\":\"86400\",\"instagram-access-key\":\"\",\"instagram-user-id\":\"\",\"instagram-thumb-size\":\"Low Resolution\",\"instagram-full-size\":\"Standard Resolution\",\"instagram-count\":\"12\",\"instagram-transient-sec\":\"86400\",\"flickr-api-key\":\"\",\"flickr-type\":\"publicphotos\",\"flickr-user-url\":\"\",\"flickr-photoset\":\"\",\"flickr-photoset-select\":\"\",\"flickr-gallery-url\":\"\",\"flickr-group-url\":\"\",\"flickr-thumb-size\":\"Small 320\",\"flickr-full-size\":\"Medium 800\",\"flickr-count\":\"12\",\"flickr-transient-sec\":\"86400\",\"facebook-app-id\":\"\",\"facebook-app-secret\":\"\",\"facebook-page-url\":\"\",\"facebook-type-source\":\"timeline\",\"facebook-album\":\"\",\"facebook-album-select\":\"\",\"facebook-count\":\"12\",\"facebook-transient-sec\":\"86400\",\"twitter-consumer-key\":\"\",\"twitter-consumer-secret\":\"\",\"twitter-access-token\":\"\",\"twitter-access-secret\":\"\",\"twitter-user-id\":\"\",\"twitter-image-only\":\"true\",\"twitter-include-retweets\":\"on\",\"twitter-exclude-replies\":\"on\",\"twitter-count\":\"12\",\"twitter-transient-sec\":\"86400\",\"behance-api\":\"\",\"behance-user-id\":\"\",\"behance-type\":\"projects\",\"behance-project\":\"\",\"behance-project-select\":\"\",\"behance-projects-thumb-size\":\"202\",\"behance-projects-full-size\":\"202\",\"behance-project-thumb-size\":\"max_1240\",\"behance-project-full-size\":\"disp\",\"behance-count\":\"12\",\"behance-transient-sec\":\"86400\",\"media-source-order\":[\"featured-image\"],\"poster-source-order\":[\"featured-image\"],\"image-source-type\":\"full\",\"image-source-type-mobile\":\"full\",\"media-filter-type\":\"none\",\"default-image\":\"0\",\"youtube-default-image\":\"0\",\"vimeo-default-image\":\"0\",\"html-default-image\":\"0\"}", "{\"layout-sizing\":\"boxed\",\"fullscreen-offset-container\":\"\",\"layout\":\"masonry\",\"content-push\":\"off\",\"x-ratio\":\"4\",\"y-ratio\":\"3\",\"auto-ratio\":\"true\",\"rtl\":\"off\",\"use-cobbles-pattern\":\"off\",\"columns-advanced\":\"off\",\"columns-height\":[\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"],\"columns-width\":[\"1400\",\"1170\",\"1024\",\"960\",\"778\",\"640\",\"480\"],\"mascontent-height\":[\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"],\"columns\":[\"3\",\"3\",\"3\",\"3\",\"3\",\"2\",\"1\"],\"rows-unlimited\":\"off\",\"rows\":\"3\",\"pagination-autoplay\":\"off\",\"pagination-autoplay-speed\":\"5000\",\"load-more\":\"none\",\"load-more-hide\":\"off\",\"load-more-text\":\"Load More\",\"load-more-show-number\":\"on\",\"load-more-start\":\"3\",\"load-more-amount\":\"3\",\"lazy-loading\":\"off\",\"lazy-loading-blur\":\"on\",\"lazy-load-color\":\"#FFFFFF\",\"spacings\":\"30\",\"grid-padding\":[\"0\",\"0\",\"0\",\"0\"],\"main-background-color\":\"transparent\",\"navigation-skin\":\"minimal-light\",\"entry-skin\":\"101\",\"grid-animation\":\"fade\",\"grid-animation-speed\":\"1000\",\"grid-animation-delay\":\"1\",\"grid-item-animation\":\"none\",\"grid-item-animation-zoomin\":\"125\",\"grid-item-animation-zoomout\":\"75\",\"grid-item-animation-fade\":\"75\",\"grid-item-animation-blur\":\"5\",\"grid-item-animation-rotate\":\"30\",\"grid-item-animation-shift\":\"up\",\"grid-item-animation-shift-amount\":\"10\",\"grid-item-animation-other\":\"none\",\"grid-item-other-zoomin\":\"125\",\"grid-item-other-zoomout\":\"75\",\"grid-item-other-fade\":\"75\",\"grid-item-other-blur\":\"5\",\"grid-item-other-rotate\":\"30\",\"grid-item-other-shift\":\"up\",\"grid-item-other-shift-amount\":\"10\",\"hover-animation-delay\":\"1\",\"top-1-align\":\"center\",\"top-1-margin-bottom\":\"0\",\"top-2-align\":\"center\",\"top-2-margin-bottom\":\"0\",\"bottom-1-align\":\"center\",\"bottom-1-margin-top\":\"0\",\"bottom-2-align\":\"center\",\"bottom-2-margin-top\":\"20\",\"left-margin-left\":\"0\",\"right-margin-right\":\"0\",\"module-spacings\":\"5\",\"pagination-numbers\":\"smart\",\"pagination-scroll\":\"off\",\"pagination-scroll-offset\":\"0\",\"filter-arrows\":\"single\",\"filter-logic\":\"or\",\"filter-start\":\"\",\"filter-show-on\":\"hover\",\"filter-all-text\":\"Filter - All\",\"filter-listing\":\"list\",\"filter-dropdown-text\":\"Filter Categories\",\"filter-counter\":\"off\",\"sort-by-text\":\"Sort By \",\"sorting-order-by\":\"date\",\"sorting-order-by-start\":\"none\",\"sorting-order-by-start-meta\":\"\",\"sorting-order-type\":\"ASC\",\"search-text\":\"Search...\",\"lb-source-order\":[\"featured-image\"],\"lightbox-mode\":\"single\",\"lightbox-exclude-media\":\"off\",\"lightbox-type\":\"null\",\"lightbox-position\":\"bottom\",\"lightbox-twitter\":\"off\",\"lightbox-facebook\":\"off\",\"lbox-inpadding\":[\"0\",\"0\",\"0\",\"0\"],\"lbox-padding\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-effect-open-close\":\"fade\",\"lightbox-effect-open-close-speed\":\"normal\",\"lightbox-effect-next-prev\":\"fade\",\"lightbox-effect-next-prev-speed\":\"normal\",\"lbox-width\":\"960\",\"lbox-height\":\"540\",\"lbox-minwidth\":\"100\",\"lbox-minheight\":\"100\",\"lbox-maxwidth\":\"9999\",\"lbox-maxheight\":\"9999\",\"lightbox-autoplay\":\"off\",\"lbox-playspeed\":\"3000\",\"lbox-preload\":\"3\",\"lightbox-arrows\":\"on\",\"lightbox-thumbs\":\"off\",\"lbox-thumb-w\":\"50\",\"lbox-thumb-h\":\"50\",\"lightbox-post-spinner\":\"off\",\"lightbox-post-content-img\":\"off\",\"lightbox-post-content-img-position\":\"top\",\"lightbox-post-content-img-width\":\"50\",\"lightbox-post-content-img-margin\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-post-content-title\":\"off\",\"lightbox-post-content-title-tag\":\"h2\",\"aj-source-order\":[\"post-content\"],\"ajax-container-id\":\"ess-grid-ajax-container-\",\"ajax-container-position\":\"top\",\"ajax-scroll-onload\":\"on\",\"ajax-scrollto-offset\":\"0\",\"ajax-close-button\":\"off\",\"ajax-button-text\":\"Close\",\"ajax-nav-button\":\"off\",\"ajax-button-skin\":\"light\",\"ajax-button-type\":\"type1\",\"ajax-button-inner\":\"false\",\"ajax-button-h-pos\":\"r\",\"ajax-button-v-pos\":\"t\",\"0\":\"\",\"ajax-container-pre\":\"\",\"ajax-container-post\":\"\",\"ajax-container-css\":\"\",\"ajax-callback\":\"\",\"ajax-callback-arg\":\"false\",\"ajax-css-url\":\"\",\"ajax-js-url\":\"\",\"use-spinner\":\"0\",\"spinner-color\":\"#FFFFFF\",\"hide-markup-before-load\":\"off\",\"custom-javascript\":\"\",\"cookie-save-time\":\"30\",\"cookie-save-search\":\"off\",\"cookie-save-filter\":\"off\",\"cookie-save-pagination\":\"off\",\"css-id\":\"\",\"navigation-layout\":{\"pagination\":{\"bottom-2\":\"0\"}}}", "[\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"65\\\",\\\"custom-ratio\\\":\\\"0\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"128\\\",\\\"custom-ratio\\\":\\\"0\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"66\\\",\\\"custom-ratio\\\":\\\"0\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"99\\\",\\\"custom-ratio\\\":\\\"0\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"104\\\",\\\"custom-ratio\\\":\\\"0\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"111\\\",\\\"custom-ratio\\\":\\\"0\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"112\\\",\\\"custom-ratio\\\":\\\"0\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"123\\\",\\\"custom-ratio\\\":\\\"0\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"124\\\",\\\"custom-ratio\\\":\\\"0\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"125\\\",\\\"custom-ratio\\\":\\\"0\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"127\\\",\\\"custom-ratio\\\":\\\"0\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"126\\\",\\\"custom-ratio\\\":\\\"0\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\"]", NULL, NULL);
INSERT INTO `wp_eg_grids` VALUES("3", "Cobbles", "cobbles", "{\"source-type\":\"post\",\"post_types\":\"post\",\"post_category\":\"post_tag_11,post_tag_13,post_tag_15\",\"category-relation\":\"OR\",\"additional-query\":\"\",\"selected_pages\":\"\",\"max_entries\":\"-1\",\"stream-source-type\":\"instagram\",\"youtube-api\":\"\",\"youtube-channel-id\":\"\",\"youtube-type-source\":\"channel\",\"youtube-playlist\":\"\",\"youtube-playlist-select\":\"\",\"youtube-thumb-size\":\"default\",\"youtube-full-size\":\"default\",\"youtube-count\":\"12\",\"youtube-transient-sec\":\"86400\",\"vimeo-type-source\":\"user\",\"vimeo-username\":\"\",\"vimeo-groupname\":\"\",\"vimeo-albumid\":\"\",\"vimeo-channelname\":\"\",\"vimeo-thumb-size\":\"thumbnail_small\",\"vimeo-count\":\"12\",\"vimeo-transient-sec\":\"86400\",\"instagram-access-key\":\"\",\"instagram-user-id\":\"\",\"instagram-thumb-size\":\"Low Resolution\",\"instagram-full-size\":\"Standard Resolution\",\"instagram-count\":\"12\",\"instagram-transient-sec\":\"86400\",\"flickr-api-key\":\"\",\"flickr-type\":\"publicphotos\",\"flickr-user-url\":\"\",\"flickr-photoset\":\"\",\"flickr-photoset-select\":\"\",\"flickr-gallery-url\":\"\",\"flickr-group-url\":\"\",\"flickr-thumb-size\":\"Small 320\",\"flickr-full-size\":\"Medium 800\",\"flickr-count\":\"12\",\"flickr-transient-sec\":\"86400\",\"facebook-app-id\":\"\",\"facebook-app-secret\":\"\",\"facebook-page-url\":\"\",\"facebook-type-source\":\"timeline\",\"facebook-album\":\"\",\"facebook-album-select\":\"\",\"facebook-count\":\"12\",\"facebook-transient-sec\":\"86400\",\"twitter-consumer-key\":\"\",\"twitter-consumer-secret\":\"\",\"twitter-access-token\":\"\",\"twitter-access-secret\":\"\",\"twitter-user-id\":\"\",\"twitter-image-only\":\"true\",\"twitter-include-retweets\":\"on\",\"twitter-exclude-replies\":\"on\",\"twitter-count\":\"12\",\"twitter-transient-sec\":\"86400\",\"behance-api\":\"\",\"behance-user-id\":\"\",\"behance-type\":\"projects\",\"behance-project\":\"\",\"behance-project-select\":\"\",\"behance-projects-thumb-size\":\"202\",\"behance-projects-full-size\":\"202\",\"behance-project-thumb-size\":\"max_1240\",\"behance-project-full-size\":\"disp\",\"behance-count\":\"12\",\"behance-transient-sec\":\"86400\",\"media-source-order\":[\"featured-image\"],\"poster-source-order\":[\"featured-image\"],\"image-source-type\":\"full\",\"image-source-type-mobile\":\"full\",\"media-filter-type\":\"none\",\"default-image\":\"0\",\"youtube-default-image\":\"0\",\"vimeo-default-image\":\"0\",\"html-default-image\":\"0\"}", "{\"layout-sizing\":\"boxed\",\"fullscreen-offset-container\":\"\",\"layout\":\"cobbles\",\"content-push\":\"off\",\"x-ratio\":\"4\",\"y-ratio\":\"4\",\"auto-ratio\":\"true\",\"rtl\":\"off\",\"use-cobbles-pattern\":\"off\",\"columns-advanced\":\"off\",\"columns-height\":[\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"],\"columns-width\":[\"1400\",\"1170\",\"1024\",\"960\",\"778\",\"640\",\"480\"],\"mascontent-height\":[\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"],\"columns\":[\"3\",\"3\",\"3\",\"3\",\"3\",\"2\",\"1\"],\"rows-unlimited\":\"off\",\"rows\":\"2\",\"pagination-autoplay\":\"off\",\"pagination-autoplay-speed\":\"5000\",\"load-more\":\"none\",\"load-more-hide\":\"off\",\"load-more-text\":\"Load More\",\"load-more-show-number\":\"on\",\"load-more-start\":\"3\",\"load-more-amount\":\"3\",\"lazy-loading\":\"off\",\"lazy-loading-blur\":\"on\",\"lazy-load-color\":\"#FFFFFF\",\"spacings\":\"30\",\"grid-padding\":[\"0\",\"0\",\"0\",\"0\"],\"main-background-color\":\"transparent\",\"navigation-skin\":\"minimal-light\",\"entry-skin\":\"1\",\"grid-animation\":\"fade\",\"grid-animation-speed\":\"1000\",\"grid-animation-delay\":\"1\",\"grid-item-animation\":\"none\",\"grid-item-animation-zoomin\":\"125\",\"grid-item-animation-zoomout\":\"75\",\"grid-item-animation-fade\":\"75\",\"grid-item-animation-blur\":\"5\",\"grid-item-animation-rotate\":\"30\",\"grid-item-animation-shift\":\"up\",\"grid-item-animation-shift-amount\":\"10\",\"grid-item-animation-other\":\"none\",\"grid-item-other-zoomin\":\"125\",\"grid-item-other-zoomout\":\"75\",\"grid-item-other-fade\":\"75\",\"grid-item-other-blur\":\"5\",\"grid-item-other-rotate\":\"30\",\"grid-item-other-shift\":\"up\",\"grid-item-other-shift-amount\":\"10\",\"hover-animation-delay\":\"1\",\"top-1-align\":\"center\",\"top-1-margin-bottom\":\"0\",\"top-2-align\":\"center\",\"top-2-margin-bottom\":\"0\",\"bottom-1-align\":\"center\",\"bottom-1-margin-top\":\"0\",\"bottom-2-align\":\"center\",\"bottom-2-margin-top\":\"45\",\"left-margin-left\":\"0\",\"right-margin-right\":\"0\",\"module-spacings\":\"5\",\"pagination-numbers\":\"smart\",\"pagination-scroll\":\"off\",\"pagination-scroll-offset\":\"0\",\"filter-arrows\":\"single\",\"filter-logic\":\"or\",\"filter-start\":\"\",\"filter-show-on\":\"hover\",\"filter-all-text\":\"All\",\"filter-listing\":\"list\",\"filter-dropdown-text\":\"Filter Categories\",\"filter-counter\":\"off\",\"filter-selected\":[\"post_tag_11\",\"post_tag_13\",\"post_tag_15\"],\"sort-by-text\":\"Sort By \",\"sorting-order-by\":\"date\",\"sorting-order-by-start\":\"none\",\"sorting-order-by-start-meta\":\"\",\"sorting-order-type\":\"ASC\",\"search-text\":\"Search...\",\"lb-source-order\":[\"featured-image\"],\"lightbox-mode\":\"single\",\"lightbox-exclude-media\":\"off\",\"lightbox-type\":\"null\",\"lightbox-position\":\"bottom\",\"lightbox-twitter\":\"off\",\"lightbox-facebook\":\"off\",\"lbox-inpadding\":[\"0\",\"0\",\"0\",\"0\"],\"lbox-padding\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-effect-open-close\":\"fade\",\"lightbox-effect-open-close-speed\":\"normal\",\"lightbox-effect-next-prev\":\"fade\",\"lightbox-effect-next-prev-speed\":\"normal\",\"lbox-width\":\"960\",\"lbox-height\":\"540\",\"lbox-minwidth\":\"100\",\"lbox-minheight\":\"100\",\"lbox-maxwidth\":\"9999\",\"lbox-maxheight\":\"9999\",\"lightbox-autoplay\":\"off\",\"lbox-playspeed\":\"3000\",\"lbox-preload\":\"3\",\"lightbox-arrows\":\"on\",\"lightbox-thumbs\":\"off\",\"lbox-thumb-w\":\"50\",\"lbox-thumb-h\":\"50\",\"lightbox-post-spinner\":\"off\",\"lightbox-post-content-img\":\"off\",\"lightbox-post-content-img-position\":\"top\",\"lightbox-post-content-img-width\":\"50\",\"lightbox-post-content-img-margin\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-post-content-title\":\"off\",\"lightbox-post-content-title-tag\":\"h2\",\"aj-source-order\":[\"post-content\"],\"ajax-container-id\":\"ess-grid-ajax-container-\",\"ajax-container-position\":\"top\",\"ajax-scroll-onload\":\"on\",\"ajax-scrollto-offset\":\"0\",\"ajax-close-button\":\"off\",\"ajax-button-text\":\"Close\",\"ajax-nav-button\":\"off\",\"ajax-button-skin\":\"light\",\"ajax-button-type\":\"type1\",\"ajax-button-inner\":\"false\",\"ajax-button-h-pos\":\"r\",\"ajax-button-v-pos\":\"t\",\"0\":\"\",\"ajax-container-pre\":\"\",\"ajax-container-post\":\"\",\"ajax-container-css\":\"\",\"ajax-callback\":\"\",\"ajax-callback-arg\":\"false\",\"ajax-css-url\":\"\",\"ajax-js-url\":\"\",\"use-spinner\":\"0\",\"spinner-color\":\"#FFFFFF\",\"hide-markup-before-load\":\"off\",\"custom-javascript\":\"\",\"cookie-save-time\":\"30\",\"cookie-save-search\":\"off\",\"cookie-save-filter\":\"off\",\"cookie-save-pagination\":\"off\",\"css-id\":\"\",\"navigation-layout\":{\"pagination\":{\"bottom-2\":\"0\"},\"filter\":{\"top-1\":\"0\"}}}", "[]", NULL, NULL);

/* INSERT TABLE DATA: wp_eg_item_skins */
INSERT INTO `wp_eg_item_skins` VALUES("1", "Washington", "washington", "{\"eg-item-skin-element-last-id\":\"9\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(0,0,0,0.65)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#3f424a\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.50)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"falldown\",\"delay\":\"10\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"css\":\"\",\"css-hover\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.50)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"falldown\",\"delay\":\"20\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"css\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"css-hover\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"3\",\"order\":\"4\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"10\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"8\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"9\",\"order\":\"5\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("2", "Adams", "adams", "{\"eg-item-skin-element-last-id\":\"8\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(137,175,114,1)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"transparent\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"10\",\"cover-animation-center\":\"flipleft\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"turnout\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"delay\":\"10\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"css\":\".eg-adams-element-0{}\",\"css-hover\":\".eg-adams-element-0{}\",\"transition-type\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"delay\":\"20\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"3\",\"order\":\"4\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"css\":\".eg-adams-element-3{}\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\".eg-adams-element-3{}\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"5\",\"order\":\"7\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\".eg-adams-element-5{}\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\".eg-adams-element-5{}\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"words\",\"limit-num\":\"6\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"source-post\":\"excerpt\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"7\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"8\",\"order\":\"5\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("3", "Jefferson", "jefferson", "{\"eg-item-skin-element-last-id\":\"8\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(227,58,12,1)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fliphorizontal\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"fliphorizontalout\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#e33a0c\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"46\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#e33a0c\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slidedown\",\"delay\":\"50\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"3\",\"order\":\"3\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"17\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"10\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"17\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"60\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"5\",\"order\":\"6\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"1\",\"5\",\"1\",\"5\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"3\",\"3\",\"3\",\"3\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"12\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"3\",\"3\",\"3\",\"3\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"70\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\"   \",\"limit-type\":\"words\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-post\":\"cat_list\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"7\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"8\",\"order\":\"4\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("4", "Madison", "madison", "{\"eg-item-skin-element-last-id\":\"7\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(88,92,103,1)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#585c67\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"flipvertical\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"flipverticalout\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"19\",\"19\",\"19\",\"19\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.25)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"50\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"19\",\"19\",\"19\",\"19\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.25)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"35\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"3\",\"order\":\"4\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"35\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"5\",\"order\":\"7\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slidedown\",\"delay\":\"45\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"words\",\"limit-num\":\"6\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"excerpt\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"6\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"7\",\"order\":\"5\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("5", "Monroe", "monroe", "{\"eg-item-skin-element-last-id\":\"8\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(10,10,10,0.50)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"out\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"none\",\"cover-animation-center-type\":\"out\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"out\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"none\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"br\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"enable-hover\":\"on\",\"font-size\":\"13\",\"line-height\":\"30\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"30\",\"0\"],\"padding\":[\"3\",\"15\",\"2\",\"15\"],\"background-color\":\"rgba(137,175,114,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"transparent\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"3\",\"0\"],\"border-radius\":[\"3\",\"3\",\"3\",\"3\"],\"border-radius-unit\":\"px\",\"border-color\":\"#617f52\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"30\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"800\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(155,193,132,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"transparent\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"3\",\"0\"],\"border-radius-hover\":[\"3\",\"3\",\"3\",\"3\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#617f52\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"0\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-text\":\"Read More\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"24\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"900\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"4\",\"12\",\"3\",\"12\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"transparent\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.20)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flipdown\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"out\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"8\",\"order\":\"0\",\"container\":\"tl\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"17\",\"line-height\":\"24\",\"color\":\"#000000\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"30\",\"0\",\"0\",\"0\"],\"padding\":[\"3\",\"12\",\"4\",\"12\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"transparent\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.20)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slidedown\",\"transition-type\":\"\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"date\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("6", "Quincy", "quincy", "{\"eg-item-skin-element-last-id\":\"6\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(45,48,57,0.75)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#2d3039\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"pressback\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"24\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"10\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"24\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"30\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"24\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"10\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"24\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"10\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"3\",\"order\":\"4\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"10\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"5\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"6\",\"order\":\"5\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("7", "Jackson", "jackson", "{\"eg-item-skin-element-last-id\":\"7\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(255,255,255,1)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#eeeeee\",\"full-padding\":[\"5\",\"5\",\"5\",\"5\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"zoomback\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(245,245,245,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(238,238,238,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"zoomback\",\"delay\":\"5\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\".eg-jackson-element-0{}\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\".eg-jackson-element-0{}\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(245,245,245,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(238,238,238,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"zoomback\",\"delay\":\"10\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"3\",\"order\":\"4\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"18\",\"line-height\":\"20\",\"color\":\"#000000\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"18\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"skewright\",\"delay\":\"15\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"5\",\"order\":\"7\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"20\",\"color\":\"#888888\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"12\",\"line-height-hover\":\"20\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"skewleft\",\"delay\":\"10\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\", \",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-post\":\"cat_list\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"6\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"7\",\"order\":\"5\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("8", "VanBuren", "vanburen", "{\"eg-item-skin-element-last-id\":\"3\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(10,6,6,0.85)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#363839\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"flipup\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"17\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"20\",\"0\",\"20\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flyleft\",\"delay\":\"5\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"2\",\"order\":\"3\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flyright\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"source-post\":\"date\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"3\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("9", "HenryHarrison", "henryharrison", "{\"eg-item-skin-element-last-id\":\"5\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(49,165,203,0.85)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"1\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"30\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"900\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"10\",\"0\"],\"padding\":[\"0\",\"20\",\"0\",\"20\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"transparent\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"5\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"2\",\"order\":\"3\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"20\",\"line-height\":\"27\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"0\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"20\",\"line-height-hover\":\"27\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"normal\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"0\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"rotatescale\",\"delay\":\"5\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-plus\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"5\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("10", "Tyler", "tyler", "{\"eg-item-skin-element-last-id\":\"8\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(54,56,57,0.85)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"falldown\",\"delay\":\"20\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"falldown\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-unlink\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"3\",\"order\":\"4\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"10\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"title\",\"transition-type\":\"\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},\"\",{\"id\":\"5\",\"order\":\"7\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"excerpt\",\"transition-type\":\"\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"7\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"8\",\"order\":\"5\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("11", "Polk", "polk", "{\"eg-item-skin-element-last-id\":\"6\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(54,56,57,0.85)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.95)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"rotatescale\",\"delay\":\"20\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"rotatescale\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-icon\":\"eg-icon-unlink\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"3\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"19\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"10\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flipdown\",\"delay\":\"46\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"title\",\"transition-type\":\"\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"3\",\"order\":\"5\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flipdown\",\"delay\":\"57\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"excerpt\",\"transition-type\":\"\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("12", "Taylor", "taylor", "{\"eg-item-skin-element-last-id\":\"6\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(54,56,57,0.85)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"flipdown\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"0\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"0\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-icon\":\"eg-icon-unlink\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"19\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"20\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"title\",\"transition-type\":\"\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"3\",\"order\":\"3\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"excerpt\",\"transition-type\":\"\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("13", "Fillmore", "fillmore", "{\"eg-item-skin-element-last-id\":\"7\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(54,56,57,0.85)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#363839\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"fade\",\"delay\":\"0\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\".eg-fillmore-element-0{cursor:pointer}\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\".eg-fillmore-element-0{cursor:pointer}\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"br\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slidedown\",\"delay\":\"13\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"transition-type\":\"out\",\"tag-type\":\"div\",\"align\":\"c_c\",\"margin-unit\":\"px\",\"source-post\":\"date\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"2\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#363839\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"fade\",\"delay\":\"0\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\".eg-fillmore-element-1{ cursor:pointer}\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\".eg-fillmore-element-1{cursor:pointer}\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"source-icon\":\"eg-icon-unlink\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"3\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"19\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"20\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"fade\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"title\",\"transition-type\":\"\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"4\",\"order\":\"3\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"fade\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"excerpt\",\"transition-type\":\"\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("14", "Pierce", "pierce", "{\"eg-item-skin-element-last-id\":\"6\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(54,56,57,0.85)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"none\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"zoomback\",\"delay\":\"20\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\".eg-pierce-element-0{}\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\".eg-pierce-element-0{}\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\".eg-pierce-element-1{}\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\".eg-pierce-element-1{}\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-icon\":\"eg-icon-unlink\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"19\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"20\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"falldown\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"title\",\"transition-type\":\"\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"3\",\"order\":\"3\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"source-post\":\"excerpt\",\"tag-type\":\"div\",\"align\":\"c_c\",\"css-hover\":\"\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("15", "Buchanan", "buchanan", "{\"eg-item-skin-element-last-id\":\"6\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(54,56,57,0.85)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"slidedown\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"rollright\",\"delay\":\"20\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"rollleft\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-icon\":\"eg-icon-link\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"19\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"20\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slidedown\",\"delay\":\"21\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"title\",\"transition-type\":\"\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"3\",\"order\":\"3\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"40\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"excerpt\",\"transition-type\":\"\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("16", "Lincoln", "lincoln", "{\"eg-item-skin-element-last-id\":\"14\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(54,56,57,0.85)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"10\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"turnout\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"10\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"br\",\"settings\":{\"0\":\"\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"1\",\"0\",\"0\"],\"padding\":[\"13\",\"13\",\"13\",\"13\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.25)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"rollleft\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-icon\":\"eg-icon-link\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"1\",\"container\":\"br\",\"settings\":{\"0\":\"\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"1\",\"0\",\"0\"],\"padding\":[\"13\",\"13\",\"13\",\"13\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.25)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"rollleft\",\"delay\":\"30\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-icon\":\"eg-icon-link-ext\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"3\",\"order\":\"2\",\"container\":\"br\",\"settings\":{\"0\":\"\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"13\",\"13\",\"13\",\"13\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.25)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"rollleft\",\"delay\":\"30\",\"link-type\":\"url\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-icon\":\"eg-icon-mail\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("17", "Johnson", "johnson", "{\"eg-item-skin-element-last-id\":\"12\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(0,142,133,0.85)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"10\",\"cover-animation-center\":\"covergrowup\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"40\",\"0\",\"40\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"10\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"css\":\".eg-johnson-element-0{}\",\"css-hover\":\".eg-johnson-element-0{}\",\"tag-type\":\"div\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"br\",\"settings\":{\"0\":\"\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"1\",\"0\"],\"padding\":[\"13\",\"13\",\"13\",\"13\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.25)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"30\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"css\":\".eg-johnson-element-1{}\",\"css-hover\":\".eg-johnson-element-1{}\",\"tag-type\":\"div\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"3\",\"order\":\"1\",\"container\":\"br\",\"settings\":{\"0\":\"\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"1\",\"0\"],\"padding\":[\"13\",\"13\",\"13\",\"13\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.25)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"20\",\"link-type\":\"embedded_video\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"css\":\".eg-johnson-element-3{}\",\"css-hover\":\".eg-johnson-element-3{}\",\"tag-type\":\"div\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-videocam\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"4\",\"order\":\"2\",\"container\":\"br\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"1\",\"0\"],\"padding\":[\"13\",\"13\",\"13\",\"13\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.25)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"10\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"css\":\"\",\"css-hover\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"5\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\", \",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"cat_list\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"12\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("18", "Grant", "grant", "{\"eg-item-skin-element-last-id\":\"22\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(54,56,57,0.85)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"30\",\"30\",\"30\",\"30\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,0.20)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"1\",\"2\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"20\",\"line-height\":\"25\",\"color\":\"#363839\",\"font-family\":\"\",\"font-weight\":\"600\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"20\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\".eg-grant-element-0{}\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\".eg-grant-element-0{}\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"br\",\"settings\":{\"0\":\"\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"right\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"13\",\"13\",\"13\",\"13\"],\"background-color\":\"rgba(0,0,0,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.40)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"rollleft\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link-ext\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"600\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(0,0,0,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"10\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-text\":\"READ MORE\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"3\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#aaaaaa\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"10\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"date\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",\"\",{\"id\":\"6\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"22\",\"color\":\"#777777\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-post\":\"excerpt\",\"transition-type\":\"\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"22\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("19", "Hayes", "hayes", "{\"eg-item-skin-element-last-id\":\"23\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(54,56,57,0.85)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"30\",\"30\",\"30\",\"30\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,0.20)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"1\",\"2\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"20\",\"line-height\":\"25\",\"color\":\"#363839\",\"font-family\":\"\",\"font-weight\":\"600\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"20\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#aaaaaa\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"10\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"1\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#aaaaaa\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"date\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#aaaaaa\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"10\"],\"padding\":[\"0\",\"10\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#aaaaaa\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"cat_list\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("20", "Garfield", "garfield", "{\"eg-item-skin-element-last-id\":\"22\",\"choose-layout\":\"masonry\",\"show-content\":\"top\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(0,0,0,0.75)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"transparent\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"30\",\"30\",\"30\",\"30\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,0.20)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"-1\",\"2\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"20\",\"line-height\":\"25\",\"color\":\"#363839\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"20\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"br\",\"settings\":{\"0\":\"\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"right\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"13\",\"13\",\"13\",\"13\"],\"background-color\":\"rgba(0,0,0,0.25)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"rollleft\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link-ext\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(0,0,0,0.25)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"800\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(0,0,0,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"10\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-text\":\"READ MORE\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"3\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"16\",\"color\":\"#777777\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"10\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"1\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"16\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"1\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#e5e5e5\",\"border-style-hover\":\"solid\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-post\":\"date\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"4\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"16\",\"color\":\"#777\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"10\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"16\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\", \",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"cat_list\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"22\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"6\",\"order\":\"5\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"22\",\"color\":\"#333333\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"words\",\"limit-num\":\"15\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"excerpt\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("21", "Arthur", "arthur", "{\"eg-item-skin-element-last-id\":\"31\",\"choose-layout\":\"masonry\",\"show-content\":\"top\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(137,175,114,0.75)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"1\",\"1\",\"1\",\"1\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#e5e5e5\",\"full-border-style\":\"solid\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#f5f5f5\",\"content-padding\":[\"30\",\"30\",\"25\",\"30\"],\"content-border\":[\"0\",\"0\",\"1\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"#e5e5e5\",\"content-border-style\":\"solid\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,0.20)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"-1\",\"2\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"17\",\"line-height\":\"22\",\"color\":\"#000000\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"20\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"28\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"woocommerce\",\"enable-hover\":\"on\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"4\",\"10\"],\"background-color\":\"rgba(0,0,0,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-size-x\":\"100\",\"background-size-y\":\"100\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"800\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"10\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-woocommerce\":\"wc_add_to_cart_button\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"25\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"woocommerce\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"17\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"10\",\"0\",\"0\",\"0\"],\"padding\":[\"2\",\"7\",\"1\",\"7\"],\"background-color\":\"rgba(227,58,12,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"margin-unit\":\"px\",\"source-woocommerce\":\"wc_full_price\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"26\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"woocommerce\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#777777\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"10\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#aaaaaa\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\\\"Open Sans\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#aaaaaa\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\", \",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-woocommerce\":\"wc_categories\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"31\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"30\",\"order\":\"5\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"woocommerce\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-size-x\":\"100\",\"background-size-y\":\"100\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"margin-unit\":\"px\",\"source-woocommerce\":\"wc_star_rating\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("22", "Cleveland", "cleveland", "{\"eg-item-skin-element-last-id\":\"22\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(0,0,0,0.75)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#333333\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#333333\",\"content-padding\":[\"30\",\"30\",\"30\",\"30\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,0.20)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"1\",\"2\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"20\",\"line-height\":\"25\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"20\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\".eg-cleveland-element-0{}\",\"font-size-hover\":\"20\",\"line-height-hover\":\"25\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\".eg-cleveland-element-0{}\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"br\",\"settings\":{\"0\":\"\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"right\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"13\",\"13\",\"13\",\"13\"],\"background-color\":\"rgba(0,0,0,0.25)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"rollleft\",\"delay\":\"30\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link-ext\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(0,0,0,0.25)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"800\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(0,0,0,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"10\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-text\":\"READ MORE\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"3\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"16\",\"color\":\"#aaaaaa\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"0\",\"10\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"1\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#555555\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"16\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"1\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#555555\",\"border-style-hover\":\"solid\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-post\":\"date\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"4\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"16\",\"color\":\"#aaaaaa\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"16\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\", \",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"cat_list\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},\"\",{\"id\":\"6\",\"order\":\"5\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"22\",\"color\":\"#eeeeee\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"words\",\"limit-num\":\"15\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"excerpt\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"22\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("23", "Harrison", "harrison", "{\"eg-item-skin-element-last-id\":\"24\",\"choose-layout\":\"masonry\",\"show-content\":\"top\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(54,56,57,0.85)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#363839\",\"content-padding\":[\"30\",\"30\",\"30\",\"30\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,0.20)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"-1\",\"2\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"20\",\"line-height\":\"25\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"500\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"20\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#aaaaaa\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"10\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"1\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#aaaaaa\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-post\":\"date\",\"transition-type\":\"\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"2\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#aaaaaa\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"10\"],\"padding\":[\"0\",\"10\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#aaaaaa\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"cat_list\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("24", "McKinley", "mckinley", "{\"eg-item-skin-element-last-id\":\"30\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(19,192,223,0.65)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#e5e5e5\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"30\",\"30\",\"30\",\"30\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"1\",\"10\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"slide\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"20\",\"line-height\":\"25\",\"color\":\"#363839\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"10\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"20\",\"line-height-hover\":\"25\",\"color-hover\":\"#13c0df\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"800\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"25\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"on\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"900\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"3\",\"10\"],\"background-color\":\"rgba(0,0,0,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-size-x\":\"100\",\"background-size-y\":\"100\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"900\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(0,0,0,0.50)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slide\",\"delay\":\"20\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"hide-on-video\":\"true\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-text\":\"SHOW IMAGE\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"28\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"on\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"900\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"5\"],\"padding\":[\"5\",\"10\",\"3\",\"10\"],\"background-color\":\"rgba(0,0,0,0.15)\",\"bg-alpha\":\"100\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"900\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(0,0,0,0.50)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"transition\":\"slide\",\"transition-type\":\"\",\"delay\":\"20\",\"link-type\":\"embedded_video\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-text\":\"PLAY VIDEO\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"3\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#aaaaaa\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\\\"Open Sans\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#e5e5e5\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\", \",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-post\":\"cat_list\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},\"\",{\"id\":\"6\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"22\",\"color\":\"#777777\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"words\",\"limit-num\":\"15\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"excerpt\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},\"\",{\"id\":\"29\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"30\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("25", "Roosevelt", "roosevelt", "{\"eg-item-skin-element-last-id\":\"3\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(34,34,34,0.50)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#333333\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#333333\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"zoomback\",\"cover-group-animation\":\"none\",\"media-animation\":\"shifttotop\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"br\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"20\",\"20\",\"20\",\"20\"],\"background-color\":\"rgba(51,51,51,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\".eg-roosevelt-element-0{}\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\".eg-roosevelt-element-0{}\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"9\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"transition-type\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"60\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(0,0,0,0.50)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.75)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"20\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"css\":\".eg-roosevelt-element-2{}\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"transition-type\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\".eg-roosevelt-element-2{}\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(0,0,0,0.50)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.75)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"transition-type\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("26", "HowardTaft", "howardtaft", "{\"eg-item-skin-element-last-id\":\"14\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(111,33,44,0.75)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#000000\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#000000\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"slide\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"900\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\".eg-howardtaft-element-0{letter-spacing:1px;}\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\".eg-howardtaft-element-0{}\",\"hideunder\":\"0\",\"transition\":\"slide\",\"delay\":\"15\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"true\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"css-hover\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"2\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"6\",\"line-height\":\"7\",\"color\":\"transparent\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"css\":\".eg-howardtaft-element-2{ min-width:50px}\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\".eg-howardtaft-element-2{}\",\"hideunder\":\"0\",\"transition\":\"zoomback\",\"delay\":\"25\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"absolute-unit\":\"px\",\"source-text\":\"anemptytextlline\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"3\",\"order\":\"3\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"css\":\"\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"css-hover\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"6\",\"order\":\"6\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"\",\"font-size\":\"17\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"200\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"7\",\"color-hover\":\"#e33a0c\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slide\",\"delay\":\"35\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"hide-on-video\":\"true\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"7\",\"order\":\"7\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"\",\"font-size\":\"17\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"7\",\"color-hover\":\"#e33a0c\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slide\",\"delay\":\"35\",\"link-type\":\"embedded_video\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-play\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("27", "WoodrowWilson", "woodrowwilson", "{\"eg-item-skin-element-last-id\":\"14\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(255,255,255,1)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#000000\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"20\",\"0\",\"20\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"delay\":\"15\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"true\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"css-hover\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"2\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"6\",\"line-height\":\"7\",\"color\":\"transparent\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"3\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#89af72\",\"border-style\":\"solid\",\"css\":\".eg-howardtaft-element-2{ min-width:50px}\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\".eg-howardtaft-element-2{}\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"25\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-text\":\"anemptytextlline\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"3\",\"order\":\"3\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"css\":\"\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"css-hover\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"4\",\"order\":\"4\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"22\",\"color\":\"#555555\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\", \",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"cat_list\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("28", "Harding", "harding", "{\"eg-item-skin-element-last-id\":\"17\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"transparent\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"transparent\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"google-fonts\":[\"Droid+Serif:400,700\",\"Open+Sans:400,600,700,800\"]}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"25\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"40\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"15\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"10\",\"source-post\":\"title\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"1\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#444444\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"500\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#363839\",\"font-family-hover\":\"\",\"font-weight-hover\":\"600\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-text\":\"Frontend Developer\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"2\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"3\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"6\",\"line-height\":\"7\",\"color\":\"transparent\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#000000\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"25\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"source-text\":\"anemptytextlline\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"4\",\"order\":\"5\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"5\",\"order\":\"6\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"22\",\"color\":\"#555555\",\"font-family\":\"\\\"Droid Serif\\\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"50\",\"source-post\":\"excerpt\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"6\",\"order\":\"7\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("29", "Coolidge", "coolidge", "{\"eg-item-skin-element-last-id\":\"19\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"transparent\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"30\",\"30\",\"30\",\"30\"],\"content-border\":[\"1\",\"1\",\"1\",\"1\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"#e5e5e5\",\"content-border-style\":\"solid\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,0.15)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"google-fonts\":[\"Droid+Serif:400,700\",\"Open+Sans:400,600,700,800\"]}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"33\",\"line-height\":\"25\",\"color\":\"#363839\",\"font-family\":\"\",\"font-weight\":\"600\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-text\":\"<i class=\\\"eg-icon-tools\\\"><\\/i>\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"19\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"15\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"10\",\"source-post\":\"title\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"2\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-text\":\"LINE-BREAK\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"3\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"6\",\"line-height\":\"7\",\"color\":\"transparent\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#000000\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"25\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"source-text\":\"anemptytextlline\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"4\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"5\",\"order\":\"5\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"22\",\"color\":\"#555555\",\"font-family\":\"\\\"Droid Serif\\\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"40\",\"source-post\":\"excerpt\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"6\",\"order\":\"6\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"7\",\"order\":\"7\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"14\",\"color\":\"#40dc8d\",\"font-family\":\"\\\"Droid Serif\\\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"20\",\"0\",\"0\",\"-15\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#363839\",\"font-family-hover\":\"\",\"font-weight-hover\":\"600\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-text\":\"<i class=\\\"eg-icon-angle-right\\\"><\\/i> Learn More\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("30", "Herbert Hoover", "herbert-hoover", "{\"eg-item-skin-element-last-id\":\"25\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"transparent\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"30\",\"30\",\"30\",\"30\"],\"content-border\":[\"0\",\"1\",\"1\",\"1\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"#e5e5e5\",\"content-border-style\":\"solid\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"transparent\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"25\",\"color\":\"#000000\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"15\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"10\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"hide-on-video\":\"\",\"source-post\":\"title\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"24\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(0,0,0,0.50)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit\":\"%\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.75)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit-hover\":\"%\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"fade\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"10\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"hide-on-video\":\"true\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#444444\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#aaaaaa\",\"font-family-hover\":\"\\\"Open Sans\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\", \",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-post\":\"cat_list\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"25\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"5\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(0,0,0,0.50)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit\":\"%\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.75)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"fade\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"10\",\"link-type\":\"embedded_video\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-icon\":\"eg-icon-play\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"10\",\"order\":\"10\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-num\":\"10\",\"limit-type\":\"none\",\"enable-hover\":\"on\",\"font-size\":\"22\",\"line-height\":\"7\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"25\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"22\",\"line-height-hover\":\"7\",\"color-hover\":\"#c32524\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"falldown\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"10\",\"link-type\":\"url\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-icon\":\"eg-icon-pinterest\",\"link-type-url\":\"#\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"3\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"4\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"6\",\"line-height\":\"7\",\"color\":\"transparent\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#000000\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"25\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"source-text\":\"anemptytextlline\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"5\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"6\",\"order\":\"5\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"22\",\"color\":\"#555555\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"15\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-post\":\"excerpt\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"7\",\"order\":\"6\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"8\",\"order\":\"7\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-num\":\"10\",\"limit-type\":\"none\",\"enable-hover\":\"on\",\"font-size\":\"22\",\"line-height\":\"7\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"25\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"22\",\"line-height-hover\":\"7\",\"color-hover\":\"#4672b3\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"falldown\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"10\",\"link-type\":\"url\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-icon\":\"eg-icon-facebook-1\",\"link-type-url\":\"#\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"9\",\"order\":\"8\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-num\":\"10\",\"limit-type\":\"none\",\"enable-hover\":\"on\",\"font-size\":\"22\",\"line-height\":\"7\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"25\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"22\",\"line-height-hover\":\"7\",\"color-hover\":\"#099bcc\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"falldown\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"10\",\"link-type\":\"url\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-icon\":\"eg-icon-twitter-1\",\"link-type-url\":\"#\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"9\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-num\":\"10\",\"limit-type\":\"none\",\"enable-hover\":\"on\",\"font-size\":\"22\",\"line-height\":\"7\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"25\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"22\",\"line-height-hover\":\"7\",\"color-hover\":\"#da4a38\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"falldown\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"10\",\"link-type\":\"url\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-icon\":\"eg-icon-gplus-1\",\"link-type-url\":\"#\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("31", "Eisenhower", "eisenhower", "{\"eg-item-skin-element-last-id\":\"24\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"transparent\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"20\",\"20\",\"20\",\"20\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"5\",\"5\",\"5\",\"5\"],\"full-border-color\":\"#606060\",\"full-border-style\":\"solid\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"30\",\"30\",\"0\",\"30\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"#e5e5e5\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,0.15)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"google-fonts\":[\"Droid+Serif:400,700\",\"Open+Sans:400,600,700,800\"]}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"19\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"15\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"10\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-post\":\"title\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"15\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(0,0,0,0.85)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit\":\"%\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"rollright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"10\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-text\":\"LINE-BREAK\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"3\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(0,0,0,0.85)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit\":\"%\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit-hover\":\"%\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"rollleft\",\"delay\":\"18\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-icon\":\"eg-icon-forward\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"4\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"6\",\"line-height\":\"7\",\"color\":\"transparent\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#40dc8d\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"25\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"source-text\":\"anemptytextlline\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"5\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"6\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"22\",\"color\":\"#555555\",\"font-family\":\"\\\"Droid Serif\\\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"5\",\"source-post\":\"cat_list\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("32", "J.F.Kennedy", "j-f-kennedy", "{\"eg-item-skin-element-last-id\":\"24\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"transparent\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#111111\",\"full-padding\":[\"20\",\"20\",\"20\",\"20\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"5\",\"5\",\"5\",\"5\"],\"full-border-color\":\"#606060\",\"full-border-style\":\"solid\",\"content-bg-color\":\"#111111\",\"content-padding\":[\"30\",\"30\",\"0\",\"30\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"#e5e5e5\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,0.15)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"google-fonts\":[\"Droid+Serif:400,700\",\"Open+Sans:400,600,700,800\"]}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"19\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"15\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"10\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-post\":\"title\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"15\",\"0\",\"0\"],\"padding\":[\"19\",\"19\",\"19\",\"19\"],\"background-color\":\"rgba(0,0,0,0.85)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit\":\"%\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"rollright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"10\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-text\":\"LINE-BREAK\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"3\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"19\",\"19\",\"19\",\"19\"],\"background-color\":\"rgba(0,0,0,0.85)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit\":\"%\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"19\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit-hover\":\"%\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"rollleft\",\"delay\":\"18\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-icon\":\"eg-icon-forward\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"4\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"6\",\"line-height\":\"7\",\"color\":\"transparent\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#40dc8d\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"25\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"source-text\":\"anemptytextlline\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"5\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"6\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"22\",\"color\":\"#888888\",\"font-family\":\"\\\"Droid Serif\\\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"5\",\"source-post\":\"cat_list\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("33", "Lyndon Johnson", "lyndon-johnson", "{\"eg-item-skin-element-last-id\":\"2\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(0,0,0,0.75)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"covergrowup\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"none\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"0\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"out\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-text\":\"<img src=\\\"%eg-clients-icon%\\\" \\/>\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("34", "Ulysses S. Grant", "ulysses-s-grant", "{\"eg-item-skin-element-last-id\":\"11\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"transparent\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#f5f5f5\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"1\",\"1\",\"1\",\"1\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#e5e5e5\",\"full-border-style\":\"solid\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#f5f5f5\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"none\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"google-fonts\":[\"Open+Sans:400\",\"Raleway:700,800,900\"]}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"50\",\"line-height\":\"50\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"80\",\"0\",\"-6\",\"0\"],\"padding\":[\"1\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(0,0,0,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"flipdown\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"out\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-post\":\"meta\",\"source-meta\":\"eg-pricetable-price\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"20\",\"line-height\":\"25\",\"color\":\"#363839\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"30\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"3\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"22\",\"color\":\"#999999\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"20\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"5\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-post\":\"excerpt\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"4\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"top\":\"0\",\"top-unit-hover\":\"px\",\"right\":\"0\",\"right-unit-hover\":\"px\",\"bottom\":\"0\",\"bottom-unit-hover\":\"px\",\"left\":\"0\",\"left-unit-hover\":\"px\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"5\",\"0\",\"5\"],\"background-color\":\"rgba(227,58,12,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\".eg-kriki-element-2{.eg-kriki-element-4{}\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\".eg-kriki-element-2{.eg-kriki-element-4{}\",\"hideunder\":\"0\",\"transition\":\"flipdown\",\"transition-type\":\"out\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-text\":\"SHIPPING INCL.\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"5\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#777777\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"20\",\"17\",\"20\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"1\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-post\":\"meta\",\"source-meta\":\"eg-pricetable-line1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"6\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#777777\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"20\",\"17\",\"20\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"1\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-post\":\"meta\",\"source-meta\":\"eg-pricetable-line2\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"7\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#777777\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"20\",\"17\",\"20\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"1\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-post\":\"meta\",\"source-meta\":\"eg-pricetable-line3\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"8\",\"order\":\"5\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#777777\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"20\",\"17\",\"20\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"1\",\"0\",\"1\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-post\":\"meta\",\"source-meta\":\"eg-pricetable-line4\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"9\",\"order\":\"6\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"on\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"top\":\"0\",\"top-unit-hover\":\"px\",\"right\":\"0\",\"right-unit-hover\":\"px\",\"bottom\":\"0\",\"bottom-unit-hover\":\"px\",\"left\":\"0\",\"left-unit-hover\":\"px\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"20\",\"0\",\"15\",\"0\"],\"padding\":[\"8\",\"25\",\"8\",\"25\"],\"background-color\":\"rgba(227,58,12,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\".eg-kriki-element-2{.eg-kriki-element-4{}\",\"font-size-hover\":\"13\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"800\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(0,0,0,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\".eg-kriki-element-2{.eg-kriki-element-4{}\",\"hideunder\":\"0\",\"transition\":\"skewright\",\"transition-type\":\"\",\"delay\":\"34\",\"link-type\":\"url\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-text\":\"BUY NOW\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"11\",\"order\":\"7\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("35", "Richard Nixon", "richard-nixon", "{\"eg-item-skin-element-last-id\":\"12\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"transparent\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#252525\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"1\",\"1\",\"1\",\"1\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#444444\",\"full-border-style\":\"solid\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#252525\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"none\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"50\",\"line-height\":\"50\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"80\",\"0\",\"-6\",\"0\"],\"padding\":[\"1\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(0,0,0,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"flipdown\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"out\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-text\":\"<span style=\\\"font-size:30px; font-weight:300;\\\">$<\\/span> 24.99\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"20\",\"line-height\":\"25\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"30\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"3\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"20\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"5\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-post\":\"excerpt\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"4\",\"order\":\"3\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"top\":\"0\",\"top-unit-hover\":\"px\",\"right\":\"0\",\"right-unit-hover\":\"px\",\"bottom\":\"0\",\"bottom-unit-hover\":\"px\",\"left\":\"0\",\"left-unit-hover\":\"px\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"5\",\"0\",\"5\"],\"background-color\":\"rgba(227,58,12,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\".eg-kriki-element-2{.eg-kriki-element-4{}\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\".eg-kriki-element-2{.eg-kriki-element-4{}\",\"hideunder\":\"0\",\"transition\":\"flipdown\",\"transition-type\":\"out\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-text\":\"SHIPPING INCL.\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"5\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#888888\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"20\",\"17\",\"20\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"1\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#444444\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-text\":\"4gb Webspace Included\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"6\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#888888\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"20\",\"17\",\"20\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"1\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#444444\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-text\":\"2 Domains\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"7\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#888888\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"20\",\"17\",\"20\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"1\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#444444\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-text\":\"PHP5 Enabled\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"8\",\"order\":\"5\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#888888\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"20\",\"17\",\"20\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"1\",\"0\",\"1\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#444444\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-text\":\"24h Support\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"9\",\"order\":\"6\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"on\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"top\":\"0\",\"top-unit-hover\":\"px\",\"right\":\"0\",\"right-unit-hover\":\"px\",\"bottom\":\"0\",\"bottom-unit-hover\":\"px\",\"left\":\"0\",\"left-unit-hover\":\"px\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"20\",\"0\",\"15\",\"0\"],\"padding\":[\"8\",\"25\",\"8\",\"25\"],\"background-color\":\"rgba(227,58,12,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\".eg-kriki-element-2{.eg-kriki-element-4{}\",\"font-size-hover\":\"13\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"800\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(0,0,0,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\".eg-kriki-element-2{.eg-kriki-element-4{}\",\"hideunder\":\"0\",\"transition\":\"skewright\",\"transition-type\":\"\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-text\":\"BUY NOW\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"11\",\"order\":\"7\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"12\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("36", "Gerald Ford", "gerald-ford", "{\"eg-item-skin-element-last-id\":\"15\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(255,255,255,0.25)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#f5f5f5\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"1\",\"1\",\"1\",\"1\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#e5e5e5\",\"full-border-style\":\"solid\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#f5f5f5\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"1\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"20\",\"line-height\":\"25\",\"color\":\"#000000\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"30\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-text\":\"PREMIUM PRODUCT\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"14\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"5\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(0,0,0,0.65)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit\":\"%\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"10\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"3\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"22\",\"color\":\"#777777\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"20\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-text\":\"The best for your small business\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"15\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(0,0,0,0.65)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit\":\"%\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit-hover\":\"%\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"20\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-basket\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"11\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"50\",\"line-height\":\"50\",\"color\":\"#000000\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"20\",\"20\",\"0\",\"20\"],\"background-color\":\"rgba(238,238,238,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"1\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-text\":\"<span style=\\\"font-size:30px; font-weight:300;\\\">$<\\/span> 39.99\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"12\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"15\",\"color\":\"#000000\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"20\",\"20\",\"20\"],\"background-color\":\"rgba(238,238,238,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-text\":\"INCL. SHIPPING\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"5\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#777777\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"20\",\"17\",\"20\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"1\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-text\":\"4GB Webspace Included\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"6\",\"order\":\"5\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#777777\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"20\",\"17\",\"20\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"1\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-text\":\"2 Domains\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"7\",\"order\":\"6\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#777777\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"20\",\"17\",\"20\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"1\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-text\":\"PHP5 Enabled\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"8\",\"order\":\"7\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#777777\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"20\",\"20\",\"20\",\"20\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"1\",\"0\",\"1\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-text\":\"24h Support\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"9\",\"order\":\"8\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"on\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"top\":\"0\",\"top-unit-hover\":\"px\",\"right\":\"0\",\"right-unit-hover\":\"px\",\"bottom\":\"0\",\"bottom-unit-hover\":\"px\",\"left\":\"0\",\"left-unit-hover\":\"px\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"20\",\"0\",\"20\",\"0\"],\"padding\":[\"8\",\"25\",\"8\",\"25\"],\"background-color\":\"rgba(227,58,12,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\".eg-kriki-element-2{.eg-kriki-element-4{}\",\"font-size-hover\":\"13\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(0,0,0,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\".eg-kriki-element-2{.eg-kriki-element-4{}\",\"hideunder\":\"0\",\"transition\":\"skewright\",\"transition-type\":\"\",\"delay\":\"34\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-text\":\"BUY NOW\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"13\",\"order\":\"9\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("37", "Jimmy Carter", "jimmy-carter", "{\"eg-item-skin-element-last-id\":\"24\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"transparent\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"30\",\"30\",\"27\",\"30\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#e5e5e5\",\"full-border-style\":\"solid\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"27\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"#e5e5e5\",\"content-border-style\":\"solid\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"3\",\"6\",\"1\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"3dturnright\",\"media-animation-delay\":\"8\",\"google-fonts\":[\"Droid+Serif:400,700\",\"Open+Sans:400,600,700,800\"]}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"15\",\"color\":\"#363839\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.75)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"skewright\",\"delay\":\"15\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-text\":\"I\'m a custom caption\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"20\",\"line-height\":\"25\",\"color\":\"#000000\",\"font-family\":\"\\\"Droid Serif\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"20\",\"line-height-hover\":\"25\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\\\"Droid Serif\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"15\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"10\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-post\":\"title\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"2\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"3\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#999999\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"5\",\"20\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#aaaaaa\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\\\"Open Sans\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#aaaaaa\",\"border-style-hover\":\"solid\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-separate\":\", \",\"source-post\":\"cat_list\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"4\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"15\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"top\":\"0\",\"top-unit-hover\":\"px\",\"right\":\"0\",\"right-unit-hover\":\"px\",\"bottom\":\"0\",\"bottom-unit-hover\":\"px\",\"left\":\"0\",\"left-unit-hover\":\"px\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"both\",\"margin\":[\"-5\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(231,65,36,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\".eg-kriki-element-2{.eg-kriki-element-4{}\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\".eg-kriki-element-2{.eg-kriki-element-4{}\",\"hideunder\":\"0\",\"transition\":\"skewright\",\"transition-type\":\"\",\"delay\":\"9\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-text\":\"ADD ANYTHING\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"5\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#777777\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"5\",\"20\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\\\"Open Sans\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-post\":\"num_comments\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"6\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"7\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"6\",\"line-height\":\"7\",\"color\":\"transparent\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#000000\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"25\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"source-text\":\"anemptytextlline\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"8\",\"order\":\"5\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"9\",\"order\":\"6\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"22\",\"color\":\"#555555\",\"font-family\":\"\\\"Droid Serif\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"15\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-post\":\"excerpt\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"10\",\"order\":\"7\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-catmax\":\"-1\"}},{\"id\":\"11\",\"order\":\"8\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"on\",\"font-size\":\"15\",\"line-height\":\"14\",\"color\":\"#e74124\",\"font-family\":\"\\\"Droid Serif\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"20\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"15\",\"line-height-hover\":\"14\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\\\"Droid Serif\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-text\":\"<i class=\\\"eg-icon-angle-right\\\"><\\/i> Read More\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("38", "Ronald Reagan", "ronald-reagan", "{\"eg-item-skin-element-last-id\":\"8\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"transparent\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"transparent\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"20\",\"20\",\"20\",\"20\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"none\",\"cover-animation-center-type\":\"out\",\"cover-animation-delay-center\":\"4\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"out\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"tl\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"10\",\"20\",\"10\",\"20\"],\"background-color\":\"rgba(77,56,75,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"6\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"\",\"transition-type\":\"out\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\"\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"date_modified\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"br\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"20\",\"line-height\":\"23\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Droid Serif\\\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"10\",\"10\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slidedown\",\"delay\":\"15\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"10\",\"transition-type\":\"out\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#999999\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"20\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\\\"Open Sans\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\", \",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-post\":\"cat_list\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"8\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"20\",\"line-height\":\"28\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(0,0,0,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"20\",\"line-height-hover\":\"28\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"rotatescale\",\"delay\":\"10\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-icon\":\"eg-icon-link\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"4\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#999\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\\\"Open Sans\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-post\":\"num_comments\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"5\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"limit-type\":\"words\",\"limit-num\":\"20\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"20\",\"color\":\"#444444\",\"font-family\":\"\\\"Droid Serif\\\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"7\",\"0\",\"0\",\"0\"],\"padding\":[\"15\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"1\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-post\":\"excerpt\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("39", "GeorgeBush", "georgebush", "{\"eg-item-skin-element-last-id\":\"4\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"content\",\"container-background-color\":\"rgba(227,58,12,1)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"covergrowup\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"google-fonts\":[\"Raleway:400,800,900\"]}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"br\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"limit-type\":\"none\",\"limit-num\":\"3\",\"enable-hover\":\"\",\"font-size\":\"35\",\"line-height\":\"38\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"20\",\"0\",\"0\",\"20\"],\"padding\":[\"0\",\"20\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"margin-unit\":\"px\",\"source-post\":\"title\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"br\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"limit-type\":\"words\",\"limit-num\":\"8\",\"enable-hover\":\"\",\"font-size\":\"18\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"20\",\"20\"],\"padding\":[\"0\",\"20\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"margin-unit\":\"px\",\"source-post\":\"excerpt\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("40", "Essential Preview", "essential-preview", "{\"eg-item-skin-element-last-id\":\"9\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(10,10,10,0.75)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#000000\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"out\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"none\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"out\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"none\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"google-fonts\":[\"Open+Sans:700;800\"]}", "[{\"id\":\"1\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"24\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"4\",\"12\",\"3\",\"12\"],\"background-color\":\"rgba(255,255,255,0.10)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"transparent\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.20)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flipdown\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"9\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"0\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"24\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"3\",\"10\",\"2\",\"10\"],\"background-color\":\"rgba(227,58,12,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"transparent\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#617f52\",\"border-style\":\"none\",\"font-size-hover\":\"12\",\"line-height-hover\":\"24\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Open Sans\\\"\",\"font-weight-hover\":\"800\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,77,28,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"transparent\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#617f52\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"0\",\"link-type\":\"meta\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-text\":\"Check it Out\",\"link-type-meta\":\"eg-demogrid-link\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("41", "More Demo Examples", "more-demo-examples", "{\"eg-item-skin-element-last-id\":\"9\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(64,70,85,0.60)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#000000\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"out\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"none\",\"cover-animation-center-type\":\"out\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"out\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"none\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"google-fonts\":[\"Open+Sans:700;800\"]}", "[{\"id\":\"1\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"24\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"4\",\"12\",\"3\",\"12\"],\"background-color\":\"rgba(0,0,0,0.75)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"transparent\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.20)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flipdown\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"9\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"0\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"24\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"3\",\"10\",\"2\",\"10\"],\"background-color\":\"rgba(227,58,12,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"transparent\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#617f52\",\"border-style\":\"none\",\"font-size-hover\":\"12\",\"line-height-hover\":\"24\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Open Sans\\\"\",\"font-weight-hover\":\"800\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,77,28,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"transparent\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#617f52\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"0\",\"link-type\":\"meta\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-text\":\"Check it Out\",\"link-type-meta\":\"eg-demogrid-link\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("42", "Wilbert", "wilbert", "{\"eg-item-skin-element-last-id\":\"2\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(17,17,17,0.65)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"out\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"none\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"0\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"out\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-text\":\"<img src=\\\"%eg-clients-icon%\\\" \\/>\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("43", "Phillie", "phillie", "{\"eg-item-skin-element-last-id\":\"3\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(255,255,255,1)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"1\",\"1\",\"1\",\"1\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#ffffff\",\"full-border-style\":\"solid\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"1\",\"1\",\"1\",\"1\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"#ffffff\",\"content-border-style\":\"solid\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"out\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"none\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"google-fonts\":[\"Raleway:700,800,900\"]}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"none\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"0\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"out\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-text\":\"<img src=\\\"%eg-clients-icon-dark%\\\" \\/>\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"3\",\"order\":\"0\",\"container\":\"tl\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"2\",\"7\",\"2\",\"7\"],\"background-color\":\"rgba(0,0,0,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-size-x\":\"100\",\"background-size-y\":\"100\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"81.67\",\"left-right\":\"38.5\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"%\",\"margin-unit\":\"px\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("44", "Jason", "jason", "{\"eg-item-skin-element-last-id\":\"32\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(255,255,255,0.20)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"1\",\"1\",\"1\",\"1\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#e5e5e5\",\"full-border-style\":\"solid\",\"full-overflow-hidden\":\"true\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"30\",\"30\",\"30\",\"30\"],\"content-border\":[\"1\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"#e5e5e5\",\"content-border-style\":\"solid\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,0.20)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"-1\",\"2\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#000000\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"20\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"32\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(227,58,12,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-size-x\":\"100\",\"background-size-y\":\"100\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slide\",\"delay\":\"10\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"hide-on-video\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"25\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"woocommerce\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#89af72\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"10\",\"0\",\"0\",\"0\"],\"padding\":[\"2\",\"7\",\"1\",\"7\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"margin-unit\":\"px\",\"source-woocommerce\":\"wc_full_price\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"31\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"30\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"woocommerce\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"30\",\"color\":\"#000000\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-size-x\":\"100\",\"background-size-y\":\"100\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"margin-unit\":\"px\",\"source-woocommerce\":\"wc_star_rating\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"26\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"28\",\"order\":\"5\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"woocommerce\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"4\",\"10\"],\"background-color\":\"rgba(227,58,12,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-size-x\":\"100\",\"background-size-y\":\"100\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"5\",\"5\",\"5\",\"5\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Open Sans\\\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"rgba(0,0,0,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"5\",\"5\",\"5\",\"5\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#e33a0c\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"10\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-woocommerce\":\"wc_add_to_cart_button\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("45", "FlickrStream", "flickrstream", "{\"eg-item-skin-element-last-id\":\"19\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"image-repeat\":\"no-repeat\",\"image-fit\":\"cover\",\"image-align-horizontal\":\"center\",\"image-align-vertical\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(0,0,0,0.50)\",\"0\":\"Default\",\"cover-always-visible-desktop\":\"\",\"cover-always-visible-mobile\":\"\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#222222\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#222222\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"link-set-to\":\"cover\",\"link-link-type\":\"lightbox\",\"link-url-link\":\"\",\"link-meta-link\":\"\",\"link-javascript-link\":\"\",\"link-target\":\"_self\"}", "[{\"id\":\"1\",\"order\":\"0\",\"container\":\"br\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"right\",\"clear\":\"none\",\"margin\":[\"0\",\"15\",\"10\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.50)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"fade\",\"delay\":\"0\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"css\":\"\",\"css-hover\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_blank\",\"source-text-style-disable\":\"\",\"show-on-lightbox-video\":\"\",\"source-icon\":\"eg-icon-link\"}},\"\",{\"id\":\"15\",\"order\":\"1\",\"container\":\"br\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"19\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"15\",\"20\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"transition\":\"fade\",\"transition-type\":\"\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"margin-unit\":\"px\",\"source-post\":\"title\"}},\"\",{\"id\":\"17\",\"order\":\"2\",\"container\":\"br\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"19\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"15\",\"20\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"transition\":\"fade\",\"transition-type\":\"\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"margin-unit\":\"px\",\"show-on-lightbox-video\":\"\",\"source-text\":\"<i class=\\\"eg-icon-star-empty\\\"><\\/i> %favorites%\"}},{\"id\":\"19\",\"order\":\"3\",\"container\":\"br\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-function\":\"link\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"source-text-style-disable\":\"\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"19\",\"color\":\"rgba(255,255,255,0.5)\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"15\",\"20\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"transition\":\"fade\",\"transition-type\":\"\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"link-target\":\"_self\",\"tag-type\":\"div\",\"force-important\":\"true\",\"facebook-sharing-link\":\"site\",\"facebook-link-url\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"show-on-lightbox-video\":\"\",\"source-text\":\"by %author_name%\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("46", "FacebookStream", "facebookstream", "{\"eg-item-skin-element-last-id\":\"33\",\"choose-layout\":\"masonry\",\"show-content\":\"top\",\"content-align\":\"left\",\"image-repeat\":\"no-repeat\",\"image-fit\":\"cover\",\"image-align-horizontal\":\"center\",\"image-align-vertical\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(54,88,153,0.65)\",\"0\":\"Default\",\"cover-always-visible-desktop\":\"\",\"cover-always-visible-mobile\":\"\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#e5e5e5\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"30\",\"30\",\"26\",\"30\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"1\",\"10\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"link-set-to\":\"none\",\"link-link-type\":\"none\",\"link-url-link\":\"\",\"link-meta-link\":\"\",\"link-javascript-link\":\"\",\"link-target\":\"_self\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"14\",\"line-height\":\"22\",\"color\":\"#363839\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"20\",\"line-height-hover\":\"25\",\"color-hover\":\"#13c0df\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"800\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_blank\",\"source-text-style-disable\":\"\",\"show-on-lightbox-video\":\"\",\"source-post\":\"title\"}},{\"id\":\"25\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"on\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"3\",\"10\"],\"background-color\":\"rgba(0,0,0,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-size-x\":\"100\",\"background-size-y\":\"100\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"Arial, Helvetica, sans-serif\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(0,0,0,0.50)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"fade\",\"delay\":\"0\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"hide-on-video\":\"true\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"show-on-lightbox-video\":\"\",\"source-text\":\"SHOW IMAGE\"}},{\"id\":\"28\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"on\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"900\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"5\"],\"padding\":[\"5\",\"10\",\"3\",\"10\"],\"background-color\":\"rgba(0,0,0,0.15)\",\"bg-alpha\":\"100\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"Arial, Helvetica, sans-serif\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(0,0,0,0.50)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"transition\":\"fade\",\"transition-type\":\"\",\"delay\":\"0\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"show-on-lightbox-video\":\"true\",\"source-text\":\"PLAY VIDEO\"}},{\"id\":\"3\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"14\",\"line-height\":\"22\",\"color\":\"#365899\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"10\",\"15\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"14\",\"line-height-hover\":\"14\",\"color-hover\":\"#000000\",\"font-family-hover\":\"Arial, Helvetica, sans-serif\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#e5e5e5\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\", \",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"show-on-lightbox-video\":\"\",\"source-text\":\"<i class=\\\"eg-icon-thumbs-up-alt\\\" style=\\\"background:#365899;color:#fff;float:left;width:23px;height:23px;font-size:12px;text-align:center;border-radius:14px;margin-right:5px;\\\"><\\/i> %likes_short%\"}},{\"id\":\"33\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"source-separate\":\", \",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"14\",\"line-height\":\"22\",\"color\":\"#90949c\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"10\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"14\",\"line-height-hover\":\"22\",\"color-hover\":\"#7f7f7f\",\"font-family-hover\":\"Arial, Helvetica, sans-serif\",\"font-weight-hover\":\"900\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"transition\":\"skewleft\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"show-on-lightbox-video\":\"\",\"source-text\":\"<i class=\\\"eg-icon-calendar-empty\\\" style=\\\"background:#90949c;color:#fff;float:left;width:23px;height:23px;font-size:12px;text-align:center;border-radius:14px;margin-right:5px;\\\"><\\/i> %date%\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("47", "YoutubeStream", "youtubestream", "{\"eg-item-skin-element-last-id\":\"35\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"image-repeat\":\"no-repeat\",\"image-fit\":\"cover\",\"image-align-horizontal\":\"center\",\"image-align-vertical\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(0,0,0,0.65)\",\"0\":\"Default\",\"cover-always-visible-desktop\":\"\",\"cover-always-visible-mobile\":\"\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#e5e5e5\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"20\",\"20\",\"20\",\"20\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"1\",\"10\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"link-set-to\":\"cover\",\"link-link-type\":\"lightbox\",\"link-url-link\":\"\",\"link-meta-link\":\"\",\"link-javascript-link\":\"\",\"link-target\":\"_self\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"14\",\"line-height\":\"19\",\"color\":\"#167ac6\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"900\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"14\",\"line-height-hover\":\"19\",\"color-hover\":\"#167ac6\",\"font-family-hover\":\"Arial, Helvetica, sans-serif\",\"font-weight-hover\":\"800\",\"text-decoration-hover\":\"underline\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_blank\",\"source-text-style-disable\":\"\",\"show-on-lightbox-video\":\"\",\"source-post\":\"title\"}},{\"id\":\"25\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"icon\",\"enable-hover\":\"\",\"font-size\":\"60\",\"line-height\":\"60\",\"color\":\"#ffffff\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-size-x\":\"100\",\"background-size-y\":\"100\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"60\",\"line-height-hover\":\"60\",\"color-hover\":\"rgba(255,255,255,0.85)\",\"font-family-hover\":\"Arial, Helvetica, sans-serif\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"zoomback\",\"delay\":\"0\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"hide-on-video\":\"true\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"source-icon\":\"eg-icon-play\"}},{\"id\":\"33\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"source-separate\":\", \",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"limit-type\":\"chars\",\"limit-num\":\"100\",\"enable-hover\":\"\",\"font-size\":\"14\",\"line-height\":\"22\",\"color\":\"#90949c\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"14\",\"line-height-hover\":\"22\",\"color-hover\":\"#7f7f7f\",\"font-family-hover\":\"Arial, Helvetica, sans-serif\",\"font-weight-hover\":\"900\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"transition\":\"skewleft\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"post\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_blank\",\"source-text-style-disable\":\"\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"show-on-lightbox-video\":\"\",\"source-text\":\"%views_short% views\"}},{\"id\":\"34\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"source-separate\":\", \",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-function\":\"link\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"source-text-style-disable\":\"\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"12\",\"color\":\"#90949c\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"5\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"22\",\"color-hover\":\"#e81c4f\",\"font-family-hover\":\"Arial, Helvetica, sans-serif\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#e5e5e5\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"transition\":\"none\",\"transition-type\":\"\",\"delay\":\"34\",\"link-type\":\"post\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"link-target\":\"_blank\",\"tag-type\":\"div\",\"force-important\":\"true\",\"facebook-sharing-link\":\"\",\"facebook-link-url\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"show-on-lightbox-video\":\"\",\"source-text\":\"<i class=\\\"eg-icon-thumbs-up-1\\\"><\\/i>%likes_short%\"}},{\"id\":\"35\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"source-separate\":\", \",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"source-function\":\"link\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"source-text-style-disable\":\"\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"12\",\"color\":\"#90949c\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"5\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"22\",\"color-hover\":\"#e81c4f\",\"font-family-hover\":\"Arial, Helvetica, sans-serif\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#e5e5e5\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"transition\":\"none\",\"transition-type\":\"\",\"delay\":\"34\",\"link-type\":\"post\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"link-target\":\"_blank\",\"tag-type\":\"div\",\"force-important\":\"true\",\"facebook-sharing-link\":\"site\",\"facebook-link-url\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"show-on-lightbox-video\":\"\",\"source-text\":\"<i class=\\\"eg-icon-thumbs-down\\\"><\\/i>%dislikes_short%\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("48", "TwitterStream", "twitterstream", "{\"eg-item-skin-element-last-id\":\"38\",\"choose-layout\":\"masonry\",\"show-content\":\"top\",\"content-align\":\"left\",\"image-repeat\":\"no-repeat\",\"image-fit\":\"cover\",\"image-align-horizontal\":\"center\",\"image-align-vertical\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(41,47,51,0.20)\",\"0\":\"Default\",\"cover-always-visible-desktop\":\"\",\"cover-always-visible-mobile\":\"\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"30\",\"30\",\"30\",\"30\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#e5e5e5\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"20\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"1\",\"10\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"zoomtodefault\",\"media-animation-delay\":\"0\",\"link-set-to\":\"none\",\"link-link-type\":\"none\",\"link-url-link\":\"\",\"link-meta-link\":\"\",\"link-javascript-link\":\"\",\"link-target\":\"_self\"}", "[{\"id\":\"25\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"30\",\"line-height\":\"30\",\"color\":\"#ffffff\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-size-x\":\"100\",\"background-size-y\":\"100\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"30\",\"line-height-hover\":\"30\",\"color-hover\":\"rgba(255,255,255,0.85)\",\"font-family-hover\":\"Arial, Helvetica, sans-serif\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"fade\",\"delay\":\"0\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"hide-on-video\":\"true\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"show-on-lightbox-video\":\"\",\"source-icon\":\"eg-icon-search\"}},{\"id\":\"37\",\"order\":\"0\",\"container\":\"br\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"source-separate\":\", \",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-function\":\"link\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"source-text-style-disable\":\"\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"10\",\"15\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"22\",\"color-hover\":\"#e81c4f\",\"font-family-hover\":\"Arial, Helvetica, sans-serif\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#e5e5e5\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"transition\":\"slideshortup\",\"transition-type\":\"\",\"delay\":\"0\",\"link-type\":\"post\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"link-target\":\"_blank\",\"tag-type\":\"div\",\"force-important\":\"true\",\"facebook-sharing-link\":\"\",\"facebook-link-url\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"show-on-lightbox-video\":\"\",\"source-text\":\"@%author_name%\"}},{\"id\":\"35\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"limit-type\":\"none\",\"limit-num\":\"40\",\"enable-hover\":\"on\",\"font-size\":\"26\",\"line-height\":\"32\",\"color\":\"#292f33\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"10\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"26\",\"line-height-hover\":\"32\",\"color-hover\":\"#0084b4\",\"font-family-hover\":\"Arial, Helvetica, sans-serif\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"underline\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"transition\":\"none\",\"transition-type\":\"\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_blank\",\"source-text-style-disable\":\"\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"show-on-lightbox-video\":\"\",\"source-post\":\"title\"}},{\"settings\":\"\"},{\"id\":\"33\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"source-separate\":\", \",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"on\",\"font-size\":\"13\",\"line-height\":\"22\",\"color\":\"#aab8c2\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"15\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"22\",\"color-hover\":\"#19cf68\",\"font-family-hover\":\"Arial, Helvetica, sans-serif\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"transition\":\"skewleft\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"sharetwitter\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-text\":\"<i class=\\\"eg-icon-shuffle-1\\\"><\\/i> %retweets%\"}},{\"id\":\"36\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-function\":\"link\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"source-text-style-disable\":\"\",\"enable-hover\":\"on\",\"font-size\":\"30\",\"line-height\":\"30\",\"color\":\"#ffffff\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"30\",\"line-height-hover\":\"30\",\"color-hover\":\"rgba(255,255,255,0.85)\",\"font-family-hover\":\"Arial, Helvetica, sans-serif\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"transition\":\"fade\",\"transition-type\":\"\",\"delay\":\"0\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"link-target\":\"_self\",\"tag-type\":\"div\",\"force-important\":\"true\",\"facebook-sharing-link\":\"\",\"facebook-link-url\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"show-on-lightbox-video\":\"true\",\"source-icon\":\"eg-icon-play\"}},{\"id\":\"3\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"on\",\"font-size\":\"13\",\"line-height\":\"22\",\"color\":\"#aab8c2\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"15\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"22\",\"color-hover\":\"#e81c4f\",\"font-family-hover\":\"Arial, Helvetica, sans-serif\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#e5e5e5\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\", \",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_blank\",\"source-text-style-disable\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-text\":\"<i class=\\\"eg-icon-heart\\\"><\\/i> %likes%\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("49", "VimeoStream", "vimeostream", "{\"eg-item-skin-element-last-id\":\"34\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(0,0,0,0.65)\",\"0\":\"Default\",\"cover-always-visible-desktop\":\"\",\"cover-always-visible-mobile\":\"\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#e5e5e5\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"20\",\"20\",\"20\",\"20\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"1\",\"10\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"link-set-to\":\"none\",\"link-link-type\":\"lightbox\",\"link-url-link\":\"\",\"link-meta-link\":\"\",\"link-javascript-link\":\"\",\"link-target\":\"_self\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"24\",\"line-height\":\"28\",\"color\":\"#ffffff\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"900\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"10\",\"0\",\"10\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"24\",\"line-height-hover\":\"28\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"Arial, Helvetica, sans-serif\",\"font-weight-hover\":\"900\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"fade\",\"delay\":\"0\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_blank\",\"source-text-style-disable\":\"\",\"source-post\":\"title\"}},{\"id\":\"34\",\"order\":\"0\",\"container\":\"br\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"limit-type\":\"none\",\"limit-num\":\"3\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"12\",\"color\":\"rgba(255,255,255,0.5)\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"10\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"transition\":\"slideshortup\",\"transition-type\":\"\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"margin-unit\":\"px\",\"source-text\":\"%duration%\"}},{\"id\":\"33\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"source-separate\":\", \",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"limit-type\":\"chars\",\"limit-num\":\"100\",\"enable-hover\":\"\",\"font-size\":\"18\",\"line-height\":\"22\",\"color\":\"#99aabc\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"10\",\"0\",\"10\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"18\",\"line-height-hover\":\"22\",\"color-hover\":\"#99aabc\",\"font-family-hover\":\"Arial, Helvetica, sans-serif\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"transition\":\"fade\",\"transition-type\":\"\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_blank\",\"source-text-style-disable\":\"\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-text\":\"by %author_name%\"}},{\"id\":\"25\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"on\",\"font-size\":\"14\",\"line-height\":\"40\",\"color\":\"#44bbff\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"10\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"30\",\"0\",\"30\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-size-x\":\"100\",\"background-size-y\":\"100\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"4\",\"4\",\"4\",\"4\"],\"border-radius-unit\":\"px\",\"border-color\":\"#44bbff\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"14\",\"line-height-hover\":\"40\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"Arial, Helvetica, sans-serif\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"4\",\"4\",\"4\",\"4\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"fade\",\"delay\":\"0\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"hide-on-video\":\"true\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"source-text\":\"Play Video\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("50", "InstagramStream", "instagramstream", "{\"eg-item-skin-element-last-id\":\"37\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"left\",\"image-repeat\":\"no-repeat\",\"image-fit\":\"cover\",\"image-align-horizontal\":\"center\",\"image-align-vertical\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(0,0,0,0.50)\",\"0\":\"Default\",\"cover-always-visible-desktop\":\"\",\"cover-always-visible-mobile\":\"\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#e5e5e5\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"20\",\"20\",\"20\",\"20\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"1\",\"10\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"link-set-to\":\"cover\",\"link-link-type\":\"lightbox\",\"link-url-link\":\"\",\"link-meta-link\":\"\",\"link-javascript-link\":\"\",\"link-target\":\"_self\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"16\",\"color\":\"#ffffff\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"900\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"5\",\"0\",\"5\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"24\",\"line-height-hover\":\"28\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"Arial, Helvetica, sans-serif\",\"font-weight-hover\":\"900\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"fade\",\"delay\":\"0\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"false\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"show-on-lightbox-video\":\"hide\",\"source-text\":\"<i class=\\\"eg-icon-heart\\\"><\\/i> %likes_short%\"}},{\"id\":\"35\",\"order\":\"0\",\"container\":\"tl\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"24\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"right\",\"clear\":\"none\",\"margin\":[\"10\",\"7\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"24\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"hide-on-video\":\"false\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"transition\":\"none\",\"transition-type\":\"\",\"delay\":\"0\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"adv-rules\":{\"ar-show\":\"show\",\"ar-type\":[\"off\",\"off\",\"off\",\"off\",\"off\",\"off\",\"off\",\"off\",\"off\"],\"ar-meta\":[\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\"],\"ar-operator\":[\"isset\",\"isset\",\"isset\",\"isset\",\"isset\",\"isset\",\"isset\",\"isset\",\"isset\"],\"ar-value\":[\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\"],\"ar-value-2\":[\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\"],\"ar-logic\":[\"and\",\"and\",\"and\",\"and\",\"and\",\"and\"],\"ar-logic-glob\":[\"and\",\"and\"]},\"show-on-lightbox-video\":\"true\",\"source-icon\":\"eg-icon-videocam\"}},{\"id\":\"37\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"16\",\"color\":\"#ffffff\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"900\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"5\",\"0\",\"5\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"20\",\"line-height-hover\":\"25\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"false\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"transition\":\"fade\",\"transition-type\":\"\",\"delay\":\"0\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"show-on-lightbox-video\":\"true\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"margin-unit\":\"px\",\"source-text\":\"<i class=\\\"eg-icon-play\\\"><\\/i> %likes_short%\"}},{\"id\":\"36\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"16\",\"color\":\"#ffffff\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"900\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"5\",\"0\",\"5\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"17\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"false\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"transition\":\"fade\",\"transition-type\":\"\",\"delay\":\"0\",\"link-type\":\"post\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_blank\",\"source-text-style-disable\":\"\",\"margin-unit\":\"px\",\"show-on-lightbox-video\":\"false\",\"source-text\":\"<i class=\\\"eg-icon-align-left\\\"><\\/i> %num_comments%\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("51", "Washington-120943", "washington-120943", "{\"eg-item-skin-element-last-id\":\"9\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"image-repeat\":\"no-repeat\",\"image-fit\":\"cover\",\"image-align-horizontal\":\"center\",\"image-align-vertical\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"splitted-item\":\"none\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(0,0,0,0.65)\",\"cover-always-visible-desktop\":\"false\",\"cover-always-visible-mobile\":\"false\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#3f424a\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"element-hover-image\":\"false\",\"hover-image-animation\":\"fade\",\"hover-image-animation-delay\":\"0\",\"link-set-to\":\"none\",\"link-link-type\":\"none\",\"link-url-link\":\"\",\"link-meta-link\":\"\",\"link-javascript-link\":\"\",\"link-target\":\"_self\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"5\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"17\",\"1\":\"17\",\"2\":\"17\",\"3\":\"17\"},\"background-color\":\"rgba(255,255,255,0.15)\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.50)\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"falldown\",\"delay\":\"10\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"css\":\"\",\"css-hover\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"false\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"show-on-lightbox-video\":\"false\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"source-icon\":\"eg-icon-search\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"5\"},\"padding\":{\"0\":\"17\",\"1\":\"17\",\"2\":\"17\",\"3\":\"17\"},\"background-color\":\"rgba(255,255,255,0.15)\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.50)\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"60\",\"1\":\"60\",\"2\":\"60\",\"3\":\"60\"},\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"falldown\",\"delay\":\"20\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"css\":\"\",\"css-hover\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"false\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"show-on-lightbox-video\":\"false\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"source-icon\":\"eg-icon-link\"}},{\"id\":\"8\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"3\",\"order\":\"4\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"10\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"9\",\"order\":\"5\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("52", "Adams-120943", "adams-120943", "{\"eg-item-skin-element-last-id\":\"8\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(137,175,114,1)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"transparent\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"10\",\"cover-animation-center\":\"flipleft\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"turnout\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"delay\":\"10\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"css\":\".eg-adams-element-0{}\",\"css-hover\":\".eg-adams-element-0{}\",\"transition-type\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"delay\":\"20\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"3\",\"order\":\"4\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"css\":\".eg-adams-element-3{}\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\".eg-adams-element-3{}\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"5\",\"order\":\"7\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\".eg-adams-element-5{}\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\".eg-adams-element-5{}\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"words\",\"limit-num\":\"6\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"source-post\":\"excerpt\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"7\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"8\",\"order\":\"5\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("53", "Jefferson-120943", "jefferson-120943", "{\"eg-item-skin-element-last-id\":\"8\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(227,58,12,1)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fliphorizontal\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"fliphorizontalout\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#e33a0c\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"46\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#e33a0c\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slidedown\",\"delay\":\"50\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"3\",\"order\":\"3\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"17\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"10\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"17\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"60\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"5\",\"order\":\"6\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"1\",\"5\",\"1\",\"5\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"3\",\"3\",\"3\",\"3\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"12\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"3\",\"3\",\"3\",\"3\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"70\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\"   \",\"limit-type\":\"words\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-post\":\"cat_list\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"7\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"8\",\"order\":\"4\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("54", "Madison-120943", "madison-120943", "{\"eg-item-skin-element-last-id\":\"7\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(88,92,103,1)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#585c67\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"flipvertical\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"flipverticalout\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"19\",\"19\",\"19\",\"19\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.25)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"50\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"19\",\"19\",\"19\",\"19\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.25)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"35\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"3\",\"order\":\"4\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"35\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"5\",\"order\":\"7\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slidedown\",\"delay\":\"45\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"words\",\"limit-num\":\"6\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"excerpt\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"6\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"7\",\"order\":\"5\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("55", "Monroe-120943", "monroe-120943", "{\"eg-item-skin-element-last-id\":\"8\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(10,10,10,0.50)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"out\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"none\",\"cover-animation-center-type\":\"out\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"out\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"none\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"br\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"enable-hover\":\"on\",\"font-size\":\"13\",\"line-height\":\"30\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"30\",\"0\"],\"padding\":[\"3\",\"15\",\"2\",\"15\"],\"background-color\":\"rgba(137,175,114,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"transparent\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"3\",\"0\"],\"border-radius\":[\"3\",\"3\",\"3\",\"3\"],\"border-radius-unit\":\"px\",\"border-color\":\"#617f52\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"30\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"800\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(155,193,132,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"transparent\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"3\",\"0\"],\"border-radius-hover\":[\"3\",\"3\",\"3\",\"3\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#617f52\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"0\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-text\":\"Read More\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"24\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"900\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"4\",\"12\",\"3\",\"12\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"transparent\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.20)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flipdown\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"out\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"8\",\"order\":\"0\",\"container\":\"tl\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"17\",\"line-height\":\"24\",\"color\":\"#000000\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"30\",\"0\",\"0\",\"0\"],\"padding\":[\"3\",\"12\",\"4\",\"12\"],\"background-color\":\"rgba(255,255,255,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"transparent\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.20)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slidedown\",\"transition-type\":\"\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"date\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("56", "Quincy-120943", "quincy-120943", "{\"eg-item-skin-element-last-id\":\"6\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(45,48,57,0.75)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#2d3039\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"pressback\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"24\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"10\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"24\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"30\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"24\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"10\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"24\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"10\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"3\",\"order\":\"4\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"10\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"5\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"6\",\"order\":\"5\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("57", "Jackson-120943", "jackson-120943", "{\"eg-item-skin-element-last-id\":\"7\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(255,255,255,1)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#eeeeee\",\"full-padding\":[\"5\",\"5\",\"5\",\"5\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"zoomback\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(245,245,245,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(238,238,238,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"zoomback\",\"delay\":\"5\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\".eg-jackson-element-0{}\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\".eg-jackson-element-0{}\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(245,245,245,1)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(238,238,238,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"zoomback\",\"delay\":\"10\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"3\",\"order\":\"4\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"18\",\"line-height\":\"20\",\"color\":\"#000000\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"18\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"skewright\",\"delay\":\"15\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"5\",\"order\":\"7\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"20\",\"color\":\"#888888\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"12\",\"line-height-hover\":\"20\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"skewleft\",\"delay\":\"10\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\", \",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-post\":\"cat_list\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"6\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"7\",\"order\":\"5\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("58", "VanBuren-120943", "vanburen-120943", "{\"eg-item-skin-element-last-id\":\"3\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(10,6,6,0.85)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#363839\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"flipup\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"17\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"20\",\"0\",\"20\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flyleft\",\"delay\":\"5\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"2\",\"order\":\"3\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flyright\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"source-post\":\"date\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"3\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("59", "HenryHarrison-120943", "henryharrison-120943", "{\"eg-item-skin-element-last-id\":\"5\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(49,165,203,0.85)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"1\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"30\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"900\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"10\",\"0\"],\"padding\":[\"0\",\"20\",\"0\",\"20\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"transparent\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"5\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"2\",\"order\":\"3\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"20\",\"line-height\":\"27\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"0\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"20\",\"line-height-hover\":\"27\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"normal\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"0\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"rotatescale\",\"delay\":\"5\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-plus\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"5\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("60", "Tyler-120943", "tyler-120943", "{\"eg-item-skin-element-last-id\":\"8\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(54,56,57,0.85)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"falldown\",\"delay\":\"20\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"falldown\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-unlink\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"3\",\"order\":\"4\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"10\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"title\",\"transition-type\":\"\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},\"\",{\"id\":\"5\",\"order\":\"7\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"excerpt\",\"transition-type\":\"\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"7\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"8\",\"order\":\"5\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("61", "Polk-120943", "polk-120943", "{\"eg-item-skin-element-last-id\":\"6\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(54,56,57,0.85)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.95)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"rotatescale\",\"delay\":\"20\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"rotatescale\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-icon\":\"eg-icon-unlink\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"3\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"19\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"10\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flipdown\",\"delay\":\"46\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"title\",\"transition-type\":\"\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"3\",\"order\":\"5\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flipdown\",\"delay\":\"57\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"excerpt\",\"transition-type\":\"\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("62", "Taylor-120944", "taylor-120944", "{\"eg-item-skin-element-last-id\":\"6\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(54,56,57,0.85)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"flipdown\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"0\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"0\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-icon\":\"eg-icon-unlink\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"19\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"20\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"title\",\"transition-type\":\"\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"3\",\"order\":\"3\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"excerpt\",\"transition-type\":\"\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("63", "Fillmore-120944", "fillmore-120944", "{\"eg-item-skin-element-last-id\":\"7\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(54,56,57,0.85)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#363839\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"fade\",\"delay\":\"0\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\".eg-fillmore-element-0{cursor:pointer}\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\".eg-fillmore-element-0{cursor:pointer}\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"br\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slidedown\",\"delay\":\"13\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"transition-type\":\"out\",\"tag-type\":\"div\",\"align\":\"c_c\",\"margin-unit\":\"px\",\"source-post\":\"date\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"2\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#363839\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"fade\",\"delay\":\"0\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\".eg-fillmore-element-1{ cursor:pointer}\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\".eg-fillmore-element-1{cursor:pointer}\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"source-icon\":\"eg-icon-unlink\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"3\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"19\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"20\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"fade\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"title\",\"transition-type\":\"\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"4\",\"order\":\"3\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"fade\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"excerpt\",\"transition-type\":\"\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("64", "Pierce-120944", "pierce-120944", "{\"eg-item-skin-element-last-id\":\"6\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(54,56,57,0.85)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"none\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"zoomback\",\"delay\":\"20\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\".eg-pierce-element-0{}\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\".eg-pierce-element-0{}\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\".eg-pierce-element-1{}\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\".eg-pierce-element-1{}\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-icon\":\"eg-icon-unlink\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"19\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"20\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"falldown\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"title\",\"transition-type\":\"\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"3\",\"order\":\"3\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"source-post\":\"excerpt\",\"tag-type\":\"div\",\"align\":\"c_c\",\"css-hover\":\"\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("65", "Buchanan-120944", "buchanan-120944", "{\"eg-item-skin-element-last-id\":\"6\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(54,56,57,0.85)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"slidedown\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"rollright\",\"delay\":\"20\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"rollleft\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-icon\":\"eg-icon-link\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"19\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"20\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slidedown\",\"delay\":\"21\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"title\",\"transition-type\":\"\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}},{\"id\":\"3\",\"order\":\"3\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"40\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"excerpt\",\"transition-type\":\"\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-catmax\":\"-1\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("66", "Lincoln-120944", "lincoln-120944", "{\"eg-item-skin-element-last-id\":\"14\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(54,56,57,0.85)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"10\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"turnout\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"10\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"br\",\"settings\":{\"0\":\"\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"1\",\"0\",\"0\"],\"padding\":[\"13\",\"13\",\"13\",\"13\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.25)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"rollleft\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-icon\":\"eg-icon-link\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"1\",\"container\":\"br\",\"settings\":{\"0\":\"\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"1\",\"0\",\"0\"],\"padding\":[\"13\",\"13\",\"13\",\"13\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.25)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"rollleft\",\"delay\":\"30\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-icon\":\"eg-icon-link-ext\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"3\",\"order\":\"2\",\"container\":\"br\",\"settings\":{\"0\":\"\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"13\",\"13\",\"13\",\"13\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.25)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"rollleft\",\"delay\":\"30\",\"link-type\":\"url\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-icon\":\"eg-icon-mail\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("67", "Johnson-120944", "johnson-120944", "{\"eg-item-skin-element-last-id\":\"12\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(0,142,133,0.85)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"10\",\"cover-animation-center\":\"covergrowup\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"40\",\"0\",\"40\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"10\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"css\":\".eg-johnson-element-0{}\",\"css-hover\":\".eg-johnson-element-0{}\",\"tag-type\":\"div\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"br\",\"settings\":{\"0\":\"\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"di