<?php
/**
 * The template to display blog archive
 *
 * @package WordPress
 * @subpackage WEALTHCO
 * @since WEALTHCO 1.0
 */

/*
Template Name: Blog archive
*/

/**
 * Make page with this template and put it into menu
 * to display posts as blog archive
 * You can setup output parameters (blog style, posts per page, parent category, etc.)
 * in the Theme Options section (under the page content)
 * You can build this page in the WordPress editor or any Page Builder to make custom page layout:
 * just insert %%CONTENT%% in the desired place of content
 */

// Get template page's content
$wealthco_content            = '';
$wealthco_blog_archive_mask  = '%%CONTENT%%';
$wealthco_blog_archive_subst = sprintf( '<div class="blog_archive">%s</div>', $wealthco_blog_archive_mask );
if ( have_posts() ) {
	the_post();
	if ( ( $wealthco_content = apply_filters( 'the_content', get_the_content() ) ) != '' ) {
		if ( ( $wealthco_pos = strpos( $wealthco_content, $wealthco_blog_archive_mask ) ) !== false ) {
			$wealthco_content = preg_replace( '/(\<p\>\s*)?' . $wealthco_blog_archive_mask . '(\s*\<\/p\>)/i', $wealthco_blog_archive_subst, $wealthco_content );
		} else {
			$wealthco_content .= $wealthco_blog_archive_subst;
		}
		$wealthco_content = explode( $wealthco_blog_archive_mask, $wealthco_content );
		// Add VC custom styles to the inline CSS
		$vc_custom_css = get_post_meta( get_the_ID(), '_wpb_shortcodes_custom_css', true );
		if ( ! empty( $vc_custom_css ) ) {
			wealthco_add_inline_css( strip_tags( $vc_custom_css ) );
		}
	}
}

// Prepare args for a new query
$wealthco_args        = array(
	'post_status' => current_user_can( 'read_private_pages' ) && current_user_can( 'read_private_posts' ) ? array( 'publish', 'private' ) : 'publish',
);
$wealthco_args        = wealthco_query_add_posts_and_cats( $wealthco_args, '', wealthco_get_theme_option( 'post_type' ), wealthco_get_theme_option( 'parent_cat' ) );
$wealthco_page_number = get_query_var( 'paged' ) ? get_query_var( 'paged' ) : ( get_query_var( 'page' ) ? get_query_var( 'page' ) : 1 );
if ( $wealthco_page_number > 1 ) {
	$wealthco_args['paged']               = $wealthco_page_number;
	$wealthco_args['ignore_sticky_posts'] = true;
}
$wealthco_ppp = wealthco_get_theme_option( 'posts_per_page' );
if ( (int) $wealthco_ppp != 0 ) {
	$wealthco_args['posts_per_page'] = (int) $wealthco_ppp;
}
// Make a new main query
$GLOBALS['wp_the_query']->query( $wealthco_args );


// Add internal query vars in the new query!
if ( is_array( $wealthco_content ) && count( $wealthco_content ) == 2 ) {
	set_query_var( 'blog_archive_start', $wealthco_content[0] );
	set_query_var( 'blog_archive_end', $wealthco_content[1] );
}

get_template_part( 'index' );

