<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage WEALTHCO
 * @since WEALTHCO 1.0
 */

$wealthco_blog_style  = explode( '_', wealthco_get_theme_option( 'blog_style' ) );
$wealthco_columns     = empty( $wealthco_blog_style[1] ) ? 2 : max( 2, $wealthco_blog_style[1] );
$wealthco_expanded    = ! wealthco_sidebar_present() && wealthco_is_on( wealthco_get_theme_option( 'expand_content' ) );
$wealthco_post_format = get_post_format();
$wealthco_post_format = empty( $wealthco_post_format ) ? 'standard' : str_replace( 'post-format-', '', $wealthco_post_format );
$wealthco_animation   = wealthco_get_theme_option( 'blog_animation' );
$wealthco_components  = wealthco_array_get_keys_by_value( wealthco_get_theme_option( 'meta_parts' ) );
$wealthco_counters    = wealthco_array_get_keys_by_value( wealthco_get_theme_option( 'counters' ) );

?><div class="<?php echo 'classic' == $wealthco_blog_style[0] ? 'column' : 'masonry_item masonry_item'; ?>-1_<?php echo esc_attr( $wealthco_columns ); ?>"><article id="post-<?php the_ID(); ?>" 
	<?php
	post_class(
		'post_item post_format_' . esc_attr( $wealthco_post_format )
					. ' post_layout_classic post_layout_classic_' . esc_attr( $wealthco_columns )
					. ' post_layout_' . esc_attr( $wealthco_blog_style[0] )
					. ' post_layout_' . esc_attr( $wealthco_blog_style[0] ) . '_' . esc_attr( $wealthco_columns )
	);
	?>
	<?php echo ( ! wealthco_is_off( $wealthco_animation ) ? ' data-animation="' . esc_attr( wealthco_get_animation_classes( $wealthco_animation ) ) . '"' : '' ); ?>>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	wealthco_show_post_featured(
		array(
			'thumb_size' => wealthco_get_thumb_size(
				$wealthco_blog_style[0] == 'classic' ? ( strpos( wealthco_get_theme_option( 'body_style' ), 'full' ) !== false																			 ? ( $wealthco_columns > 2 ? 'big' : 'huge' )
																			 : ( $wealthco_columns > 2
																				 ? ( $wealthco_expanded ? 'med' : 'small' )
																				 : ( $wealthco_expanded ? 'big' : 'med' )
																				 )
																		)
																	: ( strpos( wealthco_get_theme_option( 'body_style' ), 'full' ) !== false
																			? ( $wealthco_columns > 2 ? 'masonry-big' : 'full' )
																			: ( $wealthco_columns <= 2 && $wealthco_expanded ? 'masonry-big' : 'masonry' )
																		 )
			),
		)
	);

	if ( ! in_array( $wealthco_post_format, array( 'link', 'aside', 'status', 'quote' ) ) ) {
		?>
		<div class="post_header entry-header">
			<?php
			do_action( 'wealthco_action_before_post_title' );

			// Post title
			the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );

			do_action( 'wealthco_action_before_post_meta' );

			// Post meta
			if ( ! empty( $wealthco_components ) ) {
				wealthco_show_post_meta(
					apply_filters(
						'wealthco_filter_post_meta_args', array(
							'components' => $wealthco_components,
							'counters'   => $wealthco_counters,
							'seo'        => false,
						), $wealthco_blog_style[0], $wealthco_columns
					)
				);
			}

			do_action( 'wealthco_action_after_post_meta' );
			?>
		</div><!-- .entry-header -->
		<?php
	}
	?>

	<div class="post_content entry-content">
		<div class="post_content_inner">
			<?php
			$wealthco_show_learn_more = false; //!in_array($wealthco_post_format, array('link', 'aside', 'status', 'quote'));
			if ( has_excerpt() ) {
				the_excerpt();
			} elseif ( strpos( get_the_content( '!--more' ), '!--more' ) !== false ) {
				the_content( '' );
			} elseif ( in_array( $wealthco_post_format, array( 'link', 'aside', 'status' ) ) ) {
				the_content();
			} elseif ( $wealthco_post_format == 'quote' ) {
				if ( ( $quote = wealthco_get_tag( get_the_content(), '<blockquote>', '</blockquote>' ) ) != '' ) {
					wealthco_show_layout( wpautop( $quote ) );
				} else {
					the_excerpt();
				}
			} elseif ( substr( get_the_content(), 0, 4 ) != '[vc_' ) {
				the_excerpt();
			}
			?>
		</div>
		<?php
		// Post meta
		if ( in_array( $wealthco_post_format, array( 'link', 'aside', 'status', 'quote' ) ) ) {
			if ( ! empty( $wealthco_components ) ) {
				wealthco_show_post_meta(
					apply_filters(
						'wealthco_filter_post_meta_args', array(
							'components' => $wealthco_components,
							'counters'   => $wealthco_counters,
						), $wealthco_blog_style[0], $wealthco_columns
					)
				);
			}
		}
		// More button
		if ( $wealthco_show_learn_more ) {
			?>
			<p><a class="more-link" href="<?php echo esc_url( get_permalink() ); ?>"><?php esc_html_e( 'Read more', 'wealthco' ); ?></a></p>
			<?php
		}
		?>
	</div><!-- .entry-content -->

</article></div>
