<?php
/**
 * The Gallery template to display posts
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage WEALTHCO
 * @since WEALTHCO 1.0
 */

$wealthco_blog_style  = explode( '_', wealthco_get_theme_option( 'blog_style' ) );
$wealthco_columns     = empty( $wealthco_blog_style[1] ) ? 2 : max( 2, $wealthco_blog_style[1] );
$wealthco_post_format = get_post_format();
$wealthco_post_format = empty( $wealthco_post_format ) ? 'standard' : str_replace( 'post-format-', '', $wealthco_post_format );
$wealthco_animation   = wealthco_get_theme_option( 'blog_animation' );
$wealthco_image       = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'full' );

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_portfolio post_layout_gallery post_layout_gallery_' . esc_attr( $wealthco_columns ) . ' post_format_' . esc_attr( $wealthco_post_format ) ); ?>
	<?php echo ( ! wealthco_is_off( $wealthco_animation ) ? ' data-animation="' . esc_attr( wealthco_get_animation_classes( $wealthco_animation ) ) . '"' : '' ); ?>
	data-size="
	<?php
	if ( ! empty( $wealthco_image[1] ) && ! empty( $wealthco_image[2] ) ) {
		echo intval( $wealthco_image[1] ) . 'x' . intval( $wealthco_image[2] );}
	?>
	"
	data-src="
	<?php
	if ( ! empty( $wealthco_image[0] ) ) {
		echo esc_url( $wealthco_image[0] );}
	?>
	"
	>

	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$wealthco_image_hover = 'icon'; //wealthco_get_theme_option('image_hover');
	if ( in_array( $wealthco_image_hover, array( 'icons', 'zoom' ) ) ) {
		$wealthco_image_hover = 'dots';
	}
	$wealthco_components = wealthco_array_get_keys_by_value( wealthco_get_theme_option( 'meta_parts' ) );
	$wealthco_counters   = wealthco_array_get_keys_by_value( wealthco_get_theme_option( 'counters' ) );
	wealthco_show_post_featured(
		array(
			'hover'         => $wealthco_image_hover,
			'thumb_size'    => wealthco_get_thumb_size( strpos( wealthco_get_theme_option( 'body_style' ), 'full' ) !== false || $wealthco_columns < 3 ? 'masonry-big' : 'masonry' ),
			'thumb_only'    => true,
			'show_no_image' => true,
			'post_info'     => '<div class="post_details">'
							. '<h2 class="post_title"><a href="' . esc_url( get_permalink() ) . '">' . esc_html( get_the_title() ) . '</a></h2>'
							. '<div class="post_description">'
								. ( ! empty( $wealthco_components )
										? wealthco_show_post_meta(
											apply_filters(
												'wealthco_filter_post_meta_args', array(
													'components' => $wealthco_components,
													'counters' => $wealthco_counters,
													'seo'  => false,
													'echo' => false,
												), $wealthco_blog_style[0], $wealthco_columns
											)
										)
										: '' )
								. '<div class="post_description_content">'
									. get_the_excerpt()
								. '</div>'
								. '<a href="' . esc_url( get_permalink() ) . '" class="theme_button post_readmore"><span class="post_readmore_label">' . esc_html__( 'Learn more', 'wealthco' ) . '</span></a>'
							. '</div>'
						. '</div>',
		)
	);
	?>
</article>
