<?php
/**
 * The Sticky template to display the sticky posts
 *
 * Used for index/archive
 *
 * @package WordPress
 * @subpackage WEALTHCO
 * @since WEALTHCO 1.0
 */

$wealthco_columns     = max( 1, min( 3, count( get_option( 'sticky_posts' ) ) ) );
$wealthco_post_format = get_post_format();
$wealthco_post_format = empty( $wealthco_post_format ) ? 'standard' : str_replace( 'post-format-', '', $wealthco_post_format );
$wealthco_animation   = wealthco_get_theme_option( 'blog_animation' );

?><div class="column-1_<?php echo esc_attr( $wealthco_columns ); ?>"><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_sticky post_format_' . esc_attr( $wealthco_post_format ) ); ?>
	<?php echo ( ! wealthco_is_off( $wealthco_animation ) ? ' data-animation="' . esc_attr( wealthco_get_animation_classes( $wealthco_animation ) ) . '"' : '' ); ?>
	>

	<?php
	if ( is_sticky() && is_home() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	wealthco_show_post_featured(
		array(
			'thumb_size' => wealthco_get_thumb_size( $wealthco_columns == 1 ? 'big' : ( $wealthco_columns == 2 ? 'med' : 'avatar' ) ),
		)
	);

	if ( ! in_array( $wealthco_post_format, array( 'link', 'aside', 'status', 'quote' ) ) ) {
		?>
		<div class="post_header entry-header">
			<?php
			// Post title
			the_title( sprintf( '<h6 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h6>' );
			// Post meta
			wealthco_show_post_meta( apply_filters( 'wealthco_filter_post_meta_args', array(), 'sticky', $wealthco_columns ) );
			?>
		</div><!-- .entry-header -->
		<?php
	}
	?>
</article></div>
