<?php
if ( ( $wealthco_slider_sc = wealthco_get_theme_option( 'front_page_title_shortcode' ) ) != '' && strpos( $wealthco_slider_sc, '[' ) !== false && strpos( $wealthco_slider_sc, ']' ) !== false ) {

	?><div class="front_page_section front_page_section_title front_page_section_slider front_page_section_title_slider">
	<?php
		// Add anchor
		$wealthco_anchor_icon = wealthco_get_theme_option( 'front_page_title_anchor_icon' );
		$wealthco_anchor_text = wealthco_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $wealthco_anchor_icon ) || ! empty( $wealthco_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $wealthco_anchor_icon ) ? ' icon="' . esc_attr( $wealthco_anchor_icon ) . '"' : '' )
									. ( ! empty( $wealthco_anchor_text ) ? ' title="' . esc_attr( $wealthco_anchor_text ) . '"' : '' )
									. ']'
		);
	}
		// Show slider (or any other content, generated by shortcode)
		echo do_shortcode( $wealthco_slider_sc );
	?>
	</div>
	<?php

} else {

	?>
	<div class="front_page_section front_page_section_title
	<?php
				$wealthco_scheme = wealthco_get_theme_option( 'front_page_title_scheme' );
	if ( ! wealthco_is_inherit( $wealthco_scheme ) ) {
		echo ' scheme_' . esc_attr( $wealthco_scheme );
	}
				echo ' front_page_section_paddings_' . esc_attr( wealthco_get_theme_option( 'front_page_title_paddings' ) );
	?>
			"
			<?php
			$wealthco_css      = '';
			$wealthco_bg_image = wealthco_get_theme_option( 'front_page_title_bg_image' );
			if ( ! empty( $wealthco_bg_image ) ) {
				$wealthco_css .= 'background-image: url(' . esc_url( wealthco_get_attachment_url( $wealthco_bg_image ) ) . ');';
			}
			if ( ! empty( $wealthco_css ) ) {
				echo ' style="' . esc_attr( $wealthco_css ) . '"';
			}
			?>
	>
	<?php
		// Add anchor
		$wealthco_anchor_icon = wealthco_get_theme_option( 'front_page_title_anchor_icon' );
		$wealthco_anchor_text = wealthco_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $wealthco_anchor_icon ) || ! empty( $wealthco_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $wealthco_anchor_icon ) ? ' icon="' . esc_attr( $wealthco_anchor_icon ) . '"' : '' )
									. ( ! empty( $wealthco_anchor_text ) ? ' title="' . esc_attr( $wealthco_anchor_text ) . '"' : '' )
									. ']'
		);
	}
	?>
		<div class="front_page_section_inner front_page_section_title_inner
		<?php
		if ( wealthco_get_theme_option( 'front_page_title_fullheight' ) ) {
			echo ' wealthco-full-height sc_layouts_flex sc_layouts_columns_middle';
		}
		?>
			"
			<?php
				$wealthco_css      = '';
				$wealthco_bg_mask  = wealthco_get_theme_option( 'front_page_title_bg_mask' );
				$wealthco_bg_color = wealthco_get_theme_option( 'front_page_title_bg_color' );
			if ( ! empty( $wealthco_bg_color ) && $wealthco_bg_mask > 0 ) {
				$wealthco_css .= 'background-color: ' . esc_attr(
					$wealthco_bg_mask == 1
																	? $wealthco_bg_color
																	: wealthco_hex2rgba( $wealthco_bg_color, $wealthco_bg_mask )
				) . ';';
			}
			if ( ! empty( $wealthco_css ) ) {
				echo ' style="' . esc_attr( $wealthco_css ) . '"';
			}
			?>
		>
			<div class="front_page_section_content_wrap front_page_section_title_content_wrap content_wrap">
				<?php
				// Caption
				$wealthco_caption = wealthco_get_theme_option( 'front_page_title_caption' );
				if ( ! empty( $wealthco_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h1 class="front_page_section_caption front_page_section_title_caption front_page_block_<?php echo ! empty( $wealthco_caption ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses_post( $wealthco_caption ); ?></h1>
					<?php
				}

				// Description (text)
				$wealthco_description = wealthco_get_theme_option( 'front_page_title_description' );
				if ( ! empty( $wealthco_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_title_description front_page_block_<?php echo ! empty( $wealthco_description ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses_post( wpautop( $wealthco_description ) ); ?></div>
					<?php
				}

				// Buttons
				if ( wealthco_get_theme_option( 'front_page_title_button1_link' ) != '' || wealthco_get_theme_option( 'front_page_title_button2_link' ) != '' ) {
					?>
					<div class="front_page_section_buttons front_page_section_title_buttons">
					<?php
						wealthco_show_layout( wealthco_customizer_partial_refresh_front_page_title_button1_link() );
						wealthco_show_layout( wealthco_customizer_partial_refresh_front_page_title_button2_link() );
					?>
					</div>
					<?php
				}
				?>
			</div>
		</div>
	</div>
	<?php
}
