<?php
/**
 * Theme storage manipulations
 *
 * @package WordPress
 * @subpackage WEALTHCO
 * @since WEALTHCO 1.0
 */

// Disable direct call
if ( ! defined( 'ABSPATH' ) ) {
	exit; }

// Get theme variable
if ( ! function_exists( 'wealthco_storage_get' ) ) {
	function wealthco_storage_get( $var_name, $default = '' ) {
		global $WEALTHCO_STORAGE;
		return isset( $WEALTHCO_STORAGE[ $var_name ] ) ? $WEALTHCO_STORAGE[ $var_name ] : $default;
	}
}

// Set theme variable
if ( ! function_exists( 'wealthco_storage_set' ) ) {
	function wealthco_storage_set( $var_name, $value ) {
		global $WEALTHCO_STORAGE;
		$WEALTHCO_STORAGE[ $var_name ] = $value;
	}
}

// Check if theme variable is empty
if ( ! function_exists( 'wealthco_storage_empty' ) ) {
	function wealthco_storage_empty( $var_name, $key = '', $key2 = '' ) {
		global $WEALTHCO_STORAGE;
		if ( ! empty( $key ) && ! empty( $key2 ) ) {
			return empty( $WEALTHCO_STORAGE[ $var_name ][ $key ][ $key2 ] );
		} elseif ( ! empty( $key ) ) {
			return empty( $WEALTHCO_STORAGE[ $var_name ][ $key ] );
		} else {
			return empty( $WEALTHCO_STORAGE[ $var_name ] );
		}
	}
}

// Check if theme variable is set
if ( ! function_exists( 'wealthco_storage_isset' ) ) {
	function wealthco_storage_isset( $var_name, $key = '', $key2 = '' ) {
		global $WEALTHCO_STORAGE;
		if ( ! empty( $key ) && ! empty( $key2 ) ) {
			return isset( $WEALTHCO_STORAGE[ $var_name ][ $key ][ $key2 ] );
		} elseif ( ! empty( $key ) ) {
			return isset( $WEALTHCO_STORAGE[ $var_name ][ $key ] );
		} else {
			return isset( $WEALTHCO_STORAGE[ $var_name ] );
		}
	}
}

// Inc/Dec theme variable with specified value
if ( ! function_exists( 'wealthco_storage_inc' ) ) {
	function wealthco_storage_inc( $var_name, $value = 1 ) {
		global $WEALTHCO_STORAGE;
		if ( empty( $WEALTHCO_STORAGE[ $var_name ] ) ) {
			$WEALTHCO_STORAGE[ $var_name ] = 0;
		}
		$WEALTHCO_STORAGE[ $var_name ] += $value;
	}
}

// Concatenate theme variable with specified value
if ( ! function_exists( 'wealthco_storage_concat' ) ) {
	function wealthco_storage_concat( $var_name, $value ) {
		global $WEALTHCO_STORAGE;
		if ( empty( $WEALTHCO_STORAGE[ $var_name ] ) ) {
			$WEALTHCO_STORAGE[ $var_name ] = '';
		}
		$WEALTHCO_STORAGE[ $var_name ] .= $value;
	}
}

// Get array (one or two dim) element
if ( ! function_exists( 'wealthco_storage_get_array' ) ) {
	function wealthco_storage_get_array( $var_name, $key, $key2 = '', $default = '' ) {
		global $WEALTHCO_STORAGE;
		if ( empty( $key2 ) ) {
			return ! empty( $var_name ) && ! empty( $key ) && isset( $WEALTHCO_STORAGE[ $var_name ][ $key ] ) ? $WEALTHCO_STORAGE[ $var_name ][ $key ] : $default;
		} else {
			return ! empty( $var_name ) && ! empty( $key ) && isset( $WEALTHCO_STORAGE[ $var_name ][ $key ][ $key2 ] ) ? $WEALTHCO_STORAGE[ $var_name ][ $key ][ $key2 ] : $default;
		}
	}
}

// Set array element
if ( ! function_exists( 'wealthco_storage_set_array' ) ) {
	function wealthco_storage_set_array( $var_name, $key, $value ) {
		global $WEALTHCO_STORAGE;
		if ( ! isset( $WEALTHCO_STORAGE[ $var_name ] ) ) {
			$WEALTHCO_STORAGE[ $var_name ] = array();
		}
		if ( $key === '' ) {
			$WEALTHCO_STORAGE[ $var_name ][] = $value;
		} else {
			$WEALTHCO_STORAGE[ $var_name ][ $key ] = $value;
		}
	}
}

// Set two-dim array element
if ( ! function_exists( 'wealthco_storage_set_array2' ) ) {
	function wealthco_storage_set_array2( $var_name, $key, $key2, $value ) {
		global $WEALTHCO_STORAGE;
		if ( ! isset( $WEALTHCO_STORAGE[ $var_name ] ) ) {
			$WEALTHCO_STORAGE[ $var_name ] = array();
		}
		if ( ! isset( $WEALTHCO_STORAGE[ $var_name ][ $key ] ) ) {
			$WEALTHCO_STORAGE[ $var_name ][ $key ] = array();
		}
		if ( $key2 === '' ) {
			$WEALTHCO_STORAGE[ $var_name ][ $key ][] = $value;
		} else {
			$WEALTHCO_STORAGE[ $var_name ][ $key ][ $key2 ] = $value;
		}
	}
}

// Merge array elements
if ( ! function_exists( 'wealthco_storage_merge_array' ) ) {
	function wealthco_storage_merge_array( $var_name, $key, $value ) {
		global $WEALTHCO_STORAGE;
		if ( ! isset( $WEALTHCO_STORAGE[ $var_name ] ) ) {
			$WEALTHCO_STORAGE[ $var_name ] = array();
		}
		if ( $key === '' ) {
			$WEALTHCO_STORAGE[ $var_name ] = array_merge( $WEALTHCO_STORAGE[ $var_name ], $value );
		} else {
			$WEALTHCO_STORAGE[ $var_name ][ $key ] = array_merge( $WEALTHCO_STORAGE[ $var_name ][ $key ], $value );
		}
	}
}

// Add array element after the key
if ( ! function_exists( 'wealthco_storage_set_array_after' ) ) {
	function wealthco_storage_set_array_after( $var_name, $after, $key, $value = '' ) {
		global $WEALTHCO_STORAGE;
		if ( ! isset( $WEALTHCO_STORAGE[ $var_name ] ) ) {
			$WEALTHCO_STORAGE[ $var_name ] = array();
		}
		if ( is_array( $key ) ) {
			wealthco_array_insert_after( $WEALTHCO_STORAGE[ $var_name ], $after, $key );
		} else {
			wealthco_array_insert_after( $WEALTHCO_STORAGE[ $var_name ], $after, array( $key => $value ) );
		}
	}
}

// Add array element before the key
if ( ! function_exists( 'wealthco_storage_set_array_before' ) ) {
	function wealthco_storage_set_array_before( $var_name, $before, $key, $value = '' ) {
		global $WEALTHCO_STORAGE;
		if ( ! isset( $WEALTHCO_STORAGE[ $var_name ] ) ) {
			$WEALTHCO_STORAGE[ $var_name ] = array();
		}
		if ( is_array( $key ) ) {
			wealthco_array_insert_before( $WEALTHCO_STORAGE[ $var_name ], $before, $key );
		} else {
			wealthco_array_insert_before( $WEALTHCO_STORAGE[ $var_name ], $before, array( $key => $value ) );
		}
	}
}

// Push element into array
if ( ! function_exists( 'wealthco_storage_push_array' ) ) {
	function wealthco_storage_push_array( $var_name, $key, $value ) {
		global $WEALTHCO_STORAGE;
		if ( ! isset( $WEALTHCO_STORAGE[ $var_name ] ) ) {
			$WEALTHCO_STORAGE[ $var_name ] = array();
		}
		if ( $key === '' ) {
			array_push( $WEALTHCO_STORAGE[ $var_name ], $value );
		} else {
			if ( ! isset( $WEALTHCO_STORAGE[ $var_name ][ $key ] ) ) {
				$WEALTHCO_STORAGE[ $var_name ][ $key ] = array();
			}
			array_push( $WEALTHCO_STORAGE[ $var_name ][ $key ], $value );
		}
	}
}

// Pop element from array
if ( ! function_exists( 'wealthco_storage_pop_array' ) ) {
	function wealthco_storage_pop_array( $var_name, $key = '', $defa = '' ) {
		global $WEALTHCO_STORAGE;
		$rez = $defa;
		if ( $key === '' ) {
			if ( isset( $WEALTHCO_STORAGE[ $var_name ] ) && is_array( $WEALTHCO_STORAGE[ $var_name ] ) && count( $WEALTHCO_STORAGE[ $var_name ] ) > 0 ) {
				$rez = array_pop( $WEALTHCO_STORAGE[ $var_name ] );
			}
		} else {
			if ( isset( $WEALTHCO_STORAGE[ $var_name ][ $key ] ) && is_array( $WEALTHCO_STORAGE[ $var_name ][ $key ] ) && count( $WEALTHCO_STORAGE[ $var_name ][ $key ] ) > 0 ) {
				$rez = array_pop( $WEALTHCO_STORAGE[ $var_name ][ $key ] );
			}
		}
		return $rez;
	}
}

// Inc/Dec array element with specified value
if ( ! function_exists( 'wealthco_storage_inc_array' ) ) {
	function wealthco_storage_inc_array( $var_name, $key, $value = 1 ) {
		global $WEALTHCO_STORAGE;
		if ( ! isset( $WEALTHCO_STORAGE[ $var_name ] ) ) {
			$WEALTHCO_STORAGE[ $var_name ] = array();
		}
		if ( empty( $WEALTHCO_STORAGE[ $var_name ][ $key ] ) ) {
			$WEALTHCO_STORAGE[ $var_name ][ $key ] = 0;
		}
		$WEALTHCO_STORAGE[ $var_name ][ $key ] += $value;
	}
}

// Concatenate array element with specified value
if ( ! function_exists( 'wealthco_storage_concat_array' ) ) {
	function wealthco_storage_concat_array( $var_name, $key, $value ) {
		global $WEALTHCO_STORAGE;
		if ( ! isset( $WEALTHCO_STORAGE[ $var_name ] ) ) {
			$WEALTHCO_STORAGE[ $var_name ] = array();
		}
		if ( empty( $WEALTHCO_STORAGE[ $var_name ][ $key ] ) ) {
			$WEALTHCO_STORAGE[ $var_name ][ $key ] = '';
		}
		$WEALTHCO_STORAGE[ $var_name ][ $key ] .= $value;
	}
}

// Call object's method
if ( ! function_exists( 'wealthco_storage_call_obj_method' ) ) {
	function wealthco_storage_call_obj_method( $var_name, $method, $param = null ) {
		global $WEALTHCO_STORAGE;
		if ( $param === null ) {
			return ! empty( $var_name ) && ! empty( $method ) && isset( $WEALTHCO_STORAGE[ $var_name ] ) ? $WEALTHCO_STORAGE[ $var_name ]->$method() : '';
		} else {
			return ! empty( $var_name ) && ! empty( $method ) && isset( $WEALTHCO_STORAGE[ $var_name ] ) ? $WEALTHCO_STORAGE[ $var_name ]->$method( $param ) : '';
		}
	}
}

// Get object's property
if ( ! function_exists( 'wealthco_storage_get_obj_property' ) ) {
	function wealthco_storage_get_obj_property( $var_name, $prop, $default = '' ) {
		global $WEALTHCO_STORAGE;
		return ! empty( $var_name ) && ! empty( $prop ) && isset( $WEALTHCO_STORAGE[ $var_name ]->$prop ) ? $WEALTHCO_STORAGE[ $var_name ]->$prop : $default;
	}
}

