<?php
/**
 * The template for homepage posts with "Excerpt" style
 *
 * @package WordPress
 * @subpackage WEALTHCO
 * @since WEALTHCO 1.0
 */

wealthco_storage_set( 'blog_archive', true );

get_header();

if ( have_posts() ) {

	wealthco_show_layout( get_query_var( 'blog_archive_start' ) );

	?><div class="posts_container">
	<?php

	$wealthco_stickies   = is_home() ? get_option( 'sticky_posts' ) : false;
	$wealthco_sticky_out = wealthco_get_theme_option( 'sticky_style' ) == 'columns'
							&& is_array( $wealthco_stickies ) && count( $wealthco_stickies ) > 0 && get_query_var( 'paged' ) < 1;
	if ( $wealthco_sticky_out ) {
		?>
		<div class="sticky_wrap columns_wrap">
		<?php
	}
	while ( have_posts() ) {
		the_post();
		if ( $wealthco_sticky_out && ! is_sticky() ) {
			$wealthco_sticky_out = false;
			?>
			</div>
			<?php
		}
		get_template_part( 'content', $wealthco_sticky_out && is_sticky() ? 'sticky' : 'excerpt' );
	}
	if ( $wealthco_sticky_out ) {
		$wealthco_sticky_out = false;
		?>
		</div>
		<?php
	}

	?>
	</div><?php

	wealthco_show_pagination();

	wealthco_show_layout( get_query_var( 'blog_archive_end' ) );

} else {

	if ( is_search() ) {
		get_template_part( 'content', 'none-search' );
	} else {
		get_template_part( 'content', 'none-archive' );
	}
}

get_footer();
?>
