<?php
/**
 * The template for homepage posts with "Portfolio" style
 *
 * @package WordPress
 * @subpackage WEALTHCO
 * @since WEALTHCO 1.0
 */

wealthco_storage_set( 'blog_archive', true );

get_header();

if ( have_posts() ) {

	wealthco_show_layout( get_query_var( 'blog_archive_start' ) );

	$wealthco_stickies   = is_home() ? get_option( 'sticky_posts' ) : false;
	$wealthco_sticky_out = wealthco_get_theme_option( 'sticky_style' ) == 'columns'
							&& is_array( $wealthco_stickies ) && count( $wealthco_stickies ) > 0 && get_query_var( 'paged' ) < 1;

	// Show filters
	$wealthco_cat          = wealthco_get_theme_option( 'parent_cat' );
	$wealthco_post_type    = wealthco_get_theme_option( 'post_type' );
	$wealthco_taxonomy     = wealthco_get_post_type_taxonomy( $wealthco_post_type );
	$wealthco_show_filters = wealthco_get_theme_option( 'show_filters' );
	$wealthco_tabs         = array();
	if ( ! wealthco_is_off( $wealthco_show_filters ) ) {
		$wealthco_args           = array(
			'type'         => $wealthco_post_type,
			'child_of'     => $wealthco_cat,
			'orderby'      => 'name',
			'order'        => 'ASC',
			'hide_empty'   => 1,
			'hierarchical' => 0,
			'taxonomy'     => $wealthco_taxonomy,
			'pad_counts'   => false,
		);
		$wealthco_portfolio_list = get_terms( $wealthco_args );
		if ( is_array( $wealthco_portfolio_list ) && count( $wealthco_portfolio_list ) > 0 ) {
			$wealthco_tabs[ $wealthco_cat ] = esc_html__( 'All', 'wealthco' );
			foreach ( $wealthco_portfolio_list as $wealthco_term ) {
				if ( isset( $wealthco_term->term_id ) ) {
					$wealthco_tabs[ $wealthco_term->term_id ] = $wealthco_term->name;
				}
			}
		}
	}
	if ( count( $wealthco_tabs ) > 0 ) {
		$wealthco_portfolio_filters_ajax   = true;
		$wealthco_portfolio_filters_active = $wealthco_cat;
		$wealthco_portfolio_filters_id     = 'portfolio_filters';
		?>
		<div class="portfolio_filters wealthco_tabs wealthco_tabs_ajax">
			<ul class="portfolio_titles wealthco_tabs_titles">
				<?php
				foreach ( $wealthco_tabs as $wealthco_id => $wealthco_title ) {
					?>
					<li><a href="<?php echo esc_url( wealthco_get_hash_link( sprintf( '#%s_%s_content', $wealthco_portfolio_filters_id, $wealthco_id ) ) ); ?>" data-tab="<?php echo esc_attr( $wealthco_id ); ?>"><?php echo esc_html( $wealthco_title ); ?></a></li>
					<?php
				}
				?>
			</ul>
			<?php
			$wealthco_ppp = wealthco_get_theme_option( 'posts_per_page' );
			if ( wealthco_is_inherit( $wealthco_ppp ) ) {
				$wealthco_ppp = '';
			}
			foreach ( $wealthco_tabs as $wealthco_id => $wealthco_title ) {
				$wealthco_portfolio_need_content = $wealthco_id == $wealthco_portfolio_filters_active || ! $wealthco_portfolio_filters_ajax;
				?>
				<div id="<?php echo esc_attr( sprintf( '%s_%s_content', $wealthco_portfolio_filters_id, $wealthco_id ) ); ?>"
					class="portfolio_content wealthco_tabs_content"
					data-blog-template="<?php echo esc_attr( wealthco_storage_get( 'blog_template' ) ); ?>"
					data-blog-style="<?php echo esc_attr( wealthco_get_theme_option( 'blog_style' ) ); ?>"
					data-posts-per-page="<?php echo esc_attr( $wealthco_ppp ); ?>"
					data-post-type="<?php echo esc_attr( $wealthco_post_type ); ?>"
					data-taxonomy="<?php echo esc_attr( $wealthco_taxonomy ); ?>"
					data-cat="<?php echo esc_attr( $wealthco_id ); ?>"
					data-parent-cat="<?php echo esc_attr( $wealthco_cat ); ?>"
					data-need-content="<?php echo ( false === $wealthco_portfolio_need_content ? 'true' : 'false' ); ?>"
				>
					<?php
					if ( $wealthco_portfolio_need_content ) {
						wealthco_show_portfolio_posts(
							array(
								'cat'        => $wealthco_id,
								'parent_cat' => $wealthco_cat,
								'taxonomy'   => $wealthco_taxonomy,
								'post_type'  => $wealthco_post_type,
								'page'       => 1,
								'sticky'     => $wealthco_sticky_out,
							)
						);
					}
					?>
				</div>
				<?php
			}
			?>
		</div>
		<?php
	} else {
		wealthco_show_portfolio_posts(
			array(
				'cat'        => $wealthco_cat,
				'parent_cat' => $wealthco_cat,
				'taxonomy'   => $wealthco_taxonomy,
				'post_type'  => $wealthco_post_type,
				'page'       => 1,
				'sticky'     => $wealthco_sticky_out,
			)
		);
	}

	wealthco_show_layout( get_query_var( 'blog_archive_end' ) );

} else {

	if ( is_search() ) {
		get_template_part( 'content', 'none-search' );
	} else {
		get_template_part( 'content', 'none-archive' );
	}
}

get_footer();
?>
