<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package WordPress
 * @subpackage WEALTHCO
 * @since WEALTHCO 1.0
 */

if ( wealthco_sidebar_present() ) {
	ob_start();
	$wealthco_sidebar_name = wealthco_get_theme_option( 'sidebar_widgets' );
	wealthco_storage_set( 'current_sidebar', 'sidebar' );
	if ( is_active_sidebar( $wealthco_sidebar_name ) ) {
		dynamic_sidebar( $wealthco_sidebar_name );
	}
	$wealthco_out = trim( ob_get_contents() );
	ob_end_clean();
	if ( ! empty( $wealthco_out ) ) {
		$wealthco_sidebar_position = wealthco_get_theme_option( 'sidebar_position' );
		?>
		<div class="sidebar <?php echo esc_attr( $wealthco_sidebar_position ); ?> widget_area
									   <?php
										if ( ! wealthco_is_inherit( wealthco_get_theme_option( 'sidebar_scheme' ) ) ) {
											echo ' scheme_' . esc_attr( wealthco_get_theme_option( 'sidebar_scheme' ) );}
										?>
		" role="complementary">
			<div class="sidebar_inner">
				<?php
				do_action( 'wealthco_action_before_sidebar' );
				wealthco_show_layout( preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $wealthco_out ) );
				do_action( 'wealthco_action_after_sidebar' );
				?>
			</div><!-- /.sidebar_inner -->
		</div><!-- /.sidebar -->
		<?php
	}
}
?>
