<?php
/**
 * The template to display Admin notices
 *
 * @package WordPress
 * @subpackage WEALTHCO
 * @since WEALTHCO 1.0.1
 */

$wealthco_theme_obj = wp_get_theme();
?>
<div class="wealthco_admin_notice wealthco_welcome_notice update-nag">
<?php
	// Theme image
if ( ( $wealthco_theme_img = wealthco_get_file_url( 'screenshot.jpg' ) ) != '' ) {
	$notice = esc_html__( 'notice', 'wealthco' );
	?>
		<div class="wealthco_notice_image"><img src="<?php echo esc_url( $wealthco_theme_img ); ?>" alt="<?php echo esc_attr( $notice ); ?>"></div>
		<?php
}

	// Title
?>
	<h3 class="wealthco_notice_title">
	<?php
		// Translators: Add theme name and version to the 'Welcome' message
		echo esc_html(
			sprintf(
				__( 'Welcome to %1$s v.%2$s', 'wealthco' ),
				$wealthco_theme_obj->name . ( WEALTHCO_THEME_FREE ? ' ' . __( 'Free', 'wealthco' ) : '' ),
				$wealthco_theme_obj->version
			)
		);
		?>
	</h3>
	<?php

	// Description
	?>
	<div class="wealthco_notice_text">
	<?php
		echo str_replace( '. ', '.<br>', wp_kses_data( $wealthco_theme_obj->description ) );
	if ( ! wealthco_exists_trx_addons() ) {
		echo ( ! empty( $wealthco_theme_obj->description ) ? '<br><br>' : '' )
			. wp_kses_data( __( 'Attention! Plugin "ThemeREX Addons" is required! Please, install and activate it!', 'wealthco' ) );
	}
	?>
	</div>
	<?php

	// Buttons
	?>
	<div class="wealthco_notice_buttons">
	<?php
		// Link to the page 'About Theme'
	?>
		<a href="<?php echo esc_url( admin_url() . 'themes.php?page=wealthco_about' ); ?>" class="button button-primary"><i class="dashicons dashicons-nametag"></i> 
		<?php
			// Translators: Add theme name
			echo esc_html( sprintf( __( 'About %s', 'wealthco' ), $wealthco_theme_obj->name ) );
		?>
		</a>
		<?php
		// Link to the page 'Install plugins'
		if ( wealthco_get_value_gp( 'page' ) != 'tgmpa-install-plugins' ) {
			?>
			<a href="<?php echo esc_url( admin_url() . 'themes.php?page=tgmpa-install-plugins' ); ?>" class="button button-primary"><i class="dashicons dashicons-admin-plugins"></i> <?php esc_html_e( 'Install plugins', 'wealthco' ); ?></a>
			<?php
		}
		// Link to the 'One-click demo import'
		if ( function_exists( 'wealthco_exists_trx_addons' ) && wealthco_exists_trx_addons() && class_exists( 'trx_addons_demo_data_importer' ) ) {
			?>
			<a href="<?php echo esc_url( admin_url() . 'themes.php?page=trx_importer' ); ?>" class="button button-primary"><i class="dashicons dashicons-download"></i> <?php esc_html_e( 'One Click Demo Data', 'wealthco' ); ?></a>
			<?php
		}
		// Link to the Customizer
		?>
		<a href="<?php echo esc_url( admin_url() . 'customize.php' ); ?>" class="button"><i class="dashicons dashicons-admin-appearance"></i> <?php esc_html_e( 'Theme Customizer', 'wealthco' ); ?></a>
		<?php
		// Link to the Theme Options
		if ( ! WEALTHCO_THEME_FREE ) {
			?>
			<span> <?php esc_html_e( 'or', 'wealthco' ); ?> </span>
			<a href="<?php echo esc_url( admin_url() . 'themes.php?page=theme_options' ); ?>" class="button"><i class="dashicons dashicons-admin-appearance"></i> <?php esc_html_e( 'Theme Options', 'wealthco' ); ?></a>
								<?php
		}
		// Dismiss this notice
		?>
		<a href="#" class="wealthco_hide_notice"><i class="dashicons dashicons-dismiss"></i> <span class="wealthco_hide_notice_text"><?php esc_html_e( 'Dismiss', 'wealthco' ); ?></span></a>
	</div>
</div>
