<?php
/**
 * The template to display Admin notices
 *
 * @package WordPress
 * @subpackage WEALTHCO
 * @since WEALTHCO 1.0.1
 */

$wealthco_theme_obj = wp_get_theme();

?>
<div class="wealthco_admin_notice wealthco_rate_notice update-nag">
<?php
	// Theme image
if ( ( $wealthco_theme_img = wealthco_get_file_url( 'screenshot.jpg' ) ) != '' ) {
	$notice = esc_html__( 'notice', 'wealthco' );
	?>
		<div class="wealthco_notice_image"><img src="<?php echo esc_url( $wealthco_theme_img ); ?>" alt="<?php echo esc_attr( $notice ); ?>"></div>
		<?php
}

	// Title
?>
	<h3 class="wealthco_notice_title"><a href="<?php echo esc_url( wealthco_storage_get( 'theme_download_url' ) ); ?>" target="_blank">
	<?php
		// Translators: Add theme name and version to the 'Welcome' message
		echo esc_html(
			sprintf(
				__( 'Rate our theme "%s", please', 'wealthco' ),
				$wealthco_theme_obj->name . ( WEALTHCO_THEME_FREE ? ' ' . __( 'Free', 'wealthco' ) : '' )
			)
		);
		?>
	</a></h3>
	<?php

	// Description
	?>
	<div class="wealthco_notice_text">
		<p><?php echo wp_kses_data( __( 'We are glad you chose our WP theme for your website. You’ve done well customizing your website and we hope that you’ve enjoyed working with our theme.', 'wealthco' ) ); ?></p>
		<p><?php echo wp_kses_data( __( 'It would be just awesome if you spend just a minute of your time to rate our theme or the customer service you’ve received from us.', 'wealthco' ) ); ?></p>
		<p class="wealthco_notice_text_info"><?php echo wp_kses_data( __( '* We love receiving 5-star ratings, because our CEO Henry Rise gives $5 to homeless dog shelter for every 5-star rating we get! Save the planet with us!', 'wealthco' ) ); ?></p>
	</div>
	<?php

	// Buttons
	?>
	<div class="wealthco_notice_buttons">
	<?php
		// Link to the theme download page
	?>
		<a href="<?php echo esc_url( wealthco_storage_get( 'theme_download_url' ) ); ?>" class="button button-primary" target="_blank"><i class="dashicons dashicons-star-filled"></i> 
		<?php
			// Translators: Add theme name
			echo esc_html( sprintf( __( 'Rate theme %s', 'wealthco' ), $wealthco_theme_obj->name ) );
		?>
		</a>
		<?php
		// Link to the theme support
		?>
		<a href="<?php echo esc_url( wealthco_storage_get( 'theme_support_url' ) ); ?>" class="button" target="_blank"><i class="dashicons dashicons-sos"></i> 
		<?php
			esc_html_e( 'Support', 'wealthco' );
		?>
		</a>
		<?php
		// Link to the theme documentation
		?>
		<a href="<?php echo esc_url( wealthco_storage_get( 'theme_doc_url' ) ); ?>" class="button" target="_blank"><i class="dashicons dashicons-book"></i> 
		<?php
			esc_html_e( 'Documentation', 'wealthco' );
		?>
		</a>
		<?php
		// Dismiss
		?>
		<a href="#" class="wealthco_hide_notice"><i class="dashicons dashicons-dismiss"></i> <span class="wealthco_hide_notice_text"><?php esc_html_e( 'Dismiss', 'wealthco' ); ?></span></a>
	</div>
</div>
