<?php
/**
 * The template to display default site header
 *
 * @package WordPress
 * @subpackage WEALTHCO
 * @since WEALTHCO 1.0
 */

$wealthco_header_css   = '';
$wealthco_header_image = get_header_image();
$wealthco_header_video = wealthco_get_header_video();
if ( ! empty( $wealthco_header_image ) && wealthco_trx_addons_featured_image_override( is_singular() || wealthco_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$wealthco_header_image = wealthco_get_current_mode_image( $wealthco_header_image );
}

?><header class="top_panel top_panel_default
<?php
					echo ! empty( $wealthco_header_image ) || ! empty( $wealthco_header_video ) ? ' with_bg_image' : ' without_bg_image';
if ( $wealthco_header_video != '' ) {
	echo ' with_bg_video';
}
if ( $wealthco_header_image != '' ) {
	echo ' ' . esc_attr( wealthco_add_inline_css_class( 'background-image: url(' . esc_url( $wealthco_header_image ) . ');' ) );
}
if ( is_single() && has_post_thumbnail() ) {
	echo ' with_featured_image';
}
if ( wealthco_is_on( wealthco_get_theme_option( 'header_fullheight' ) ) ) {
	echo ' header_fullheight wealthco-full-height';
}
if ( ! wealthco_is_inherit( wealthco_get_theme_option( 'header_scheme' ) ) ) {
	echo ' scheme_' . esc_attr( wealthco_get_theme_option( 'header_scheme' ) );
}
?>
					">
					<?php

					// Background video
					if ( ! empty( $wealthco_header_video ) ) {
						get_template_part( 'templates/header-video' );
					}

					// Main menu
					if ( wealthco_get_theme_option( 'menu_style' ) == 'top' ) {
						get_template_part( 'templates/header-navi' );
					}

					// Mobile header
					if ( wealthco_is_on( wealthco_get_theme_option( 'header_mobile_enabled' ) ) ) {
						get_template_part( 'templates/header-mobile' );
					}

					// Page title and breadcrumbs area
					get_template_part( 'templates/header-title' );

					// Header widgets area
					get_template_part( 'templates/header-widgets' );

					// Display featured image in the header on the single posts
					// Comment next line to prevent show featured image in the header area
					// and display it in the post's content
					//get_template_part( 'templates/header-single' );

					?>
</header>
