<?php
/**
 * The template to display the logo or the site name and the slogan in the Header
 *
 * @package WordPress
 * @subpackage WEALTHCO
 * @since WEALTHCO 1.0
 */

$wealthco_args = get_query_var( 'wealthco_logo_args' );

// Site logo
$wealthco_logo_type   = isset( $wealthco_args['type'] ) ? $wealthco_args['type'] : '';
$wealthco_logo_image  = wealthco_get_logo_image( $wealthco_logo_type );
$wealthco_logo_text   = wealthco_is_on( wealthco_get_theme_option( 'logo_text' ) ) ? get_bloginfo( 'name' ) : '';
$wealthco_logo_slogan = get_bloginfo( 'description', 'display' );
if ( ! empty( $wealthco_logo_image ) || ! empty( $wealthco_logo_text ) ) {
	?><a class="sc_layouts_logo" href="<?php echo esc_url( home_url( '/' ) ); ?>">
	<?php
	if ( ! empty( $wealthco_logo_image ) ) {
		if ( empty( $wealthco_logo_type ) && function_exists( 'the_custom_logo' ) && (int) $wealthco_logo_image > 0 ) {
			the_custom_logo();
		} else {
			$wealthco_attr = wealthco_getimagesize( $wealthco_logo_image );
			echo '<img src="' . esc_url( $wealthco_logo_image ) . '" alt="' . esc_attr( $wealthco_logo_text ) . '"' . ( ! empty( $wealthco_attr[3] ) ? ' ' . wp_kses_data( $wealthco_attr[3] ) : '' ) . '>';
		}
	} else {
		wealthco_show_layout( wealthco_prepare_macros( $wealthco_logo_text ), '<span class="logo_text">', '</span>' );
		wealthco_show_layout( wealthco_prepare_macros( $wealthco_logo_slogan ), '<span class="logo_slogan">', '</span>' );
	}
	?>
	</a><?php
}
?>
