<?php
/**
 * The template to display the widgets area in the header
 *
 * @package WordPress
 * @subpackage WEALTHCO
 * @since WEALTHCO 1.0
 */

// Header sidebar
$wealthco_header_name    = wealthco_get_theme_option( 'header_widgets' );
$wealthco_header_present = ! wealthco_is_off( $wealthco_header_name ) && is_active_sidebar( $wealthco_header_name );
if ( $wealthco_header_present ) {
	wealthco_storage_set( 'current_sidebar', 'header' );
	$wealthco_header_wide = wealthco_get_theme_option( 'header_wide' );
	ob_start();
	if ( is_active_sidebar( $wealthco_header_name ) ) {
		dynamic_sidebar( $wealthco_header_name );
	}
	$wealthco_widgets_output = ob_get_contents();
	ob_end_clean();
	if ( ! empty( $wealthco_widgets_output ) ) {
		$wealthco_widgets_output = preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $wealthco_widgets_output );
		$wealthco_need_columns   = strpos( $wealthco_widgets_output, 'columns_wrap' ) === false;
		if ( $wealthco_need_columns ) {
			$wealthco_columns = max( 0, (int) wealthco_get_theme_option( 'header_columns' ) );
			if ( $wealthco_columns == 0 ) {
				$wealthco_columns = min( 6, max( 1, substr_count( $wealthco_widgets_output, '<aside ' ) ) );
			}
			if ( $wealthco_columns > 1 ) {
				$wealthco_widgets_output = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $wealthco_columns ) . ' widget', $wealthco_widgets_output );
			} else {
				$wealthco_need_columns = false;
			}
		}
		?>
		<div class="header_widgets_wrap widget_area<?php echo ! empty( $wealthco_header_wide ) ? ' header_fullwidth' : ' header_boxed'; ?>">
			<div class="header_widgets_inner widget_area_inner">
				<?php
				if ( ! $wealthco_header_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $wealthco_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'wealthco_action_before_sidebar' );
				wealthco_show_layout( $wealthco_widgets_output );
				do_action( 'wealthco_action_after_sidebar' );
				if ( $wealthco_need_columns ) {
					?>
					</div>	<!-- /.columns_wrap -->
					<?php
				}
				if ( ! $wealthco_header_wide ) {
					?>
					</div>	<!-- /.content_wrap -->
					<?php
				}
				?>
			</div>	<!-- /.header_widgets_inner -->
		</div>	<!-- /.header_widgets_wrap -->
		<?php
	}
}
?>
