<?php
/**
 * Setup theme-specific fonts and colors
 *
 * @package WordPress
 * @subpackage WEALTHCO
 * @since WEALTHCO 1.0.22
 */

if ( ! defined( 'WEALTHCO_THEME_FREE' ) ) {
	define( 'WEALTHCO_THEME_FREE', false );
}
if ( ! defined( 'WEALTHCO_THEME_FREE_WP' ) ) {
	define( 'WEALTHCO_THEME_FREE_WP', false );
}

// Theme storage
$WEALTHCO_STORAGE = array(
	// Theme required plugin's slugs
	'required_plugins'   => array_merge(

		// List of plugins for both - FREE and PREMIUM versions
		//-----------------------------------------------------
		array(
			// Required plugins
			// DON'T COMMENT OR REMOVE NEXT LINES!
			'trx_addons'       => esc_html__( 'ThemeREX Addons', 'wealthco' ),

			// Recommended (supported) plugins fot both (lite and full) versions
			// If plugin not need - comment (or remove) it
			'contact-form-7'   => esc_html__( 'Contact Form 7', 'wealthco' ),
			'mailchimp-for-wp' => esc_html__( 'MailChimp for WP', 'wealthco' ),
		),
		// List of plugins for the FREE version only
		//-----------------------------------------------------
		WEALTHCO_THEME_FREE
			? array(
					// Recommended (supported) plugins for the FREE (lite) version
					//...
			)

		// List of plugins for the PREMIUM version only
		//-----------------------------------------------------
			: array(
				// Recommended (supported) plugins for the PRO (full) version
				// If plugin not need - comment (or remove) it
				'essential-grid' => esc_html__( 'Essential Grid', 'wealthco' ),
				'revslider'      => esc_html__( 'Revolution Slider', 'wealthco' ),
				'js_composer'    => esc_html__( 'WPBakery PageBuilder', 'wealthco' ),
					//'sitepress-multilingual-cms'=> esc_html__('WPML - Sitepress Multilingual CMS', 'wealthco'),
			)
	),

	// Key validator: market[env|loc]-vendor[axiom|ancora|themerex]
	'theme_pro_key'      => WEALTHCO_THEME_FREE
								? 'env-themerex'
								: '',

	// Theme-specific URLs (will be escaped in place of the output)
	'theme_demo_url'     => 'http://wealthco.themerex.net',
	'theme_doc_url'      => 'http://wealthco.themerex.net/doc',
	'theme_download_url' => 'http://theme.download.url',

	'theme_support_url'  => 'http://themerex.ticksy.com',                                // ThemeREX

	'theme_video_url'    => 'https://www.youtube.com/channel/UCnFisBimrK2aIE-hnY70kCA',  // ThemeREX

	// Comma separated slugs of theme-specific categories (for get relevant news in the dashboard widget)
	// (i.e. 'children,kindergarten')
	'theme_categories'   => '',

	// Responsive resolutions
	// Parameters to create css media query: min, max
	'responsive'         => array(
		// By device
		'desktop'  => array( 'min' => 1680 ),
		'notebook' => array(
			'min' => 1280,
			'max' => 1679,
		),
		'tablet'   => array(
			'min' => 768,
			'max' => 1279,
		),
		'mobile'   => array( 'max' => 767 ),
		// By size
		'xxl'      => array( 'max' => 1679 ),
		'xl'       => array( 'max' => 1439 ),
		'lg'       => array( 'max' => 1279 ),
		'md'       => array( 'max' => 1023 ),
		'sm'       => array( 'max' => 767 ),
		'sm_wp'    => array( 'max' => 600 ),
		'xs'       => array( 'max' => 479 ),
	),
);

// Theme init priorities:
// Action 'after_setup_theme'
// 1 - register filters to add/remove lists items in the Theme Options
// 2 - create Theme Options
// 3 - add/remove Theme Options elements
// 5 - load Theme Options. Attention! After this step you can use only basic options (not overriden)
// 9 - register other filters (for installer, etc.)
//10 - standard Theme init procedures (not ordered)
// Action 'wp_loaded'
// 1 - detect override mode. Attention! Only after this step you can use overriden options (separate values for the shop, courses, etc.)

if ( ! function_exists( 'wealthco_customizer_theme_setup1' ) ) {
	add_action( 'after_setup_theme', 'wealthco_customizer_theme_setup1', 1 );
	function wealthco_customizer_theme_setup1() {

		// -----------------------------------------------------------------
		// -- ONLY FOR PROGRAMMERS, NOT FOR CUSTOMER
		// -- Internal theme settings
		// -----------------------------------------------------------------
		wealthco_storage_set(
			'settings', array(

				'duplicate_options'  => 'child',     // none  - use separate options for the main and the child-theme
				// child - duplicate theme options from the main theme to the child-theme only
				// both  - sinchronize changes in the theme options between main and child themes

				'customize_refresh'  => 'auto',      // Refresh method for preview area in the Appearance - Customize:
				// auto - refresh preview area on change each field with Theme Options
				// manual - refresh only obn press button 'Refresh' at the top of Customize frame

				'max_load_fonts'     => 5,           // Max fonts number to load from Google fonts or from uploaded fonts

				'comment_after_name' => true,        // Place 'comment' field before the 'name' and 'email'

				'socials_type'       => 'icons',     // Type of socials:
				// icons - use font icons to present social networks
				// images - use images from theme's folder trx_addons/css/icons.png

				'icons_type'         => 'icons',     // Type of other icons:
				// icons - use font icons to present icons
				// images - use images from theme's folder trx_addons/css/icons.png

				'icons_selector'     => 'internal',  // Icons selector in the shortcodes:
				// vc (default) - standard VC or Elementor's icons selector (very slow and don't support images)
				// internal - internal popup with plugin's or theme's icons list (fast)
				'check_min_version'  => true,        // Check if exists a .min version of .css and .js and return path to it
				// instead the path to the original file
				// (if debug_mode is off and modification time of the original file < time of the .min file)
				'autoselect_menu'    => false,       // Show any menu if no menu selected in the location 'main_menu'
				// (for example, the theme is just activated)
				'disable_jquery_ui'  => false,       // Prevent loading custom jQuery UI libraries in the third-party plugins

				'use_mediaelements'  => true,        // Load script "Media Elements" to play video and audio

				'tgmpa_upload'       => false,       // Allow upload not pre-packaged plugins via TGMPA

				'allow_no_image'     => false,       // Allow use image placeholder if no image present in the blog, related posts, post navigation, etc.

				'separate_schemes'   => true,        // Save color schemes to the separate files __color_xxx.css (true) or append its to the __custom.css (false)

				'allow_fullscreen'   => false,        // Allow cases 'fullscreen' and 'fullwide' for the body style in the Theme Options
													// In the Page Options this styles are present always (can be removed if filter 'wealthco_filter_allow_fullscreen' return false)
			)
		);

		// -----------------------------------------------------------------
		// -- Theme fonts (Google and/or custom fonts)
		// -----------------------------------------------------------------

		// Fonts to load when theme start
		// It can be Google fonts or uploaded fonts, placed in the folder /css/font-face/font-name inside the theme folder
		// Attention! Font's folder must have name equal to the font's name, with spaces replaced on the dash '-'
		// For example: font name 'TeX Gyre Termes', folder 'TeX-Gyre-Termes'
		wealthco_storage_set(
			'load_fonts', array(
				// Google font
				array(
					'name'   => 'Hind',
					'family' => 'sans-serif',
					'styles' => '300,400,500,600,700',       // Parameter 'style' used only for the Google fonts
				),
				array(
					'name'   => 'Playfair Display',
					'family' => 'serif',
					'styles' => '400,400i,700,700i,900,900i',        // Parameter 'style' used only for the Google fonts
				),

			// For example:
			// Font-face packed with theme
			//array(
			//	'name'   => 'Montserrat',
			//	'family' => 'sans-serif'
			//	)
			)
		);

		// Characters subset for the Google fonts. Available values are: latin,latin-ext,cyrillic,cyrillic-ext,greek,greek-ext,vietnamese
		wealthco_storage_set( 'load_fonts_subset', 'latin,latin-ext' );

		// Settings of the main tags
		// Attention! Font name in the parameter 'font-family' will be enclosed in the quotes and no spaces after comma!
		// For example:	'font-family' => '"Roboto",sans-serif'	- is correct
		// 				'font-family' => '"Roboto", sans-serif'	- is incorrect
		// 				'font-family' => 'Roboto,sans-serif'	- is incorrect

		wealthco_storage_set(
			'theme_fonts', array(
				'p'       => array(
					'title'           => esc_html__( 'Main text', 'wealthco' ),
					'description'     => esc_html__( 'Font settings of the main text of the site. Attention! For correct display of the site on mobile devices, use only units "rem", "em" or "ex"', 'wealthco' ),
					'font-family'     => '"Hind",sans-serif',
					'font-size'       => '1rem',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.38em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '-0.4px',
					'margin-top'      => '0em',
					'margin-bottom'   => '1.4em',
				),
				'h1'      => array(
					'title'           => esc_html__( 'Heading 1', 'wealthco' ),
					'font-family'     => '"Playfair Display",serif',
					'font-size'       => '3.474em',
					'font-weight'     => '700',
					'font-style'      => 'normal',
					'line-height'     => '1.05em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '1.78em',
					'margin-bottom'   => '1.12em',
				),
				'h2'      => array(
					'title'           => esc_html__( 'Heading 2', 'wealthco' ),
					'font-family'     => '"Playfair Display",serif',
					'font-size'       => '3.053em',
					'font-weight'     => '700',
					'font-style'      => 'normal',
					'line-height'     => '1.21em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '1.98em',
					'margin-bottom'   => '1.01em',
				),
				'h3'      => array(
					'title'           => esc_html__( 'Heading 3', 'wealthco' ),
					'font-family'     => '"Playfair Display",serif',
					'font-size'       => '2.368em',
					'font-weight'     => '700',
					'font-style'      => 'normal',
					'line-height'     => '1.1515em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '2.07em',
					'margin-bottom'   => '1.18em',
				),
				'h4'      => array(
					'title'           => esc_html__( 'Heading 4', 'wealthco' ),
					'font-family'     => '"Playfair Display",serif',
					'font-size'       => '1.684em',
					'font-weight'     => '700',
					'font-style'      => 'normal',
					'line-height'     => '1.3077em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '1.65em',
					'margin-bottom'   => '1em',
				),
				'h5'      => array(
					'title'           => esc_html__( 'Heading 5', 'wealthco' ),
					'font-family'     => '"Playfair Display",serif',
					'font-size'       => '1.316em',
					'font-weight'     => '700',
					'font-style'      => 'normal',
					'line-height'     => '1.2em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '2.03em',
					'margin-bottom'   => '1.23em',
				),
				'h6'      => array(
					'title'           => esc_html__( 'Heading 6', 'wealthco' ),
					'font-family'     => '"Playfair Display",serif',
					'font-size'       => '1.053em',
					'font-weight'     => '700',
					'font-style'      => 'normal',
					'line-height'     => '1.2em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '1.5em',
					'margin-bottom'   => '1.45em',
				),
				'logo'    => array(
					'title'           => esc_html__( 'Logo text', 'wealthco' ),
					'description'     => esc_html__( 'Font settings of the text case of the logo', 'wealthco' ),
					'font-family'     => '"Playfair Display",serif',
					'font-size'       => '1.8em',
					'font-weight'     => '700',
					'font-style'      => 'normal',
					'line-height'     => '1.25em',
					'text-decoration' => 'none',
					'text-transform'  => 'uppercase',
					'letter-spacing'  => '0.5px',
				),
				'button'  => array(
					'title'           => esc_html__( 'Buttons', 'wealthco' ),
					'font-family'     => '"Hind",sans-serif',
					'font-size'       => '14px',
					'font-weight'     => '600',
					'font-style'      => 'normal',
					'line-height'     => '20px',
					'text-decoration' => 'none',
					'text-transform'  => 'uppercase',
					'letter-spacing'  => '3.5px',
				),
				'input'   => array(
					'title'           => esc_html__( 'Input fields', 'wealthco' ),
					'description'     => esc_html__( 'Font settings of the input fields, dropdowns and textareas', 'wealthco' ),
					'font-family'     => '"Hind",sans-serif',
					'font-size'       => '0.947em',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.5em', // Attention! Firefox don't allow line-height less then 1.5em in the select
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
				),
				'info'    => array(
					'title'           => esc_html__( 'Post meta', 'wealthco' ),
					'description'     => esc_html__( 'Font settings of the post meta: date, counters, share, etc.', 'wealthco' ),
					'font-family'     => '"Hind",sans-serif',
					'font-size'       => '18px',
					'font-weight'     => '500',
					'font-style'      => 'normal',
					'line-height'     => '1.2em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '-0.4px',
					'margin-top'      => '0.4em',
					'margin-bottom'   => '',
				),
				'menu'    => array(
					'title'           => esc_html__( 'Main menu', 'wealthco' ),
					'description'     => esc_html__( 'Font settings of the main menu items', 'wealthco' ),
					'font-family'     => '"Hind",sans-serif',
					'font-size'       => '1.158rem',
					'font-weight'     => '500',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '-0.3px',
				),
				'submenu' => array(
					'title'           => esc_html__( 'Dropdown menu', 'wealthco' ),
					'description'     => esc_html__( 'Font settings of the dropdown menu items', 'wealthco' ),
					'font-family'     => '"Hind",sans-serif',
					'font-size'       => '14px',
					'font-weight'     => '600',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',
					'text-decoration' => 'none',
					'text-transform'  => 'uppercase',
					'letter-spacing'  => '0px',
				),
			)
		);

		// -----------------------------------------------------------------
		// -- Theme colors for customizer
		// -- Attention! Inner scheme must be last in the array below
		// -----------------------------------------------------------------
		wealthco_storage_set(
			'scheme_color_groups', array(
				'main'    => array(
					'title'       => __( 'Main', 'wealthco' ),
					'description' => __( 'Colors of the main content area', 'wealthco' ),
				),
				'alter'   => array(
					'title'       => __( 'Alter', 'wealthco' ),
					'description' => __( 'Colors of the alternative blocks (sidebars, etc.)', 'wealthco' ),
				),
				'extra'   => array(
					'title'       => __( 'Extra', 'wealthco' ),
					'description' => __( 'Colors of the extra blocks (dropdowns, price blocks, table headers, etc.)', 'wealthco' ),
				),
				'inverse' => array(
					'title'       => __( 'Inverse', 'wealthco' ),
					'description' => __( 'Colors of the inverse blocks - when link color used as background of the block (dropdowns, blockquotes, etc.)', 'wealthco' ),
				),
				'input'   => array(
					'title'       => __( 'Input', 'wealthco' ),
					'description' => __( 'Colors of the form fields (text field, textarea, select, etc.)', 'wealthco' ),
				),
			)
		);
		wealthco_storage_set(
			'scheme_color_names', array(
				'bg_color'    => array(
					'title'       => __( 'Background color', 'wealthco' ),
					'description' => __( 'Background color of this block in the normal state', 'wealthco' ),
				),
				'bg_hover'    => array(
					'title'       => __( 'Background hover', 'wealthco' ),
					'description' => __( 'Background color of this block in the hovered state', 'wealthco' ),
				),
				'bd_color'    => array(
					'title'       => __( 'Border color', 'wealthco' ),
					'description' => __( 'Border color of this block in the normal state', 'wealthco' ),
				),
				'bd_hover'    => array(
					'title'       => __( 'Border hover', 'wealthco' ),
					'description' => __( 'Border color of this block in the hovered state', 'wealthco' ),
				),
				'text'        => array(
					'title'       => __( 'Text', 'wealthco' ),
					'description' => __( 'Color of the plain text inside this block', 'wealthco' ),
				),
				'text_dark'   => array(
					'title'       => __( 'Text dark', 'wealthco' ),
					'description' => __( 'Color of the dark text (bold, header, etc.) inside this block', 'wealthco' ),
				),
				'text_light'  => array(
					'title'       => __( 'Text light', 'wealthco' ),
					'description' => __( 'Color of the light text (post meta, etc.) inside this block', 'wealthco' ),
				),
				'text_link'   => array(
					'title'       => __( 'Link', 'wealthco' ),
					'description' => __( 'Color of the links inside this block', 'wealthco' ),
				),
				'text_hover'  => array(
					'title'       => __( 'Link hover', 'wealthco' ),
					'description' => __( 'Color of the hovered state of links inside this block', 'wealthco' ),
				),
				'text_link2'  => array(
					'title'       => __( 'Link 2', 'wealthco' ),
					'description' => __( 'Color of the accented texts (areas) inside this block', 'wealthco' ),
				),
				'text_hover2' => array(
					'title'       => __( 'Link 2 hover', 'wealthco' ),
					'description' => __( 'Color of the hovered state of accented texts (areas) inside this block', 'wealthco' ),
				),
				'text_link3'  => array(
					'title'       => __( 'Link 3', 'wealthco' ),
					'description' => __( 'Color of the other accented texts (buttons) inside this block', 'wealthco' ),
				),
				'text_hover3' => array(
					'title'       => __( 'Link 3 hover', 'wealthco' ),
					'description' => __( 'Color of the hovered state of other accented texts (buttons) inside this block', 'wealthco' ),
				),
			)
		);
		wealthco_storage_set(
			'schemes', array(

				// Color scheme: 'default'
				'default' => array(
					'title'    => esc_html__( 'Default', 'wealthco' ),
					'internal' => true,
					'colors'   => array(

						// Whole block border and background
						'bg_color'         => '#ffffff',
						'bd_color'         => '#e5e5e5',

						// Text and links colors
						'text'             => '#9d9ca4', //ok
						'text_light'       => '#b7b7b7',
						'text_dark'        => '#393a4e', //ok
						'text_link'        => '#81c2fa', //ok
						'text_hover'       => '#5e4ac5', //ok
						'text_link2'       => '#80d572',
						'text_hover2'      => '#8be77c',
						'text_link3'       => '#8461c6', //ok
						'text_hover3'      => '#81c2fa', //ok

						// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
						'alter_bg_color'   => '#f3f4f4', //ok
						'alter_bg_hover'   => '#ebeeef', //ok
						'alter_bd_color'   => '#e6e7e7', //ok
						'alter_bd_hover'   => '#dadada',
						'alter_text'       => '#9d9ba3', //ok
						'alter_light'      => '#9d9ba3', //ok
						'alter_dark'       => '#3a3a4e', //ok
						'alter_link'       => '#80c2fa', //ok
						'alter_hover'      => '#5d4ac5', //ok
						'alter_link2'      => '#8be77c',
						'alter_hover2'     => '#80d572',
						'alter_link3'      => '#eec432',
						'alter_hover3'     => '#ddb837',

						// Extra blocks (submenu, tabs, color blocks, etc.)
						'extra_bg_color'   => '#80c2fa', //ok
						'extra_bg_hover'   => '#99cefb', //ok
						'extra_bd_color'   => '#ffffff', //ok
						'extra_bd_hover'   => '#3d3d3d',
						'extra_text'       => '#bfbfbf',
						'extra_light'      => '#afafaf',
						'extra_dark'       => '#ffffff',
						'extra_link'       => '#bfbeed', //ok
						'extra_hover'      => '#5d4ac5', //ok
						'extra_link2'      => '#80d572',
						'extra_hover2'     => '#8be77c',
						'extra_link3'      => '#ddb837',
						'extra_hover3'     => '#eec432',

						// Input fields (form's fields and textarea)
						'input_bg_color'   => '#ffffff', //ok
						'input_bg_hover'   => '#ffffff', //ok
						'input_bd_color'   => '#e6e7e7', //ok
						'input_bd_hover'   => '#5d4ac5', //ok
						'input_text'       => '#9d9ba3', //ok
						'input_light'      => '#9d9ba3', //ok
						'input_dark'       => '#3a3a4e', //ok

						// Inverse blocks (text and links on the 'text_link' background)
						'inverse_bd_color' => '#67bcc1',
						'inverse_bd_hover' => '#5aa4a9',
						'inverse_text'     => '#1d1d1d',
						'inverse_light'    => '#333333',
						'inverse_dark'     => '#000000',
						'inverse_link'     => '#ffffff',
						'inverse_hover'    => '#1d1d1d',
					),
				),

				// Color scheme: 'dark'
				'dark'    => array(
					'title'    => esc_html__( 'Dark', 'wealthco' ),
					'internal' => true,
					'colors'   => array(

						// Whole block border and background
						'bg_color'         => '#2d3340', //ok
						'bd_color'         => '#4c515c', //ok

						// Text and links colors
						'text'             => '#9d9ca4', //ok
						'text_light'       => '#5f5f5f',
						'text_dark'        => '#ffffff', //ok
						'text_link'        => '#81c2fa', //ok
						'text_hover'       => '#5e4ac5', //ok
						'text_link2'       => '#80d572',
						'text_hover2'      => '#8be77c',
						'text_link3'       => '#8461c6', //ok
						'text_hover3'      => '#81c2fa', //ok

						// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
						'alter_bg_color'   => '#313744', //ok
						'alter_bg_hover'   => '#2a303b', //ok
						'alter_bd_color'   => '#262b36', //ok
						'alter_bd_hover'   => '#4a4a4a',
						'alter_text'       => '#9d9ba3', //ok
						'alter_light'      => '#9d9ba3', //ok
						'alter_dark'       => '#ffffff', //ok
						'alter_link'       => '#80c2fa', //ok
						'alter_hover'      => '#5d4ac5', //ok
						'alter_link2'      => '#8be77c',
						'alter_hover2'     => '#80d572',
						'alter_link3'      => '#eec432',
						'alter_hover3'     => '#ddb837',

						// Extra blocks (submenu, tabs, color blocks, etc.)
						'extra_bg_color'   => '#80c2fa', //ok
						'extra_bg_hover'   => '#99cefb', //ok
						'extra_bd_color'   => '#e5e5e5', //ok
						'extra_bd_hover'   => '#4a4a4a',
						'extra_text'       => '#a6a6a6',
						'extra_light'      => '#5f5f5f',
						'extra_dark'       => '#ffffff',
						'extra_link'       => '#bfbeed', //ok
						'extra_hover'      => '#5d4ac5', //ok
						'extra_link2'      => '#80d572',
						'extra_hover2'     => '#8be77c',
						'extra_link3'      => '#ddb837',
						'extra_hover3'     => '#eec432',

						// Input fields (form's fields and textarea)
						'input_bg_color'   => '#2e2d32', //ok
						'input_bg_hover'   => '#2e2d32', //ok
						'input_bd_color'   => '#4c515c', //ok
						'input_bd_hover'   => '#5d4ac5', //ok
						'input_text'       => '#9d9ba3', //ok
						'input_light'      => '#9d9ba3', //ok
						'input_dark'       => '#ffffff', //ok

						// Inverse blocks (text and links on the 'text_link' background)
						'inverse_bd_color' => '#e36650',
						'inverse_bd_hover' => '#cb5b47',
						'inverse_text'     => '#1d1d1d',
						'inverse_light'    => '#5f5f5f',
						'inverse_dark'     => '#000000',
						'inverse_link'     => '#ffffff',
						'inverse_hover'    => '#1d1d1d',
					),
				),

			)
		);

		// Simple schemes substitution
		wealthco_storage_set(
			'schemes_simple', array(
				// Main color	// Slave elements and it's darkness koef.
				'text_link'   => array(
					'alter_hover'      => 1,
					'extra_link'       => 1,
					'inverse_bd_color' => 0.85,
					'inverse_bd_hover' => 0.7,
				),
				'text_hover'  => array(
					'alter_link'  => 1,
					'extra_hover' => 1,
				),
				'text_link2'  => array(
					'alter_hover2' => 1,
					'extra_link2'  => 1,
				),
				'text_hover2' => array(
					'alter_link2'  => 1,
					'extra_hover2' => 1,
				),
				'text_link3'  => array(
					'alter_hover3' => 1,
					'extra_link3'  => 1,
				),
				'text_hover3' => array(
					'alter_link3'  => 1,
					'extra_hover3' => 1,
				),
			)
		);

		// Additional colors for each scheme
		// Parameters:	'color' - name of the color from the scheme that should be used as source for the transformation
		//				'alpha' - to make color transparent (0.0 - 1.0)
		//				'hue', 'saturation', 'brightness' - inc/dec value for each color's component
		wealthco_storage_set(
			'scheme_colors_add', array(
				'bg_color_0'        => array(
					'color' => 'bg_color',
					'alpha' => 0,
				),
				'bg_color_02'       => array(
					'color' => 'bg_color',
					'alpha' => 0.2,
				),
				'bg_color_07'       => array(
					'color' => 'bg_color',
					'alpha' => 0.7,
				),
				'bg_color_08'       => array(
					'color' => 'bg_color',
					'alpha' => 0.8,
				),
				'bg_color_09'       => array(
					'color' => 'bg_color',
					'alpha' => 0.9,
				),
				'alter_bg_color_07' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.7,
				),
				'alter_bg_color_04' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.4,
				),
				'alter_bg_color_02' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.2,
				),
				'alter_bd_color_02' => array(
					'color' => 'alter_bd_color',
					'alpha' => 0.2,
				),
				'alter_link_02'     => array(
					'color' => 'alter_link',
					'alpha' => 0.2,
				),
				'alter_link_07'     => array(
					'color' => 'alter_link',
					'alpha' => 0.7,
				),
				'extra_bg_color_07' => array(
					'color' => 'extra_bg_color',
					'alpha' => 0.7,
				),
				'extra_link_02'     => array(
					'color' => 'extra_link',
					'alpha' => 0.2,
				),
				'extra_link_07'     => array(
					'color' => 'extra_link',
					'alpha' => 0.7,
				),
				'text_dark_07'      => array(
					'color' => 'text_dark',
					'alpha' => 0.7,
				),
				'text_hover_02'     => array(
					'color' => 'text_hover',
					'alpha' => 0.2,
				),
				'text_link_02'      => array(
					'color' => 'text_link',
					'alpha' => 0.2,
				),
				'text_link_07'      => array(
					'color' => 'text_link',
					'alpha' => 0.7,
				),
				'text_link_blend'   => array(
					'color'      => 'text_link',
					'hue'        => 2,
					'saturation' => -5,
					'brightness' => 5,
				),
				'alter_link_blend'  => array(
					'color'      => 'alter_link',
					'hue'        => 2,
					'saturation' => -5,
					'brightness' => 5,
				),
			)
		);

		// Parameters to set order of schemes in the css
		wealthco_storage_set(
			'schemes_sorted', array(
				'color_scheme',
				'header_scheme',
				'menu_scheme',
				'sidebar_scheme',
				'footer_scheme',
			)
		);

		// -----------------------------------------------------------------
		// -- Theme specific thumb sizes
		// -----------------------------------------------------------------
		wealthco_storage_set(
			'theme_thumbs', apply_filters(
				'wealthco_filter_add_thumb_sizes', array(
					// Width of the image is equal to the content area width (without sidebar)
					// Height is fixed
					'wealthco-thumb-huge'         => array(
						'size'  => array( 1170, 658, true ),
						'title' => esc_html__( 'Huge image', 'wealthco' ),
						'subst' => 'trx_addons-thumb-huge',
					),
					// Width of the image is equal to the content area width (with sidebar)
					// Height is fixed
					'wealthco-thumb-big'          => array(
						'size'  => array( 730, 324, true ), // 760, 428
						'title' => esc_html__( 'Large image', 'wealthco' ),
						'subst' => 'trx_addons-thumb-big',
					),

					// Width of the image is equal to the 1/3 of the content area width (without sidebar)
					// Height is fixed
					'wealthco-thumb-med'          => array(
						'size'  => array( 574, 404, true ), //370, 208,
						'title' => esc_html__( 'Medium image', 'wealthco' ),
						'subst' => 'trx_addons-thumb-medium',
					),

					// Small square image (for avatars in comments, etc.)
					'wealthco-thumb-tiny'         => array(
						'size'  => array( 90, 90, true ),
						'title' => esc_html__( 'Small square avatar', 'wealthco' ),
						'subst' => 'trx_addons-thumb-tiny',
					),

					// Width of the image is equal to the content area width (with sidebar)
					// Height is proportional (only downscale, not crop)
					'wealthco-thumb-masonry-big'  => array(
						'size'  => array( 760, 0, false ),     // Only downscale, not crop
						'title' => esc_html__( 'Masonry Large (scaled)', 'wealthco' ),
						'subst' => 'trx_addons-thumb-masonry-big',
					),

					// Width of the image is equal to the 1/3 of the full content area width (without sidebar)
					// Height is proportional (only downscale, not crop)
					'wealthco-thumb-masonry'      => array(
						'size'  => array( 370, 0, false ),     // Only downscale, not crop
						'title' => esc_html__( 'Masonry (scaled)', 'wealthco' ),
						'subst' => 'trx_addons-thumb-masonry',
					),

					'wealthco-thumb-extra'        => array(
						'size'  => array( 600, 285, true ),
						'title' => esc_html__( 'Extra', 'wealthco' ),
						'subst' => 'trx_addons-thumb-extra',
					),

					'wealthco-thumb-extra-square' => array(
						'size'  => array( 336, 416, true ),
						'title' => esc_html__( 'Extra Square', 'wealthco' ),
						'subst' => 'trx_addons-thumb-extra-square',
					),

				)
			)
		);
	}
}




//------------------------------------------------------------------------
// One-click import support
//------------------------------------------------------------------------

// Set theme specific importer options
if ( ! function_exists( 'wealthco_importer_set_options' ) ) {
	add_filter( 'trx_addons_filter_importer_options', 'wealthco_importer_set_options', 9 );
	function wealthco_importer_set_options( $options = array() ) {
		if ( is_array( $options ) ) {
			// Save or not installer's messages to the log-file
			$options['debug'] = false;
			// Prepare demo data
			$options['demo_url'] = esc_url( wealthco_get_protocol() . '://demofiles.themerex.net/wealthco/' );
			// Required plugins
			$options['required_plugins'] = array_keys( wealthco_storage_get( 'required_plugins' ) );
			// Set number of thumbnails to regenerate when its imported (if demo data was zipped without cropped images)
			// Set 0 to prevent regenerate thumbnails (if demo data archive is already contain cropped images)
			$options['regenerate_thumbnails'] = 3;
			// Default demo
			$options['files']['default']['title']       = esc_html__( 'WealthCo Demo', 'wealthco' );
			$options['files']['default']['domain_dev']  = '';        // Developers domain
			$options['files']['default']['domain_demo'] = esc_url( wealthco_get_protocol() . '://wealthco.themerex.net' );       // Demo-site domain
			// If theme need more demo - just copy 'default' and change required parameter
			// For example:
			// 		$options['files']['dark_demo'] = $options['files']['default'];
			// 		$options['files']['dark_demo']['title'] = esc_html__('Dark Demo', 'wealthco');
			// Banners
			$options['banners'] = array(
				array(
					'image'        => wealthco_get_file_url( 'theme-specific/theme-about/images/frontpage.png' ),
					'title'        => esc_html__( 'Front Page Builder', 'wealthco' ),
					'content'      => wp_kses_post( __( "Create your front page right in the WordPress Customizer. There's no need any page builder. Simply enable/disable sections, fill them out with content, and customize to your liking.", 'wealthco' ) ),
					'link_url'     => esc_url( '//www.youtube.com/watch?v=VT0AUbMl_KA' ),
					'link_caption' => esc_html__( 'Watch Video Introduction', 'wealthco' ),
					'duration'     => 20,
				),
				array(
					'image'        => wealthco_get_file_url( 'theme-specific/theme-about/images/layouts.png' ),
					'title'        => esc_html__( 'Layouts Builder', 'wealthco' ),
					'content'      => wp_kses_post( __( 'Use Layouts Builder to create and customize header and footer styles for your website. With a flexible page builder interface and custom shortcodes, you can create as many header and footer layouts as you want with ease.', 'wealthco' ) ),
					'link_url'     => esc_url( '//www.youtube.com/watch?v=pYhdFVLd7y4' ),
					'link_caption' => esc_html__( 'Learn More', 'wealthco' ),
					'duration'     => 20,
				),
				array(
					'image'        => wealthco_get_file_url( 'theme-specific/theme-about/images/documentation.png' ),
					'title'        => esc_html__( 'Read Full Documentation', 'wealthco' ),
					'content'      => wp_kses_post( __( 'Need more details? Please check our full online documentation for detailed information on how to use WealthCo.', 'wealthco' ) ),
					'link_url'     => esc_url( wealthco_storage_get( 'theme_doc_url' ) ),
					'link_caption' => esc_html__( 'Online Documentation', 'wealthco' ),
					'duration'     => 15,
				),
				array(
					'image'        => wealthco_get_file_url( 'theme-specific/theme-about/images/video-tutorials.png' ),
					'title'        => esc_html__( 'Video Tutorials', 'wealthco' ),
					'content'      => wp_kses_post( __( 'No time for reading documentation? Check out our video tutorials and learn how to customize WealthCo in detail.', 'wealthco' ) ),
					'link_url'     => esc_url( wealthco_storage_get( 'theme_video_url' ) ),
					'link_caption' => esc_html__( 'Video Tutorials', 'wealthco' ),
					'duration'     => 15,
				),
				array(
					'image'        => wealthco_get_file_url( 'theme-specific/theme-about/images/studio.png' ),
					'title'        => esc_html__( 'Mockingbird Website Customization Studio', 'wealthco' ),
					'content'      => wp_kses_post( __( "Need a website fast? Order our custom service, and we'll build a website based on this theme for a very fair price. We can also implement additional functionality such as website translation, setting up WPML, and much more.", 'wealthco' ) ),
					'link_url'     => esc_url( '//mockingbird.ticksy.com/' ),
					'link_caption' => esc_html__( 'Contact Us', 'wealthco' ),
					'duration'     => 25,
				),
			);
		}
		return $options;
	}
}



// -----------------------------------------------------------------
// -- Theme options for customizer
// -----------------------------------------------------------------
if ( ! function_exists( 'wealthco_create_theme_options' ) ) {

	function wealthco_create_theme_options() {

		// Message about options override.
		// Attention! Not need esc_html() here, because this message put in wp_kses_data() below
		$msg_override = __( 'Attention! Some of these options can be overridden in the following sections (Blog, Plugins settings, etc.) or in the settings of individual pages', 'wealthco' );

		// Color schemes number: if < 2 - hide fields with selectors
		$hide_schemes = count( wealthco_storage_get( 'schemes' ) ) < 2;

		wealthco_storage_set(
			'options', array(

				// 'Logo & Site Identity'
				'title_tagline'                 => array(
					'title'    => esc_html__( 'Logo & Site Identity', 'wealthco' ),
					'desc'     => '',
					'priority' => 10,
					'type'     => 'section',
				),
				'logo_info'                     => array(
					'title'    => esc_html__( 'Logo in the header', 'wealthco' ),
					'desc'     => '',
					'priority' => 20,
					'type'     => 'info',
				),
				'logo_text'                     => array(
					'title'    => esc_html__( 'Use Site Name as Logo', 'wealthco' ),
					'desc'     => wp_kses_data( __( 'Use the site title and tagline as a text logo if no image is selected', 'wealthco' ) ),
					'class'    => 'wealthco_column-1_2 wealthco_new_row',
					'priority' => 30,
					'std'      => 1,
					'type'     => WEALTHCO_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'logo_retina_enabled'           => array(
					'title'    => esc_html__( 'Allow retina display logo', 'wealthco' ),
					'desc'     => wp_kses_data( __( 'Show fields to select logo images for Retina display', 'wealthco' ) ),
					'class'    => 'wealthco_column-1_2',
					'priority' => 40,
					'refresh'  => false,
					'std'      => 0,
					'type'     => WEALTHCO_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'logo_zoom'                     => array(
					'title'   => esc_html__( 'Logo zoom', 'wealthco' ),
					'desc'    => wp_kses_data( __( 'Zoom the logo. 1 - original size. Maximum size of logo depends on the actual size of the picture', 'wealthco' ) ),
					'std'     => 1,
					'min'     => 0.2,
					'max'     => 2,
					'step'    => 0.1,
					'refresh' => false,
					'type'    => WEALTHCO_THEME_FREE ? 'hidden' : 'slider',
				),
				// Parameter 'logo' was replaced with standard WordPress 'custom_logo'
				'logo_retina'                   => array(
					'title'      => esc_html__( 'Logo for Retina', 'wealthco' ),
					'desc'       => wp_kses_data( __( 'Select or upload site logo used on Retina displays (if empty - use default logo from the field above)', 'wealthco' ) ),
					'class'      => 'wealthco_column-1_2',
					'priority'   => 70,
					'dependency' => array(
						'logo_retina_enabled' => array( 1 ),
					),
					'std'        => '',
					'type'       => WEALTHCO_THEME_FREE ? 'hidden' : 'image',
				),
				'logo_mobile_header'            => array(
					'title' => esc_html__( 'Logo for the mobile header', 'wealthco' ),
					'desc'  => wp_kses_data( __( 'Select or upload site logo to display it in the mobile header (if enabled in the section "Header - Header mobile"', 'wealthco' ) ),
					'class' => 'wealthco_column-1_2 wealthco_new_row',
					'std'   => '',
					'type'  => 'image',
				),
				'logo_mobile_header_retina'     => array(
					'title'      => esc_html__( 'Logo for the mobile header for Retina', 'wealthco' ),
					'desc'       => wp_kses_data( __( 'Select or upload site logo used on Retina displays (if empty - use default logo from the field above)', 'wealthco' ) ),
					'class'      => 'wealthco_column-1_2',
					'dependency' => array(
						'logo_retina_enabled' => array( 1 ),
					),
					'std'        => '',
					'type'       => WEALTHCO_THEME_FREE ? 'hidden' : 'image',
				),
				'logo_mobile'                   => array(
					'title' => esc_html__( 'Logo mobile', 'wealthco' ),
					'desc'  => wp_kses_data( __( 'Select or upload site logo to display it in the mobile menu', 'wealthco' ) ),
					'class' => 'wealthco_column-1_2 wealthco_new_row',
					'std'   => '',
					'type'  => 'image',
				),
				'logo_mobile_retina'            => array(
					'title'      => esc_html__( 'Logo mobile for Retina', 'wealthco' ),
					'desc'       => wp_kses_data( __( 'Select or upload site logo used on Retina displays (if empty - use default logo from the field above)', 'wealthco' ) ),
					'class'      => 'wealthco_column-1_2',
					'dependency' => array(
						'logo_retina_enabled' => array( 1 ),
					),
					'std'        => '',
					'type'       => WEALTHCO_THEME_FREE ? 'hidden' : 'image',
				),
				'logo_side'                     => array(
					'title' => esc_html__( 'Logo side', 'wealthco' ),
					'desc'  => wp_kses_data( __( 'Select or upload site logo (with vertical orientation) to display it in the side menu', 'wealthco' ) ),
					'class' => 'wealthco_column-1_2 wealthco_new_row',
					'std'   => '',
					//"type" => "image"
					'type'  => 'hidden',
				),
				'logo_side_retina'              => array(
					'title'      => esc_html__( 'Logo side for Retina', 'wealthco' ),
					'desc'       => wp_kses_data( __( 'Select or upload site logo (with vertical orientation) to display it in the side menu on Retina displays (if empty - use default logo from the field above)', 'wealthco' ) ),
					'class'      => 'wealthco_column-1_2',
					'dependency' => array(
						'logo_retina_enabled' => array( 1 ),
					),
					'std'        => '',
					//"type" => WEALTHCO_THEME_FREE ? "hidden" : "image"
					'type'       => 'hidden',
				),

				// 'General settings'
				'general'                       => array(
					'title'    => esc_html__( 'General Settings', 'wealthco' ),
					'desc'     => wp_kses_data( $msg_override ),
					'priority' => 20,
					'type'     => 'section',
				),

				'general_layout_info'           => array(
					'title' => esc_html__( 'Layout', 'wealthco' ),
					'desc'  => '',
					'type'  => 'info',
				),
				'body_style'                    => array(
					'title'    => esc_html__( 'Body style', 'wealthco' ),
					'desc'     => wp_kses_data( __( 'Select width of the body content', 'wealthco' ) ),
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Content', 'wealthco' ),
					),
					'refresh'  => false,
					'std'      => 'wide',
					'options'  => wealthco_get_list_body_styles( false ),
					'type'     => 'select',
				),
				'page_width'                    => array(
					'title'      => esc_html__( 'Page width', 'wealthco' ),
					'desc'       => wp_kses_data( __( 'Total width of the site content and sidebar (in pixels). If empty - use default width', 'wealthco' ) ),
					'dependency' => array(
						'body_style' => array( 'boxed', 'wide' ),
					),
					'std'        => 1170,
					'min'        => 1000,
					'max'        => 1400,
					'step'       => 10,
					'refresh'    => false,
					'customizer' => 'page',     // SASS name to preview changes 'on fly'
					'type'       => WEALTHCO_THEME_FREE ? 'hidden' : 'slider',
				),
				'boxed_bg_image'                => array(
					'title'      => esc_html__( 'Boxed bg image', 'wealthco' ),
					'desc'       => wp_kses_data( __( 'Select or upload image, used as background in the boxed body', 'wealthco' ) ),
					'dependency' => array(
						'body_style' => array( 'boxed' ),
					),
					'override'   => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Content', 'wealthco' ),
					),
					'std'        => '',
					'hidden'     => true,
					'type'       => 'image',
				),
				'remove_margins'                => array(
					'title'    => esc_html__( 'Remove margins', 'wealthco' ),
					'desc'     => wp_kses_data( __( 'Remove margins above and below the content area', 'wealthco' ) ),
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Content', 'wealthco' ),
					),
					'refresh'  => false,
					'std'      => 0,
					'type'     => 'checkbox',
				),

				'general_sidebar_info'          => array(
					'title' => esc_html__( 'Sidebar', 'wealthco' ),
					'desc'  => '',
					'type'  => 'info',
				),
				'sidebar_position'              => array(
					'title'    => esc_html__( 'Sidebar position', 'wealthco' ),
					'desc'     => wp_kses_data( __( 'Select position to show sidebar', 'wealthco' ) ),
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Widgets', 'wealthco' ),
					),
					'std'      => 'right',
					'options'  => array(),
					'type'     => 'switch',
				),
				'sidebar_widgets'               => array(
					'title'      => esc_html__( 'Sidebar widgets', 'wealthco' ),
					'desc'       => wp_kses_data( __( 'Select default widgets to show in the sidebar', 'wealthco' ) ),
					'override'   => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Widgets', 'wealthco' ),
					),
					'dependency' => array(
						'sidebar_position' => array( 'left', 'right' ),
					),
					'std'        => 'sidebar_widgets',
					'options'    => array(),
					'type'       => 'select',
				),
				'sidebar_width'                 => array(
					'title'      => esc_html__( 'Sidebar width', 'wealthco' ),
					'desc'       => wp_kses_data( __( 'Width of the sidebar (in percents). If empty - use default width', 'wealthco' ) ),
					'std'        => 370,
					'min'        => 150,
					'max'        => 500,
					'step'       => 10,
					'refresh'    => false,
					'customizer' => 'sidebar',      // SASS name to preview changes 'on fly'
					'type'       => WEALTHCO_THEME_FREE ? 'hidden' : 'slider',
				),
				'sidebar_gap'                   => array(
					'title'      => esc_html__( 'Sidebar gap', 'wealthco' ),
					'desc'       => wp_kses_data( __( 'Gap between content and sidebar (in pepcents). If empty - use default gap', 'wealthco' ) ),
					'std'        => 40,
					'min'        => 0,
					'max'        => 100,
					'step'       => 1,
					'refresh'    => false,
					'customizer' => 'gap',      // SASS name to preview changes 'on fly'
					'type'       => WEALTHCO_THEME_FREE ? 'hidden' : 'slider',
				),
				'expand_content'                => array(
					'title'   => esc_html__( 'Expand content', 'wealthco' ),
					'desc'    => wp_kses_data( __( 'Expand the content width if the sidebar is hidden', 'wealthco' ) ),
					'refresh' => false,
					'std'     => 1,
					'type'    => 'checkbox',
				),

				'general_widgets_info'          => array(
					'title' => esc_html__( 'Additional widgets', 'wealthco' ),
					'desc'  => '',
					'type'  => WEALTHCO_THEME_FREE ? 'hidden' : 'info',
				),
				'widgets_above_page'            => array(
					'title'    => esc_html__( 'Widgets at the top of the page', 'wealthco' ),
					'desc'     => wp_kses_data( __( 'Select widgets to show at the top of the page (above content and sidebar)', 'wealthco' ) ),
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Widgets', 'wealthco' ),
					),
					'std'      => 'hide',
					'options'  => array(),
					'type'     => WEALTHCO_THEME_FREE ? 'hidden' : 'select',
				),
				'widgets_above_content'         => array(
					'title'    => esc_html__( 'Widgets above the content', 'wealthco' ),
					'desc'     => wp_kses_data( __( 'Select widgets to show at the beginning of the content area', 'wealthco' ) ),
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Widgets', 'wealthco' ),
					),
					'std'      => 'hide',
					'options'  => array(),
					'type'     => WEALTHCO_THEME_FREE ? 'hidden' : 'select',
				),
				'widgets_below_content'         => array(
					'title'    => esc_html__( 'Widgets below the content', 'wealthco' ),
					'desc'     => wp_kses_data( __( 'Select widgets to show at the ending of the content area', 'wealthco' ) ),
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Widgets', 'wealthco' ),
					),
					'std'      => 'hide',
					'options'  => array(),
					'type'     => WEALTHCO_THEME_FREE ? 'hidden' : 'select',
				),
				'widgets_below_page'            => array(
					'title'    => esc_html__( 'Widgets at the bottom of the page', 'wealthco' ),
					'desc'     => wp_kses_data( __( 'Select widgets to show at the bottom of the page (below content and sidebar)', 'wealthco' ) ),
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Widgets', 'wealthco' ),
					),
					'std'      => 'hide',
					'options'  => array(),
					'type'     => WEALTHCO_THEME_FREE ? 'hidden' : 'select',
				),

				'general_effects_info'          => array(
					'title' => esc_html__( 'Design & Effects', 'wealthco' ),
					'desc'  => '',
					'type'  => 'info',
				),
				'border_radius'                 => array(
					'title'      => esc_html__( 'Border radius', 'wealthco' ),
					'desc'       => wp_kses_data( __( 'Specify the border radius of the form fields and buttons in pixels', 'wealthco' ) ),
					'std'        => 0,
					'min'        => 0,
					'max'        => 20,
					'step'       => 1,
					'refresh'    => false,
					'customizer' => 'rad',      // SASS name to preview changes 'on fly'
					//"type" => WEALTHCO_THEME_FREE ? "hidden" : "slider"
					'type'       => 'hidden',
				),

				'general_misc_info'             => array(
					'title' => esc_html__( 'Miscellaneous', 'wealthco' ),
					'desc'  => '',
					'type'  => WEALTHCO_THEME_FREE ? 'hidden' : 'info',
				),
				'seo_snippets'                  => array(
					'title' => esc_html__( 'SEO snippets', 'wealthco' ),
					'desc'  => wp_kses_data( __( 'Add structured data markup to the single posts and pages', 'wealthco' ) ),
					'std'   => 0,
					'type'  => WEALTHCO_THEME_FREE ? 'hidden' : 'checkbox',
				),

				'general_side_info'             => array(
					'title' => esc_html__( 'Side Info', 'wealthco' ),
					'desc'  => '',
					'type'  => WEALTHCO_THEME_FREE ? 'hidden' : 'info',
				),
				'socials_in_side'               => array(
					'title' => esc_html__( 'Socials in right side section', 'wealthco' ),
					'desc'  => wp_kses_data( __( 'Show socials to the right of page\'s body for Body style -> Wide', 'wealthco' ) ),
					'std'   => 0,
					'type'  => 'checkbox',
				),
				'text_in_side'                  => array(
					'title' => esc_html__( 'Text in left side section (if not empty)', 'wealthco' ),
					'desc'  => wp_kses_data( __( 'Show Text to the left of page\'s body for Body style -> Wide', 'wealthco' ) ),
					'std'   => '',
					'type'  => 'text',
				),

				// 'Header'
				'header'                        => array(
					'title'    => esc_html__( 'Header', 'wealthco' ),
					'desc'     => wp_kses_data( $msg_override ),
					'priority' => 30,
					'type'     => 'section',
				),

				'header_style_info'             => array(
					'title' => esc_html__( 'Header style', 'wealthco' ),
					'desc'  => '',
					'type'  => 'info',
				),
				'header_type'                   => array(
					'title'    => esc_html__( 'Header style', 'wealthco' ),
					'desc'     => wp_kses_data( __( 'Choose whether to use the default header or header Layouts (available only if the ThemeREX Addons is activated)', 'wealthco' ) ),
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Header', 'wealthco' ),
					),
					'std'      => 'default',
					'options'  => wealthco_get_list_header_footer_types(),
					'type'     => WEALTHCO_THEME_FREE || ! wealthco_exists_trx_addons() ? 'hidden' : 'switch',
				),
				'header_style'                  => array(
					'title'      => esc_html__( 'Select custom layout', 'wealthco' ),
					'desc'       => wp_kses_post( __( 'Select custom header from Layouts Builder', 'wealthco' ) ),
					'override'   => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Header', 'wealthco' ),
					),
					'dependency' => array(
						'header_type' => array( 'custom' ),
					),
					'std'        => WEALTHCO_THEME_FREE ? 'header-custom-elementor-header-default' : 'header-custom-header-default',
					'options'    => array(),
					'type'       => 'select',
				),
				'header_position'               => array(
					'title'    => esc_html__( 'Header position', 'wealthco' ),
					'desc'     => wp_kses_data( __( 'Select position to display the site header', 'wealthco' ) ),
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Header', 'wealthco' ),
					),
					'std'      => 'default',
					'options'  => array(),
					'type'     => WEALTHCO_THEME_FREE ? 'hidden' : 'switch',
				),
				'header_fullheight'             => array(
					'title'    => esc_html__( 'Header fullheight', 'wealthco' ),
					'desc'     => wp_kses_data( __( 'Enlarge header area to fill whole screen. Used only if header have a background image', 'wealthco' ) ),
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Header', 'wealthco' ),
					),
					'std'      => 0,
					'type'     => WEALTHCO_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'header_zoom'                   => array(
					'title'   => esc_html__( 'Header zoom', 'wealthco' ),
					'desc'    => wp_kses_data( __( 'Zoom the header title. 1 - original size', 'wealthco' ) ),
					'std'     => 1,
					'min'     => 0.3,
					'max'     => 2,
					'step'    => 0.1,
					'refresh' => false,
					'type'    => WEALTHCO_THEME_FREE ? 'hidden' : 'slider',
				),
				'header_wide'                   => array(
					'title'      => esc_html__( 'Header fullwidth', 'wealthco' ),
					'desc'       => wp_kses_data( __( 'Do you want to stretch the header widgets area to the entire window width?', 'wealthco' ) ),
					'override'   => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Header', 'wealthco' ),
					),
					'dependency' => array(
						'header_type' => array( 'default' ),
					),
					'std'        => 1,
					'type'       => WEALTHCO_THEME_FREE ? 'hidden' : 'checkbox',
				),

				'header_widgets_info'           => array(
					'title' => esc_html__( 'Header widgets', 'wealthco' ),
					'desc'  => wp_kses_data( __( 'Here you can place a widget slider, advertising banners, etc.', 'wealthco' ) ),
					'type'  => 'info',
				),
				'header_widgets'                => array(
					'title'    => esc_html__( 'Header widgets', 'wealthco' ),
					'desc'     => wp_kses_data( __( 'Select set of widgets to show in the header on each page', 'wealthco' ) ),
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Header', 'wealthco' ),
						'desc'    => wp_kses_data( __( 'Select set of widgets to show in the header on this page', 'wealthco' ) ),
					),
					'std'      => 'hide',
					'options'  => array(),
					'type'     => 'select',
				),
				'header_columns'                => array(
					'title'      => esc_html__( 'Header columns', 'wealthco' ),
					'desc'       => wp_kses_data( __( 'Select number columns to show widgets in the Header. If 0 - autodetect by the widgets count', 'wealthco' ) ),
					'override'   => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Header', 'wealthco' ),
					),
					'dependency' => array(
						'header_type'    => array( 'default' ),
						'header_widgets' => array( '^hide' ),
					),
					'std'        => 0,
					'options'    => wealthco_get_list_range( 0, 6 ),
					'type'       => 'select',
				),

				'menu_info'                     => array(
					'title' => esc_html__( 'Main menu', 'wealthco' ),
					'desc'  => wp_kses_data( __( 'Select main menu style, position and other parameters', 'wealthco' ) ),
					'type'  => WEALTHCO_THEME_FREE ? 'hidden' : 'info',
				),
				'menu_style'                    => array(
					'title'    => esc_html__( 'Menu position', 'wealthco' ),
					'desc'     => wp_kses_data( __( 'Select position of the main menu', 'wealthco' ) ),
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Header', 'wealthco' ),
					),
					'std'      => 'top',
					'options'  => array(
						'top' => esc_html__( 'Top', 'wealthco' ),
						//'left'	=> esc_html__('Left',	'wealthco'),
						//'right'	=> esc_html__('Right',	'wealthco')
					),
					'type'     => WEALTHCO_THEME_FREE || ! wealthco_exists_trx_addons() ? 'hidden' : 'switch',
				),
				'menu_side_stretch'             => array(
					'title'      => esc_html__( 'Stretch sidemenu', 'wealthco' ),
					'desc'       => wp_kses_data( __( 'Stretch sidemenu to window height (if menu items number >= 5)', 'wealthco' ) ),
					'override'   => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Header', 'wealthco' ),
					),
					'dependency' => array(
						'menu_style' => array( 'left', 'right' ),
					),
					'std'        => 0,
					'type'       => WEALTHCO_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'menu_side_icons'               => array(
					'title'      => esc_html__( 'Iconed sidemenu', 'wealthco' ),
					'desc'       => wp_kses_data( __( 'Get icons from anchors and display it in the sidemenu or mark sidemenu items with simple dots', 'wealthco' ) ),
					'override'   => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Header', 'wealthco' ),
					),
					'dependency' => array(
						'menu_style' => array( 'left', 'right' ),
					),
					'std'        => 1,
					'type'       => WEALTHCO_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'menu_mobile_fullscreen'        => array(
					'title' => esc_html__( 'Mobile menu fullscreen', 'wealthco' ),
					'desc'  => wp_kses_data( __( 'Display mobile and side menus on full screen (if checked) or slide narrow menu from the left or from the right side (if not checked)', 'wealthco' ) ),
					'std'   => 1,
					'type'  => WEALTHCO_THEME_FREE ? 'hidden' : 'checkbox',
				),

				'header_image_info'             => array(
					'title' => esc_html__( 'Header image', 'wealthco' ),
					'desc'  => '',
					'type'  => WEALTHCO_THEME_FREE ? 'hidden' : 'info',
				),
				'header_image_override'         => array(
					'title'    => esc_html__( 'Header image override', 'wealthco' ),
					'desc'     => wp_kses_data( __( "Allow override the header image with the page's/post's/product's/etc. featured image", 'wealthco' ) ),
					'override' => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Header', 'wealthco' ),
					),
					'std'      => 0,
					'type'     => WEALTHCO_THEME_FREE ? 'hidden' : 'checkbox',
				),

				'header_mobile_info'            => array(
					'title'      => esc_html__( 'Mobile header', 'wealthco' ),
					'desc'       => wp_kses_data( __( 'Configure the mobile version of the header', 'wealthco' ) ),
					'priority'   => 500,
					'dependency' => array(
						'header_type' => array( 'default' ),
					),
					'type'       => WEALTHCO_THEME_FREE ? 'hidden' : 'info',
				),
				'header_mobile_enabled'         => array(
					'title'      => esc_html__( 'Enable the mobile header', 'wealthco' ),
					'desc'       => wp_kses_data( __( 'Use the mobile version of the header (if checked) or relayout the current header on mobile devices', 'wealthco' ) ),
					'dependency' => array(
						'header_type' => array( 'default' ),
					),
					'std'        => 0,
					'type'       => WEALTHCO_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'header_mobile_additional_info' => array(
					'title'      => esc_html__( 'Additional info', 'wealthco' ),
					'desc'       => wp_kses_data( __( 'Additional info to show at the top of the mobile header', 'wealthco' ) ),
					'std'        => '',
					'dependency' => array(
						'header_type'           => array( 'default' ),
						'header_mobile_enabled' => array( 1 ),
					),
					'refresh'    => false,
					'teeny'      => false,
					'rows'       => 20,
					'type'       => WEALTHCO_THEME_FREE ? 'hidden' : 'text_editor',
				),
				'header_mobile_hide_info'       => array(
					'title'      => esc_html__( 'Hide additional info', 'wealthco' ),
					'std'        => 0,
					'dependency' => array(
						'header_type'           => array( 'default' ),
						'header_mobile_enabled' => array( 1 ),
					),
					'type'       => WEALTHCO_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'header_mobile_hide_logo'       => array(
					'title'      => esc_html__( 'Hide logo', 'wealthco' ),
					'std'        => 0,
					'dependency' => array(
						'header_type'           => array( 'default' ),
						'header_mobile_enabled' => array( 1 ),
					),
					'type'       => WEALTHCO_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'header_mobile_hide_login'      => array(
					'title'      => esc_html__( 'Hide login/logout', 'wealthco' ),
					'std'        => 0,
					'dependency' => array(
						'header_type'           => array( 'default' ),
						'header_mobile_enabled' => array( 1 ),
					),
					'type'       => WEALTHCO_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'header_mobile_hide_search'     => array(
					'title'      => esc_html__( 'Hide search', 'wealthco' ),
					'std'        => 0,
					'dependency' => array(
						'header_type'           => array( 'default' ),
						'header_mobile_enabled' => array( 1 ),
					),
					'type'       => WEALTHCO_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'header_mobile_hide_cart'       => array(
					'title'      => esc_html__( 'Hide cart', 'wealthco' ),
					'std'        => 0,
					'dependency' => array(
						'header_type'           => array( 'default' ),
						'header_mobile_enabled' => array( 1 ),
					),
					'type'       => WEALTHCO_THEME_FREE ? 'hidden' : 'checkbox',
				),

				// 'Footer'
				'footer'                        => array(
					'title'    => esc_html__( 'Footer', 'wealthco' ),
					'desc'     => wp_kses_data( $msg_override ),
					'priority' => 50,
					'type'     => 'section',
				),
				'footer_type'                   => array(
					'title'    => esc_html__( 'Footer style', 'wealthco' ),
					'desc'     => wp_kses_data( __( 'Choose whether to use the default footer or footer Layouts (available only if the ThemeREX Addons is activated)', 'wealthco' ) ),
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Footer', 'wealthco' ),
					),
					'std'      => 'default',
					'options'  => wealthco_get_list_header_footer_types(),
					'type'     => WEALTHCO_THEME_FREE || ! wealthco_exists_trx_addons() ? 'hidden' : 'switch',
				),
				'footer_style'                  => array(
					'title'      => esc_html__( 'Select custom layout', 'wealthco' ),
					'desc'       => wp_kses_post( __( 'Select custom footer from Layouts Builder', 'wealthco' ) ),
					'override'   => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Footer', 'wealthco' ),
					),
					'dependency' => array(
						'footer_type' => array( 'custom' ),
					),
					'std'        => WEALTHCO_THEME_FREE ? 'footer-custom-elementor-footer-default' : 'footer-custom-footer-default',
					'options'    => array(),
					'type'       => 'select',
				),
				'footer_widgets'                => array(
					'title'      => esc_html__( 'Footer widgets', 'wealthco' ),
					'desc'       => wp_kses_data( __( 'Select set of widgets to show in the footer', 'wealthco' ) ),
					'override'   => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Footer', 'wealthco' ),
					),
					'dependency' => array(
						'footer_type' => array( 'default' ),
					),
					'std'        => 'footer_widgets',
					'options'    => array(),
					'type'       => 'select',
				),
				'footer_columns'                => array(
					'title'      => esc_html__( 'Footer columns', 'wealthco' ),
					'desc'       => wp_kses_data( __( 'Select number columns to show widgets in the footer. If 0 - autodetect by the widgets count', 'wealthco' ) ),
					'override'   => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Footer', 'wealthco' ),
					),
					'dependency' => array(
						'footer_type'    => array( 'default' ),
						'footer_widgets' => array( '^hide' ),
					),
					'std'        => 0,
					'options'    => wealthco_get_list_range( 0, 6 ),
					'type'       => 'select',
				),
				'footer_wide'                   => array(
					'title'      => esc_html__( 'Footer fullwidth', 'wealthco' ),
					'desc'       => wp_kses_data( __( 'Do you want to stretch the footer to the entire window width?', 'wealthco' ) ),
					'override'   => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Footer', 'wealthco' ),
					),
					'dependency' => array(
						'footer_type' => array( 'default' ),
					),
					'std'        => 0,
					'type'       => 'checkbox',
				),
				'logo_in_footer'                => array(
					'title'      => esc_html__( 'Show logo', 'wealthco' ),
					'desc'       => wp_kses_data( __( 'Show logo in the footer', 'wealthco' ) ),
					'refresh'    => false,
					'dependency' => array(
						'footer_type' => array( 'default' ),
					),
					'std'        => 0,
					//"type" => "checkbox"
					'type'       => 'hidden',
				),
				'logo_footer'                   => array(
					'title'      => esc_html__( 'Logo for footer', 'wealthco' ),
					'desc'       => wp_kses_data( __( 'Select or upload site logo to display it in the footer', 'wealthco' ) ),
					'dependency' => array(
						'footer_type'    => array( 'default' ),
						'logo_in_footer' => array( 1 ),
					),
					'std'        => '',
					'type'       => 'image',
				),
				'logo_footer_retina'            => array(
					'title'      => esc_html__( 'Logo for footer (Retina)', 'wealthco' ),
					'desc'       => wp_kses_data( __( 'Select or upload logo for the footer area used on Retina displays (if empty - use default logo from the field above)', 'wealthco' ) ),
					'dependency' => array(
						'footer_type'         => array( 'default' ),
						'logo_in_footer'      => array( 1 ),
						'logo_retina_enabled' => array( 1 ),
					),
					'std'        => '',
					'type'       => WEALTHCO_THEME_FREE ? 'hidden' : 'image',
				),
				'socials_in_footer'             => array(
					'title'      => esc_html__( 'Show social icons', 'wealthco' ),
					'desc'       => wp_kses_data( __( 'Show social icons in the footer (under logo or footer widgets)', 'wealthco' ) ),
					'dependency' => array(
						'footer_type' => array( 'default' ),
					),
					'std'        => 0,
					'type'       => ! wealthco_exists_trx_addons() ? 'hidden' : 'checkbox',
				),
				'copyright'                     => array(
					'title'      => esc_html__( 'Copyright', 'wealthco' ),
					'desc'       => wp_kses_data( __( 'Copyright text in the footer. Use {Y} to insert current year and press "Enter" to create a new line', 'wealthco' ) ),
					'translate'  => true,
					'std'        => esc_html__( 'Copyright &copy; {Y} by ThemeREX. All rights reserved.', 'wealthco' ),
					'dependency' => array(
						'footer_type' => array( 'default' ),
					),
					'refresh'    => false,
					'type'       => 'textarea',
				),

				// 'Blog'
				'blog'                          => array(
					'title'    => esc_html__( 'Blog', 'wealthco' ),
					'desc'     => wp_kses_data( __( 'Options of the the blog archive', 'wealthco' ) ),
					'priority' => 70,
					'type'     => 'panel',
				),

				// Blog - Posts page
				'blog_general'                  => array(
					'title' => esc_html__( 'Posts page', 'wealthco' ),
					'desc'  => wp_kses_data( __( 'Style and components of the blog archive', 'wealthco' ) ),
					'type'  => 'section',
				),
				'blog_general_info'             => array(
					'title' => esc_html__( 'General settings', 'wealthco' ),
					'desc'  => '',
					'type'  => 'info',
				),
				'blog_style'                    => array(
					'title'      => esc_html__( 'Blog style', 'wealthco' ),
					'desc'       => '',
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'wealthco' ),
					),
					'dependency' => array(
						'#page_template' => array( 'blog.php' ),
					),
					'std'        => 'excerpt',
					'options'    => array(),
					'type'       => 'select',
				),
				'first_post_large'              => array(
					'title'      => esc_html__( 'First post large', 'wealthco' ),
					'desc'       => wp_kses_data( __( 'Make your first post stand out by making it bigger', 'wealthco' ) ),
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'wealthco' ),
					),
					'dependency' => array(
						'#page_template' => array( 'blog.php' ),
						'blog_style'     => array( 'classic', 'masonry' ),
					),
					'std'        => 0,
					'type'       => 'checkbox',
				),
				'blog_content'                  => array(
					'title'      => esc_html__( 'Posts content', 'wealthco' ),
					'desc'       => wp_kses_data( __( 'Display either post excerpts or the full post content', 'wealthco' ) ),
					'std'        => 'excerpt',
					'dependency' => array(
						'blog_style' => array( 'excerpt' ),
					),
					'options'    => array(
						'excerpt'  => esc_html__( 'Excerpt', 'wealthco' ),
						'fullpost' => esc_html__( 'Full post', 'wealthco' ),
					),
					'type'       => 'switch',
				),
				'excerpt_length'                => array(
					'title'      => esc_html__( 'Excerpt length', 'wealthco' ),
					'desc'       => wp_kses_data( __( 'Length (in words) to generate excerpt from the post content. Attention! If the post excerpt is explicitly specified - it appears unchanged', 'wealthco' ) ),
					'dependency' => array(
						'blog_style'   => array( 'excerpt' ),
						'blog_content' => array( 'excerpt' ),
					),
					'std'        => 50,
					'type'       => 'text',
				),
				'blog_columns'                  => array(
					'title'   => esc_html__( 'Blog columns', 'wealthco' ),
					'desc'    => wp_kses_data( __( 'How many columns should be used in the blog archive (from 2 to 4)?', 'wealthco' ) ),
					'std'     => 2,
					'options' => wealthco_get_list_range( 2, 4 ),
					'type'    => 'hidden',
				),
				'post_type'                     => array(
					'title'      => esc_html__( 'Post type', 'wealthco' ),
					'desc'       => wp_kses_data( __( 'Select post type to show in the blog archive', 'wealthco' ) ),
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'wealthco' ),
					),
					'dependency' => array(
						'#page_template' => array( 'blog.php' ),
					),
					'linked'     => 'parent_cat',
					'refresh'    => false,
					'hidden'     => true,
					'std'        => 'post',
					'options'    => array(),
					'type'       => 'select',
				),
				'parent_cat'                    => array(
					'title'      => esc_html__( 'Category to show', 'wealthco' ),
					'desc'       => wp_kses_data( __( 'Select category to show in the blog archive', 'wealthco' ) ),
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'wealthco' ),
					),
					'dependency' => array(
						'#page_template' => array( 'blog.php' ),
					),
					'refresh'    => false,
					'hidden'     => true,
					'std'        => '0',
					'options'    => array(),
					'type'       => 'select',
				),
				'posts_per_page'                => array(
					'title'      => esc_html__( 'Posts per page', 'wealthco' ),
					'desc'       => wp_kses_data( __( 'How many posts will be displayed on this page', 'wealthco' ) ),
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'wealthco' ),
					),
					'dependency' => array(
						'#page_template' => array( 'blog.php' ),
					),
					'hidden'     => true,
					'std'        => '',
					'type'       => 'text',
				),
				'blog_pagination'               => array(
					'title'      => esc_html__( 'Pagination style', 'wealthco' ),
					'desc'       => wp_kses_data( __( 'Show Older/Newest posts or Page numbers below the posts list', 'wealthco' ) ),
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'wealthco' ),
					),
					'std'        => 'pages',
					'dependency' => array(
						'#page_template' => array( 'blog.php' ),
					),
					'options'    => array(
						'pages'    => esc_html__( 'Page numbers', 'wealthco' ),
						'links'    => esc_html__( 'Older/Newest', 'wealthco' ),
						'more'     => esc_html__( 'Load more', 'wealthco' ),
						'infinite' => esc_html__( 'Infinite scroll', 'wealthco' ),
					),
					'type'       => 'select',
				),
				'show_filters'                  => array(
					'title'      => esc_html__( 'Show filters', 'wealthco' ),
					'desc'       => wp_kses_data( __( 'Show categories as tabs to filter posts', 'wealthco' ) ),
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'wealthco' ),
					),
					'dependency' => array(
						'#page_template' => array( 'blog.php' ),
						'blog_style'     => array( 'portfolio', 'gallery' ),
					),
					'hidden'     => true,
					'std'        => 0,
					'type'       => WEALTHCO_THEME_FREE ? 'hidden' : 'checkbox',
				),

				'blog_sidebar_info'             => array(
					'title' => esc_html__( 'Sidebar', 'wealthco' ),
					'desc'  => '',
					'type'  => 'info',
				),
				'sidebar_position_blog'         => array(
					'title'   => esc_html__( 'Sidebar position', 'wealthco' ),
					'desc'    => wp_kses_data( __( 'Select position to show sidebar', 'wealthco' ) ),
					'std'     => 'right',
					'options' => array(),
					'type'    => 'switch',
				),
				'sidebar_widgets_blog'          => array(
					'title'      => esc_html__( 'Sidebar widgets', 'wealthco' ),
					'desc'       => wp_kses_data( __( 'Select default widgets to show in the sidebar', 'wealthco' ) ),
					'dependency' => array(
						'sidebar_position_blog' => array( 'left', 'right' ),
					),
					'std'        => 'sidebar_widgets',
					'options'    => array(),
					'type'       => 'select',
				),
				'expand_content_blog'           => array(
					'title'   => esc_html__( 'Expand content', 'wealthco' ),
					'desc'    => wp_kses_data( __( 'Expand the content width if the sidebar is hidden', 'wealthco' ) ),
					'refresh' => false,
					'std'     => 1,
					'type'    => 'checkbox',
				),

				'blog_widgets_info'             => array(
					'title' => esc_html__( 'Additional widgets', 'wealthco' ),
					'desc'  => '',
					'type'  => WEALTHCO_THEME_FREE ? 'hidden' : 'info',
				),
				'widgets_above_page_blog'       => array(
					'title'   => esc_html__( 'Widgets at the top of the page', 'wealthco' ),
					'desc'    => wp_kses_data( __( 'Select widgets to show at the top of the page (above content and sidebar)', 'wealthco' ) ),
					'std'     => 'hide',
					'options' => array(),
					'type'    => WEALTHCO_THEME_FREE ? 'hidden' : 'select',
				),
				'widgets_above_content_blog'    => array(
					'title'   => esc_html__( 'Widgets above the content', 'wealthco' ),
					'desc'    => wp_kses_data( __( 'Select widgets to show at the beginning of the content area', 'wealthco' ) ),
					'std'     => 'hide',
					'options' => array(),
					'type'    => WEALTHCO_THEME_FREE ? 'hidden' : 'select',
				),
				'widgets_below_content_blog'    => array(
					'title'   => esc_html__( 'Widgets below the content', 'wealthco' ),
					'desc'    => wp_kses_data( __( 'Select widgets to show at the ending of the content area', 'wealthco' ) ),
					'std'     => 'hide',
					'options' => array(),
					'type'    => WEALTHCO_THEME_FREE ? 'hidden' : 'select',
				),
				'widgets_below_page_blog'       => array(
					'title'   => esc_html__( 'Widgets at the bottom of the page', 'wealthco' ),
					'desc'    => wp_kses_data( __( 'Select widgets to show at the bottom of the page (below content and sidebar)', 'wealthco' ) ),
					'std'     => 'hide',
					'options' => array(),
					'type'    => WEALTHCO_THEME_FREE ? 'hidden' : 'select',
				),

				'blog_advanced_info'            => array(
					'title' => esc_html__( 'Advanced settings', 'wealthco' ),
					'desc'  => '',
					'type'  => 'info',
				),
				'no_image'                      => array(
					'title' => esc_html__( 'Image placeholder', 'wealthco' ),
					'desc'  => wp_kses_data( __( 'Select or upload an image used as placeholder for posts without a featured image', 'wealthco' ) ),
					'std'   => '',
					'type'  => 'image',
				),
				'time_diff_before'              => array(
					'title' => esc_html__( 'Easy Readable Date Format', 'wealthco' ),
					'desc'  => wp_kses_data( __( "For how many days to show the easy-readable date format (e.g. '3 days ago') instead of the standard publication date", 'wealthco' ) ),
					'std'   => 5,
					'type'  => 'text',
				),
				'sticky_style'                  => array(
					'title'   => esc_html__( 'Sticky posts style', 'wealthco' ),
					'desc'    => wp_kses_data( __( 'Select style of the sticky posts output', 'wealthco' ) ),
					'std'     => 'inherit',
					'options' => array(
						'inherit' => esc_html__( 'Decorated posts', 'wealthco' ),
						'columns' => esc_html__( 'Mini-cards', 'wealthco' ),
					),
					'type'    => WEALTHCO_THEME_FREE ? 'hidden' : 'select',
				),
				'blog_animation'                => array(
					'title'      => esc_html__( 'Animation for the posts', 'wealthco' ),
					'desc'       => wp_kses_data( __( 'Select animation to show posts in the blog. Attention! Do not use any animation on pages with the "wheel to the anchor" behaviour (like a "Chess 2 columns")!', 'wealthco' ) ),
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'wealthco' ),
					),
					'dependency' => array(
						'#page_template' => array( 'blog.php' ),
					),
					'std'        => 'none',
					'options'    => array(),
					'type'       => WEALTHCO_THEME_FREE ? 'hidden' : 'select',
				),
				'meta_parts'                    => array(
					'title'      => esc_html__( 'Post meta', 'wealthco' ),
					'desc'       => wp_kses_data( __( "If your blog page is created using the 'Blog archive' page template, set up the 'Post Meta' settings in the 'Theme Options' section of that page. Post counters and Share Links are available only if plugin ThemeREX Addons is active", 'wealthco' ) )
								. '<br>'
								. wp_kses_data( __( '<b>Tip:</b> Drag items to change their order.', 'wealthco' ) ),
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'wealthco' ),
					),
					'dependency' => array(
						'#page_template' => array( 'blog.php' ),
					),
					'dir'        => 'vertical',
					'sortable'   => true,
					'std'        => 'categories=1|author=1|date=1|counters=1|share=0|edit=0',
					'options'    => array(
						'categories' => esc_html__( 'Categories', 'wealthco' ),
						'date'       => esc_html__( 'Post date', 'wealthco' ),
						'author'     => esc_html__( 'Post author', 'wealthco' ),
						'counters'   => esc_html__( 'Post counters', 'wealthco' ),
						'share'      => esc_html__( 'Share links', 'wealthco' ),
						'edit'       => esc_html__( 'Edit link', 'wealthco' ),
					),
					'type'       => WEALTHCO_THEME_FREE ? 'hidden' : 'checklist',
				),
				'counters'                      => array(
					'title'      => esc_html__( 'Post counters', 'wealthco' ),
					'desc'       => wp_kses_data( __( 'Show only selected counters. Attention! Likes and Views are available only if ThemeREX Addons is active', 'wealthco' ) ),
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'wealthco' ),
					),
					'dependency' => array(
						'#page_template' => array( 'blog.php' ),
					),
					'dir'        => 'vertical',
					'sortable'   => true,
					'std'        => 'comments=1|views=0|likes=1',
					'options'    => array(
						'views'    => esc_html__( 'Views', 'wealthco' ),
						'likes'    => esc_html__( 'Likes', 'wealthco' ),
						'comments' => esc_html__( 'Comments', 'wealthco' ),
					),
					'type'       => WEALTHCO_THEME_FREE || ! wealthco_exists_trx_addons() ? 'hidden' : 'checklist',
				),

				// Blog - Single posts
				'blog_single'                   => array(
					'title' => esc_html__( 'Single posts', 'wealthco' ),
					'desc'  => wp_kses_data( __( 'Settings of the single post', 'wealthco' ) ),
					'type'  => 'section',
				),
				'hide_featured_on_single'       => array(
					'title'    => esc_html__( 'Hide featured image on the single post', 'wealthco' ),
					'desc'     => wp_kses_data( __( "Hide featured image on the single post's pages", 'wealthco' ) ),
					'override' => array(
						'mode'    => 'page,post',
						'section' => esc_html__( 'Content', 'wealthco' ),
					),
					'std'      => 0,
					'type'     => 'checkbox',
				),
				'hide_sidebar_on_single'        => array(
					'title' => esc_html__( 'Hide sidebar on the single post', 'wealthco' ),
					'desc'  => wp_kses_data( __( "Hide sidebar on the single post's pages", 'wealthco' ) ),
					'std'   => 0,
					'type'  => 'checkbox',
				),
				'show_post_meta'                => array(
					'title' => esc_html__( 'Show post meta', 'wealthco' ),
					'desc'  => wp_kses_data( __( "Display block with post's meta: date, categories, counters, etc.", 'wealthco' ) ),
					'std'   => 1,
					'type'  => 'checkbox',
				),
				'meta_parts_post'               => array(
					'title'      => esc_html__( 'Post meta', 'wealthco' ),
					'desc'       => wp_kses_data( __( 'Meta parts for single posts. Post counters and Share Links are available only if plugin ThemeREX Addons is active', 'wealthco' ) )
								. '<br>'
								. wp_kses_data( __( '<b>Tip:</b> Drag items to change their order.', 'wealthco' ) ),
					'dependency' => array(
						'show_post_meta' => array( 1 ),
					),
					'dir'        => 'vertical',
					'sortable'   => true,
					'std'        => 'categories=0|author=1|date=1|share=0|counters=1|edit=0',
					'options'    => array(
						'categories' => esc_html__( 'Categories', 'wealthco' ),
						'date'       => esc_html__( 'Post date', 'wealthco' ),
						'author'     => esc_html__( 'Post author', 'wealthco' ),
						'counters'   => esc_html__( 'Post counters', 'wealthco' ),
						'share'      => esc_html__( 'Share links', 'wealthco' ),
						'edit'       => esc_html__( 'Edit link', 'wealthco' ),
					),
					'type'       => WEALTHCO_THEME_FREE ? 'hidden' : 'checklist',
				),
				'counters_post'                 => array(
					'title'      => esc_html__( 'Post counters', 'wealthco' ),
					'desc'       => wp_kses_data( __( 'Show only selected counters. Attention! Likes and Views are available only if plugin ThemeREX Addons is active', 'wealthco' ) ),
					'dependency' => array(
						'show_post_meta' => array( 1 ),
					),
					'dir'        => 'vertical',
					'sortable'   => true,
					'std'        => 'comments=1|views=0|likes=1',
					'options'    => array(
						'views'    => esc_html__( 'Views', 'wealthco' ),
						'likes'    => esc_html__( 'Likes', 'wealthco' ),
						'comments' => esc_html__( 'Comments', 'wealthco' ),
					),
					'type'       => WEALTHCO_THEME_FREE || ! wealthco_exists_trx_addons() ? 'hidden' : 'checklist',
				),
				'show_share_links'              => array(
					'title' => esc_html__( 'Show share links', 'wealthco' ),
					'desc'  => wp_kses_data( __( 'Display share links on the single post', 'wealthco' ) ),
					'std'   => 1,
					'type'  => ! wealthco_exists_trx_addons() ? 'hidden' : 'checkbox',
				),
				'show_author_info'              => array(
					'title' => esc_html__( 'Show author info', 'wealthco' ),
					'desc'  => wp_kses_data( __( "Display block with information about post's author", 'wealthco' ) ),
					'std'   => 1,
					'type'  => 'checkbox',
				),
				'blog_single_related_info'      => array(
					'title' => esc_html__( 'Related posts', 'wealthco' ),
					'desc'  => '',
					'type'  => 'info',
				),
				'show_related_posts'            => array(
					'title'    => esc_html__( 'Show related posts', 'wealthco' ),
					'desc'     => wp_kses_data( __( "Show section 'Related posts' on the single post's pages", 'wealthco' ) ),
					'override' => array(
						'mode'    => 'page,post',
						'section' => esc_html__( 'Content', 'wealthco' ),
					),
					'std'      => 1,
					'type'     => 'checkbox',
				),
				'related_posts'                 => array(
					'title'      => esc_html__( 'Related posts', 'wealthco' ),
					'desc'       => wp_kses_data( __( 'How many related posts should be displayed in the single post? If 0 - no related posts are shown.', 'wealthco' ) ),
					'dependency' => array(
						'show_related_posts' => array( 1 ),
					),
					'std'        => 2,
					'options'    => wealthco_get_list_range( 1, 9 ),
					'type'       => WEALTHCO_THEME_FREE ? 'hidden' : 'select',
				),
				'related_columns'               => array(
					'title'      => esc_html__( 'Related columns', 'wealthco' ),
					'desc'       => wp_kses_data( __( 'How many columns should be used to output related posts in the single page (from 2 to 4)?', 'wealthco' ) ),
					'dependency' => array(
						'show_related_posts' => array( 1 ),
					),
					'std'        => 1,
					'options'    => wealthco_get_list_range( 1, 4 ),
					//"type" => WEALTHCO_THEME_FREE ? "hidden" : "switch"
					'type'       => 'hidden',
				),
				'related_style'                 => array(
					'title'      => esc_html__( 'Related posts style', 'wealthco' ),
					'desc'       => wp_kses_data( __( 'Select style of the related posts output', 'wealthco' ) ),
					'dependency' => array(
						'show_related_posts' => array( 1 ),
					),
					'std'        => 2,
					'options'    => wealthco_get_list_styles( 1, 2 ),
					//"type" => WEALTHCO_THEME_FREE ? "hidden" : "switch"
					'type'       => 'hidden',
				),
				'blog_end'                      => array(
					'type' => 'panel_end',
				),

				// 'Colors'
				'panel_colors'                  => array(
					'title'    => esc_html__( 'Colors', 'wealthco' ),
					'desc'     => '',
					'priority' => 300,
					'type'     => 'section',
				),

				'color_schemes_info'            => array(
					'title'  => esc_html__( 'Color schemes', 'wealthco' ),
					'desc'   => wp_kses_data( __( 'Color schemes for various parts of the site. "Inherit" means that this block is used the Site color scheme (the first parameter)', 'wealthco' ) ),
					'hidden' => $hide_schemes,
					'type'   => 'info',
				),
				'color_scheme'                  => array(
					'title'    => esc_html__( 'Site Color Scheme', 'wealthco' ),
					'desc'     => '',
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Colors', 'wealthco' ),
					),
					'std'      => 'default',
					'options'  => array(),
					'refresh'  => false,
					'type'     => $hide_schemes ? 'hidden' : 'switch',
				),
				'header_scheme'                 => array(
					'title'    => esc_html__( 'Header Color Scheme', 'wealthco' ),
					'desc'     => '',
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Colors', 'wealthco' ),
					),
					'std'      => 'inherit',
					'options'  => array(),
					'refresh'  => false,
					'type'     => $hide_schemes ? 'hidden' : 'switch',
				),
				'menu_scheme'                   => array(
					'title'    => esc_html__( 'Sidemenu Color Scheme', 'wealthco' ),
					'desc'     => '',
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Colors', 'wealthco' ),
					),
					'std'      => 'inherit',
					'options'  => array(),
					'refresh'  => false,
					//'type'     => $hide_schemes || WEALTHCO_THEME_FREE ? 'hidden' : 'switch',
					'type'     => 'hidden',
				),
				'sidebar_scheme'                => array(
					'title'    => esc_html__( 'Sidebar Color Scheme', 'wealthco' ),
					'desc'     => '',
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Colors', 'wealthco' ),
					),
					'std'      => 'inherit',
					'options'  => array(),
					'refresh'  => false,
					'type'     => $hide_schemes ? 'hidden' : 'switch',
				),
				'footer_scheme'                 => array(
					'title'    => esc_html__( 'Footer Color Scheme', 'wealthco' ),
					'desc'     => '',
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Colors', 'wealthco' ),
					),
					'std'      => 'dark',
					'options'  => array(),
					'refresh'  => false,
					'type'     => $hide_schemes ? 'hidden' : 'switch',
				),

				'color_scheme_editor_info'      => array(
					'title' => esc_html__( 'Color scheme editor', 'wealthco' ),
					'desc'  => wp_kses_data( __( 'Select color scheme to modify. Attention! Only those sections in the site will be changed which this scheme was assigned to', 'wealthco' ) ),
					'type'  => 'info',
				),
				'scheme_storage'                => array(
					'title'       => esc_html__( 'Color scheme editor', 'wealthco' ),
					'desc'        => '',
					'std'         => '$wealthco_get_scheme_storage',
					'refresh'     => false,
					'colorpicker' => 'tiny',
					'type'        => 'scheme_editor',
				),

				// 'Hidden'
				'media_title'                   => array(
					'title'    => esc_html__( 'Media title', 'wealthco' ),
					'desc'     => wp_kses_data( __( 'Used as title for the audio and video item in this post', 'wealthco' ) ),
					'override' => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Content', 'wealthco' ),
					),
					'hidden'   => true,
					'std'      => '',
					'type'     => WEALTHCO_THEME_FREE ? 'hidden' : 'text',
				),
				'media_author'                  => array(
					'title'    => esc_html__( 'Media author', 'wealthco' ),
					'desc'     => wp_kses_data( __( 'Used as author name for the audio and video item in this post', 'wealthco' ) ),
					'override' => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Content', 'wealthco' ),
					),
					'hidden'   => true,
					'std'      => '',
					'type'     => WEALTHCO_THEME_FREE ? 'hidden' : 'text',
				),

				// Internal options.
				// Attention! Don't change any options in the section below!
				// Use huge priority to call render this elements after all options!
				'reset_options'                 => array(
					'title'    => '',
					'desc'     => '',
					'std'      => '0',
					'priority' => 10000,
					'type'     => 'hidden',
				),

				'last_option'                   => array(     // Need to manually call action to include Tiny MCE scripts
					'title' => '',
					'desc'  => '',
					'std'   => 1,
					'type'  => 'hidden',
				),

			)
		);

		// Prepare panel 'Fonts'
		// -------------------------------------------------------------
		$fonts = array(

			// 'Fonts'
			'fonts'             => array(
				'title'    => esc_html__( 'Typography', 'wealthco' ),
				'desc'     => '',
				'priority' => 200,
				'type'     => 'panel',
			),

			// Fonts - Load_fonts
			'load_fonts'        => array(
				'title' => esc_html__( 'Load fonts', 'wealthco' ),
				'desc'  => wp_kses_data( __( 'Specify fonts to load when theme start. You can use them in the base theme elements: headers, text, menu, links, input fields, etc.', 'wealthco' ) )
						. '<br>'
						. wp_kses_data( __( 'Attention! Press "Refresh" button to reload preview area after the all fonts are changed', 'wealthco' ) ),
				'type'  => 'section',
			),
			'load_fonts_subset' => array(
				'title'   => esc_html__( 'Google fonts subsets', 'wealthco' ),
				'desc'    => wp_kses_data( __( 'Specify comma separated list of the subsets which will be load from Google fonts', 'wealthco' ) )
						. '<br>'
						. wp_kses_data( __( 'Available subsets are: latin,latin-ext,cyrillic,cyrillic-ext,greek,greek-ext,vietnamese', 'wealthco' ) ),
				'class'   => 'wealthco_column-1_3 wealthco_new_row',
				'refresh' => false,
				'std'     => '$wealthco_get_load_fonts_subset',
				'type'    => 'text',
			),
		);

		for ( $i = 1; $i <= wealthco_get_theme_setting( 'max_load_fonts' ); $i++ ) {
			if ( wealthco_get_value_gp( 'page' ) != 'theme_options' ) {
				$fonts[ "load_fonts-{$i}-info" ] = array(
					// Translators: Add font's number - 'Font 1', 'Font 2', etc
					'title' => esc_html( sprintf( __( 'Font %s', 'wealthco' ), $i ) ),
					'desc'  => '',
					'type'  => 'info',
				);
			}
			$fonts[ "load_fonts-{$i}-name" ]   = array(
				'title'   => esc_html__( 'Font name', 'wealthco' ),
				'desc'    => '',
				'class'   => 'wealthco_column-1_3 wealthco_new_row',
				'refresh' => false,
				'std'     => '$wealthco_get_load_fonts_option',
				'type'    => 'text',
			);
			$fonts[ "load_fonts-{$i}-family" ] = array(
				'title'   => esc_html__( 'Font family', 'wealthco' ),
				'desc'    => $i == 1
							? wp_kses_data( __( 'Select font family to use it if font above is not available', 'wealthco' ) )
							: '',
				'class'   => 'wealthco_column-1_3',
				'refresh' => false,
				'std'     => '$wealthco_get_load_fonts_option',
				'options' => array(
					'inherit'    => esc_html__( 'Inherit', 'wealthco' ),
					'serif'      => esc_html__( 'serif', 'wealthco' ),
					'sans-serif' => esc_html__( 'sans-serif', 'wealthco' ),
					'monospace'  => esc_html__( 'monospace', 'wealthco' ),
					'cursive'    => esc_html__( 'cursive', 'wealthco' ),
					'fantasy'    => esc_html__( 'fantasy', 'wealthco' ),
				),
				'type'    => 'select',
			);
			$fonts[ "load_fonts-{$i}-styles" ] = array(
				'title'   => esc_html__( 'Font styles', 'wealthco' ),
				'desc'    => $i == 1
							? wp_kses_data( __( 'Font styles used only for the Google fonts. This is a comma separated list of the font weight and styles. For example: 400,400italic,700', 'wealthco' ) )
								. '<br>'
								. wp_kses_data( __( 'Attention! Each weight and style increase download size! Specify only used weights and styles.', 'wealthco' ) )
							: '',
				'class'   => 'wealthco_column-1_3',
				'refresh' => false,
				'std'     => '$wealthco_get_load_fonts_option',
				'type'    => 'text',
			);
		}
		$fonts['load_fonts_end'] = array(
			'type' => 'section_end',
		);

		// Fonts - H1..6, P, Info, Menu, etc.
		$theme_fonts = wealthco_get_theme_fonts();
		foreach ( $theme_fonts as $tag => $v ) {
			$fonts[ "{$tag}_section" ] = array(
				'title' => ! empty( $v['title'] )
								? $v['title']
								// Translators: Add tag's name to make title 'H1 settings', 'P settings', etc.
								: esc_html( sprintf( __( '%s settings', 'wealthco' ), $tag ) ),
				'desc'  => ! empty( $v['description'] )
								? $v['description']
								// Translators: Add tag's name to make description
								: wp_kses_post( sprintf( __( 'Font settings of the "%s" tag.', 'wealthco' ), $tag ) ),
				'type'  => 'section',
			);

			foreach ( $v as $css_prop => $css_value ) {
				if ( in_array( $css_prop, array( 'title', 'description' ) ) ) {
					continue;
				}
				$options    = '';
				$type       = 'text';
				$load_order = 1;
				$title      = ucfirst( str_replace( '-', ' ', $css_prop ) );
				if ( $css_prop == 'font-family' ) {
					$type       = 'select';
					$options    = array();
					$load_order = 2;        // Load this option's value after all options are loaded (use option 'load_fonts' to build fonts list)
				} elseif ( $css_prop == 'font-weight' ) {
					$type    = 'select';
					$options = array(
						'inherit' => esc_html__( 'Inherit', 'wealthco' ),
						'100'     => esc_html__( '100 (Light)', 'wealthco' ),
						'200'     => esc_html__( '200 (Light)', 'wealthco' ),
						'300'     => esc_html__( '300 (Thin)', 'wealthco' ),
						'400'     => esc_html__( '400 (Normal)', 'wealthco' ),
						'500'     => esc_html__( '500 (Semibold)', 'wealthco' ),
						'600'     => esc_html__( '600 (Semibold)', 'wealthco' ),
						'700'     => esc_html__( '700 (Bold)', 'wealthco' ),
						'800'     => esc_html__( '800 (Black)', 'wealthco' ),
						'900'     => esc_html__( '900 (Black)', 'wealthco' ),
					);
				} elseif ( $css_prop == 'font-style' ) {
					$type    = 'select';
					$options = array(
						'inherit' => esc_html__( 'Inherit', 'wealthco' ),
						'normal'  => esc_html__( 'Normal', 'wealthco' ),
						'italic'  => esc_html__( 'Italic', 'wealthco' ),
					);
				} elseif ( $css_prop == 'text-decoration' ) {
					$type    = 'select';
					$options = array(
						'inherit'      => esc_html__( 'Inherit', 'wealthco' ),
						'none'         => esc_html__( 'None', 'wealthco' ),
						'underline'    => esc_html__( 'Underline', 'wealthco' ),
						'overline'     => esc_html__( 'Overline', 'wealthco' ),
						'line-through' => esc_html__( 'Line-through', 'wealthco' ),
					);
				} elseif ( $css_prop == 'text-transform' ) {
					$type    = 'select';
					$options = array(
						'inherit'    => esc_html__( 'Inherit', 'wealthco' ),
						'none'       => esc_html__( 'None', 'wealthco' ),
						'uppercase'  => esc_html__( 'Uppercase', 'wealthco' ),
						'lowercase'  => esc_html__( 'Lowercase', 'wealthco' ),
						'capitalize' => esc_html__( 'Capitalize', 'wealthco' ),
					);
				}
				$fonts[ "{$tag}_{$css_prop}" ] = array(
					'title'      => $title,
					'desc'       => '',
					'class'      => 'wealthco_column-1_5',
					'refresh'    => false,
					'load_order' => $load_order,
					'std'        => '$wealthco_get_theme_fonts_option',
					'options'    => $options,
					'type'       => $type,
				);
			}

			$fonts[ "{$tag}_section_end" ] = array(
				'type' => 'section_end',
			);
		}

		$fonts['fonts_end'] = array(
			'type' => 'panel_end',
		);

		// Add fonts parameters to Theme Options
		wealthco_storage_set_array_before( 'options', 'panel_colors', $fonts );

		// Add Header Video if WP version < 4.7
		// -----------------------------------------------------
		if ( ! function_exists( 'get_header_video_url' ) ) {
			wealthco_storage_set_array_after(
				'options', 'header_image_override', 'header_video', array(
					'title'    => esc_html__( 'Header video', 'wealthco' ),
					'desc'     => wp_kses_data( __( 'Select video to use it as background for the header', 'wealthco' ) ),
					'override' => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Header', 'wealthco' ),
					),
					'std'      => '',
					'type'     => 'video',
				)
			);
		}

		// Add option 'logo' if WP version < 4.5
		// or 'custom_logo' if current page is 'Theme Options'
		// ------------------------------------------------------
		if ( ! function_exists( 'the_custom_logo' ) || ( isset( $_REQUEST['page'] ) && $_REQUEST['page'] == 'theme_options' ) ) {
			wealthco_storage_set_array_before(
				'options', 'logo_retina', function_exists( 'the_custom_logo' ) ? 'custom_logo' : 'logo', array(
					'title'    => esc_html__( 'Logo', 'wealthco' ),
					'desc'     => wp_kses_data( __( 'Select or upload the site logo', 'wealthco' ) ),
					'class'    => 'wealthco_column-1_2 wealthco_new_row',
					'priority' => 60,
					'std'      => '',
					'type'     => 'image',
				)
			);
		}

	}
}


// Returns a list of options that can be overridden for CPT
if ( ! function_exists( 'wealthco_options_get_list_cpt_options' ) ) {
	function wealthco_options_get_list_cpt_options( $cpt, $title = '' ) {
		if ( empty( $title ) ) {
			$title = ucfirst( $cpt );
		}
		return array(
			"header_info_{$cpt}"            => array(
				'title' => esc_html__( 'Header', 'wealthco' ),
				'desc'  => '',
				'type'  => 'info',
			),
			"header_type_{$cpt}"            => array(
				'title'   => esc_html__( 'Header style', 'wealthco' ),
				'desc'    => wp_kses_data( __( 'Choose whether to use the default header or header Layouts (available only if the ThemeREX Addons is activated)', 'wealthco' ) ),
				'std'     => 'inherit',
				'options' => wealthco_get_list_header_footer_types( true ),
				'type'    => WEALTHCO_THEME_FREE ? 'hidden' : 'switch',
			),
			"header_style_{$cpt}"           => array(
				'title'      => esc_html__( 'Select custom layout', 'wealthco' ),
				// Translators: Add CPT name to the description
				'desc'       => wp_kses_data( sprintf( __( 'Select custom layout to display the site header on the %s pages', 'wealthco' ), $title ) ),
				'dependency' => array(
					"header_type_{$cpt}" => array( 'custom' ),
				),
				'std'        => 'inherit',
				'options'    => array(),
				'type'       => WEALTHCO_THEME_FREE ? 'hidden' : 'select',
			),
			"header_position_{$cpt}"        => array(
				'title'   => esc_html__( 'Header position', 'wealthco' ),
				// Translators: Add CPT name to the description
				'desc'    => wp_kses_data( sprintf( __( 'Select position to display the site header on the %s pages', 'wealthco' ), $title ) ),
				'std'     => 'inherit',
				'options' => array(),
				'type'    => WEALTHCO_THEME_FREE ? 'hidden' : 'switch',
			),
			"header_image_override_{$cpt}"  => array(
				'title'   => esc_html__( 'Header image override', 'wealthco' ),
				'desc'    => wp_kses_data( __( "Allow override the header image with the post's featured image", 'wealthco' ) ),
				'std'     => 'inherit',
				'options' => array(
					'inherit' => esc_html__( 'Inherit', 'wealthco' ),
					1         => esc_html__( 'Yes', 'wealthco' ),
					0         => esc_html__( 'No', 'wealthco' ),
				),
				'type'    => WEALTHCO_THEME_FREE ? 'hidden' : 'switch',
			),
			"header_widgets_{$cpt}"         => array(
				'title'   => esc_html__( 'Header widgets', 'wealthco' ),
				// Translators: Add CPT name to the description
				'desc'    => wp_kses_data( sprintf( __( 'Select set of widgets to show in the header on the %s pages', 'wealthco' ), $title ) ),
				'std'     => 'hide',
				'options' => array(),
				'type'    => 'select',
			),

			"sidebar_info_{$cpt}"           => array(
				'title' => esc_html__( 'Sidebar', 'wealthco' ),
				'desc'  => '',
				'type'  => 'info',
			),
			"sidebar_position_{$cpt}"       => array(
				'title'   => esc_html__( 'Sidebar position', 'wealthco' ),
				// Translators: Add CPT name to the description
				'desc'    => wp_kses_data( sprintf( __( 'Select position to show sidebar on the %s pages', 'wealthco' ), $title ) ),
				'std'     => 'left',
				'options' => array(),
				'type'    => 'switch',
			),
			"sidebar_widgets_{$cpt}"        => array(
				'title'      => esc_html__( 'Sidebar widgets', 'wealthco' ),
				// Translators: Add CPT name to the description
				'desc'       => wp_kses_data( sprintf( __( 'Select sidebar to show on the %s pages', 'wealthco' ), $title ) ),
				'dependency' => array(
					"sidebar_position_{$cpt}" => array( 'left', 'right' ),
				),
				'std'        => 'hide',
				'options'    => array(),
				'type'       => 'select',
			),
			"hide_sidebar_on_single_{$cpt}" => array(
				'title'   => esc_html__( 'Hide sidebar on the single pages', 'wealthco' ),
				'desc'    => wp_kses_data( __( 'Hide sidebar on the single page', 'wealthco' ) ),
				'std'     => 'inherit',
				'options' => array(
					'inherit' => esc_html__( 'Inherit', 'wealthco' ),
					1         => esc_html__( 'Hide', 'wealthco' ),
					0         => esc_html__( 'Show', 'wealthco' ),
				),
				'type'    => 'switch',
			),

			"footer_info_{$cpt}"            => array(
				'title' => esc_html__( 'Footer', 'wealthco' ),
				'desc'  => '',
				'type'  => 'info',
			),
			"footer_type_{$cpt}"            => array(
				'title'   => esc_html__( 'Footer style', 'wealthco' ),
				'desc'    => wp_kses_data( __( 'Choose whether to use the default footer or footer Layouts (available only if the ThemeREX Addons is activated)', 'wealthco' ) ),
				'std'     => 'inherit',
				'options' => wealthco_get_list_header_footer_types( true ),
				'type'    => WEALTHCO_THEME_FREE ? 'hidden' : 'switch',
			),
			"footer_style_{$cpt}"           => array(
				'title'      => esc_html__( 'Select custom layout', 'wealthco' ),
				'desc'       => wp_kses_data( __( 'Select custom layout to display the site footer', 'wealthco' ) ),
				'std'        => 'inherit',
				'dependency' => array(
					"footer_type_{$cpt}" => array( 'custom' ),
				),
				'options'    => array(),
				'type'       => WEALTHCO_THEME_FREE ? 'hidden' : 'select',
			),
			"footer_widgets_{$cpt}"         => array(
				'title'      => esc_html__( 'Footer widgets', 'wealthco' ),
				'desc'       => wp_kses_data( __( 'Select set of widgets to show in the footer', 'wealthco' ) ),
				'dependency' => array(
					"footer_type_{$cpt}" => array( 'default' ),
				),
				'std'        => 'footer_widgets',
				'options'    => array(),
				'type'       => 'select',
			),
			"footer_columns_{$cpt}"         => array(
				'title'      => esc_html__( 'Footer columns', 'wealthco' ),
				'desc'       => wp_kses_data( __( 'Select number columns to show widgets in the footer. If 0 - autodetect by the widgets count', 'wealthco' ) ),
				'dependency' => array(
					"footer_type_{$cpt}"    => array( 'default' ),
					"footer_widgets_{$cpt}" => array( '^hide' ),
				),
				'std'        => 0,
				'options'    => wealthco_get_list_range( 0, 6 ),
				'type'       => 'select',
			),
			"footer_wide_{$cpt}"            => array(
				'title'      => esc_html__( 'Footer fullwidth', 'wealthco' ),
				'desc'       => wp_kses_data( __( 'Do you want to stretch the footer to the entire window width?', 'wealthco' ) ),
				'dependency' => array(
					"footer_type_{$cpt}" => array( 'default' ),
				),
				'std'        => 0,
				'type'       => 'checkbox',
			),

			"widgets_info_{$cpt}"           => array(
				'title' => esc_html__( 'Additional panels', 'wealthco' ),
				'desc'  => '',
				'type'  => WEALTHCO_THEME_FREE ? 'hidden' : 'info',
			),
			"widgets_above_page_{$cpt}"     => array(
				'title'   => esc_html__( 'Widgets at the top of the page', 'wealthco' ),
				'desc'    => wp_kses_data( __( 'Select widgets to show at the top of the page (above content and sidebar)', 'wealthco' ) ),
				'std'     => 'hide',
				'options' => array(),
				'type'    => WEALTHCO_THEME_FREE ? 'hidden' : 'select',
			),
			"widgets_above_content_{$cpt}"  => array(
				'title'   => esc_html__( 'Widgets above the content', 'wealthco' ),
				'desc'    => wp_kses_data( __( 'Select widgets to show at the beginning of the content area', 'wealthco' ) ),
				'std'     => 'hide',
				'options' => array(),
				'type'    => WEALTHCO_THEME_FREE ? 'hidden' : 'select',
			),
			"widgets_below_content_{$cpt}"  => array(
				'title'   => esc_html__( 'Widgets below the content', 'wealthco' ),
				'desc'    => wp_kses_data( __( 'Select widgets to show at the ending of the content area', 'wealthco' ) ),
				'std'     => 'hide',
				'options' => array(),
				'type'    => WEALTHCO_THEME_FREE ? 'hidden' : 'select',
			),
			"widgets_below_page_{$cpt}"     => array(
				'title'   => esc_html__( 'Widgets at the bottom of the page', 'wealthco' ),
				'desc'    => wp_kses_data( __( 'Select widgets to show at the bottom of the page (below content and sidebar)', 'wealthco' ) ),
				'std'     => 'hide',
				'options' => array(),
				'type'    => WEALTHCO_THEME_FREE ? 'hidden' : 'select',
			),
		);
	}
}


// Return lists with choises when its need in the admin mode
if ( ! function_exists( 'wealthco_options_get_list_choises' ) ) {
	add_filter( 'wealthco_filter_options_get_list_choises', 'wealthco_options_get_list_choises', 10, 2 );
	function wealthco_options_get_list_choises( $list, $id ) {
		if ( is_array( $list ) && count( $list ) == 0 ) {
			if ( strpos( $id, 'header_style' ) === 0 ) {
				$list = wealthco_get_list_header_styles( strpos( $id, 'header_style_' ) === 0 );
			} elseif ( strpos( $id, 'header_position' ) === 0 ) {
				$list = wealthco_get_list_header_positions( strpos( $id, 'header_position_' ) === 0 );
			} elseif ( strpos( $id, 'header_widgets' ) === 0 ) {
				$list = wealthco_get_list_sidebars( strpos( $id, 'header_widgets_' ) === 0, true );
			} elseif ( strpos( $id, '_scheme' ) > 0 ) {
				$list = wealthco_get_list_schemes( $id != 'color_scheme' );
			} elseif ( strpos( $id, 'sidebar_widgets' ) === 0 ) {
				$list = wealthco_get_list_sidebars( strpos( $id, 'sidebar_widgets_' ) === 0, true );
			} elseif ( strpos( $id, 'sidebar_position' ) === 0 ) {
				$list = wealthco_get_list_sidebars_positions( strpos( $id, 'sidebar_position_' ) === 0 );
			} elseif ( strpos( $id, 'widgets_above_page' ) === 0 ) {
				$list = wealthco_get_list_sidebars( strpos( $id, 'widgets_above_page_' ) === 0, true );
			} elseif ( strpos( $id, 'widgets_above_content' ) === 0 ) {
				$list = wealthco_get_list_sidebars( strpos( $id, 'widgets_above_content_' ) === 0, true );
			} elseif ( strpos( $id, 'widgets_below_page' ) === 0 ) {
				$list = wealthco_get_list_sidebars( strpos( $id, 'widgets_below_page_' ) === 0, true );
			} elseif ( strpos( $id, 'widgets_below_content' ) === 0 ) {
				$list = wealthco_get_list_sidebars( strpos( $id, 'widgets_below_content_' ) === 0, true );
			} elseif ( strpos( $id, 'footer_style' ) === 0 ) {
				$list = wealthco_get_list_footer_styles( strpos( $id, 'footer_style_' ) === 0 );
			} elseif ( strpos( $id, 'footer_widgets' ) === 0 ) {
				$list = wealthco_get_list_sidebars( strpos( $id, 'footer_widgets_' ) === 0, true );
			} elseif ( strpos( $id, 'blog_style' ) === 0 ) {
				$list = wealthco_get_list_blog_styles( strpos( $id, 'blog_style_' ) === 0 );
			} elseif ( strpos( $id, 'post_type' ) === 0 ) {
				$list = wealthco_get_list_posts_types();
			} elseif ( strpos( $id, 'parent_cat' ) === 0 ) {
				$list = wealthco_array_merge( array( 0 => esc_html__( '- Select category -', 'wealthco' ) ), wealthco_get_list_categories() );
			} elseif ( strpos( $id, 'blog_animation' ) === 0 ) {
				$list = wealthco_get_list_animations_in();
			} elseif ( $id == 'color_scheme_editor' ) {
				$list = wealthco_get_list_schemes();
			} elseif ( strpos( $id, '_font-family' ) > 0 ) {
				$list = wealthco_get_list_load_fonts( true );
			}
		}
		return $list;
	}
}

