<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
 
/**
 * Quarty About Me Widget.
 *
 * @since 1.0
 */
class Quarty_About_Resume_Widget extends Widget_Base {

	public function get_name() {
		return 'quarty-about-resume';
	}

	public function get_title() {
		return esc_html__( 'About Me', 'quarty-plugin' );
	}

	public function get_icon() {
		return 'eicon-parallax';
	}

	public function get_categories() {
		return [ 'quarty-category' ];
	}

	/**
	 * Register widget controls.
	 *
	 * @since 1.0
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'content_tab',
			[
				'label' => esc_html__( 'Content', 'quarty-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'name',
			[
				'label'       => esc_html__( 'Name', 'quarty-plugin' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'placeholder' => esc_html__( 'Enter name', 'quarty-plugin' ),
				'default'     => esc_html__( 'Name', 'quarty-plugin' ),
			]
		);

		$this->add_control(
			'subname',
			[
				'label'       => esc_html__( 'Subname', 'quarty-plugin' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'placeholder' => esc_html__( 'Enter subname', 'quarty-plugin' ),
				'default'     => esc_html__( 'Subname', 'quarty-plugin' ),
			]
		);

		$this->add_control(
			'image',
			[
				'label'       => esc_html__( 'Image', 'quarty-plugin' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'label', [
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__( 'Name', 'quarty-plugin' ),
				'label_block' => true,
				'placeholder' => esc_html__( 'Enter label', 'quarty-plugin' ),
				'default'	=> esc_html__( 'Label', 'quarty-plugin' ),
			]
		);

		$repeater->add_control(
			'value', [
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__( 'Value', 'quarty-plugin' ),
				'label_block' => true,
				'placeholder' => esc_html__( 'Enter value', 'quarty-plugin' ),
				'default'	=> esc_html__( 'Value', 'quarty-plugin' ),
			]
		);

		$this->add_control(
			'list',
			[
				'label' => esc_html__( 'Info List', 'quarty-plugin' ),
				'type' => Controls_Manager::REPEATER,
				'prevent_empty' => false,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ label }}}',
			]
		);

		$repeater2 = new \Elementor\Repeater();

		$repeater2->add_control(
			'title', [
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__( 'Enter title', 'quarty-plugin' ),
				'default'	=> esc_html__( 'Enter title', 'quarty-plugin' ),
			]
		);

		$repeater2->add_control(
			'icon', [
				'type' => Controls_Manager::ICON,
				'label' => esc_html__( 'Icon', 'quarty-plugin' ),
				'default'	=> 'fa fa-facebook',
			]
		);

		$repeater2->add_control(
			'url', [
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__( 'URL', 'quarty-plugin' ),
				'default'	=> esc_html__( 'URL', 'quarty-plugin' ),
			]
		);

		$this->add_control(
			'social_list',
			[
				'label' => esc_html__( 'Social List', 'quarty-plugin' ),
				'type' => Controls_Manager::REPEATER,
				'prevent_empty' => false,
				'fields' => $repeater2->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'content_styling',
			[
				'label'     => esc_html__( 'Content', 'quarty-plugin' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'name_color',
			[
				'label'     => esc_html__( 'Name Color', 'quarty-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .qrt-member-about h3' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'name_typography',
				'label'     => esc_html__( 'Name Typography', 'quarty-plugin' ),
				'selector' => '{{WRAPPER}} .qrt-member-about h3',
			]
		);

		$this->add_control(
			'subname_color',
			[
				'label'     => esc_html__( 'Subname Color', 'quarty-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .qrt-member-about .qrt-el-suptitle' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'subname_typography',
				'label'     => esc_html__( 'Subname Typography', 'quarty-plugin' ),
				'selector' => '{{WRAPPER}} .qrt-member-about .qrt-el-suptitle',
			]
		);

		$this->add_control(
			'label_color',
			[
				'label'     => esc_html__( 'Label Color', 'quarty-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .qrt-table li h5' => 'color: {{VALUE}};',
				],
			]
		);		

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'label_typography',
				'label'     => esc_html__( 'Label Typography', 'quarty-plugin' ),
				'selector' => '{{WRAPPER}} .qrt-table li h5',
			]
		);

		$this->add_control(
			'value_color',
			[
				'label'     => esc_html__( 'Value Color', 'quarty-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .qrt-table li > span' => 'color: {{VALUE}};',
				],
			]
		);		

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'value_typography',
				'label'     => esc_html__( 'Value Typography', 'quarty-plugin' ),
				'selector' => '{{WRAPPER}} .qrt-table li > span',
			]
		);

		$this->add_control(
			'social_button_color',
			[
				'label'     => esc_html__( 'Social Button Color', 'quarty-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .qrt-social-list li a' => 'color: {{VALUE}};',
					'{{WRAPPER}} .qrt-social-list li a' => 'border-color: {{VALUE}};',
				],
			]
		);
		
		$this->end_controls_section();
	}

	/**
	 * Render widget output on the frontend.
	 *
	 * @since 1.0
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		$this->add_inline_editing_attributes( 'name', 'basic' );
		$this->add_inline_editing_attributes( 'subname', 'basic' );

		?>

		<div class="row">
          <div class="col-lg-6 col-md-12">
            <div class="qrt-about-me-cover">
              <?php if ( $settings['image'] ) : $image = wp_get_attachment_image_url( $settings['image']['id'], 'quarty_1920xAuto' ); ?>
              <img src="<?php echo esc_url( $image ); ?>" alt="<?php echo esc_attr( $settings['name'] ); ?>">
          	  <?php endif; ?>
          	  <?php if ( get_field( 'page_layout' ) != 1 ) : ?>
          	  <div class="qrt-hint-frame qrt-left">
                  <div class="qrt-scroll-hint">
                    <span></span>
                  </div>
              </div>
          	  <?php endif; ?>
            </div>
          </div>
          <div class="col-lg-6 col-md-12 align-self-center">

            <div class="qrt-member-about">
              <?php if ( $settings['name'] || $settings['subname'] ) : ?>
              <?php if ( $settings['name'] ) : ?>
              <h3 class="qrt-mb-5">
              	<span <?php echo $this->get_render_attribute_string( 'name' ); ?>>
        			<?php echo wp_kses_post( $settings['name'] ); ?>
        		</span>
              </h3>
              <?php endif; ?>
              <?php if ( $settings['subname'] ) : ?>
              <div class="qrt-el-suptitle">
              	<span <?php echo $this->get_render_attribute_string( 'subname' ); ?>>
        			<?php echo wp_kses_post( $settings['subname'] ); ?>
        		</span>
              </div>
              <?php endif; ?>
              <div class="qrt-divider"></div>
              <?php endif; ?>

              <?php if ( $settings['list'] ) : ?>
              <ul class="qrt-table">
                <?php foreach ( $settings['list'] as $index => $item ) : 
				$item_label = $this->get_repeater_setting_key( 'label', 'list', $index );
				$this->add_inline_editing_attributes( $item_label, 'basic' );

				$item_value = $this->get_repeater_setting_key( 'value', 'list', $index );
				$this->add_inline_editing_attributes( $item_value, 'basic' );
                ?>
                <li>
                  <h5>
                  	<span <?php echo $this->get_render_attribute_string( $item_label ); ?>>
        				<?php echo wp_kses_post( $item['label'] ); ?>
        			</span>
                  </h5>
                  <span <?php echo $this->get_render_attribute_string( $item_value ); ?>>
					<?php echo esc_html( $item['value'] ); ?>
				  </span>
				</li>
				<?php endforeach; ?>
              </ul>
              <div class="qrt-divider"></div>
              <?php endif; ?>

              <?php if ( $settings['social_list'] ) : ?>
              <ul class="qrt-social-list">
                <?php foreach ( $settings['social_list'] as $index => $item ) : ?>
                <li>
                	<a target="_blank" title="<?php echo esc_attr( $item['title'] ); ?>" href="<?php echo esc_url( $item['url'] ); ?>" class="qrt-cursor-scale qrt-cursor-color">
                		<i class="<?php echo esc_attr( $item['icon'] ); ?>"></i>
                	</a>
                </li>
                <?php endforeach; ?>
              </ul>
              <?php endif; ?>
            </div>

          </div>
        </div>

		<?php
	}

	/**
	 * Render widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function content_template() {
		?>

		<div class="row">
          <div class="col-lg-6 col-md-12">
            <div class="qrt-about-me-cover">
              <# if ( settings.image ) { #>
              <img src="{{{ settings.image.url }}}" alt="{{{ settings.name }}}">
          	  <# } #>
            </div>
          </div>
          <div class="col-lg-6 col-md-12 align-self-center">

            <div class="qrt-member-about">
              <# if ( settings.name || settings.subname ) { #>
              <# if ( settings.name ) { #>
              <h3 class="qrt-mb-5">
              	<span {{{ view.getRenderAttributeString( 'name' ) }}}>
	        		{{{ settings.name }}}
	        	</span>
              </h3>
              <# } #>
              <# if ( settings.subname ) { #>
              <div class="qrt-el-suptitle">
              	<span {{{ view.getRenderAttributeString( 'subname' ) }}}>
	        		{{{ settings.subname }}}
	        	</span>
              </div>
              <# } #>
              <div class="qrt-divider"></div>
              <# } #>

              <# if ( settings.list ) { #>
              <ul class="qrt-table">
                <# _.each( settings.list, function( item, index ) { 
				  var item_label = view.getRepeaterSettingKey( 'label', 'list', index );
				  view.addInlineEditingAttributes( item_label, 'basic' );

				  var item_value = view.getRepeaterSettingKey( 'value', 'list', index );
				  view.addInlineEditingAttributes( item_value, 'basic' );
				#>
                <li>
                  <h5>
                  	<span {{{ view.getRenderAttributeString( item_label ) }}}>
	        			{{{ item.label }}}
	        		</span>
                  </h5>
                  <span {{{ view.getRenderAttributeString( item_value ) }}}>
						{{{ item.value }}}
		          </span>
				</li>
				<# }); #>
              </ul>
              <div class="qrt-divider"></div>
              <# } #>

              <# if ( settings.social_list ) { #>
              <ul class="qrt-social-list">
                <# _.each( settings.social_list, function( item, index ) { #>
                <li>
                	<a target="_blank" title="{{{ item.title }}}" href="{{{ item.url }}}" class="qrt-cursor-scale qrt-cursor-color">
                		<i class="{{{ item.icon }}}"></i>
                	</a>
                </li>
                <# }); #>
              </ul>
              <# } #>
            </div>

          </div>
        </div>

		<?php 
	}
}

Plugin::instance()->widgets_manager->register_widget_type( new Quarty_About_Resume_Widget() );