<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
 
/**
 * Quarty Contact Map Widget.
 *
 * @since 1.0
 */

class Quarty_Contact_Map_Widget extends Widget_Base {

	public function get_name() {
		return 'quarty-contact-map';
	}

	public function get_title() {
		return esc_html__( 'Contact Map', 'quarty-plugin' );
	}

	public function get_icon() {
		return 'eicon-parallax';
	}

	public function get_categories() {
		return [ 'quarty-category' ];
	}

	/**
	 * Register widget controls.
	 *
	 * @since 1.0
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'heading_tab',
			[
				'label' => esc_html__( 'Title', 'quarty-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'title',
			[
				'label'       => esc_html__( 'Title', 'quarty-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter title', 'quarty-plugin' ),
				'default'     => esc_html__( 'Title', 'quarty-plugin' ),
			]
		);

		$this->add_control(
			'title_tag',
			[
				'label'       => esc_html__( 'Title Tag', 'quarty-plugin' ),
				'type'        => Controls_Manager::SELECT,
				'default' => 'h4',
				'options' => [
					'h1'  => __( 'H1', 'quarty-plugin' ),
					'h2' => __( 'H2', 'quarty-plugin' ),
					'h3' => __( 'H3', 'quarty-plugin' ),
					'h4' => __( 'H4', 'quarty-plugin' ),
					'div' => __( 'DIV', 'quarty-plugin' ),
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'map_tab',
			[
				'label' => esc_html__( 'Map', 'tastyc-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'map_long',
			[
				'label'       => esc_html__( 'Long', 'tastyc-plugin' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Enter long value', 'tastyc-plugin' ),
				'default'     => esc_html__( '70.123', 'tastyc-plugin' ),
			]
		);
		
		$this->add_control(
			'map_lat',
			[
				'label'       => esc_html__( 'Lat', 'tastyc-plugin' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Enter lat value', 'tastyc-plugin' ),
				'default'     => esc_html__( '50.123', 'tastyc-plugin' ),
			]
		);

		$this->add_control(
			'map_zoom',
			[
				'label'       => esc_html__( 'Zoom', 'tastyc-plugin' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Enter zoom value', 'tastyc-plugin' ),
				'default'     => esc_html__( '13', 'tastyc-plugin' ),
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'title_styling',
			[
				'label'     => esc_html__( 'Title', 'quarty-plugin' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Color', 'quarty-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .qrt-section .qrt-title-h' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typography',
				'selector' => '{{WRAPPER}} .qrt-section .qrt-title-h',
			]
		);

		$this->end_controls_section();
	}

	/**
	 * Render widget output on the frontend.
	 *
	 * @since 1.0
	 */
	protected function render() { 
		$settings = $this->get_settings_for_display();
		
		$this->add_inline_editing_attributes( 'title', 'basic' );

		?>

		<div class="qrt-section qrt-section-sf">
			<div class="row">
              <?php if ( $settings['title'] ) : ?>
              <div class="col-lg-12">
                <<?php echo esc_attr( $settings['title_tag'] ); ?> class="qrt-mb-40 qrt-title-h">
            		<span <?php echo $this->get_render_attribute_string( 'title' ); ?>>
		          		<?php echo wp_kses_post( $settings['title'] ); ?>
		         	</span>
            	</<?php echo esc_attr( $settings['title_tag'] ); ?>>
              </div>
              <?php endif; ?>

              <?php if ( $settings['map_long'] || $settings['map_lat'] ) : ?>
              <div class="col-lg-12">
              	<div class="qrt-map-frame qrt-map-frame-2">
                  <div class="qrt-lock"><i class="fas fa-lock"></i></div>
                  <div id="map" data-long="<?php echo esc_attr( $settings['map_long'] ); ?>" data-lat="<?php echo esc_attr( $settings['map_lat'] ); ?>" data-zoom="<?php echo esc_attr( $settings['map_zoom'] ); ?>" class="qrt-map"></div>
                </div>
              </div>
              <?php endif; ?>
            </div>
        </div>		

		<?php 
	}
}

Plugin::instance()->widgets_manager->register_widget_type( new Quarty_Contact_Map_Widget() );