<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package quarty
 */

get_header();
?>

<!-- 404 -->
<div class="parallax-container">
    <div class="container d-flex text-center align-items-center justify-content-center error-page">
        <div>
	        <div class="error-page__num"><?php echo esc_html__( '404', 'quarty' ); ?></div>
	        <h3 class="title title--h5 mb-3">
	        	<?php 
	        	if ( ! get_field( 'p404_title', 'option' ) ) : 
	        		echo esc_html__( 'Page not found...', 'quarty' );
	        	else :
	        		echo esc_html( get_field( 'p404_title', 'option' ) );
	        	endif; ?>		
	        </h3>
		    <div class="description">
		    	<?php 
	        	if ( ! get_field( 'p404_content', 'option' ) ) : 
	        		echo '<p>' . esc_html__( 'We are unable to find the page you are looking for.', 'quarty' ) . '</p>';
	        	else :
	        		echo wp_kses_post( get_field( 'p404_content', 'option' ) );
	        	endif; ?>
		    </div>
        </div>
    </div>
</div>
<!-- /404 -->

<?php
get_footer();