/* -------------------------------------------

Name: 		Quarty
Version:	1.0
Author:		Nazar Miller (millerDigitalDesign)
Portfolio:	https://themeforest.net/user/millerdigitaldesign/portfolio?ref=MillerDigitalDesign

p.s. I am available for Freelance hire (UI design, web development). mail: miller.themes@gmail.com

------------------------------------------- */

( function( $ ) {
	'use strict';

	setHeightFullSection();
	$(window).resize(function() {
		setHeightFullSection();
	});

	/* menu custom link */
	$('.menu-item-type-custom').each(function () {
      $(this).find('> a').attr('data-no-swup', '');
    });

	var elementor = 0;
	if ( window.location.href.indexOf('/?elementor-preview=') > -1 ) {
		elementor = 1;
	}

	if ( ! $('body').hasClass('default--scrolling') ) {
		// scrollbar
		Scrollbar.use(OverscrollPlugin);
		if ( $('#qrt-scroll-content').length ) {
			var scrollbar = Scrollbar.init(document.querySelector('#qrt-scroll-content'), {
				damping: 0.17,
				renderByPixel: true,
				continuousScrolling: true,
				plugins: {
					overscroll: {
						effect: 'bounce',
						damping: 0.15,
						maxOverscroll: 80
					},
					mobile: {
						speed: 0.2,
						alwaysShowTracks: false
					}
				},
			});
		}
		if ( $('#qrt-scroll-info').length ) {
			Scrollbar.init(document.querySelector('#qrt-scroll-info'), {
				damping: 0.17,
				renderByPixel: true,
				continuousScrolling: true,
				plugins: {
					overscroll: {
						effect: 'bounce',
						damping: 0.15,
						maxOverscroll: 80
					},
					mobile: {
						speed: 0.2,
						alwaysShowTracks: false
					}
				},
			});
		}
	}

	$(document).ready(function() {
		$('html').addClass('is-animating');
		anime({
			targets: '.qrt-preloader .qrt-preloader-content',
			opacity: [0, 1],
			delay: 200,
			duration: 600,
			easing: 'linear',
			complete: function(anim) {

			}
		});
		anime({
			targets: '.qrt-preloader',
			opacity: [1, 0],
			delay: 2200,
			duration: 400,
			easing: 'linear',
			complete: function(anim) {
				$('.qrt-preloader').css('display', 'none');
				$('html').removeClass('is-animating');
			}
		});
	});

	var bar = new ProgressBar.Line(preloader, {
		strokeWidth: 1.7,
		easing: 'easeInOut',
		duration: 1400,
		delay: 750,
		trailWidth: 1.7,
		svgStyle: {
			width: '100%',
			height: '100%'
		},
		step: (state, bar) => {
			bar.setText(Math.round(bar.value() * 100) + ' %');
		}
	});

	bar.animate(1);

	const cursor = document.querySelector('#cursor');
	const cursorRadius = Math.round(cursor.getBoundingClientRect().width / 1.2);

	const mouse = {
		x: 300,
		y: 300
	};
	const pos = {
		x: 0,
		y: 0
	};
	const ratio = 0.07;

	const draw = () => {
		pos.x += (mouse.x - cursorRadius - pos.x) * ratio;
		pos.y += (mouse.y - cursorRadius - pos.y) * ratio;
		cursor.style.transform = 'translate3d(' + pos.x + 'px ,' + pos.y + 'px, 0)';
	};

	const update = e => {
		mouse.x = e.clientX;
		mouse.y = e.clientY;
	}

	window.addEventListener('mousemove', update, {
		capture: false,
		passive: true
	});

	function animate() {
		draw();
		requestAnimationFrame(animate);
	}

	requestAnimationFrame(animate);

	// fixed
	if ( ! elementor  && ! $('body').hasClass('default--scrolling') ) {
		var fixedElem = document.getElementById('fixed');

		if ($(window).width() > 1200) {
			scrollbar.addListener(function(status) {
				var offset = status.offset;

				fixedElem.style.top = offset.y + 'px';
				fixedElem.style.left = offset.x + 'px';
			});
		}

		$(window).resize(function() {
			if ($(window).width() > 1200) {
				scrollbar.addListener(function(status) {
					var offset = status.offset;

					fixedElem.style.top = offset.y + 'px';
					fixedElem.style.left = offset.x + 'px';
				});
				$(fixedElem).css('position', 'relative')
			}
			if ($(window).width() < 1200) {
				scrollbar.addListener(function(status) {
					var offset = status.offset;

					fixedElem.style.top = offset.y + 'px';
					fixedElem.style.left = offset.x + 'px';
				});
				$(fixedElem).css('position', 'static')
			}
		});
	}

	// sliders
	var param_mousewheel = 1;
	if ( elementor ) {
		var param_mousewheel = 0;
	}

	var swiper = new Swiper('.qrt-main-slider', {
		slidesPerView: 1,
		speed: 800,
		parallax: true,
		mousewheel: false,
		/*mousewheel: {
			releaseOnEdges: true,
		},*/
		keyboard: true,
		autoplay: {
			delay: 6000,
		},
		pagination: {
			el: '.swiper-main-pagination',
			type: 'progressbar',
		},
		navigation: {
			nextEl: '.qrt-main-next',
			prevEl: '.qrt-main-prev',
		},
	});

	var swiper = new Swiper('.qrt-main-slider-onepage', {
		slidesPerView: 1,
		speed: 800,
		parallax: true,
		keyboard: true,
		autoplay: {
			delay: 6000,
		},
		pagination: {
			el: '.swiper-main-pagination',
			type: 'progressbar',
		},
		navigation: {
			nextEl: '.qrt-main-next',
			prevEl: '.qrt-main-prev',
		},
	});

	var swiper = new Swiper('.qrt-testimonials-slider', {
		slidesPerView: 2,
		speed: 800,
		spaceBetween: 20,
		autoplay: {
			delay: 6000,
		},
		pagination: {
			el: '.swiper-testi-pagination',
			clickable: true,
		},
		navigation: {
			nextEl: '.qrt-testi-next',
			prevEl: '.qrt-testi-prev',
		},
		breakpoints: {
			0: {
				slidesPerView: 1,
			},
			767: {
				slidesPerView: 1,
			},
			1024: {
				slidesPerView: 2,
			},
		},
	});

	// brands slider
	var swiper = new Swiper('.qrt-brands-slider', {
		slidesPerView: 4,
		speed: 6000,
		loop: true,
		spaceBetween: 20,
		autoplay: {
			delay: 0,
		},
		breakpoints: {
			0: {
				slidesPerView: 2,
			},
			768: {
				slidesPerView: 2,
			},
			992: {
				slidesPerView: 3,
			},
			1024: {
				slidesPerView: 4,
			},
		},
	});

	// latest works slider
	var swiper = new Swiper('.qrt-latest-works-slider', {
		slidesPerView: 2,
		speed: 800,
		spaceBetween: 20,
		pagination: {
			el: '.swiper-latest-works-pagination',
			clickable: true,
		},
		navigation: {
			nextEl: '.qrt-latest-works-next',
			prevEl: '.qrt-latest-works-prev',
		},
		breakpoints: {
			0: {
				slidesPerView: 1,
			},
			768: {
				slidesPerView: 1,
			},
			1024: {
				slidesPerView: 2,
			},
		},
	});

	var swiper = new Swiper('.qrt-pop-post-slider', {
		slidesPerView: 2,
		speed: 800,
		spaceBetween: 20,
		pagination: {
			el: '.swiper-pp-pagination',
			clickable: true,
		},
		navigation: {
			nextEl: '.qrt-pp-next',
			prevEl: '.qrt-pp-prev',
		},
		breakpoints: {
			0: {
				slidesPerView: 1,
			},
			768: {
				slidesPerView: 1,
			},
			1024: {
				slidesPerView: 2,
			},
		},
	});

	// Magnific Popups
	if(/\.(?:jpg|jpeg|gif|png)$/i.test($('.wp-block-gallery .blocks-gallery-item:first a').attr('href'))){
		$('.wp-block-gallery a').magnificPopup({
			gallery: {
					enabled: true
			},
			type: 'image',
			closeOnContentClick: false,
			fixedContentPos: false,
			closeBtnInside: false,
			removalDelay: 500,
			callbacks: {
				beforeOpen: function() {
					// just a hack that adds mfp-anim class to markup
					 this.st.image.markup = this.st.image.markup.replace('mfp-figure', 'mfp-figure mfp-with-anim');
					 this.st.mainClass = 'mfp-zoom-in';
				}
			},
		});
	}
	$('[data-magnific-inline]').magnificPopup({
		type: 'inline',
		overflowY: 'auto',
		preloader: false,
		removalDelay: 500,
		callbacks: {
			beforeOpen: function() {
				 this.st.mainClass = 'mfp-zoom-in';
			}
		},
	});
	$('[data-magnific-image]').magnificPopup({
		type: 'image',
		closeOnContentClick: true,
		fixedContentPos: false,
		closeBtnInside: false,
		removalDelay: 500,
		callbacks: {
			beforeOpen: function() {
				// just a hack that adds mfp-anim class to markup
				 this.st.image.markup = this.st.image.markup.replace('mfp-figure', 'mfp-figure mfp-with-anim');
				 this.st.mainClass = 'mfp-zoom-in';
			}
		},
	});
	if (!$('body').hasClass('elementor-page')) {
		$("a").each(function(i, el) {
			var href_value = el.href;
			if (/\.(jpg|png|gif)$/.test(href_value)) {
				 $(el).magnificPopup({
						type: 'image',
						closeOnContentClick: true,
						fixedContentPos: false,
						closeBtnInside: false,
						removalDelay: 500,
						callbacks: {
							beforeOpen: function() {
								// just a hack that adds mfp-anim class to markup
								 this.st.image.markup = this.st.image.markup.replace('mfp-figure', 'mfp-figure mfp-with-anim');
								 this.st.mainClass = 'mfp-zoom-in';
							}
						},
					});
			}
		});
	}
	$('[data-magnific-video]').magnificPopup({
		disableOn: 700,
		type: 'iframe',
		iframe: {
				patterns: {
						youtube_short: {
							index: 'youtu.be/',
							id: 'youtu.be/',
							src: 'https://www.youtube.com/embed/%id%?autoplay=1'
						}
				}
		},
		preloader: false,
		fixedContentPos: false,
		removalDelay: 500,
		callbacks: {
			markupParse: function(template, values, item) {
				template.find('iframe').attr('allow', 'autoplay');
			},
			beforeOpen: function() {
				// just a hack that adds mfp-anim class to markup
				 this.st.image.markup = this.st.image.markup.replace('mfp-figure', 'mfp-figure mfp-with-anim');
				 this.st.mainClass = 'mfp-zoom-in';
			}
		},
	});
	$('[data-magnific-music]').magnificPopup({
		disableOn: 700,
		type: 'iframe',
		preloader: false,
		fixedContentPos: false,
		closeBtnInside: true,
		removalDelay: 500,
		callbacks: {
			beforeOpen: function() {
				// just a hack that adds mfp-anim class to markup
				 this.st.image.markup = this.st.image.markup.replace('mfp-figure', 'mfp-figure mfp-with-anim');
				 this.st.mainClass = 'mfp-zoom-in';
			}
		},
	});
	$('[data-magnific-gallery]').magnificPopup({
		gallery: {
				enabled: true
		},
		type: 'image',
		closeOnContentClick: false,
		fixedContentPos: false,
		closeBtnInside: false,
		removalDelay: 500,
		callbacks: {
			beforeOpen: function() {
				// just a hack that adds mfp-anim class to markup
				 this.st.image.markup = this.st.image.markup.replace('mfp-figure', 'mfp-figure mfp-with-anim');
				 this.st.mainClass = 'mfp-zoom-in';
			}
		},
	});
	$('[data-magnific-gallery-portfolio-carousel]').magnificPopup({
		gallery: {
				enabled: true
		},
		type: 'image',
		closeOnContentClick: false,
		fixedContentPos: false,
		closeBtnInside: false,
		removalDelay: 500,
		callbacks: {
			beforeOpen: function() {
				// just a hack that adds mfp-anim class to markup
				 this.st.image.markup = this.st.image.markup.replace('mfp-figure', 'mfp-figure mfp-with-anim');
				 this.st.mainClass = 'mfp-zoom-in';
			}
		},
	});

	// portfolio filter
	$('.qrt-filter a').on('click', function() {
		$('.qrt-filter .qrt-current').removeClass('qrt-current');
		$(this).addClass('qrt-current');

		var selector = $(this).data('filter');
		$('.qrt-masonry-grid').isotope({
			filter: selector
		});
		return false;
	});

	$('.qrt-masonry-grid').isotope({
		filter: '*',
		itemSelector: '.qrt-masonry-grid-item',
		percentPosition: true,
		masonry: {
			columnWidth: '.qrt-grid-sizer'
		}
	});

	$('.qrt-counter').each(function() {
		$(this).prop('Counter', 0).animate({
			Counter: $(this).text()
		}, {
			duration: 2000,
			easing: 'linear',
			step: function(now) {
				$(this).text(Math.ceil(now));
			}
		});
	});

	/*-----------------------------------------------------------------
		Menu Dropdown
	-------------------------------------------------------------------*/
	if ($(window).width() < 920) {
		$('.qrt-menu li a').each(function(){
			if ( ! $(this).parent().find(' > ul').length ) {
				if( $(this).hasClass('qrt-mobile-fix') ){
					$(this).removeClass('qrt-mobile-fix');
				}
			} else {
				if( ! $(this).hasClass('qrt-mobile-fix') ){
					$(this).addClass('qrt-mobile-fix');
				}
			}
		});

		$('.qrt-mobile-fix').attr("href", "#.");

		$('.qrt-mobile-fix').on( 'click', function() {
			if($(this).closest('li').hasClass('active')) {
				$(this).closest('li').removeClass('active');
				$(this).closest('li').find('> ul').slideUp();
			}
			else {
				$(this).closest('li').addClass('active');
				$(this).closest('li').find('> ul').slideDown();
			}

			return false;
		});

	}

	$(".qrt-lock").on('click', function() {
		$('.qrt-map').toggleClass('qrt-active');
		$('.qrt-lock').toggleClass('qrt-active');
		$('.qrt-lock .fas').toggleClass('fa-unlock');
	});

	$(".qrt-menu nav ul li a").on('click', function() {
		if ($(this).hasClass("qrt-mobile-fix")) {
			$('.qrt-menu , .qrt-menu-btn').addClass('qrt-active');
		} else {
			$('.qrt-menu , .qrt-menu-btn').removeClass('qrt-active');
		}
	});

	$('.qrt-info-btn').on('click', function() {
		$('.qrt-info , .qrt-info-btn , .qrt-curtain').toggleClass('qrt-active');
		$('.qrt-menu , .qrt-menu-btn').removeClass('qrt-active');
		$('.qrt-search , .qrt-search-btn').removeClass('qrt-active');
	});

	$('.qrt-info-frame a').on('click', function() {
		$('.qrt-info , .qrt-info-btn , .qrt-curtain').removeClass('qrt-active');
	});

	$(document).on('click', function(e) {
		var el = '.qrt-info , .qrt-info-btn';
		if (jQuery(e.target).closest(el).length) return;
		$('.qrt-info , .qrt-info-btn , .qrt-curtain').removeClass('qrt-active');
	});

	$('.qrt-menu-btn').on('click', function() {
		$('.qrt-menu , .qrt-menu-btn').toggleClass('qrt-active');
		$('.qrt-info , .qrt-info-btn , .qrt-curtain').removeClass('qrt-active');
		$('.qrt-search , .qrt-search-btn').removeClass('qrt-active');
	});

	$(document).on('click', function(e) {
		var el = '.qrt-menu , .qrt-menu-btn';
		if (jQuery(e.target).closest(el).length) return;
		$('.qrt-menu , .qrt-menu-btn').removeClass('qrt-active');
	});

	$('.qrt-search-btn').on('click', function() {
		$('.qrt-search , .qrt-search-btn').toggleClass('qrt-active');
		$('.qrt-menu , .qrt-menu-btn').removeClass('qrt-active');
		$('.qrt-info , .qrt-info-btn , .qrt-curtain').removeClass('qrt-active');
	});

	$(document).on('click', function(e) {
		var el = '.qrt-search , .qrt-search-btn';
		if (jQuery(e.target).closest(el).length) return;
		$('.qrt-search , .qrt-search-btn').removeClass('qrt-active');
	});

	$('.current-menu-item a').clone().prependTo('.qrt-current-page-title');

	anime({
		targets: '.qrt-follower',
		scale: 0,
	});

	$(".qrt-menu nav ul li a").mouseover(function() {
		anime({
			targets: '.qrt-follower',
			scale: 1,
			background: 'rgba(222,225,230,1)',
		});
	});
	$(".qrt-menu nav ul li a").mouseout(function() {
		anime({
			targets: '.qrt-follower',
			scale: 0,
			background: '#fff',
		});
	});

	$(".qrt-menu nav ul li ul li a").mouseover(function() {
		anime({
			targets: '.qrt-follower',
			scale: 1,
			background: '#fff',
		});
	});
	$(".qrt-menu nav ul li ul li a").mouseout(function() {
		anime({
			targets: '.qrt-follower',
			scale: 0,
			background: '#fff',
		});
	});

	$(".qrt-cursor-scale , .qrt-btn").mouseover(function() {
		anime({
			targets: '.qrt-follower',
			scale: 1,
		});
	});
	$(".qrt-cursor-scale , .qrt-btn").mouseout(function() {
		anime({
			targets: '.qrt-follower',
			scale: 0,
		});
	});

	$(".qrt-cursor-color").mouseover(function() {
		anime({
			targets: '.qrt-follower',
			background: 'rgba(222,225,230,1)',
		});
	});
	$(".qrt-cursor-color").mouseout(function() {
		anime({
			targets: '.qrt-follower',
			background: '#fff',
		});
	});

	$('.qrt-input').keyup(function() {
		if ($(this).val()) {
			$(this).addClass('qrt-active');
		} else {
			$(this).removeClass('qrt-active');
		}
	});

	$('.qrt-price-list li').each(function(){
		if($(this).find('del').length){
			$(this).addClass('qrt-empty-item');
		}
	});

	if ($("div").is("#map")) {
		var map_long = $('#map').data('long');
    	var map_lat = $('#map').data('lat');
    	var map_zoom = $('#map').data('zoom');

	    mapboxgl.accessToken = 'pk.eyJ1Ijoic3Rvc2NhciIsImEiOiJja2VpbDE4b2UwbDg3MnNwY2d3YzlvcDV5In0.e26tLedpKwxrkOmPkWhQlg';
	    var map = new mapboxgl.Map({
	      container: 'map',
	      style: 'mapbox://styles/stoscar/ckggs77460wxw19ob8q5wldwf',
	      center: [map_long, map_lat],
	      zoom: map_zoom

	    });

	    var marker = new mapboxgl.Marker()
	      .setLngLat([map_long, map_lat])
	      .addTo(map);
	}

	function setHeightFullSection() {
		var width = $(window).width();
		var height = $(window).height();

		/* Set full height in started blocks */
		$('.qrt-app, .qrt-app .qrt-curtain').css({'height': height-20});
		$('.admin-bar .qrt-app, .admin-bar .qrt-app .qrt-curtain').css({'height': height-52});
		$('.qrt-main-slider, .qrt-main-slider-onepage, .qrt-banner, .qrt-app .qrt-content').css({'height': height-100});
		$('.admin-bar .qrt-main-slider, .admin-bar .qrt-main-slider-onepage, .admin-bar .qrt-banner, .admin-bar .qrt-app .qrt-content').css({'height': height-132});
		if(width < 783) {
			$('.qrt-app, .qrt-app .qrt-curtain').css({'height': height});
			$('.admin-bar .qrt-app, .admin-bar .qrt-app .qrt-curtain').css({'height': height-46});
			$('.qrt-main-slider, .qrt-main-slider-onepage, .qrt-banner, .qrt-app .qrt-content').css({'height': height-80});
			$('.admin-bar .qrt-main-slider, .admin-bar .qrt-main-slider-onepage, .admin-bar .qrt-banner, .admin-bar .qrt-app .qrt-content').css({'height': height-126});
		}
	}

	/**
		Cart Popup
	**/
	$('.cart-btn .cart-icon').on('click', function(){
		if($(this).closest('.cart-btn').hasClass('opened')){
			$(this).closest('.cart-btn').removeClass('opened');
			$(this).closest('.cart-btn').find('.cart-widget').hide();
		} else {
			$(this).closest('.cart-btn').addClass('opened');
			$(this).closest('.cart-btn').find('.cart-widget').fadeIn();
		}

		return false;
	});

} )( jQuery );
