<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package quarty
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<!-- Meta Data -->
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<?php

$page_layout = 0;
if ( is_singular( 'post' ) ) {
  $page_layout = get_field( 'post_layout', 'option' );
} else if ( is_singular( 'portfolio' ) ) {
  $page_layout = get_field( 'portfolio_layout', 'option' );
} else {
  $page_layout = get_field( 'page_layout' );
}

if ( is_archive() || is_search() ) {
  $page_layout = 0;
}

$header_logo = get_field( 'header_logo', 'option' );
$header_sm_logo = get_field( 'header_sm_logo', 'option' );
$social_links = get_field( 'social_links', 'option' );
$header_btn = get_field( 'header_btn', 'option' );
$header_btn_label = get_field( 'header_btn_label', 'option' );
$header_btn_url = get_field( 'header_btn_url', 'option' );

?>

<body <?php body_class(); ?>>
	<?php wp_body_open(); ?>
	
  <div class="qrt-app">
    <?php $preloader_hide_logo = get_field( 'preloader_hide_logo', 'option' ) ?>
    <div class="qrt-preloader">
      <div class="qrt-preloader-content">
        <div class="qrt-logo">
          <?php if ( ! $preloader_hide_logo && $header_logo ) : ?><img src="<?php echo esc_url( $header_logo ); ?>" alt="<?php echo esc_attr( bloginfo('name') ); ?>"><?php endif; ?>
        </div>
        <div id="preloader" class="qrt-preloader-load"></div>
      </div>
    </div>

    <div id="cursor" class="qrt-cursor">
      <div></div>
      <div class="qrt-follower"><i class="fas fa-circle-notch"></i></div>
    </div>

    <div class="qrt-top-bar<?php if ( ! $header_sm_logo ) : ?> qrt-top-bar-wsm<?php endif; ?>">
      <?php if ( $header_sm_logo ) : ?>
      <a href="<?php echo esc_url( home_url() ); ?>" class="qrt-symbol qrt-cursor-scale qrt-anima-link">
          <img src="<?php echo esc_url( $header_sm_logo ); ?>" alt="<?php echo esc_attr( bloginfo('name') ); ?>">
      </a>
      <?php endif; ?>

      <a href="<?php echo esc_url( home_url() ); ?>" class="qrt-logo qrt-cursor-color qrt-cursor-scale qrt-anima-link">
        <?php if ( $header_logo ) : ?>
        <img src="<?php echo esc_url( $header_logo ); ?>" alt="<?php echo esc_attr( bloginfo('name') ); ?>">
        <?php else : ?>
        <span class="qrt-logo-text"><?php echo esc_html( bloginfo('name') ); ?></span>
        <span class="qrt-logo-sub"><?php echo esc_html( bloginfo('description') ); ?></span>
        <?php endif; ?>
      </a>

      <div class="qrt-menu">
        <div id="qrt-dynamic-menu" class="qrt-dynamic-menu">
          <nav>
            <?php if ( has_nav_menu( 'primary' ) ) :
              wp_nav_menu( array(
                'theme_location' => 'primary',
                'container' => '',
                'menu_class' => '',
                'walker' => new Quarty_Header_Menu_Walker(),
              ) );
            endif; ?>
          </nav>
        </div>
      </div>

      <div class="qrt-buttons">
        <?php if ( $header_btn ) : ?>
        <a href="<?php echo esc_url( $header_btn_url ); ?>" class="qrt-btn qrt-btn-md qrt-btn-color qrt-send-request qrt-anima-link qrt-mr-20">
          <span><?php echo esc_html( $header_btn_label ); ?></span>
        </a>
        <?php endif; ?>
        <div class="qrt-menu-btn qrt-cursor-color qrt-cursor-scale"><span></span></div>
        <div class="qrt-search-btn qrt-cursor-color qrt-cursor-scale"><i class="fas fa-search"></i></div>

        <?php if ( class_exists( 'WooCommerce' ) ) : ?>
        <div class="cart-btn<?php if ( WC()->cart->get_cart_contents_count() == 0 ) : ?> cart-btn-empty<?php endif; ?>">
          <div class="cart-icon zoom-cursor">
            <span class="cart-count"><?php echo sprintf (_n( '%d', '%d', WC()->cart->get_cart_contents_count(), 'quarty' ), WC()->cart->get_cart_contents_count() ); ?></span> 
          </div>
          <div class="cart-widget">
            <?php woocommerce_mini_cart(); ?>
          </div>
        </div>
        <?php endif; ?>

      </div>
      
      <div class="qrt-search">
        <?php get_search_form(); ?>
      </div>

    </div>

    <div class="qrt-left-bar">
      <div class="qrt-current-page-title"></div>

      <?php if ( $social_links ) : ?>
      <div class="qrt-social-links">
        <?php foreach ( $social_links as $social ) : ?>
        <a href="<?php echo esc_url( $social['url'] ); ?>" target="_blank" class="qrt-social-link qrt-cursor-color qrt-cursor-scale">
          <i class="<?php echo esc_attr( $social['icon'] ); ?>"></i>
        </a>
        <?php endforeach; ?>
      </div>
      <?php endif; ?>
    </div>
    <div class="qrt-curtain"></div>
    
    <div id="qrt-dynamic-content" class="qrt-dynamic-content">
      <div class="qrt-content" id="qrt-scroll-content">
        <div class="<?php if ( $page_layout == 1 ) : ?>qrt-half-content-frame<?php else :?>qrt-content-frame<?php endif; ?>">
          <div class="qrt-left">