<?php
/**
 * The template for displaying search form
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package quarty
 */
?>

<form role="search" method="get" class="searchform" action="<?php echo esc_url( home_url( '/' ) ); ?>">
	<input type="search" value="<?php echo esc_attr( get_search_query() ); ?>" name="s" placeholder="<?php echo esc_attr__( 'Search ...', 'quarty' ); ?>" />
	<button type="submit" class="searchform-btn"><?php echo esc_html__( 'Submit', 'quarty' ); ?></button>
</form>